/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.CIERGB;
import com.idrsolutions.image.jpegXL.data.CIEXY;
import com.idrsolutions.image.jpegXL.data.ColorUtil;
import com.idrsolutions.image.jpegXL.data.MathXL;
import java.awt.color.ColorSpace;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;

class ColorSpaceXL
extends ColorSpace {
    public final CIERGB primaries;
    public final CIEXY whitePoint;
    public final int transfer;
    public final DoubleUnaryOperator transferFunction;
    public final DoubleUnaryOperator inverseTransferFunction;
    private final float[][] primariesToXYZD50;
    private final float[][] primariesFromXYZD50;
    private final float[][] primariesToSRGB;
    private final float[][] primariesFromSRGB;

    ColorSpaceXL(CIERGB primaries, CIEXY whitePoint, int transfer, int nComp) {
        super(Objects.hash(primaries, whitePoint, transfer), nComp);
        this.primaries = primaries;
        this.whitePoint = whitePoint;
        this.transfer = transfer;
        this.primariesToXYZD50 = ColorUtil.primariesToXYZD50(primaries, whitePoint);
        this.primariesFromXYZD50 = MathXL.mmInverse3x3(this.primariesToXYZD50);
        this.primariesToSRGB = ColorUtil.getConversionMatrix(ColorUtil.PRI_SRGB, ColorUtil.WP_D65, primaries, whitePoint);
        this.primariesFromSRGB = MathXL.mmInverse3x3(this.primariesToSRGB);
        this.transferFunction = ColorUtil.getTransferFunction(transfer);
        this.inverseTransferFunction = ColorUtil.getInverseTransfer(transfer);
    }

    private float[] transfer(float[] thisSpace) {
        thisSpace[1] = (float)this.transferFunction.applyAsDouble(thisSpace[1]);
        if (this.getNumComponents() < 3) {
            thisSpace[0] = thisSpace[1];
        } else {
            thisSpace[0] = (float)this.transferFunction.applyAsDouble(thisSpace[0]);
            thisSpace[2] = (float)this.transferFunction.applyAsDouble(thisSpace[2]);
        }
        return thisSpace;
    }

    private float[] linearize(float[] colorvalue) {
        float[] linear = new float[3];
        for (int i2 = 0; i2 < this.getNumComponents(); ++i2) {
            linear[i2] = (float)this.inverseTransferFunction.applyAsDouble(colorvalue[i2]);
        }
        if (this.getNumComponents() < 3) {
            linear[1] = linear[2] = linear[0];
        }
        return linear;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float[] linear = this.linearize(colorvalue);
        float[] sRGB = MathXL.mmMutliply(this.primariesToSRGB, linear);
        DoubleUnaryOperator sRGBTransfer = ColorUtil.getTransferFunction(0x100000D);
        sRGB[0] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[0]), 0.0f, 1.0f);
        sRGB[1] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[1]), 0.0f, 1.0f);
        sRGB[2] = MathXL.clamp((float)sRGBTransfer.applyAsDouble(sRGB[2]), 0.0f, 1.0f);
        return sRGB;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float[] linear = new float[3];
        DoubleUnaryOperator inverseSRGB = ColorUtil.getInverseTransfer(0x100000D);
        linear[0] = (float)inverseSRGB.applyAsDouble(rgbvalue[0]);
        linear[1] = (float)inverseSRGB.applyAsDouble(rgbvalue[1]);
        linear[2] = (float)inverseSRGB.applyAsDouble(rgbvalue[2]);
        float[] thisSpace = MathXL.mmMutliply(this.primariesFromSRGB, linear);
        return this.transfer(thisSpace);
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] linear = this.linearize(colorvalue);
        return MathXL.mmMutliply(this.primariesToXYZD50, linear);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] thisSpace = MathXL.mmMutliply(this.primariesFromXYZD50, colorvalue);
        return this.transfer(thisSpace);
    }
}

