/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL.data;

import com.idrsolutions.image.jpegXL.data.ANS;
import com.idrsolutions.image.jpegXL.data.BitXL;
import com.idrsolutions.image.jpegXL.data.Symbols;
import com.idrsolutions.image.jpegXL.data.VLC;
import java.io.IOException;
import java.util.ArrayDeque;

class ANSSymbols
extends Symbols {
    private static final VLC kLogCountLut = new VLC(7, new int[][]{{10, 3}, {12, 7}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {11, 6}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {13, 7}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {11, 6}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}, {10, 3}, {0, 5}, {7, 3}, {3, 4}, {6, 3}, {8, 3}, {9, 3}, {5, 4}, {10, 3}, {4, 4}, {7, 3}, {1, 4}, {6, 3}, {8, 3}, {9, 3}, {2, 4}});
    private final int[] frequencies;
    private int[] cutoffs;
    private int[] symbols;
    private int[] offsets;

    ANSSymbols(BitXL reader, int logAlphabetSize) throws IOException {
        this.logAlphabetSize = logAlphabetSize;
        int uniqPos = -1;
        if (reader.bool()) {
            if (reader.bool()) {
                int v1 = reader.u8();
                int v2 = reader.u8();
                this.alphabetSize = 1 + Math.max(v1, v2);
                this.frequencies = new int[this.alphabetSize];
                this.frequencies[v1] = reader.u(12);
                this.frequencies[v2] = 4096 - this.frequencies[v1];
                if (this.frequencies[v1] == 0) {
                    uniqPos = v2;
                }
            } else {
                int x2 = reader.u8();
                this.alphabetSize = 1 + x2;
                this.frequencies = new int[this.alphabetSize];
                this.frequencies[x2] = 4096;
                uniqPos = x2;
            }
        } else {
            int len;
            reader.bool();
            for (len = 0; len < 3 && reader.bool(); ++len) {
            }
            int shift = (reader.u(len) | 1 << len) - 1;
            this.alphabetSize = 3 + reader.u8();
            this.frequencies = new int[this.alphabetSize];
            int[] logCounts = new int[this.alphabetSize];
            int[] same = new int[this.alphabetSize];
            int omitLog = -1;
            int omitPos = -1;
            for (int i2 = 0; i2 < this.alphabetSize; ++i2) {
                logCounts[i2] = kLogCountLut.getVLC(reader);
                if (logCounts[i2] == 13) {
                    int rle = reader.u8();
                    same[i2] = rle + 5;
                    i2 += rle + 3;
                    continue;
                }
                if (logCounts[i2] <= omitLog) continue;
                omitLog = logCounts[i2];
                omitPos = i2;
            }
            int totalCount = 0;
            int numSame = 0;
            int prev = 0;
            for (int i3 = 0; i3 < this.alphabetSize; ++i3) {
                if (same[i3] != 0) {
                    numSame = same[i3] - 1;
                    int n2 = prev = i3 > 0 ? this.frequencies[i3 - 1] : 0;
                }
                if (numSame != 0) {
                    this.frequencies[i3] = prev;
                    --numSame;
                } else {
                    if (i3 == omitPos || logCounts[i3] == 0) continue;
                    if (logCounts[i3] == 1) {
                        this.frequencies[i3] = 1;
                    } else {
                        int bitcount = shift - (12 - logCounts[i3] + 1 >> 1);
                        if (bitcount < 0) {
                            bitcount = 0;
                        }
                        if (bitcount > logCounts[i3] - 1) {
                            bitcount = logCounts[i3] - 1;
                        }
                        this.frequencies[i3] = (1 << logCounts[i3] - 1) + (reader.u(bitcount) << logCounts[i3] - 1 - bitcount);
                    }
                }
                totalCount += this.frequencies[i3];
            }
            this.frequencies[omitPos] = 4096 - totalCount;
        }
        this.generateAliasMapping(uniqPos);
    }

    @Override
    public int readSymbol(BitXL reader, ANS stateObj) throws IOException {
        int offset;
        int state = stateObj.hasState ? stateObj.state : reader.u(32);
        int index = state & 0xFFF;
        int pos = index & (1 << this.logBucketSize) - 1;
        int i2 = index >>> this.logBucketSize;
        boolean greater = pos >= this.cutoffs[i2];
        int symbol = greater ? this.symbols[i2] : i2;
        if (((state = this.frequencies[symbol] * (state >>> 12) + (offset = greater ? this.offsets[i2] + pos : pos)) & 0xFFFF0000) == 0) {
            state = state << 16 | reader.u(16);
        }
        stateObj.state = state;
        stateObj.hasState = true;
        return symbol;
    }

    private void generateAliasMapping(int uniqPos) {
        int i2;
        this.logBucketSize = 12 - this.logAlphabetSize;
        ArrayDeque<Integer> overfull = new ArrayDeque<Integer>();
        ArrayDeque<Integer> underfull = new ArrayDeque<Integer>();
        int bucketSize = 1 << this.logBucketSize;
        int tableSize = 1 << this.logAlphabetSize;
        this.symbols = new int[tableSize];
        this.cutoffs = new int[tableSize];
        this.offsets = new int[tableSize];
        if (uniqPos >= 0) {
            for (int i3 = 0; i3 < tableSize; ++i3) {
                this.symbols[i3] = uniqPos;
                this.offsets[i3] = i3 * bucketSize;
                this.cutoffs[i3] = 0;
            }
            return;
        }
        for (i2 = 0; i2 < this.alphabetSize; ++i2) {
            this.cutoffs[i2] = this.frequencies[i2];
            if (this.cutoffs[i2] > bucketSize) {
                overfull.addFirst(i2);
                continue;
            }
            if (this.cutoffs[i2] >= bucketSize) continue;
            underfull.addFirst(i2);
        }
        for (i2 = this.alphabetSize; i2 < tableSize; ++i2) {
            underfull.addFirst(i2);
        }
        while (!overfull.isEmpty()) {
            int u2 = (Integer)underfull.removeFirst();
            int o2 = (Integer)overfull.removeFirst();
            int by = bucketSize - this.cutoffs[u2];
            int n2 = o2;
            this.cutoffs[n2] = this.cutoffs[n2] - by;
            this.symbols[u2] = o2;
            this.offsets[u2] = this.cutoffs[o2];
            if (this.cutoffs[o2] < bucketSize) {
                underfull.addFirst(o2);
                continue;
            }
            if (this.cutoffs[o2] <= bucketSize) continue;
            overfull.addFirst(o2);
        }
        for (i2 = 0; i2 < tableSize; ++i2) {
            if (this.cutoffs[i2] == bucketSize) {
                this.symbols[i2] = i2;
                this.offsets[i2] = 0;
                this.cutoffs[i2] = 0;
                continue;
            }
            int n3 = i2;
            this.offsets[n3] = this.offsets[n3] - this.cutoffs[i2];
        }
    }
}

