/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpegXL;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.jpegXL.data.StreamXL;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;

public class JpegXLDecoder
extends JDeliImage
implements Decoder {
    @Override
    public BufferedImage read(byte[] jpegxlRawData) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(jpegxlRawData);
        StreamXL decoder = new StreamXL(in);
        return decoder.decode().asBufferedImage();
    }

    @Override
    public BufferedImage read(File file) throws Exception {
        byte[] bytes = new byte[(int)file.length()];
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            dis.readFully(bytes);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        StreamXL decoder = new StreamXL(in);
        return decoder.decode().asBufferedImage();
    }

    @Override
    public Rectangle readDimension(byte[] data) throws Exception {
        BufferedImage image = this.read(data);
        return new Rectangle(image.getWidth(), image.getHeight());
    }

    @Override
    public Rectangle readDimension(File imageFile) throws Exception {
        BufferedImage image = this.read(imageFile);
        return new Rectangle(image.getWidth(), image.getHeight());
    }
}

