/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.Subband;
import com.idrsolutions.image.jpeg2000.data.SubbandCoefficient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Trns {
    private static final float ALPHA = -1.5861343f;
    private static final float BETA = -0.052980117f;
    private static final float GAMMA = 0.8829111f;
    private static final float DELTA = 0.44350687f;
    private static final float ZETA = 1.2301741f;
    private static final float ZETA_ = 0.8128931f;

    private Trns() {
    }

    public static List<Subband> getForward(float[] pixels, int iw, int ih, int NL, boolean reversible) {
        Subband cur = new Subband();
        ArrayList<Subband> result = new ArrayList<Subband>();
        cur.width = iw;
        cur.height = ih;
        cur.floats = pixels;
        for (int lev = 1; lev <= NL; ++lev) {
            Subband[] coefs = Trns.twoDSD(cur, iw, ih, lev, reversible);
            cur = coefs[0];
            for (int i2 = 3; i2 > 0; --i2) {
                result.add(coefs[i2]);
            }
        }
        result.add(cur);
        Collections.reverse(result);
        return result;
    }

    private static Subband[] twoDSD(Subband a10, int iw, int ih, int lev, boolean reversible) {
        int extH = a10.height + 8;
        int extW = a10.width + 8;
        float[] ext = new float[Math.max(extH, extW)];
        int u0 = a10.x;
        int u1 = a10.x + a10.width;
        int v0 = a10.y;
        int v1 = a10.y + a10.height;
        int w2 = a10.width;
        float[] items = new float[a10.height];
        for (int u2 = u0; u2 < u1; ++u2) {
            int x2;
            for (x2 = v0; x2 < v1; ++x2) {
                items[x2] = a10.floats[x2 * w2 + u2];
            }
            Trns.oneDSD(items, 0, a10.height, ext, reversible);
            for (x2 = v0; x2 < v1; ++x2) {
                a10.floats[x2 * w2 + u2] = items[x2];
            }
        }
        int len = u1 - u0;
        for (int v2 = v0; v2 < v1; ++v2) {
            Trns.oneDSD(a10.floats, v2 * w2, len, ext, reversible);
        }
        Subband ll = new Subband();
        int powN = 1 << lev;
        int powM = 1 << lev - 1;
        ll.width = (int)Math.abs(Math.ceil(1.0 * (double)iw / (double)powN));
        ll.height = (int)Math.abs(Math.ceil(1.0 * (double)ih / (double)powN));
        ll.floats = new float[ll.width * ll.height];
        Trns.interleaveLL(a10, ll, u0, u1, v0, v1);
        ll.type = 0;
        Subband hl = new Subband();
        hl.width = (int)Math.abs(Math.ceil((1.0 * (double)iw - (double)powM) / (double)powN));
        hl.height = ll.height;
        hl.floats = new float[hl.width * hl.height];
        Trns.interleaveHL(a10, hl, u0, u1, v0, v1);
        hl.type = 2;
        Subband lh = new Subband();
        lh.width = ll.width;
        lh.height = (int)Math.abs(Math.ceil((1.0 * (double)ih - (double)powM) / (double)powN));
        lh.floats = new float[lh.width * lh.height];
        Trns.interleaveLH(a10, lh, u0, u1, v0, v1);
        lh.type = 1;
        Subband hh = new Subband();
        hh.width = hl.width;
        hh.height = lh.height;
        hh.floats = new float[hh.width * hh.height];
        Trns.interleaveHH(a10, hh, u0, u1, v0, v1);
        hh.type = 3;
        return new Subband[]{ll, hl, lh, hh};
    }

    private static void oneDSD(float[] items, int offset, int len, float[] ext, boolean reversible) {
        int loc;
        int i2;
        System.arraycopy(items, offset, ext, 4, len);
        int i1 = len;
        for (i2 = 0; i2 < 4; ++i2) {
            loc = offset + i2 + 1;
            if (loc >= items.length) continue;
            ext[3 - i2] = items[loc];
        }
        for (i2 = 0; i2 < 4; ++i2) {
            loc = offset + i1 - 2 - i2;
            if (loc <= 0) continue;
            ext[i1 + 4 + i2] = items[loc];
        }
        int i0 = 4;
        i1 = len + 4;
        if (reversible) {
            Trns.filterReverse(i1, ext);
        } else {
            Trns.filterIrreverse(i1, ext);
        }
        System.arraycopy(ext, 4, items, offset, len);
    }

    private static void filterReverse(int i1, float[] ext) {
        int n2 = 1;
        int n22 = n2 << 1;
        int jj = i1 + 1;
        while (n22 + 1 < jj) {
            int n3 = n22 + 1;
            ext[n3] = ext[n3] - (float)((int)((ext[n22] + ext[n22 + 2]) / 2.0f));
            n22 += 2;
        }
        n2 = 2;
        jj = i1;
        for (n22 = n2 << 1; n22 < jj; n22 += 2) {
            int n4 = n22;
            ext[n4] = ext[n4] + (float)((int)((ext[n22 - 1] + ext[n22 + 1] + 2.0f) / 4.0f));
        }
    }

    private static void filterIrreverse(int i1, float[] ext) {
        int jj = i1 + 3;
        int n2 = 0;
        while (n2 + 1 < jj) {
            int n3 = n2 + 1;
            ext[n3] = ext[n3] + -1.5861343f * (ext[n2] + ext[n2 + 2]);
            n2 += 2;
        }
        int n4 = 1;
        jj = i1 + 2;
        for (n2 = n4 << 1; n2 < jj; n2 += 2) {
            int n5 = n2;
            ext[n5] = ext[n5] + -0.052980117f * (ext[n2 - 1] + ext[n2 + 1]);
        }
        n4 = 1;
        jj = i1 + 1;
        for (n2 = (n4 << 1) + 1; n2 < jj; n2 += 2) {
            int n6 = n2;
            ext[n6] = ext[n6] + 0.8829111f * (ext[n2 - 1] + ext[n2 + 1]);
        }
        jj = i1;
        n4 = 2;
        for (n2 = n4 << 1; n2 < jj; n2 += 2) {
            float t2 = ext[n2];
            t2 += 0.44350687f * (ext[n2 - 1] + ext[n2 + 1]);
            ext[n2] = t2 *= 0.8128931f;
        }
        n4 = 1;
        for (n2 = (n4 << 1) + 1; n2 < jj; n2 += 2) {
            int n7 = n2;
            ext[n7] = ext[n7] * 1.2301741f;
        }
    }

    private static void interleaveLL(Subband a10, Subband b2, int u0, int u1, int v0, int v1) {
        int ub = (int)Math.ceil((float)u0 / 2.0f);
        int vb = (int)Math.ceil((float)v0 / 2.0f);
        int aw2 = a10.width;
        int bw = b2.width;
        float[] auv = a10.floats;
        float[] buv = b2.floats;
        int uend = u1 + 1 >> 1;
        int vend = v1 + 1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[vb2 * aw2 + 2 * ub];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 + 1 >> 1;
        }
    }

    private static void interleaveHL(Subband a10, Subband b2, int u0, int u1, int v0, int v1) {
        int aw2 = a10.width;
        int bw = b2.width;
        float[] auv = a10.floats;
        float[] buv = b2.floats;
        int ub = u0 >> 1;
        int vb = v0 + 1 >> 1;
        int uend = u1 >> 1;
        int vend = v1 + 1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[vb2 * aw2 + 2 * ub + 1];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 >> 1;
        }
    }

    private static void interleaveLH(Subband a10, Subband b2, int u0, int u1, int v0, int v1) {
        int aw2 = a10.width;
        int bw = b2.width;
        float[] auv = a10.floats;
        float[] buv = b2.floats;
        int ub = u0 + 1 >> 1;
        int vb = v0 >> 1;
        int uend = u1 + 1 >> 1;
        int vend = v1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[(vb2 + 1) * aw2 + 2 * ub];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 + 1 >> 1;
        }
    }

    private static void interleaveHH(Subband a10, Subband b2, int u0, int u1, int v0, int v1) {
        int aw2 = a10.width;
        int bw = b2.width;
        float[] auv = a10.floats;
        float[] buv = b2.floats;
        int ub = u0 >> 1;
        int vb = v0 >> 1;
        int uend = u1 >> 1;
        int vend = v1 >> 1;
        while (true) {
            int vb2 = vb << 1;
            do {
                buv[vb * bw + ub] = auv[(vb2 + 1) * aw2 + 2 * ub + 1];
            } while (++ub < uend);
            if (++vb >= vend) break;
            ub = u0 >> 1;
        }
    }

    public static SubbandCoefficient getInversed(List<SubbandCoefficient> subCos, int u0, int v0, boolean reversible) {
        SubbandCoefficient sb = subCos.get(0);
        for (int i2 = 1; i2 < subCos.size(); ++i2) {
            sb = Trns.getNext(sb, subCos.get(i2), u0, v0, reversible);
        }
        return sb;
    }

    private static void applyFilter(float[] data, int size, boolean reversible) {
        Trns.initData(data, size);
        int len = size >> 1;
        if (reversible) {
            Trns.reverse(data, len);
        } else {
            Trns.processData(data, len);
        }
    }

    private static void processData(float[] data, int len) {
        float next;
        int j2 = 1;
        int n2 = len + 4;
        while (n2 > 0) {
            int n3 = j2;
            data[n3] = data[n3] * 0.8128931f;
            --n2;
            j2 += 2;
        }
        j2 = 2;
        float current = 0.44350687f * data[j2 - 1];
        for (n2 = len + 2; n2 >= 0; --n2) {
            next = 0.44350687f * data[j2 + 1];
            data[j2] = 1.2301741f * data[j2] - current - next;
            if (--n2 < 0) break;
            current = 0.44350687f * data[(j2 += 2) + 1];
            data[j2] = 1.2301741f * data[j2] - current - next;
            j2 += 2;
        }
        j2 = 3;
        current = 0.8829111f * data[j2 - 1];
        for (n2 = len + 1; n2 >= 0; --n2) {
            next = 0.8829111f * data[j2 + 1];
            int n4 = j2;
            data[n4] = data[n4] - (current + next);
            if (--n2 < 0) break;
            current = 0.8829111f * data[(j2 += 2) + 1];
            int n5 = j2;
            data[n5] = data[n5] - (current + next);
            j2 += 2;
        }
        j2 = 4;
        current = -0.052980117f * data[j2 - 1];
        for (n2 = len; n2 >= 0; --n2) {
            next = -0.052980117f * data[j2 + 1];
            int n6 = j2;
            data[n6] = data[n6] - (current + next);
            if (--n2 < 0) break;
            current = -0.052980117f * data[(j2 += 2) + 1];
            int n7 = j2;
            data[n7] = data[n7] - (current + next);
            j2 += 2;
        }
        if (len != 0) {
            j2 = 5;
            current = -1.5861343f * data[j2 - 1];
            for (n2 = len - 1; n2 >= 0; --n2) {
                next = -1.5861343f * data[j2 + 1];
                int n8 = j2;
                data[n8] = data[n8] - (current + next);
                if (--n2 < 0) break;
                current = -1.5861343f * data[(j2 += 2) + 1];
                int n9 = j2;
                data[n9] = data[n9] - (current + next);
                j2 += 2;
            }
        }
    }

    private static void initData(float[] data, int size) {
        int aa2 = 3;
        int bb2 = 5;
        int cc = 4 + size - 2;
        int dd = 4 + size;
        data[aa2--] = data[bb2++];
        data[dd++] = data[cc--];
        data[aa2--] = data[bb2++];
        data[dd++] = data[cc--];
        data[aa2--] = data[bb2++];
        data[dd++] = data[cc--];
        data[aa2] = data[bb2];
        data[dd] = data[cc];
    }

    private static void reverse(float[] data, int len) {
        int n2;
        int j2 = 4;
        for (n2 = len; n2 >= 0; --n2) {
            int n3 = j2;
            data[n3] = data[n3] - (float)((int)(data[j2 - 1] + data[j2 + 1] + 2.0f) >> 2);
            j2 += 2;
        }
        j2 = 5;
        for (n2 = len - 1; n2 >= 0; --n2) {
            int n4 = j2;
            data[n4] = data[n4] + (float)((int)(data[j2 - 1] + data[j2 + 1]) >> 1);
            j2 += 2;
        }
    }

    private static SubbandCoefficient getNext(SubbandCoefficient ll, SubbandCoefficient other, int u0, int v0, boolean reversible) {
        int widthLL = ll.width;
        int heightLL = ll.height;
        int width = other.width;
        int height = other.height;
        int w2 = width << 1;
        Trns.updateItemCount(ll, other, widthLL, heightLL, w2);
        int bufferPadding = 4;
        Trns.getK(other, u0, width, height, reversible);
        int numBuffers = 16;
        float[][] colBuffers = new float[16][height + 8];
        boolean currentBuffer = false;
        int ss = 4 + height;
        if (height == 1) {
            Trns.handleSinglePixelHeight(other, v0, width);
        } else {
            Trns.handleOtherHeights(other, width, height, 16, colBuffers, 0, ss, reversible);
        }
        SubbandCoefficient sc = new SubbandCoefficient();
        sc.width = width;
        sc.height = height;
        sc.floatItems = other.floatItems;
        return sc;
    }

    private static void handleOtherHeights(SubbandCoefficient other, int width, int height, int numBuffers, float[][] colBuffers, int currentBuffer, int ss, boolean reversible) {
        for (int u2 = 0; u2 < width; ++u2) {
            if (currentBuffer == 0) {
                numBuffers = Math.min(width - u2, numBuffers);
                int k2 = u2;
                for (int l2 = 4; l2 < ss; ++l2) {
                    for (int b2 = 0; b2 < numBuffers; ++b2) {
                        colBuffers[b2][l2] = other.floatItems[k2 + b2];
                    }
                    k2 += width;
                }
                currentBuffer = numBuffers;
            }
            float[] buffer = colBuffers[--currentBuffer];
            Trns.applyFilter(buffer, height, reversible);
            if (currentBuffer != 0) continue;
            int k3 = u2 - numBuffers + 1;
            for (int l3 = 4; l3 < ss; ++l3) {
                for (int b3 = 0; b3 < numBuffers; ++b3) {
                    other.floatItems[k3 + b3] = colBuffers[b3][l3];
                }
                k3 += width;
            }
        }
    }

    private static void handleSinglePixelHeight(SubbandCoefficient other, int v0, int width) {
        if ((v0 & 1) != 0) {
            int u2 = 0;
            while (u2 < width) {
                int n2 = u2++;
                other.floatItems[n2] = (float)((double)other.floatItems[n2] * 0.5);
            }
        }
    }

    private static void getK(SubbandCoefficient other, int u0, int width, int height, boolean reversible) {
        block3: {
            float[] rowBuffer;
            block2: {
                rowBuffer = new float[width + 8];
                if (width != 1) break block2;
                if ((u0 & 1) == 0) break block3;
                int k2 = 0;
                for (int v2 = 0; v2 < height; ++v2) {
                    int n2 = k2++;
                    other.floatItems[n2] = other.floatItems[n2] * 0.5f;
                }
                break block3;
            }
            int k3 = 0;
            for (int v3 = 0; v3 < height; ++v3) {
                System.arraycopy(other.floatItems, k3, rowBuffer, 4, width);
                Trns.applyFilter(rowBuffer, width, reversible);
                System.arraycopy(rowBuffer, 4, other.floatItems, k3, width);
                k3 += width;
            }
        }
    }

    private static void updateItemCount(SubbandCoefficient ll, SubbandCoefficient other, int widthLL, int heightLL, int w2) {
        int k2 = 0;
        for (int i2 = 0; i2 < heightLL; ++i2) {
            int l2 = i2 * w2;
            for (int j2 = 0; j2 < widthLL; ++j2) {
                other.floatItems[l2] = ll.floatItems[k2++];
                l2 += 2;
            }
        }
    }
}

