/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.EntropyEncoder;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import java.util.Arrays;

public class Tier1Encoder {
    private final int cbw;
    private final int cbh;
    private final EntropyEncoder encoder;
    private final CodeBlock cb;
    private int maxMag;
    private final int mb;
    private final int[] magnArr;
    private final byte[] signArr;
    private final byte[] aArr;
    private final byte[] a_Arr;
    private final byte[] nArr;
    private final byte[] vArr;
    private final byte[] zArr;
    private boolean pnh;
    private int znh;
    private static final byte[] CXLLHH = new byte[]{0, 1, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] CXHL = new byte[]{0, 1, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] CXHH = new byte[]{0, 3, 3, 6, 3, 6, 6, 8, 3, 6, 6, 8, 6, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 1, 4, 4, 7, 4, 7, 7, 8, 4, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8, 2, 5, 5, 7, 5, 7, 7, 8, 5, 7, 7, 8, 7, 8, 8, 8};
    private static final int[] CXSIGN = new int[]{9, 10, 10, 0, 12, 13, 11, 0, 12, 11, 13};
    private final byte[] zeroTable;

    public Tier1Encoder(Info info, TileBand tb, CodeBlock cb) {
        this.encoder = info.entropy;
        this.encoder.init();
        this.mb = info.qcd.guardBits + tb.eb - 1;
        this.cb = cb;
        this.cbw = cb.tbx1_ - cb.tbx0_;
        this.cbh = cb.tby1_ - cb.tby0_;
        Arrays.fill(info.signArray, (byte)0);
        Arrays.fill(info.curFlagArray, (byte)0);
        Arrays.fill(info.a_Array, (byte)0);
        Arrays.fill(info.nbrArray, (byte)0);
        Arrays.fill(info.zArray, (byte)0);
        this.magnArr = info.magnArray;
        this.signArr = info.signArray;
        this.aArr = info.curFlagArray;
        this.a_Arr = info.a_Array;
        this.nArr = info.nbrArray;
        this.vArr = info.bitsDecArray;
        this.zArr = info.zArray;
        int pos = 0;
        int tbw = tb.x1 - tb.x0;
        float[] subbandData = tb.floats;
        for (int y2 = cb.tby0_; y2 < cb.tby1_; ++y2) {
            for (int x2 = cb.tbx0_; x2 < cb.tbx1_; ++x2) {
                int mn = (int)subbandData[y2 * tbw + x2];
                if (mn < 0) {
                    this.signArr[pos] = 1;
                    mn = -mn;
                }
                this.maxMag = mn > this.maxMag ? mn : this.maxMag;
                this.magnArr[pos] = mn;
                ++pos;
            }
        }
        switch (tb.type) {
            case 3: {
                this.zeroTable = CXHH;
                break;
            }
            case 2: {
                this.zeroTable = CXHL;
                break;
            }
            default: {
                this.zeroTable = CXLLHH;
            }
        }
    }

    public void encode() {
        int nBP = 0;
        for (int t2 = this.maxMag; t2 > 0; t2 >>= 1) {
            ++nBP;
        }
        this.cb.zeroBitPlanes = this.mb - nBP;
        int p2 = nBP - 1;
        int nPasses = 0;
        this.updateV(p2);
        while (true) {
            ++nPasses;
            this.cup();
            if (p2 <= 0) break;
            Arrays.fill(this.nArr, (byte)0);
            this.updateV(--p2);
            nPasses += 2;
            this.spp();
            this.mrp();
        }
        this.cb.block.data = this.encoder.getEncodedData();
        this.cb.block.nCodingPass = (byte)nPasses;
    }

    private void updateV(int p2) {
        int len = this.vArr.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.vArr[i2] = (byte)(this.magnArr[i2] >> p2 & 1);
        }
    }

    private void callCXD(int cx, int d2) {
        this.encoder.encode(cx, d2);
    }

    private void cup() {
        int nextBit = 0;
        int h2 = this.cbh;
        int w2 = this.cbw;
        int w22 = this.cbw * 2;
        int w3 = this.cbw * 3;
        while (nextBit < h2) {
            int i0 = nextBit;
            nextBit = Math.min(i0 + 4, h2);
            boolean has4 = i0 + 3 < h2;
            for (int j2 = 0; j2 < w2; ++j2) {
                int i1 = 0;
                int mn = i0 * w2 + j2;
                int mn3 = mn + w3;
                if (this.aArr[mn] == 0 && this.nArr[mn] == 0 && has4 && this.canRLC(mn, mn3)) {
                    byte r0 = this.vArr[mn];
                    byte r1 = this.vArr[mn + w2];
                    byte r2 = this.vArr[mn + w22];
                    byte r3 = this.vArr[mn3];
                    int v2 = r0 << 3 | r1 << 2 | r2 << 1 | r3;
                    if (v2 == 0) {
                        this.callCXD(17, 0);
                        continue;
                    }
                    i1 = this.getI1(i0, j2, mn, i0, i1, v2);
                }
                for (int i2 = i0 + i1; i2 < nextBit; ++i2) {
                    mn = i2 * w2 + j2;
                    if (this.aArr[mn] != 0 || this.nArr[mn] != 0) continue;
                    this.updateNeighbours(mn);
                    byte d2 = this.vArr[mn];
                    this.callCXD(this.zeroTable[this.znh], d2);
                    if (d2 != 1) continue;
                    this.signCoding(i2, j2, mn);
                    this.setNeighbours(i2, j2, mn);
                }
            }
        }
    }

    private int getI1(int i2, int j2, int mn, int i0, int i1, int v2) {
        this.callCXD(17, 1);
        while (i1 < 4 && (v2 >> 3 - i1 & 1) != 1) {
            ++i1;
        }
        int d2 = i1 >> 1 & 1;
        this.callCXD(18, d2);
        d2 = i1 & 1;
        this.callCXD(18, d2);
        if (i1 != 0) {
            i2 = i0 + i1;
            mn += i1 * this.cbw;
        }
        if ((d2 = this.vArr[mn]) == 1) {
            this.signCoding(i2, j2, mn);
            this.setNeighbours(i2, j2, mn);
        }
        return ++i1;
    }

    private boolean canRLC(int mn, int mn3) {
        this.updateNeighbours(mn);
        if (this.pnh) {
            return false;
        }
        this.updateNeighbours(mn3);
        return this.aArr[mn3] == 0 && !this.pnh;
    }

    private void spp() {
        for (int i0 = 0; i0 < this.cbh; i0 += 4) {
            for (int j2 = 0; j2 < this.cbw; ++j2) {
                int i2;
                int mn = i0 * this.cbw + j2;
                for (int i1 = 0; i1 < 4 && (i2 = i0 + i1) < this.cbh; ++i1) {
                    if (this.aArr[mn] == 0) {
                        this.updateNeighbours(mn);
                        if (this.pnh) {
                            byte cxLabel = this.zeroTable[this.znh];
                            byte d2 = this.vArr[mn];
                            this.callCXD(cxLabel, d2);
                            this.nArr[mn] = 1;
                            if (d2 == 1) {
                                this.signCoding(i2, j2, mn);
                                this.setNeighbours(i2, j2, mn);
                            }
                        }
                    }
                    mn += this.cbw;
                }
            }
        }
    }

    private void mrp() {
        for (int i0 = 0; i0 < this.cbh; i0 += 4) {
            for (int j2 = 0; j2 < this.cbw; ++j2) {
                int i2;
                int mn = i0 * this.cbw + j2;
                for (int i1 = 0; i1 < 4 && (i2 = i0 + i1) < this.cbh; ++i1) {
                    if (this.aArr[mn] == 1 && this.nArr[mn] == 0) {
                        int cxLabel;
                        byte d2 = this.vArr[mn];
                        if (this.a_Arr[mn] == 1) {
                            cxLabel = 16;
                        } else {
                            this.updateNeighbours(mn);
                            cxLabel = this.pnh ? 15 : 14;
                        }
                        this.callCXD(cxLabel, d2);
                        this.a_Arr[mn] = 1;
                    }
                    mn += this.cbw;
                }
            }
        }
    }

    private void signCoding(int i2, int j2, int mn) {
        byte sh0 = 0;
        byte sh1 = 0;
        byte sv0 = 0;
        byte sv1 = 0;
        if (i2 > 0) {
            sv0 = this.signArr[mn - this.cbw];
        }
        if (i2 + 1 < this.cbh) {
            sv1 = this.signArr[mn + this.cbw];
        }
        if (j2 > 0) {
            sh0 = this.signArr[mn - 1];
        }
        if (j2 + 1 < this.cbw) {
            sh1 = this.signArr[mn + 1];
        }
        int zn = this.zArr[mn] & 0xFF;
        int h0 = zn >> 7 & 1;
        int h1 = zn >> 6 & 1;
        int v0 = zn >> 5 & 1;
        int v1 = zn >> 4 & 1;
        int h2 = h0 * (1 - 2 * sh0) + h1 * (1 - 2 * sh1);
        h2 = h2 < 0 ? 2 : (h2 > 1 ? 1 : h2);
        int v2 = v0 * (1 - 2 * sv0) + v1 * (1 - 2 * sv1);
        v2 = v2 < 0 ? 2 : (v2 > 1 ? 1 : v2);
        int hv = h2 << 2 | v2;
        byte xorB = h2 == 2 || hv == 2 ? (byte)1 : 0;
        int cxLabel = CXSIGN[hv];
        int d2 = xorB ^ this.signArr[mn];
        this.callCXD(cxLabel, d2);
    }

    private void updateNeighbours(int mn) {
        this.znh = this.zArr[mn] & 0xFF;
        this.pnh = this.znh != 0;
    }

    private void setNeighbours(int m2, int n2, int mn) {
        int i2;
        boolean right;
        this.aArr[mn] = 1;
        boolean left = n2 > 0;
        boolean bl2 = right = n2 + 1 < this.cbw;
        if (m2 > 0) {
            i2 = mn - this.cbw;
            if (left) {
                this.zArr[i2 - 1] = (byte)(this.zArr[i2 - 1] & 0xFF | 1);
            }
            if (right) {
                this.zArr[i2 + 1] = (byte)(this.zArr[i2 + 1] & 0xFF | 2);
            }
            this.zArr[i2] = (byte)(this.zArr[i2] & 0xFF | 0x10);
        }
        if (m2 + 1 < this.cbh) {
            i2 = mn + this.cbw;
            if (left) {
                this.zArr[i2 - 1] = (byte)(this.zArr[i2 - 1] & 0xFF | 4);
            }
            if (right) {
                this.zArr[i2 + 1] = (byte)(this.zArr[i2 + 1] & 0xFF | 8);
            }
            this.zArr[i2] = (byte)(this.zArr[i2] & 0xFF | 0x20);
        }
        if (left) {
            this.zArr[mn - 1] = (byte)(this.zArr[mn - 1] & 0xFF | 0x40);
        }
        if (right) {
            this.zArr[mn + 1] = (byte)(this.zArr[mn + 1] & 0xFF | 0x80);
        }
    }
}

