/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.JpxBitWriter;

public class TagTree {
    private final int w;
    private final int h;
    private int lvls;
    private final int[][] treeV;
    private final int[][] treeS;

    public TagTree(int h2, int w2, int[] val) {
        this.w = w2;
        this.h = h2;
        int w22 = this.w;
        int h22 = this.h;
        if (w2 == 0 || h2 == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (h22 != 1 || w22 != 1) {
                w22 = w22 + 1 >> 1;
                h22 = h22 + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        w22 = this.w;
        for (int i2 = 0; i2 < this.lvls; ++i2) {
            this.treeV[i2] = new int[h2 * w22];
            this.treeS[i2] = new int[h2 * w22];
            w22 = w2 + 1 >> 1;
        }
        for (int k2 = w2 * h2 - 1; k2 >= 0; --k2) {
            this.treeV[0][k2] = val[k2];
        }
        this.recalculate();
    }

    private void recalculate() {
        for (int k2 = 0; k2 < this.lvls - 1; ++k2) {
            int bi2;
            int n2;
            int m2;
            int lw = this.w + (1 << k2) - 1 >> k2;
            int lh = this.h + (1 << k2) - 1 >> k2;
            for (m2 = (lh >> 1 << 1) - 2; m2 >= 0; m2 -= 2) {
                for (n2 = (lw >> 1 << 1) - 2; n2 >= 0; n2 -= 2) {
                    bi2 = m2 * lw + n2;
                    int tm1 = this.treeV[k2][bi2] < this.treeV[k2][bi2 + 1] ? this.treeV[k2][bi2] : this.treeV[k2][bi2 + 1];
                    int tm2 = this.treeV[k2][bi2 + lw] < this.treeV[k2][bi2 + lw + 1] ? this.treeV[k2][bi2 + lw] : this.treeV[k2][bi2 + lw + 1];
                    this.treeV[k2 + 1][(m2 >> 1) * (lw + 1 >> 1) + (n2 >> 1)] = tm1 < tm2 ? tm1 : tm2;
                }
                if (lw % 2 == 0) continue;
                n2 = lw >> 1 << 1;
                bi2 = m2 * lw + n2;
                this.treeV[k2 + 1][(m2 >> 1) * (lw + 1 >> 1) + (n2 >> 1)] = this.treeV[k2][bi2] < this.treeV[k2][bi2 + lw] ? this.treeV[k2][bi2] : this.treeV[k2][bi2 + lw];
            }
            if (lh % 2 == 0) continue;
            m2 = lh >> 1 << 1;
            for (n2 = (lw >> 1 << 1) - 2; n2 >= 0; n2 -= 2) {
                bi2 = m2 * lw + n2;
                this.treeV[k2 + 1][(m2 >> 1) * (lw + 1 >> 1) + (n2 >> 1)] = this.treeV[k2][bi2] < this.treeV[k2][bi2 + 1] ? this.treeV[k2][bi2] : this.treeV[k2][bi2 + 1];
            }
            if (lw % 2 == 0) continue;
            n2 = lw >> 1 << 1;
            this.treeV[k2 + 1][(m2 >> 1) * (lw + 1 >> 1) + (n2 >> 1)] = this.treeV[k2][m2 * lw + n2];
        }
    }

    public void encode(int m2, int n2, JpxBitWriter out) {
        int t2 = 1028;
        int k2 = this.lvls - 1;
        int tmin = this.treeS[k2][0];
        while (true) {
            int idx;
            int ts;
            if ((ts = this.treeS[k2][idx = (m2 >> k2) * (this.w + (1 << k2) - 1 >> k2) + (n2 >> k2)]) < tmin) {
                ts = tmin;
            }
            while (1028 > ts) {
                if (this.treeV[k2][idx] > ts) {
                    out.putBit(0);
                } else if (this.treeV[k2][idx] == ts) {
                    out.putBit(1);
                } else {
                    ts = 1028;
                    break;
                }
                ++ts;
            }
            this.treeS[k2][idx] = ts;
            if (k2 <= 0) break;
            tmin = ts < this.treeV[k2][idx] ? ts : this.treeV[k2][idx];
            --k2;
        }
    }
}

