/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.TreeNode;

public class QuadTree {
    private final TreeNode[] nodeMap;
    private int value;
    private int currentLevel;

    public QuadTree(int width, int height) {
        int x2 = Math.max(width, height);
        int n2 = 1;
        int tt = 0;
        while (x2 > n2) {
            n2 <<= 1;
            ++tt;
        }
        int levLen = tt + 1;
        this.nodeMap = new TreeNode[levLen];
        for (int i2 = 0; i2 < levLen; ++i2) {
            this.nodeMap[i2] = new TreeNode(width, height);
            width = width + 1 >> 1;
            height = height + 1 >> 1;
        }
    }

    public void reset(int i2, int j2) {
        TreeNode level;
        int curLev;
        int val = 0;
        int len = this.nodeMap.length;
        for (curLev = 0; curLev < len; ++curLev) {
            level = this.nodeMap[curLev];
            int index = i2 + j2 * level.width;
            int kVal = level.items[index];
            if (kVal != -1) {
                val = kVal;
                break;
            }
            level.index = index;
            i2 >>= 1;
            j2 >>= 1;
        }
        level = this.nodeMap[--curLev];
        level.items[level.index] = val;
        this.currentLevel = curLev;
        this.value = 0;
    }

    public void incrementValue() {
        TreeNode level = this.nodeMap[this.currentLevel];
        int n2 = level.index;
        level.items[n2] = level.items[n2] + 1;
    }

    public boolean nextNode() {
        int curLev = this.currentLevel;
        TreeNode level = this.nodeMap[curLev];
        int val = level.items[level.index];
        if (--curLev < 0) {
            this.value = val;
            return false;
        }
        this.currentLevel = curLev;
        level = this.nodeMap[curLev];
        level.items[level.index] = val;
        return true;
    }

    public int getValue() {
        return this.value;
    }
}

