/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.Info;
import com.idrsolutions.image.jpeg2000.data.Packet;
import com.idrsolutions.image.jpeg2000.data.PrecinctSizeInfo;
import com.idrsolutions.image.jpeg2000.data.Progression;
import com.idrsolutions.image.jpeg2000.data.SIZ;
import com.idrsolutions.image.jpeg2000.data.SizeComponent;
import com.idrsolutions.image.jpeg2000.data.Tile;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import com.idrsolutions.image.jpeg2000.data.TileComponent;
import com.idrsolutions.image.jpeg2000.data.TileResolution;

public class PCRL
implements Progression {
    private final Tile tile;
    private final int layersCount;
    private final int componentsCount;
    private final PrecinctSizeInfo precinctsSizes;
    private final PrecinctSizeInfo precinctsIterationSizes;
    private final int maxNL;
    private int l;
    private int r;
    private int c;
    private int px;
    private int py;

    public PCRL(Info info, int tileIndex) {
        SIZ siz = info.siz;
        this.tile = info.tilesMap.get(tileIndex);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = siz.Csiz;
        this.maxNL = this.tile.cod.nDecompLevel;
        this.precinctsIterationSizes = this.precinctsSizes = this.getPrecinctSizesInImageScale(this.tile, this.maxNL);
    }

    @Override
    public Packet getNextPacket() {
        while (this.py < this.precinctsIterationSizes.maxNumHigh) {
            while (this.px < this.precinctsIterationSizes.maxNumWide) {
                while (this.c < this.componentsCount) {
                    TileComponent component = this.tile.components.get(this.c);
                    while (this.r <= this.maxNL) {
                        int[] sizeInImageScale = this.precinctsSizes.components[this.c].resolutions[this.r];
                        TileResolution resolution = component.resolutions.get(this.r);
                        int k2 = PCRL.getPrecinctIndexIfExist(this.px, this.py, sizeInImageScale, this.precinctsIterationSizes, resolution);
                        if (k2 == -1) {
                            ++this.r;
                            continue;
                        }
                        if (this.l < this.layersCount) {
                            Packet packet = this.createPacket(resolution, k2, this.l);
                            ++this.l;
                            return packet;
                        }
                        this.l = 0;
                        ++this.r;
                    }
                    this.r = 0;
                    ++this.c;
                }
                this.c = 0;
                ++this.px;
            }
            this.px = 0;
            ++this.py;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution resolution, int precintNumber, int layerNumber) {
        Packet packet = new Packet();
        packet.layerNumber = layerNumber;
        for (TileBand subband : resolution.tileBands) {
            for (CodeBlock codeBlock : subband.codeBlocks) {
                if (codeBlock.precinctNumber != precintNumber) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }

    private PrecinctSizeInfo getPrecinctSizesInImageScale(Tile tile, int maxNL) {
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        int maxNumWide = 0;
        int maxNumHigh = 0;
        SizeComponent[] sizePerComponent = new SizeComponent[this.componentsCount];
        for (int cc = 0; cc < this.componentsCount; ++cc) {
            TileComponent component = tile.components.get(cc);
            int[][] sizePerResolution = new int[maxNL + 1][2];
            int minWidthCurrentComponent = Integer.MAX_VALUE;
            int minHeightCurrentComponent = Integer.MAX_VALUE;
            int maxNumWideCurrentComponent = 0;
            int maxNumHighCurrentComponent = 0;
            int scale = 1;
            for (int rr = maxNL; rr >= 0; --rr) {
                TileResolution tr = component.resolutions.get(rr);
                int wcr = scale * tr.precinctInfo.precinctWidth;
                int hcr = scale * tr.precinctInfo.precinctHeight;
                minWidthCurrentComponent = Math.min(minWidthCurrentComponent, wcr);
                minHeightCurrentComponent = Math.min(minHeightCurrentComponent, hcr);
                maxNumWideCurrentComponent = Math.max(maxNumWideCurrentComponent, tr.precinctInfo.numPrecinctsWide);
                maxNumHighCurrentComponent = Math.max(maxNumHighCurrentComponent, tr.precinctInfo.numPrecinctsHigh);
                sizePerResolution[rr][0] = wcr;
                sizePerResolution[rr][1] = hcr;
                scale <<= 1;
            }
            minWidth = Math.min(minWidth, minWidthCurrentComponent);
            minHeight = Math.min(minHeight, minHeightCurrentComponent);
            maxNumWide = Math.max(maxNumWide, maxNumWideCurrentComponent);
            maxNumHigh = Math.max(maxNumHigh, maxNumHighCurrentComponent);
            sizePerComponent[cc] = new SizeComponent();
            sizePerComponent[cc].resolutions = sizePerResolution;
        }
        PrecinctSizeInfo ps = new PrecinctSizeInfo();
        ps.components = sizePerComponent;
        ps.minWidth = minWidth;
        ps.minHeight = minHeight;
        ps.maxNumWide = maxNumWide;
        ps.maxNumHigh = maxNumHigh;
        return ps;
    }

    private static int getPrecinctIndexIfExist(int px, int py, int[] sizeInImageScale, PrecinctSizeInfo psi, TileResolution tr) {
        int posX = px * psi.minWidth;
        int posY = py * psi.minHeight;
        if (posX % sizeInImageScale[0] != 0 || posY % sizeInImageScale[1] != 0) {
            return -1;
        }
        int startPrecinctRowIndex = posY / sizeInImageScale[0] * tr.precinctInfo.numPrecinctsWide;
        return posX / sizeInImageScale[1] + startPrecinctRowIndex;
    }
}

