/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.COD;
import com.idrsolutions.image.jpeg2000.data.CodeBlock;
import com.idrsolutions.image.jpeg2000.data.EntropyEncoder;
import com.idrsolutions.image.jpeg2000.data.Palette;
import com.idrsolutions.image.jpeg2000.data.Precinct;
import com.idrsolutions.image.jpeg2000.data.PrecinctInfo;
import com.idrsolutions.image.jpeg2000.data.QCD;
import com.idrsolutions.image.jpeg2000.data.SIZ;
import com.idrsolutions.image.jpeg2000.data.Tile;
import com.idrsolutions.image.jpeg2000.data.TileBand;
import com.idrsolutions.image.jpeg2000.data.TileComponent;
import com.idrsolutions.image.jpeg2000.data.TileResolution;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Info {
    public static final int CS_CMYK = 12;
    public static final int CS_GRAYSCALE = 16;
    public static final int CS_SRGB = 17;
    public static final int CS_SYCC = 18;
    public int imageWidth;
    public int imageHeight;
    public int nComp;
    public byte[] bitDepths;
    public int enumerateCS;
    public final List<Integer> contiguousCodeStreamBoxes = new ArrayList<Integer>();
    public Tile tileProcess;
    public boolean mainSOC;
    public SIZ siz;
    public COD cod;
    public QCD qcd;
    public QCD[] qcc;
    public Palette palette;
    public final int[] ROI = new int[8];
    public final HashMap<Integer, Tile> tilesMap = new HashMap();
    public final HashMap<Integer, Integer> cDef = new HashMap();
    public int[] magnArray = new int[4096];
    public byte[] nbrArray = new byte[4096];
    public byte[] signArray = new byte[4096];
    public byte[] curFlagArray = new byte[4096];
    public byte[] bitsDecArray = new byte[4096];
    public final byte[] a_Array = new byte[4096];
    public final byte[] zArray = new byte[4096];
    public final EntropyEncoder entropy = new EntropyEncoder();

    public void generateTileMap() {
        int numXTiles = (int)Math.ceil(1.0 * (double)(this.siz.Xsiz - this.siz.XTOsiz) / (double)this.siz.XTsiz);
        int numYTiles = (int)Math.ceil(1.0 * (double)(this.siz.Ysiz - this.siz.YTOsiz) / (double)this.siz.YTsiz);
        int index = 0;
        for (int q2 = 0; q2 < numYTiles; ++q2) {
            for (int p2 = 0; p2 < numXTiles; ++p2) {
                Tile tile = new Tile();
                tile.x0 = Math.max(this.siz.XTOsiz + p2 * this.siz.XTsiz, this.siz.XOsiz);
                tile.y0 = Math.max(this.siz.YTOsiz + q2 * this.siz.YTsiz, this.siz.YOsiz);
                tile.x1 = Math.min(this.siz.XTOsiz + (p2 + 1) * this.siz.XTsiz, this.siz.Xsiz);
                tile.y1 = Math.min(this.siz.YTOsiz + (q2 + 1) * this.siz.YTsiz, this.siz.Ysiz);
                for (int i2 = 0; i2 < this.siz.Csiz; ++i2) {
                    int XRsiz_ = this.siz.precisionInfo[i2][1];
                    int YRsiz_ = this.siz.precisionInfo[i2][2];
                    TileComponent tc = new TileComponent();
                    tc.x0 = (int)Math.ceil(1.0 * (double)tile.x0 / (double)XRsiz_);
                    tc.x1 = (int)Math.ceil(1.0 * (double)tile.x1 / (double)XRsiz_);
                    tc.y0 = (int)Math.ceil(1.0 * (double)tile.y0 / (double)YRsiz_);
                    tc.y1 = (int)Math.ceil(1.0 * (double)tile.y1 / (double)YRsiz_);
                    tile.components.add(tc);
                }
                this.tilesMap.put(index, tile);
                ++index;
            }
        }
    }

    public static void updateCodeBlocks(TileResolution tr, TileBand tb, int xcb_, int ycb_) {
        int codeblockWidth = 1 << xcb_;
        int codeblockHeight = 1 << ycb_;
        int cbx0 = tb.x0 >> xcb_;
        int cby0 = tb.y0 >> ycb_;
        int cbx1 = tb.x1 + codeblockWidth - 1 >> xcb_;
        int cby1 = tb.y1 + codeblockHeight - 1 >> ycb_;
        PrecinctInfo precintInfo = tr.precinctInfo;
        List<CodeBlock> codeblocks = tb.codeBlocks;
        List<Precinct> precincts = tb.precincts;
        for (int j2 = cby0; j2 < cby1; ++j2) {
            for (int i2 = cbx0; i2 < cbx1; ++i2) {
                Precinct precinct;
                int precintNumber;
                CodeBlock cblk = new CodeBlock();
                cblk.x = i2;
                cblk.y = j2;
                cblk.tbx0 = codeblockWidth * i2;
                cblk.tby0 = codeblockHeight * j2;
                cblk.tbx1 = codeblockWidth * (i2 + 1);
                cblk.tby1 = codeblockHeight * (j2 + 1);
                cblk.tbx0_ = Math.max(tb.x0, cblk.tbx0);
                cblk.tby0_ = Math.max(tb.y0, cblk.tby0);
                cblk.tbx1_ = Math.min(tb.x1, cblk.tbx1);
                cblk.tby1_ = Math.min(tb.y1, cblk.tby1);
                int pi = (int)Math.floor((double)(cblk.tbx0_ - tb.x0) / ((double)precintInfo.precinctWidthInSubband * 1.0));
                int pj = (int)Math.floor((double)(cblk.tby0_ - tb.y0) / ((double)precintInfo.precinctHeightInSubband * 1.0));
                cblk.precinctNumber = precintNumber = pi + pj * precintInfo.numPrecinctsWide;
                cblk.subbandType = tb.type;
                cblk.Lblock = 3;
                if (cblk.tbx1_ <= cblk.tbx0_ || cblk.tby1_ <= cblk.tby0_) continue;
                codeblocks.add(cblk);
                if (precincts.size() > precintNumber) {
                    precinct = precincts.get(precintNumber);
                    if (i2 < precinct.cbx0) {
                        precinct.cbx0 = i2;
                    } else if (i2 > precinct.cbx1) {
                        precinct.cbx1 = i2;
                    }
                    if (j2 < precinct.cby0) {
                        precinct.cbx0 = j2;
                    } else if (j2 > precinct.cby1) {
                        precinct.cby1 = j2;
                    }
                } else {
                    precinct = new Precinct();
                    precinct.cby0 = j2;
                    precinct.cby1 = j2;
                    precinct.cbx0 = i2;
                    precinct.cbx1 = i2;
                    precincts.add(precinct);
                }
                cblk.precinct = precinct;
            }
        }
    }

    public static void getComponentAsABGR(BufferedImage image, int[] pix) {
        switch (image.getType()) {
            case 10: {
                Info.updateGray(image, pix);
                break;
            }
            case 5: {
                Info.updateBGR(image, pix);
                break;
            }
            case 6: 
            case 7: {
                Info.updateABGR(image, pix);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Info.updateRGB(image, pix);
                break;
            }
            case 4: {
                Info.updateBGR_INT(image, pix);
                break;
            }
            case 13: {
                Info.updateIndexed(image, pix);
                break;
            }
            case 11: {
                Info.updateGray16(image, pix);
                break;
            }
            default: {
                Info.updateCustom(image, pix);
            }
        }
    }

    private static void updateGray(BufferedImage image, int[] r2) {
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < data.length; ++i2) {
            r2[i2] = data[i2] & 0xFF;
        }
    }

    private static void updateGray16(BufferedImage image, int[] pix) {
        short[] data = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < data.length; i2 += 2) {
            pix[i2] = data[i2] >> 8;
        }
    }

    private static void updateBGR(BufferedImage image, int[] pix) {
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        for (int i2 = 0; i2 < data.length; i2 += 3) {
            int b2 = data[i2] & 0xFF;
            int g2 = data[i2 + 1] & 0xFF;
            int r2 = data[i2 + 2] & 0xFF;
            pix[p2++] = b2 << 16 | g2 << 8 | r2;
        }
    }

    private static void updateABGR(BufferedImage image, int[] pix) {
        byte[] data = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        for (int i2 = 0; i2 < data.length; i2 += 4) {
            int a10 = data[i2] & 0xFF;
            int b2 = data[i2 + 1] & 0xFF;
            int g2 = data[i2 + 2] & 0xFF;
            int r2 = data[i2 + 3] & 0xFF;
            pix[p2++] = a10 << 24 | b2 << 16 | g2 << 8 | r2;
        }
    }

    private static void updateRGB(BufferedImage image, int[] pix) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < pixels.length; ++i2) {
            int v2 = pixels[i2];
            int a10 = v2 >> 24 & 0xFF;
            int r2 = v2 >> 16 & 0xFF;
            int g2 = v2 >> 8 & 0xFF;
            int b2 = v2 & 0xFF;
            pix[i2] = a10 << 24 | b2 << 16 | g2 << 8 | r2;
        }
    }

    private static void updateBGR_INT(BufferedImage image, int[] pix) {
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        System.arraycopy(pixels, 0, pix, 0, pix.length);
    }

    private static void updateIndexed(BufferedImage image, int[] pix) {
        int[] argb = new int[256];
        IndexColorModel icm = (IndexColorModel)image.getColorModel();
        icm.getRGBs(argb);
        byte[] temp = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < temp.length; ++i2) {
            int v2 = argb[temp[i2] & 0xFF];
            int a10 = v2 >> 24 & 0xFF;
            int r2 = v2 >> 16 & 0xFF;
            int g2 = v2 >> 8 & 0xFF;
            int b2 = v2 & 0xFF;
            pix[i2] = a10 << 24 | b2 << 16 | g2 << 8 | r2;
        }
    }

    private static void updateCustom(BufferedImage image, int[] pix) {
        int i2 = 0;
        for (int y2 = 0; y2 < image.getHeight(); ++y2) {
            for (int x2 = 0; x2 < image.getWidth(); ++x2) {
                int v2 = image.getRGB(x2, y2);
                int a10 = v2 >> 24 & 0xFF;
                int r2 = v2 >> 16 & 0xFF;
                int g2 = v2 >> 8 & 0xFF;
                int b2 = v2 & 0xFF;
                pix[i2++] = a10 << 24 | b2 << 16 | g2 << 8 | r2;
            }
        }
    }

    @Deprecated
    public static float[] getBoundary(int x2, int y2, int x22, int y22, int iw, int ih, float[] data) {
        return Info.getBoundary(x2, y2, x22, y22, ih, data);
    }

    public static float[] getBoundary(int x2, int y2, int x22, int y22, int ih, float[] data) {
        float[] result = new float[(x22 - x2) * (y22 - y2)];
        int p2 = 0;
        for (int i2 = y2; i2 < x22; ++i2) {
            for (int j2 = x2; j2 < y22; ++j2) {
                result[p2++] = data[i2 * ih + j2];
            }
        }
        return result;
    }
}

