/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000.data;

import com.idrsolutions.image.jpeg2000.data.TreeNode;

public class IncQuadTree {
    private final TreeNode[] nodeList;
    private int currentLevel;

    public IncQuadTree(int width, int height, int def) {
        int x2 = Math.max(width, height);
        int n2 = 1;
        int tt = 0;
        while (x2 > n2) {
            n2 <<= 1;
            ++tt;
        }
        int levLen = tt + 1;
        this.nodeList = new TreeNode[levLen];
        for (int i2 = 0; i2 < levLen; ++i2) {
            TreeNode lev = new TreeNode(width, height);
            int dim = width * height;
            for (int j2 = 0; j2 < dim; ++j2) {
                lev.items[j2] = def;
            }
            this.nodeList[i2] = lev;
            width = width + 1 >> 1;
            height = height + 1 >> 1;
        }
    }

    public boolean reset(int m2, int n2, int stop) {
        int curLev;
        int len = this.nodeList.length;
        for (curLev = 0; curLev < len; ++curLev) {
            int index;
            TreeNode level = this.nodeList[curLev];
            level.index = index = m2 + n2 * level.width;
            int val = level.items[index];
            if (val == 255) break;
            if (val > stop) {
                this.currentLevel = curLev;
                this.updateValues();
                return false;
            }
            m2 >>= 1;
            n2 >>= 1;
        }
        this.currentLevel = curLev - 1;
        return true;
    }

    public void incrementValue(int stop) {
        TreeNode level = this.nodeList[this.currentLevel];
        level.items[level.index] = stop + 1;
        this.updateValues();
    }

    private void updateValues() {
        int levIndex = this.currentLevel;
        TreeNode level = this.nodeList[levIndex];
        int curVal = level.items[level.index];
        while (--levIndex >= 0) {
            level = this.nodeList[levIndex];
            level.items[level.index] = curVal;
        }
    }

    public boolean nextNode() {
        int curLev = this.currentLevel;
        TreeNode level = this.nodeList[curLev];
        int value = level.items[level.index];
        level.items[level.index] = 255;
        if (--curLev < 0) {
            return false;
        }
        this.currentLevel = curLev;
        level = this.nodeList[curLev];
        level.items[level.index] = value;
        return true;
    }
}

