/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg.data;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.jpeg.data.JpegScanner;
import java.util.Arrays;
import org.jpedal.io.filter.DCT;

public class JpegScannerInts
extends JpegScanner {
    private final int[] p64 = new int[64];

    public JpegScannerInts(byte[] data) {
        super(data);
    }

    @Override
    void decodeOrdering(Component component, int offsetD, int decodeFn) {
        Arrays.fill(component.codeInts, 0);
        switch (decodeFn) {
            case 0: {
                int e2 = this.findHuffmanValue(component.huffmanTableDC);
                int diff = e2 == 0 ? 0 : this.getNextFull(e2) << this.successive;
                component.codeInts[0] = component.pred += diff;
                break;
            }
            case 1: {
                component.codeInts[0] = component.codeInts[0] | this.readBit() << this.successive;
                break;
            }
            case 2: {
                if (this.eobrun > 0) {
                    --this.eobrun;
                    break;
                }
                this.handleACFirst(component);
                break;
            }
            case 3: {
                this.handleACSuccessive(component);
                break;
            }
            case 4: {
                this.handleBaseline(component);
            }
        }
        DCT.IDCTQInts(component, this.p64);
        for (int i2 = 0; i2 < 64; ++i2) {
            component.codeBytes[i2 + offsetD] = (byte)component.codeInts[i2];
        }
    }

    private void handleACSuccessive(Component component) {
        int a10 = this.sStart;
        int b2 = this.sEnd;
        int c2 = 0;
        block6: while (a10 <= b2) {
            byte z2 = JpegDecoder.ZIGZAGORDER[a10];
            switch (this.stateAC) {
                case 0: {
                    int f2 = this.findHuffmanValue(component.huffmanTableAC);
                    int d2 = f2 & 0xF;
                    c2 = f2 >> 4;
                    if (d2 == 0) {
                        if (c2 < 15) {
                            this.eobrun = this.getNext(c2) + (1 << c2);
                            this.stateAC = 4;
                            continue block6;
                        }
                        c2 = 16;
                        this.stateAC = 1;
                        continue block6;
                    }
                    this.stateNextAC = this.getNextFull(d2);
                    this.stateAC = c2 != 0 ? 2 : 3;
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (component.codeInts[z2] != 0) {
                        byte by = z2;
                        component.codeInts[by] = component.codeInts[by] + (this.readBit() << this.successive);
                        break;
                    }
                    if (--c2 != 0) break;
                    this.stateAC = this.stateAC == 2 ? 3 : 0;
                    break;
                }
                case 3: {
                    if (component.codeInts[z2] != 0) {
                        byte by = z2;
                        component.codeInts[by] = component.codeInts[by] + (this.readBit() << this.successive);
                        break;
                    }
                    component.codeInts[z2] = this.stateNextAC << this.successive;
                    this.stateAC = 0;
                    break;
                }
                case 4: {
                    if (component.codeInts[z2] == 0) break;
                    byte by = z2;
                    component.codeInts[by] = component.codeInts[by] + (this.readBit() << this.successive);
                }
            }
            ++a10;
        }
        if (this.stateAC == 4) {
            --this.eobrun;
            if (this.eobrun == 0) {
                this.stateAC = 0;
            }
        }
    }

    private void handleBaseline(Component component) {
        int a10 = 1;
        int e2 = this.findHuffmanValue(component.huffmanTableDC);
        int diff = e2 == 0 ? 0 : this.getNextFull(e2);
        component.codeInts[0] = component.pred += diff;
        while (a10 < 64) {
            int f2 = this.findHuffmanValue(component.huffmanTableAC);
            int d2 = f2 & 0xF;
            int c2 = f2 >> 4;
            if (d2 == 0) {
                if (c2 < 15) break;
                a10 += 16;
                continue;
            }
            byte z2 = JpegDecoder.ZIGZAGORDER[a10 += c2];
            component.codeInts[z2] = this.getNextFull(d2);
            ++a10;
        }
    }

    private void handleACFirst(Component component) {
        int a10 = this.sStart;
        int b2 = this.sEnd;
        while (a10 <= b2) {
            int f2 = this.findHuffmanValue(component.huffmanTableAC);
            int d2 = f2 & 0xF;
            int c2 = f2 >> 4;
            if (d2 == 0) {
                if (c2 < 15) {
                    this.eobrun = this.getNext(c2) + (1 << c2) - 1;
                    break;
                }
                a10 += 16;
                continue;
            }
            byte z2 = JpegDecoder.ZIGZAGORDER[a10 += c2];
            component.codeInts[z2] = this.getNextFull(d2) * (1 << this.successive);
            ++a10;
        }
    }
}

