/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg.data;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.data.Component;
import com.idrsolutions.image.jpeg.data.Frame;
import com.idrsolutions.image.jpeg.data.HTree;
import java.util.List;

public class JpegScanner {
    static final int DCFIRST = 0;
    static final int DCSUCCESSIVE = 1;
    static final int ACFIRST = 2;
    static final int ACSUCCESSIVE = 3;
    static final int BASELINE = 4;
    private final byte[] data;
    int bitPos;
    int bitBuffer;
    int eobrun;
    int mcusX;
    int offset;
    int successive;
    int sStart;
    int sEnd;
    int stateAC;
    int stateNextAC;

    public JpegScanner(byte[] data) {
        this.data = data;
    }

    public int decodeScan(int off, Frame frame, List<Component> components, int resetInterval, int sStart, int sEnd, int sPrev, int successive) {
        this.mcusX = frame.mcusX;
        this.offset = off;
        this.successive = successive;
        this.sStart = sStart;
        this.sEnd = sEnd;
        int componentsLength = components.size();
        int decodeFn = JpegScanner.getDecodeFn(frame, sStart, sPrev);
        int mcu = 0;
        int mcuExpected = componentsLength == 1 ? components.get((int)0).blocksX * components.get((int)0).blocksY : this.mcusX * frame.mcusY;
        while (mcu < mcuExpected) {
            int nc = resetInterval != 0 ? Math.min(mcuExpected - mcu, resetInterval) : mcuExpected;
            for (int i2 = 0; i2 < componentsLength; ++i2) {
                components.get((int)i2).pred = 0;
            }
            this.eobrun = 0;
            mcu = componentsLength == 1 ? this.setSingleComponent(components, decodeFn, mcu, nc) : this.setMultiComponent(components, componentsLength, decodeFn, mcu, nc);
            if (this.offset + 2 >= this.data.length) break;
            this.bitPos = 0;
            int[] markAndOff = new int[]{0, this.offset};
            JpegScanner.findNextFileMarker(this.data, markAndOff);
            int marker = markAndOff[0];
            this.offset = markAndOff[1];
            if (marker <= 65280) {
                return this.offset;
            }
            if (marker < 65488 || marker > 65495) break;
            this.offset += 2;
        }
        return this.offset;
    }

    private static void findNextFileMarker(byte[] data, int[] markAndOff) {
        int pos = markAndOff[1];
        int currentMarker = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        if (currentMarker >= 65472 && currentMarker <= 65534) {
            markAndOff[0] = currentMarker;
            return;
        }
        int newMarker = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        while (newMarker < 65472 || newMarker > 65534) {
            if (++pos >= data.length - 1) {
                markAndOff[1] = pos;
                return;
            }
            newMarker = (data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF;
        }
        markAndOff[0] = newMarker;
        markAndOff[1] = pos;
    }

    private static int getDecodeFn(Frame frame, int sStart, int sPrev) {
        int decodeFn = frame.progressive ? (sStart == 0 ? (sPrev == 0 ? 0 : 1) : (sPrev == 0 ? 2 : 3)) : 4;
        return decodeFn;
    }

    private int setSingleComponent(List<Component> components, int decodeFn, int mcu, int nc) {
        Component component = components.get(0);
        for (int n2 = 0; n2 < nc; ++n2) {
            this.decodeBlock(component, decodeFn, mcu);
            ++mcu;
        }
        return mcu;
    }

    private int setMultiComponent(List<Component> components, int componentsLength, int decodeFn, int mcu, int nc) {
        for (int n2 = 0; n2 < nc; ++n2) {
            for (int i2 = 0; i2 < componentsLength; ++i2) {
                Component component = components.get(i2);
                int h2 = component.h;
                int v2 = component.v;
                for (int j2 = 0; j2 < v2; ++j2) {
                    for (int k2 = 0; k2 < h2; ++k2) {
                        this.decodeMcu(component, decodeFn, mcu, j2, k2);
                    }
                }
            }
            ++mcu;
        }
        return mcu;
    }

    int findHuffmanValue(HTree tree) {
        HTree t2 = tree;
        do {
            t2 = t2.nodes[this.readBit()];
        } while (!t2.isEnd);
        return t2.value;
    }

    int readBit() {
        if (this.bitPos > 0) {
            --this.bitPos;
            return this.bitBuffer >> this.bitPos & 1;
        }
        this.bitBuffer = this.data[this.offset++] & 0xFF;
        this.offset += this.bitBuffer + 1 >> 8;
        this.bitPos = 7;
        return this.bitBuffer >> 7;
    }

    int getNext(int length) {
        int n2 = 0;
        while (length > 0) {
            n2 = n2 << 1 | this.readBit();
            --length;
        }
        return n2;
    }

    int getNextFull(int length) {
        if (length == 1) {
            return this.readBit() == 1 ? 1 : -1;
        }
        int n2 = this.getNext(length);
        if (n2 >= 1 << length - 1) {
            return n2;
        }
        return n2 + (-1 << length) + 1;
    }

    private void decodeMcu(Component component, int decodeFn, int mcu, int row, int col) {
        int mcuRow = mcu / this.mcusX;
        int mcuCol = mcu % this.mcusX;
        int blockRow = mcuRow * component.v + row;
        int blockCol = mcuCol * component.h + col;
        int offsetD = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
        this.decodeOrdering(component, offsetD, decodeFn);
    }

    private void decodeBlock(Component component, int decodeFn, int mcu) {
        int blockRow = mcu / component.blocksX;
        int blockCol = mcu % component.blocksX;
        int offsetD = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
        this.decodeOrdering(component, offsetD, decodeFn);
    }

    void decodeOrdering(Component component, int offset, int decodeFn) {
        switch (decodeFn) {
            case 0: {
                int e2 = this.findHuffmanValue(component.huffmanTableDC);
                int diff = e2 == 0 ? 0 : this.getNextFull(e2) << this.successive;
                component.pred += diff;
                component.codeBlock[offset] = (short)component.pred;
                break;
            }
            case 1: {
                int n2 = offset;
                component.codeBlock[n2] = (short)(component.codeBlock[n2] | this.readBit() << this.successive);
                break;
            }
            case 2: {
                if (this.eobrun > 0) {
                    --this.eobrun;
                    break;
                }
                this.handleACFirst(component, offset);
                break;
            }
            case 3: {
                this.handleACSuccessive(component, offset);
                break;
            }
            case 4: {
                this.handleBaseline(component, offset);
            }
        }
    }

    private void handleACSuccessive(Component component, int offset1) {
        int a10 = this.sStart;
        int b2 = this.sEnd;
        int c2 = 0;
        block6: while (a10 <= b2) {
            byte z2 = JpegDecoder.ZIGZAGORDER[a10];
            switch (this.stateAC) {
                case 0: {
                    int f2 = this.findHuffmanValue(component.huffmanTableAC);
                    int d2 = f2 & 0xF;
                    c2 = f2 >> 4;
                    if (d2 == 0) {
                        if (c2 < 15) {
                            this.eobrun = this.getNext(c2) + (1 << c2);
                            this.stateAC = 4;
                            continue block6;
                        }
                        c2 = 16;
                        this.stateAC = 1;
                        continue block6;
                    }
                    this.stateNextAC = this.getNextFull(d2);
                    this.stateAC = c2 != 0 ? 2 : 3;
                    continue block6;
                }
                case 1: 
                case 2: {
                    if (component.codeBlock[offset1 + z2] != 0) {
                        int n2 = offset1 + z2;
                        component.codeBlock[n2] = (short)(component.codeBlock[n2] + (this.readBit() << this.successive));
                        break;
                    }
                    if (--c2 != 0) break;
                    this.stateAC = this.stateAC == 2 ? 3 : 0;
                    break;
                }
                case 3: {
                    if (component.codeBlock[offset1 + z2] != 0) {
                        int n3 = offset1 + z2;
                        component.codeBlock[n3] = (short)(component.codeBlock[n3] + (this.readBit() << this.successive));
                        break;
                    }
                    component.codeBlock[offset1 + z2] = (short)(this.stateNextAC << this.successive);
                    this.stateAC = 0;
                    break;
                }
                case 4: {
                    if (component.codeBlock[offset1 + z2] == 0) break;
                    int n4 = offset1 + z2;
                    component.codeBlock[n4] = (short)(component.codeBlock[n4] + (this.readBit() << this.successive));
                }
            }
            ++a10;
        }
        if (this.stateAC == 4) {
            --this.eobrun;
            if (this.eobrun == 0) {
                this.stateAC = 0;
            }
        }
    }

    private void handleBaseline(Component component, int offset1) {
        int a10 = 1;
        int e2 = this.findHuffmanValue(component.huffmanTableDC);
        int diff = e2 == 0 ? 0 : this.getNextFull(e2);
        component.pred += diff;
        component.codeBlock[offset1] = (short)component.pred;
        while (a10 < 64) {
            int f2 = this.findHuffmanValue(component.huffmanTableAC);
            int d2 = f2 & 0xF;
            int c2 = f2 >> 4;
            if (d2 == 0) {
                if (c2 < 15) break;
                a10 += 16;
                continue;
            }
            byte z2 = JpegDecoder.ZIGZAGORDER[a10 += c2];
            component.codeBlock[offset1 + z2] = (short)this.getNextFull(d2);
            ++a10;
        }
    }

    private void handleACFirst(Component component, int offset1) {
        int a10 = this.sStart;
        int b2 = this.sEnd;
        while (a10 <= b2) {
            int f2 = this.findHuffmanValue(component.huffmanTableAC);
            int d2 = f2 & 0xF;
            int c2 = f2 >> 4;
            if (d2 == 0) {
                if (c2 < 15) {
                    this.eobrun = this.getNext(c2) + (1 << c2) - 1;
                    break;
                }
                a10 += 16;
                continue;
            }
            byte z2 = JpegDecoder.ZIGZAGORDER[a10 += c2];
            component.codeBlock[offset1 + z2] = (short)(this.getNextFull(d2) * (1 << this.successive));
            ++a10;
        }
    }

    public static int getCodeBlockOffset(Component component, int row, int col) {
        return 64 * ((component.blocksX + 1) * row + col);
    }
}

