/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.jpeg.options.JpegEncoderOptions;
import com.idrsolutions.image.util.ImageUtils;
import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder
extends JDeliImage
implements Encoder {
    private static final int[] QL = new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    private static final int[] QC = new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
    private static final int[] ZIGZAG = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private static final int[] CODESDCL = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] SYMBOLSDCL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] CODESACL = new int[]{0, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final int[] SYMBOLSACL = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private static final int[] CODESDCC = new int[]{0, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] SYMBOLSDCC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] CODESACC = new int[]{0, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final int[] SYMBOLSACC = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private final int[] TL = new int[64];
    private final int[] TC = new int[64];
    private final float[] FDL = new float[64];
    private final float[] FDC = new float[64];
    private final int[] DU = new int[64];
    private final int[] DCHTL = new int[12];
    private final int[] DCHTC = new int[12];
    private final int[] ACHTL = new int[256];
    private final int[] ACHTC = new int[256];
    private final int[] codes = new int[65536];
    private int buffer;
    private int bitLen;
    private static final int bLen = 1024;
    private final byte[] bArr = new byte[1024];
    private int bp;
    private OutputStream stream;
    private PixGet pg;
    private BufferedImage img;
    private JpegEncoderOptions jpegEncoderOptions = new JpegEncoderOptions();

    public JpegEncoder(EncoderOptions format) {
        if (format != null) {
            this.jpegEncoderOptions = (JpegEncoderOptions)format;
        }
    }

    public JpegEncoder() {
    }

    public JpegEncoderOptions getEncoderOptions() {
        return this.jpegEncoderOptions;
    }

    @Override
    public void write(BufferedImage image, OutputStream out) throws IOException {
        JpegEncoder.optimiseImage(image);
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(image);
        this.pg = Access.getPixGet(imageToCompress);
        this.bp = 0;
        this.img = imageToCompress;
        this.stream = out;
        this.encode(image.getWidth(), this.img.getHeight(), this.img.getType());
        if (this.bp > 0) {
            this.stream.write(this.bArr, 0, this.bp);
        }
    }

    @Deprecated
    public void setQuality(int percentage) {
        this.jpegEncoderOptions.setQuality(percentage);
    }

    @Deprecated
    public int getQuality() {
        return this.jpegEncoderOptions.getQuality();
    }

    private void generateQTables(float qq) {
        int j2;
        int i2;
        for (i2 = 0; i2 < 64; ++i2) {
            j2 = (int)(((float)QL[i2] * qq + 50.0f) / 100.0f);
            this.TL[JpegEncoder.ZIGZAG[i2]] = j2 < 1 ? 1 : Math.min(j2, 255);
        }
        for (i2 = 0; i2 < 64; ++i2) {
            j2 = (int)(((float)QC[i2] * qq + 50.0f) / 100.0f);
            this.TC[JpegEncoder.ZIGZAG[i2]] = j2 < 1 ? 1 : Math.min(j2, 255);
        }
        float[] multipliyer = new float[]{1.0f, 1.3870399f, 1.306563f, 1.1758755f, 1.0f, 0.78569496f, 0.5411961f, 0.27589938f};
        int k2 = 0;
        for (int row = 0; row < 8; ++row) {
            for (int col = 0; col < 8; ++col) {
                double mrc8 = (double)(multipliyer[row] * multipliyer[col]) * 8.0;
                this.FDL[k2] = (float)(1.0 / ((double)this.TL[ZIGZAG[k2]] * mrc8));
                this.FDC[k2] = (float)(1.0 / ((double)this.TC[ZIGZAG[k2]] * mrc8));
                ++k2;
            }
        }
    }

    private static void generateHuffmanMapping(int[] huffman, int[] codes, int[] lookup) {
        int value = 0;
        int index = 0;
        for (int i2 = 1; i2 <= 16; ++i2) {
            for (int j2 = 1; j2 <= codes[i2]; ++j2) {
                int t2 = lookup[index];
                huffman[t2] = value << 16 | i2;
                ++index;
                ++value;
            }
            value *= 2;
        }
    }

    private void generateHuffmanItems() {
        int low = 1;
        int high = 2;
        for (int i2 = 1; i2 <= 15; ++i2) {
            for (int j2 = low; j2 < high; ++j2) {
                this.codes[Short.MAX_VALUE + j2] = j2 << 16 | i2;
            }
            for (int nrneg = -(high - 1); nrneg <= -low; ++nrneg) {
                this.codes[Short.MAX_VALUE + nrneg] = high - 1 + nrneg << 16 | i2;
            }
            low <<= 1;
            high <<= 1;
        }
    }

    private void putHuffBits(int bs2) throws IOException {
        int code = bs2 >> 16 & 0xFFFF;
        int size = bs2 & 0xFFFF;
        this.buffer = this.buffer << size | code;
        this.bitLen += size;
        if (this.bitLen > 15) {
            this.bitLen -= 8;
            int c2 = this.buffer >> this.bitLen & 0xFF;
            this.putByte(c2);
            if (c2 == 255) {
                this.putByte(0);
            }
            this.bitLen -= 8;
            c2 = this.buffer >> this.bitLen & 0xFF;
            this.putByte(c2);
            if (c2 == 255) {
                this.putByte(0);
            }
        }
    }

    private void putByte(int v2) throws IOException {
        if (this.bp == 1024) {
            this.stream.write(this.bArr);
            this.bp = 0;
        }
        this.bArr[this.bp++] = (byte)v2;
    }

    private void putChar(int v2) throws IOException {
        this.putByte(v2 >> 8 & 0xFF);
        this.putByte(v2 & 0xFF);
    }

    private static void fDCT(float[] inp) {
        JpegEncoder.processH(inp);
        JpegEncoder.processV(inp);
    }

    private static void processH(float[] inp) {
        for (int p2 = 0; p2 < 64; p2 += 8) {
            float d0 = inp[p2];
            float d1 = inp[p2 + 1];
            float d2 = inp[p2 + 2];
            float d3 = inp[p2 + 3];
            float d4 = inp[p2 + 4];
            float d5 = inp[p2 + 5];
            float d6 = inp[p2 + 6];
            float d7 = inp[p2 + 7];
            float t0 = d0 + d7;
            float t7 = d0 - d7;
            float t1 = d1 + d6;
            float t6 = d1 - d6;
            float t2 = d2 + d5;
            float t5 = d2 - d5;
            float t3 = d3 + d4;
            float t4 = d3 - d4;
            float t10 = t0 + t3;
            float t13 = t0 - t3;
            float t11 = t1 + t2;
            float t12 = t1 - t2;
            inp[p2] = t10 + t11;
            inp[p2 + 4] = t10 - t11;
            d1 = (t12 + t13) * 0.70710677f;
            inp[p2 + 2] = t13 + d1;
            inp[p2 + 6] = t13 - d1;
            t10 = t4 + t5;
            t12 = t6 + t7;
            d5 = (t10 - t12) * 0.38268343f;
            d2 = 0.5411961f * t10 + d5;
            d4 = 1.306563f * t12 + d5;
            d3 = (t5 + t6) * 0.70710677f;
            d6 = t7 + d3;
            d7 = t7 - d3;
            inp[p2 + 5] = d7 + d2;
            inp[p2 + 3] = d7 - d2;
            inp[p2 + 1] = d6 + d4;
            inp[p2 + 7] = d6 - d4;
        }
    }

    private static void processV(float[] inp) {
        for (int p2 = 0; p2 < 8; ++p2) {
            float d0 = inp[p2];
            float d1 = inp[p2 + 8];
            float d2 = inp[p2 + 16];
            float d3 = inp[p2 + 24];
            float d4 = inp[p2 + 32];
            float d5 = inp[p2 + 40];
            float d6 = inp[p2 + 48];
            float d7 = inp[p2 + 56];
            float t0 = d0 + d7;
            float t7 = d0 - d7;
            float t1 = d1 + d6;
            float t6 = d1 - d6;
            float t2 = d2 + d5;
            float t5 = d2 - d5;
            float t3 = d3 + d4;
            float t4 = d3 - d4;
            float t10 = t0 + t3;
            float t13 = t0 - t3;
            float t11 = t1 + t2;
            float t12 = t1 - t2;
            inp[p2] = t10 + t11;
            inp[p2 + 32] = t10 - t11;
            d1 = (t12 + t13) * 0.70710677f;
            t10 = t4 + t5;
            t12 = t6 + t7;
            d5 = (t10 - t12) * 0.38268343f;
            d2 = 0.5411961f * t10 + d5;
            d4 = 1.306563f * t12 + d5;
            d3 = (t5 + t6) * 0.70710677f;
            d6 = t7 + d3;
            d7 = t7 - d3;
            inp[p2 + 16] = t13 + d1;
            inp[p2 + 48] = t13 - d1;
            inp[p2 + 40] = d7 + d2;
            inp[p2 + 24] = d7 - d2;
            inp[p2 + 8] = d6 + d4;
            inp[p2 + 56] = d6 - d4;
        }
    }

    private void writeAPP0() throws IOException {
        this.putChar(65504);
        this.putChar(16);
        this.putByte(74);
        this.putByte(70);
        this.putByte(73);
        this.putByte(70);
        this.putByte(0);
        this.putByte(1);
        this.putByte(1);
        this.putByte(0);
        this.putChar(1);
        this.putChar(1);
        this.putByte(0);
        this.putByte(0);
    }

    private void writeSOF0(int width, int height, boolean isGray, boolean is211) throws IOException {
        this.putChar(65472);
        if (isGray) {
            this.putChar(11);
            this.putByte(8);
            this.putChar(height);
            this.putChar(width);
            this.putByte(1);
            this.putByte(0);
            this.putByte(17);
            this.putByte(0);
        } else {
            this.putChar(17);
            this.putByte(8);
            this.putChar(height);
            this.putChar(width);
            this.putByte(3);
            if (is211) {
                this.putByte(1);
                this.putByte(34);
                this.putByte(0);
                this.putByte(2);
                this.putByte(17);
                this.putByte(1);
                this.putByte(3);
                this.putByte(17);
                this.putByte(1);
            } else {
                this.putByte(1);
                this.putByte(17);
                this.putByte(0);
                this.putByte(2);
                this.putByte(17);
                this.putByte(1);
                this.putByte(3);
                this.putByte(17);
                this.putByte(1);
            }
        }
    }

    private void writeSOS(boolean isGray) throws IOException {
        this.putChar(65498);
        if (isGray) {
            this.putChar(8);
            this.putByte(1);
            this.putByte(0);
            this.putByte(0);
        } else {
            this.putChar(12);
            this.putByte(3);
            this.putByte(1);
            this.putByte(0);
            this.putByte(2);
            this.putByte(17);
            this.putByte(3);
            this.putByte(17);
        }
        this.putByte(0);
        this.putByte(63);
        this.putByte(0);
    }

    private void writeDQT(boolean isGray) throws IOException {
        this.putChar(65499);
        if (isGray) {
            this.putChar(67);
            this.putByte(0);
            for (int i2 = 0; i2 < 64; ++i2) {
                this.putByte(this.TL[i2]);
            }
        } else {
            this.putChar(132);
            this.putByte(0);
            for (int i3 = 0; i3 < 64; ++i3) {
                this.putByte(this.TL[i3]);
            }
            this.putByte(1);
            for (int j2 = 0; j2 < 64; ++j2) {
                this.putByte(this.TC[j2]);
            }
        }
    }

    private void writeDHT(boolean isGray) throws IOException {
        this.putChar(65476);
        if (isGray) {
            int i2;
            this.putChar(210);
            this.putByte(0);
            for (i2 = 0; i2 < 16; ++i2) {
                this.putByte(CODESDCL[i2 + 1]);
            }
            for (i2 = 0; i2 < 12; ++i2) {
                this.putByte(SYMBOLSDCL[i2]);
            }
            this.putByte(16);
            for (i2 = 0; i2 < 16; ++i2) {
                this.putByte(CODESACL[i2 + 1]);
            }
            for (i2 = 0; i2 <= 161; ++i2) {
                this.putByte(SYMBOLSACL[i2]);
            }
        } else {
            int i3;
            this.putChar(418);
            this.putByte(0);
            for (i3 = 0; i3 < 16; ++i3) {
                this.putByte(CODESDCL[i3 + 1]);
            }
            for (i3 = 0; i3 <= 11; ++i3) {
                this.putByte(SYMBOLSDCL[i3]);
            }
            this.putByte(16);
            for (i3 = 0; i3 < 16; ++i3) {
                this.putByte(CODESACL[i3 + 1]);
            }
            for (i3 = 0; i3 <= 161; ++i3) {
                this.putByte(SYMBOLSACL[i3]);
            }
            this.putByte(1);
            for (i3 = 0; i3 < 16; ++i3) {
                this.putByte(CODESDCC[i3 + 1]);
            }
            for (i3 = 0; i3 <= 11; ++i3) {
                this.putByte(SYMBOLSDCC[i3]);
            }
            this.putByte(17);
            for (int o2 = 0; o2 < 16; ++o2) {
                this.putByte(CODESACC[o2 + 1]);
            }
            for (int p2 = 0; p2 <= 161; ++p2) {
                this.putByte(SYMBOLSACC[p2]);
            }
        }
    }

    private int compress(float[] CDU, float[] fdtbl, int DC, int[] huffDC, int[] huffAC) throws IOException {
        int end0pos;
        int ci;
        int pos;
        int EOB = huffAC[0];
        int M16zeroes = huffAC[240];
        JpegEncoder.fDCT(CDU);
        for (int j2 = 0; j2 < 64; ++j2) {
            float fq = CDU[j2] * fdtbl[j2];
            this.DU[JpegEncoder.ZIGZAG[j2]] = (int)(fq > 0.0f ? (double)fq + 0.5 : (double)fq - 0.5);
        }
        int Diff2 = this.DU[0] - DC;
        DC = this.DU[0];
        if (Diff2 == 0) {
            this.putHuffBits(huffDC[0]);
        } else {
            pos = Short.MAX_VALUE + Diff2;
            ci = this.codes[pos];
            this.putHuffBits(huffDC[ci & 0xFFFF]);
            this.putHuffBits(ci);
        }
        for (end0pos = 63; end0pos > 0 && this.DU[end0pos] == 0; --end0pos) {
        }
        if (end0pos == 0) {
            this.putHuffBits(EOB);
            return DC;
        }
        for (int i2 = 1; i2 <= end0pos; ++i2) {
            int startpos = i2;
            while (this.DU[i2] == 0 && i2 <= end0pos) {
                ++i2;
            }
            int nrzeroes = i2 - startpos;
            if (nrzeroes > 15) {
                int lng = nrzeroes >> 4;
                for (int nrmarker = 1; nrmarker <= lng; ++nrmarker) {
                    this.putHuffBits(M16zeroes);
                }
                nrzeroes &= 0xF;
            }
            pos = Short.MAX_VALUE + this.DU[i2];
            ci = this.codes[pos];
            this.putHuffBits(huffAC[(nrzeroes << 4) + (ci & 0xFFFF)]);
            this.putHuffBits(ci);
        }
        if (end0pos != 63) {
            this.putHuffBits(EOB);
        }
        return DC;
    }

    private void encode(int width, int height, int type) throws IOException {
        int quality = this.jpegEncoderOptions.getQuality();
        quality = quality <= 0 ? 1 : Math.min(quality, 100);
        boolean is211 = quality < 80;
        int qq = quality < 50 ? 5000 / quality : 200 - (quality << 1);
        this.generateQTables(qq);
        JpegEncoder.generateHuffmanMapping(this.DCHTL, CODESDCL, SYMBOLSDCL);
        JpegEncoder.generateHuffmanMapping(this.DCHTC, CODESDCC, SYMBOLSDCC);
        JpegEncoder.generateHuffmanMapping(this.ACHTL, CODESACL, SYMBOLSACL);
        JpegEncoder.generateHuffmanMapping(this.ACHTC, CODESACC, SYMBOLSACC);
        this.generateHuffmanItems();
        boolean isGray = type == 10;
        this.buffer = 0;
        this.bitLen = 0;
        this.putChar(65496);
        this.writeAPP0();
        this.writeDQT(isGray);
        this.writeSOF0(width, height, isGray, is211);
        this.writeDHT(isGray);
        this.writeSOS(isGray);
        this.buffer = 0;
        this.bitLen = 0;
        if (isGray) {
            this.compressGray(width, height);
        } else if (is211) {
            this.compressRGB211(width, height);
        } else {
            this.compressRGB(width, height);
        }
        if (this.bitLen > 0) {
            int c2;
            if (this.bitLen > 7) {
                this.bitLen -= 8;
                c2 = this.buffer >> this.bitLen & 0xFF;
                this.putByte(c2);
                if (c2 == 255) {
                    this.putByte(0);
                }
            }
            if (this.bitLen > 0) {
                c2 = (this.buffer & 0xFF) << 8 - this.bitLen;
                this.putByte(c2);
            }
        }
        this.putChar(65497);
    }

    private void compressGray(int width, int height) throws IOException {
        int DCY = 0;
        float[] unitY = new float[64];
        int maxLen = width * height;
        byte[] pixBytes = ((DataBufferByte)this.img.getRaster().getDataBuffer()).getData();
        for (int y2 = 0; y2 < height; y2 += 8) {
            for (int x2 = 0; x2 < width; x2 += 8) {
                int start = width * y2 + x2;
                for (int pos = 0; pos < 64; ++pos) {
                    int b2;
                    int row = pos >> 3;
                    int col = pos & 7;
                    int p2 = start + row * width + col;
                    if (y2 + row >= height) {
                        p2 -= width * (y2 + 1 + row - height);
                    }
                    if (x2 + col >= width) {
                        p2 -= x2 + col - width + 4;
                    }
                    if (p2 > maxLen || p2 < 0) continue;
                    int g2 = b2 = pixBytes[p2] & 0xFF;
                    int r2 = b2;
                    unitY[pos] = (128 + 76 * r2 + 150 * g2 + 29 * b2 >> 8) - 128;
                }
                DCY = this.compress(unitY, this.FDL, DCY, this.DCHTL, this.ACHTL);
            }
        }
    }

    private void compressRGB(int width, int height) throws IOException {
        int DCY = 0;
        int DCU = 0;
        int DCV = 0;
        float[] unitY = new float[64];
        float[] unitU = new float[64];
        float[] unitV = new float[64];
        int maxLen = width * height;
        for (int y2 = 0; y2 < height; y2 += 8) {
            for (int x2 = 0; x2 < width; x2 += 8) {
                int start = width * y2 + x2;
                for (int pos = 0; pos < 64; ++pos) {
                    int row = pos >> 3;
                    int col = pos & 7;
                    int p2 = start + row * width + col;
                    if (y2 + row >= height) {
                        p2 -= width * (y2 + 1 + row - height);
                    }
                    if (x2 + col >= width) {
                        p2 -= x2 + col - width + 4;
                    }
                    if (p2 > maxLen || p2 < 0) continue;
                    int xx = p2 % width;
                    int yy = p2 / width;
                    JpegEncoder.updateYUV(this.pg, xx, yy, unitY, unitU, unitV, pos);
                }
                DCY = this.compress(unitY, this.FDL, DCY, this.DCHTL, this.ACHTL);
                DCU = this.compress(unitU, this.FDC, DCU, this.DCHTC, this.ACHTC);
                DCV = this.compress(unitV, this.FDC, DCV, this.DCHTC, this.ACHTC);
            }
        }
    }

    private static void updateYUV(PixGet pg, int x2, int y2, float[] unitY, float[] unitU, float[] unitV, int pos) {
        int v2 = pg.getRGB(x2, y2);
        int r2 = v2 >> 16 & 0xFF;
        int g2 = v2 >> 8 & 0xFF;
        int b2 = v2 & 0xFF;
        unitY[pos] = (128 + 76 * r2 + 150 * g2 + 29 * b2 >> 8) - 128;
        unitU[pos] = 128 + 127 * b2 - 84 * g2 - 43 * r2 >> 8;
        unitV[pos] = 128 + 127 * r2 - 106 * g2 - 21 * b2 >> 8;
    }

    private void compressRGB211(int iw, int ih) throws IOException {
        int[] blockHeight = new int[3];
        int[] blockWidth = new int[3];
        int[] compHeight = new int[3];
        int[] compWidth = new int[3];
        int[] sampleFactor = new int[]{2, 1, 1};
        int[] iterFactor = new int[]{1, 2, 2};
        int maxH = sampleFactor[0];
        int maxV = sampleFactor[0];
        for (int i2 = 0; i2 < 3; ++i2) {
            compWidth[i2] = (iw % 8 != 0 ? (int)Math.ceil((double)iw / 8.0) * 8 : iw) / maxH * sampleFactor[i2];
            compHeight[i2] = (ih % 8 != 0 ? (int)Math.ceil((double)ih / 8.0) * 8 : ih) / maxV * sampleFactor[i2];
            blockWidth[i2] = (int)Math.ceil((double)compWidth[i2] / 8.0);
            blockHeight[i2] = (int)Math.ceil((double)compHeight[i2] / 8.0);
        }
        int minBlockWidth = iw % 8 != 0 ? (int)(Math.floor((double)iw / 8.0) + 1.0) * 8 : iw;
        int minBlockHeight = ih % 8 != 0 ? (int)(Math.floor((double)ih / 8.0) + 1.0) * 8 : ih;
        for (int comp = 0; comp < 3; ++comp) {
            minBlockWidth = Math.min(minBlockWidth, blockWidth[comp]);
            minBlockHeight = Math.min(minBlockHeight, blockHeight[comp]);
        }
        float[] unitY = new float[64];
        float[] unitU = new float[64];
        float[] unitV = new float[64];
        int[] DCTBL = new int[3];
        for (int r2 = 0; r2 < minBlockHeight; ++r2) {
            for (int c2 = 0; c2 < minBlockWidth; ++c2) {
                this.updateY(iw, ih, c2, r2, sampleFactor[0], iterFactor[0], unitY, DCTBL);
                this.updateU(iw, ih, c2, r2, sampleFactor[1], iterFactor[1], unitU, DCTBL);
                this.updateV(iw, ih, c2, r2, sampleFactor[2], iterFactor[2], unitV, DCTBL);
            }
        }
    }

    private void updateY(int iw, int ih, int c2, int r2, int hv, int iter, float[] unitY, int[] DCTBL) throws IOException {
        int xpos = c2 * 8 * hv * iter;
        int ypos = r2 * 8 * hv * iter;
        int maxLen = iw * ih;
        for (int i2 = 0; i2 < hv; ++i2) {
            for (int j2 = 0; j2 < hv; ++j2) {
                int xx = xpos + (j2 << 3);
                int yy = ypos + (i2 << 3);
                int start = iw * yy + xx;
                for (int pos = 0; pos < 64; ++pos) {
                    int row = (pos >> 3) * iter;
                    int col = (pos & 7) * iter;
                    int p2 = start + row * iw + col;
                    if (yy + row >= ih) {
                        p2 -= iw * (yy + 1 + row - ih);
                    }
                    if (xx + col >= iw) {
                        p2 -= xx + col - iw + 4;
                    }
                    if (p2 > maxLen || p2 < 0) continue;
                    int x2 = p2 % iw;
                    int y2 = p2 / iw;
                    int v2 = this.pg.getRGB(x2, y2);
                    int rr = v2 >> 16 & 0xFF;
                    int gg = v2 >> 8 & 0xFF;
                    int bb2 = v2 & 0xFF;
                    unitY[pos] = (128 + 76 * rr + 150 * gg + 29 * bb2 >> 8) - 128;
                }
                DCTBL[0] = this.compress(unitY, this.FDL, DCTBL[0], this.DCHTL, this.ACHTL);
            }
        }
    }

    private void updateU(int iw, int ih, int c2, int r2, int hv, int iter, float[] unitU, int[] DCTBL) throws IOException {
        int xpos = c2 * 8 * hv * iter;
        int ypos = r2 * 8 * hv * iter;
        int maxLen = iw * ih;
        for (int i2 = 0; i2 < hv; ++i2) {
            for (int j2 = 0; j2 < hv; ++j2) {
                int xx = xpos + (j2 << 3);
                int yy = ypos + (i2 << 3);
                int start = iw * yy + xx;
                for (int pos = 0; pos < 64; ++pos) {
                    int row = (pos >> 3) * iter;
                    int col = (pos & 7) * iter;
                    int p2 = start + row * iw + col;
                    if (yy + row >= ih) {
                        p2 -= iw * (yy + 1 + row - ih);
                    }
                    if (xx + col >= iw) {
                        p2 -= xx + col - iw + 4;
                    }
                    if (p2 > maxLen || p2 < 0) continue;
                    int x2 = p2 % iw;
                    int y2 = p2 / iw;
                    int v2 = this.pg.getRGB(x2, y2);
                    int rr = v2 >> 16 & 0xFF;
                    int gg = v2 >> 8 & 0xFF;
                    int bb2 = v2 & 0xFF;
                    unitU[pos] = 128 + 127 * bb2 - 84 * gg - 43 * rr >> 8;
                }
                DCTBL[1] = this.compress(unitU, this.FDC, DCTBL[1], this.DCHTC, this.ACHTC);
            }
        }
    }

    private void updateV(int iw, int ih, int c2, int r2, int hv, int iter, float[] unitV, int[] DCTBL) throws IOException {
        int xpos = c2 * 8 * hv * iter;
        int ypos = r2 * 8 * hv * iter;
        int maxLen = iw * ih;
        for (int i2 = 0; i2 < hv; ++i2) {
            for (int j2 = 0; j2 < hv; ++j2) {
                int xx = xpos + (j2 << 3);
                int yy = ypos + (i2 << 3);
                int start = iw * yy + xx;
                for (int pos = 0; pos < 64; ++pos) {
                    int row = (pos >> 3) * iter;
                    int col = (pos & 7) * iter;
                    int p2 = start + row * iw + col;
                    if (yy + row >= ih) {
                        p2 -= iw * (yy + 1 + row - ih);
                    }
                    if (xx + col >= iw) {
                        p2 -= xx + col - iw + 4;
                    }
                    if (p2 > maxLen || p2 < 0) continue;
                    int x2 = p2 % iw;
                    int y2 = p2 / iw;
                    int v2 = this.pg.getRGB(x2, y2);
                    int rr = v2 >> 16 & 0xFF;
                    int gg = v2 >> 8 & 0xFF;
                    int bb2 = v2 & 0xFF;
                    unitV[pos] = 128 + 127 * rr - 106 * gg - 21 * bb2 >> 8;
                }
                DCTBL[2] = this.compress(unitV, this.FDC, DCTBL[2], this.DCHTC, this.ACHTC);
            }
        }
    }
}

