/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg.data.Info;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public final class ARGBJpegDecoder {
    private ARGBJpegDecoder() {
    }

    public static BufferedImage read(byte[] data) throws Exception {
        JpegDecoder dec = new JpegDecoder();
        Info info = new Info();
        byte[] input = dec.readAsUnconvertedBytes(data, 0, info);
        if (info.nComp == 4 && info.adobe == null) {
            BufferedImage image = new BufferedImage(info.width, info.height, 5);
            byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            int p2 = 0;
            int ii = input.length;
            for (int i2 = 0; i2 < ii; i2 += 4) {
                int y2 = ((input[i2] & 0xFF) << 8) + 128;
                int u2 = (input[i2 + 1] & 0xFF) - 128;
                int v2 = (input[i2 + 2] & 0xFF) - 128;
                int r2 = y2 + 359 * v2 >> 8;
                int g2 = y2 - 88 * u2 - 183 * v2 >> 8;
                int b2 = y2 + 454 * u2 >> 8;
                pixels[p2++] = (byte)(b2 < 0 ? 0 : (byte)(b2 > 255 ? -1 : (byte)b2));
                pixels[p2++] = (byte)(g2 < 0 ? 0 : (byte)(g2 > 255 ? -1 : (byte)g2));
                pixels[p2++] = (byte)(r2 < 0 ? 0 : (byte)(r2 > 255 ? -1 : (byte)r2));
            }
            return image;
        }
        JpegDecoder dec2 = new JpegDecoder();
        return dec2.read(data);
    }
}

