/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.PixGet;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

final class YuvDisplay {
    private YuvDisplay() {
    }

    static BufferedImage fromMonoGray(int w2, int h2, int[] luma) {
        BufferedImage res = new BufferedImage(w2, h2, 10);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < luma.length; ++i2) {
            pixelsByte[i2] = (byte)luma[i2];
        }
        return res;
    }

    static BufferedImage fromYUV444(HImg img) {
        int[] luma = img.getImagePlane(0);
        int[] chroma1 = img.getImagePlane(1);
        int[] chroma2 = img.getImagePlane(2);
        int w2 = img.getWidth(0);
        int h2 = img.getHeight(0);
        BufferedImage res = new BufferedImage(w2, h2, 5);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        for (int i2 = 0; i2 < luma.length; ++i2) {
            int y2 = ((luma[i2] & 0xFF) << 8) + 128;
            int u2 = (chroma1[i2] & 0xFF) - 128;
            int v2 = (chroma2[i2] & 0xFF) - 128;
            int r2 = y2 + 359 * v2 >> 8;
            int g2 = y2 - 88 * u2 - 183 * v2 >> 8;
            int b2 = y2 + 454 * u2 >> 8;
            r2 = Math.max(0, Math.min(255, r2));
            g2 = Math.max(0, Math.min(255, g2));
            b2 = Math.max(0, Math.min(255, b2));
            pixelsByte[p2++] = (byte)b2;
            pixelsByte[p2++] = (byte)g2;
            pixelsByte[p2++] = (byte)r2;
        }
        return res;
    }

    static BufferedImage fromYUV420(HImg img) {
        int[] luma = img.getImagePlane(0);
        int[] chroma1 = img.getImagePlane(1);
        int[] chroma2 = img.getImagePlane(2);
        int w2 = img.getWidth(0);
        int h2 = img.getHeight(0);
        int cw = img.getWidth(1);
        BufferedImage res = new BufferedImage(w2, h2, 5);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        int c2 = 0;
        int l2 = 0;
        for (int hh = 0; hh < h2; ++hh) {
            int cStart = (hh >> 1) * cw;
            for (int ww = 0; ww < w2; ++ww) {
                c2 = cStart + (ww >> 1);
                int y2 = ((luma[l2++] & 0xFF) << 8) + 128;
                int u2 = (chroma1[c2] & 0xFF) - 128;
                int v2 = (chroma2[c2] & 0xFF) - 128;
                int r2 = y2 + 359 * v2 >> 8;
                int g2 = y2 - 88 * u2 - 183 * v2 >> 8;
                int b2 = y2 + 454 * u2 >> 8;
                r2 = Math.max(0, Math.min(255, r2));
                g2 = Math.max(0, Math.min(255, g2));
                b2 = Math.max(0, Math.min(255, b2));
                pixelsByte[p2++] = (byte)b2;
                pixelsByte[p2++] = (byte)g2;
                pixelsByte[p2++] = (byte)r2;
            }
        }
        return res;
    }

    static void getAsYUV420(BufferedImage bImg, HImg hImg) {
        int b2;
        int g2;
        int r2;
        int p2;
        int x2;
        int y2;
        int h2 = hImg.Height;
        int w2 = hImg.Width;
        int bw = bImg.getWidth();
        int bh2 = bImg.getHeight();
        byte[] planY = hImg.planesBytes[0];
        byte[] planCB = hImg.planesBytes[1];
        byte[] planCR = hImg.planesBytes[2];
        PixGet pg = Access.getPixGet(bImg);
        int strideY = w2;
        int strideC = hImg.ChromaW;
        for (y2 = 0; y2 < h2; ++y2) {
            for (x2 = 0; x2 < w2; ++x2) {
                if (x2 >= bw || y2 >= bh2) continue;
                p2 = pg.getRGB(x2, y2);
                r2 = p2 >> 16 & 0xFF;
                g2 = p2 >> 8 & 0xFF;
                b2 = p2 & 0xFF;
                planY[y2 * strideY + x2] = (byte)((128 + 77 * r2 + 150 * g2 + 29 * b2 >> 8) - 128);
            }
        }
        for (y2 = 0; y2 < h2; y2 += 2) {
            for (x2 = 0; x2 < w2; x2 += 2) {
                if (x2 >= bw || y2 >= bh2) continue;
                p2 = pg.getRGB(x2, y2);
                r2 = p2 >> 16 & 0xFF;
                g2 = p2 >> 8 & 0xFF;
                b2 = p2 & 0xFF;
                p2 = y2 / 2 * strideC + x2 / 2;
                planCB[p2] = (byte)(128 + 127 * b2 - 84 * g2 - 43 * r2 >> 8);
                planCR[p2] = (byte)(128 + 127 * r2 - 106 * g2 - 21 * b2 >> 8);
            }
        }
        pg = null;
    }

    static BufferedImage fromYUV422(HImg img) {
        int[] luma = img.getImagePlane(0);
        int[] chroma1 = img.getImagePlane(1);
        int[] chroma2 = img.getImagePlane(2);
        int w2 = img.getWidth(0);
        int h2 = img.getHeight(0);
        int cw = img.getWidth(1);
        BufferedImage res = new BufferedImage(w2, h2, 5);
        byte[] pixelsByte = ((DataBufferByte)res.getRaster().getDataBuffer()).getData();
        int p2 = 0;
        int l2 = 0;
        for (int hh = 0; hh < h2; ++hh) {
            int cStart = hh * cw;
            for (int ww = 0; ww < w2; ++ww) {
                int c2 = cStart + (ww >> 1);
                int y2 = luma[l2++];
                int u2 = chroma1[c2];
                int v2 = chroma2[c2];
                int r2 = (int)((double)y2 + 1.402 * (double)(v2 - 128));
                int g2 = (int)((double)y2 - 0.34414 * (double)(u2 - 128) - 0.71414 * (double)(v2 - 128));
                int b2 = (int)((double)y2 + 1.772 * (double)(u2 - 128));
                r2 = Math.max(0, Math.min(255, r2));
                g2 = Math.max(0, Math.min(255, g2));
                b2 = Math.max(0, Math.min(255, b2));
                pixelsByte[p2++] = (byte)b2;
                pixelsByte[p2++] = (byte)g2;
                pixelsByte[p2++] = (byte)r2;
            }
        }
        return res;
    }
}

