/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.ProfileTierLevel;

class Vps {
    private int vps_video_parameter_set_id;
    private int vps_max_layers;
    private int vps_max_sub_layers;
    private byte vps_temporal_id_nesting_flag;
    private final ProfileTierLevel profileTierLevel = new ProfileTierLevel();
    private int[] vps_max_dec_pic_buffering = new int[1];
    private int[] vps_max_num_reorder_pics = new int[1];
    private int[] vps_max_latency_increase = new int[1];
    private int vps_max_layer_id;
    private int vps_num_layer_sets;
    private byte[][] layer_id_included_flag = new byte[1][1];
    private byte vps_sub_layer_ordering_info_present_flag;

    Vps() {
    }

    void readVps(Bitstream reader, HImg d2) {
        int i2;
        this.vps_video_parameter_set_id = reader.readBits(4);
        reader.readBit();
        reader.readBit();
        this.vps_max_layers = reader.readBits(6) + 1;
        this.vps_max_sub_layers = reader.readBits(3) + 1;
        this.vps_temporal_id_nesting_flag = reader.readBit();
        reader.readBits(16);
        this.profileTierLevel.read(reader, this.vps_max_sub_layers);
        this.vps_sub_layer_ordering_info_present_flag = reader.readBit();
        int start = this.vps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.vps_max_sub_layers - 1;
        int len = this.vps_max_sub_layers - 1 + start + 1;
        this.vps_max_dec_pic_buffering = new int[len];
        this.vps_max_num_reorder_pics = new int[len];
        this.vps_max_latency_increase = new int[len];
        for (i2 = start; i2 < this.vps_max_sub_layers; ++i2) {
            this.vps_max_dec_pic_buffering[i2] = reader.ue();
            this.vps_max_num_reorder_pics[i2] = reader.ue();
            this.vps_max_latency_increase[i2] = reader.ue();
        }
        if (this.vps_sub_layer_ordering_info_present_flag == 0) {
            for (i2 = 0; i2 < start; ++i2) {
                this.vps_max_dec_pic_buffering[i2] = this.vps_max_dec_pic_buffering[start];
                this.vps_max_num_reorder_pics[i2] = this.vps_max_num_reorder_pics[start];
                this.vps_max_latency_increase[i2] = this.vps_max_latency_increase[start];
            }
        }
        this.vps_max_layer_id = reader.readBits(6);
        this.vps_num_layer_sets = reader.ue() + 1;
        this.layer_id_included_flag = new byte[this.vps_num_layer_sets][this.vps_max_layer_id + 1];
        for (i2 = 1; i2 < this.vps_num_layer_sets; ++i2) {
            for (int j2 = 0; j2 <= this.vps_max_layer_id; ++j2) {
                this.layer_id_included_flag[i2][j2] = reader.readBit();
            }
        }
    }

    void setDefaults(int profile, int level_major, int level_minor) {
        this.vps_video_parameter_set_id = 0;
        this.vps_max_layers = 1;
        this.vps_max_sub_layers = 1;
        this.vps_temporal_id_nesting_flag = 1;
        this.profileTierLevel.general.setDefaults(profile, level_major, level_minor);
        this.vps_max_dec_pic_buffering[0] = 1;
        this.vps_max_num_reorder_pics[0] = 0;
        this.vps_max_latency_increase[0] = 0;
        this.vps_max_layer_id = 0;
        this.vps_num_layer_sets = 1;
    }

    void write(HImg img, Cabac out) {
        int firstLayerRead;
        int i2;
        out.write_bits(this.vps_video_parameter_set_id, 4);
        out.write_bits(3, 2);
        out.write_bits(this.vps_max_layers - 1, 6);
        out.write_bits(this.vps_max_sub_layers - 1, 3);
        out.write_bit(this.vps_temporal_id_nesting_flag);
        out.write_bits(65535, 16);
        this.profileTierLevel.write(out, this.vps_max_sub_layers);
        out.write_bit(this.vps_sub_layer_ordering_info_present_flag);
        for (i2 = firstLayerRead = this.vps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.vps_max_sub_layers - 1; i2 < this.vps_max_sub_layers; ++i2) {
            out.writeUE(this.vps_max_dec_pic_buffering[i2] - 1);
            out.writeUE(this.vps_max_num_reorder_pics[i2]);
            out.writeUE(this.vps_max_latency_increase[i2] + 1);
        }
        out.write_bits(this.vps_max_layer_id, 6);
        out.writeUE(this.vps_num_layer_sets - 1);
        for (i2 = 1; i2 <= this.vps_num_layer_sets - 1; ++i2) {
            for (int j2 = 0; j2 <= this.vps_max_layer_id; ++j2) {
                out.write_bit(this.layer_id_included_flag[i2][j2]);
            }
        }
        out.write_bit(0);
        out.write_bit(0);
    }
}

