/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.ProfileTierLevel;
import com.idrsolutions.image.heic.common.Rps;
import com.idrsolutions.image.heic.common.Scan;
import java.util.ArrayList;
import java.util.List;
import org.jpedal.utils.LogWriter;

class Sps {
    int SubWidthC;
    int SubHeightC;
    int ChromaArrayType;
    int WinUnitX;
    int WinUnitY;
    int BitDepthY;
    int BitDepthC;
    int QpBdOffsetY;
    int QpBdOffsetC;
    int Log2MinCbSizeY;
    int Log2CtbSizeY;
    int MinCbSizeY;
    int CtbSizeY;
    int CtbWidthC;
    int CtbHeightC;
    int Log2MinTrafoSize;
    int Log2MaxTrafoSize;
    int PicWidthInMinCbsY;
    int PicHeightInMinCbsY;
    int PicSizeInMinCbsY;
    int PicWidthInCtbsY;
    int PicHeightInCtbsY;
    int PicSizeInCtbsY;
    int PicSizeInSamplesY;
    int PicWidthInSamplesC;
    int PicHeightInSamplesC;
    int PcmBitDepthY;
    int PcmBitDepthC;
    int MaxPicOrderCntLsb;
    int CoeffMinY;
    int CoeffMinC;
    int CoeffMaxY;
    int CoeffMaxC;
    int WpOffsetBdShiftY;
    int WpOffsetBdShiftC;
    int WpOffsetHalfRangeY;
    int WpOffsetHalfRangeC;
    final int[] SpsMaxLatencyPictures = new int[7];
    int Log2MinIpcmCbSizeY;
    int Log2MaxIpcmCbSizeY;
    int Log2MinPuSize;
    int PicWidthInMinPus;
    int PicHeightInMinPus;
    int PicWidthInTbsY;
    int PicHeightInTbsY;
    int PicSizeInTbsY;
    private int video_parameter_set_id;
    int max_sub_layers = 1;
    private byte sps_temporal_id_nesting_flag = 1;
    private ProfileTierLevel profileTilerLevel = new ProfileTierLevel();
    private int sps_seq_parameter_set_id;
    int chroma_format_idc = 1;
    byte separate_colour_plane_flag;
    int pic_width_in_luma_samples;
    int pic_height_in_luma_samples;
    private byte conformance_window_flag;
    private int conf_win_left_offset;
    private int conf_win_right_offset;
    private int conf_win_top_offset;
    private int conf_win_bottom_offset;
    private int bit_depth_luma = 8;
    private int bit_depth_chroma = 8;
    int log2_max_pic_order_cnt_lsb = 4;
    private byte sps_sub_layer_ordering_info_present_flag;
    final int[] sps_max_dec_pic_buffering = new int[]{1, 0, 0, 0, 0, 0, 0};
    private final int[] sps_max_num_reorder_pics = new int[7];
    private final int[] sps_max_latency_increase = new int[7];
    private int log2_min_luma_coding_block_size;
    private int log2_diff_max_min_luma_coding_block_size;
    private int log2_min_luma_transform_block_size;
    private int log2_diff_max_min_luma_transform_block_size;
    int max_transform_hierarchy_depth_inter = 1;
    int max_transform_hierarchy_depth_intra = 1;
    byte scaling_list_enabled_flag;
    private byte sps_scaling_list_data_present_flag;
    byte amp_enabled_flag;
    byte sample_adaptive_offset_enabled_flag;
    byte pcm_enabled_flag;
    int pcm_sample_bit_depth_luma = 8;
    int pcm_sample_bit_depth_chroma = 8;
    private int log2_min_pcm_luma_coding_block_size;
    private int log2_diff_max_min_pcm_luma_coding_block_size;
    byte pcm_loop_filter_disabled_flag = 1;
    int num_short_term_ref_pic_sets;
    byte long_term_ref_pics_present_flag;
    int num_long_term_ref_pics_sps;
    int[] lt_ref_pic_poc_lsb_sps;
    byte[] used_by_curr_pic_lt_sps_flag;
    byte sps_temporal_mvp_enabled_flag;
    byte strong_intra_smoothing_enabled_flag;
    private byte vui_parameters_present_flag;
    private byte sps_extension_present_flag;
    private byte sps_range_extension_flag;
    private int sps_extension_4bits;
    List<Rps> ref_pic_sets = new ArrayList<Rps>();
    byte transform_skip_rotation_enabled_flag;
    byte transform_skip_context_enabled_flag;
    byte implicit_rdpcm_enabled_flag;
    byte explicit_rdpcm_enabled_flag;
    private byte extended_precision_processing_flag;
    byte intra_smoothing_disabled_flag;
    private byte high_precision_offsets_enabled_flag;
    byte persistent_rice_adaptation_enabled_flag;

    Sps() {
    }

    void readSps(Bitstream reader, HImg d2) {
        int firstLayer;
        int i2;
        this.setDefaults();
        this.video_parameter_set_id = reader.readBits(4);
        this.max_sub_layers = reader.readBits(3) + 1;
        this.sps_temporal_id_nesting_flag = reader.readBit();
        this.profileTilerLevel.read(reader, this.max_sub_layers);
        this.sps_seq_parameter_set_id = reader.ue();
        this.chroma_format_idc = reader.ue();
        this.separate_colour_plane_flag = this.chroma_format_idc == 3 ? reader.readBit() : (byte)0;
        this.pic_width_in_luma_samples = reader.ue();
        this.pic_height_in_luma_samples = reader.ue();
        this.conformance_window_flag = reader.readBit();
        if (this.conformance_window_flag != 0) {
            this.conf_win_left_offset = reader.ue();
            this.conf_win_right_offset = reader.ue();
            this.conf_win_top_offset = reader.ue();
            this.conf_win_bottom_offset = reader.ue();
        }
        this.bit_depth_luma = reader.ue() + 8;
        this.bit_depth_chroma = reader.ue() + 8;
        this.log2_max_pic_order_cnt_lsb = reader.ue() + 4;
        this.sps_sub_layer_ordering_info_present_flag = reader.readBit();
        for (i2 = firstLayer = this.sps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.max_sub_layers - 1; i2 <= this.max_sub_layers - 1; ++i2) {
            this.sps_max_dec_pic_buffering[i2] = reader.ue() + 1;
            this.sps_max_num_reorder_pics[i2] = reader.ue();
            this.sps_max_latency_increase[i2] = reader.ue() - 1;
        }
        if (this.sps_sub_layer_ordering_info_present_flag != 0) {
            int ref = this.max_sub_layers - 1;
            for (i2 = 0; i2 < this.max_sub_layers - 1; ++i2) {
                this.sps_max_dec_pic_buffering[i2] = this.sps_max_dec_pic_buffering[ref];
                this.sps_max_num_reorder_pics[i2] = this.sps_max_num_reorder_pics[ref];
                this.sps_max_latency_increase[i2] = this.sps_max_latency_increase[ref];
            }
        }
        this.log2_min_luma_coding_block_size = reader.ue() + 3;
        this.log2_diff_max_min_luma_coding_block_size = reader.ue();
        this.log2_min_luma_transform_block_size = reader.ue() + 2;
        this.log2_diff_max_min_luma_transform_block_size = reader.ue();
        this.max_transform_hierarchy_depth_inter = reader.ue();
        this.max_transform_hierarchy_depth_intra = reader.ue();
        this.scaling_list_enabled_flag = reader.readBit();
        if (this.scaling_list_enabled_flag != 0) {
            this.sps_scaling_list_data_present_flag = reader.readBit();
            if (d2.scan.scaling0 == null) {
                d2.scan.initScalingFactor();
            }
            if (this.sps_scaling_list_data_present_flag != 0) {
                Scan.scale(reader, d2);
            }
        }
        this.amp_enabled_flag = reader.readBit();
        this.sample_adaptive_offset_enabled_flag = reader.readBit();
        this.pcm_enabled_flag = reader.readBit();
        if (this.pcm_enabled_flag != 0) {
            this.pcm_sample_bit_depth_luma = reader.readBits(4) + 1;
            this.pcm_sample_bit_depth_chroma = reader.readBits(4) + 1;
            this.log2_min_pcm_luma_coding_block_size = reader.ue() + 3;
            this.log2_diff_max_min_pcm_luma_coding_block_size = reader.ue();
            this.pcm_loop_filter_disabled_flag = reader.readBit();
        } else {
            this.pcm_sample_bit_depth_luma = 0;
            this.pcm_sample_bit_depth_chroma = 0;
            this.log2_min_pcm_luma_coding_block_size = 0;
            this.log2_diff_max_min_pcm_luma_coding_block_size = 0;
            this.pcm_loop_filter_disabled_flag = 0;
        }
        this.num_short_term_ref_pic_sets = reader.ue();
        for (i2 = 0; i2 < this.num_short_term_ref_pic_sets; ++i2) {
            Rps temp = new Rps();
            this.ref_pic_sets.add(temp);
            Rps.read(reader, this, temp, i2, this.ref_pic_sets, false);
        }
        this.long_term_ref_pics_present_flag = reader.readBit();
        if (this.long_term_ref_pics_present_flag != 0) {
            this.num_long_term_ref_pics_sps = reader.ue();
            this.lt_ref_pic_poc_lsb_sps = new int[this.num_long_term_ref_pics_sps];
            this.used_by_curr_pic_lt_sps_flag = new byte[this.num_long_term_ref_pics_sps];
            for (i2 = 0; i2 < this.num_long_term_ref_pics_sps; ++i2) {
                this.lt_ref_pic_poc_lsb_sps[i2] = reader.readBits(this.log2_max_pic_order_cnt_lsb);
                this.used_by_curr_pic_lt_sps_flag[i2] = reader.readBit();
            }
        } else {
            this.num_long_term_ref_pics_sps = 0;
        }
        this.sps_temporal_mvp_enabled_flag = reader.readBit();
        this.strong_intra_smoothing_enabled_flag = reader.readBit();
        this.vui_parameters_present_flag = reader.readBit();
        if (this.vui_parameters_present_flag != 0) {
            Sps.skipVUI(reader, this);
        }
        this.sps_extension_present_flag = reader.readBit();
        if (this.sps_extension_present_flag != 0) {
            this.sps_range_extension_flag = reader.readBit();
            reader.readBits(3);
            this.sps_extension_4bits = reader.readBits(4);
        }
        if (this.sps_range_extension_flag != 0) {
            this.updateSpsRange(reader);
        }
        this.deriveValues();
        if (this.sps_extension_4bits != 0) {
            while (reader.moreRbspData()) {
                reader.readBit();
            }
        }
        reader.readRbspTrailingBits();
    }

    void deriveValues() {
        int firstLayer;
        this.MaxPicOrderCntLsb = 1 << this.log2_max_pic_order_cnt_lsb;
        for (int i2 = firstLayer = this.sps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.max_sub_layers - 1; i2 <= this.max_sub_layers - 1; ++i2) {
            this.SpsMaxLatencyPictures[i2] = this.sps_max_num_reorder_pics[i2] + this.sps_max_latency_increase[i2];
        }
        this.SubWidthC = Sps.getSubWidthC(this.chroma_format_idc);
        this.SubHeightC = Sps.getSubHeightC(this.chroma_format_idc);
        int n2 = this.ChromaArrayType = this.separate_colour_plane_flag == 0 ? this.chroma_format_idc : 0;
        if (this.ChromaArrayType == 0) {
            this.WinUnitX = 1;
            this.WinUnitY = 1;
        } else {
            this.WinUnitX = Sps.getSubWidthC(this.chroma_format_idc);
            this.WinUnitY = Sps.getSubHeightC(this.chroma_format_idc);
        }
        this.BitDepthY = this.bit_depth_luma;
        this.QpBdOffsetY = 6 * (this.bit_depth_luma - 8);
        this.BitDepthC = this.bit_depth_chroma;
        this.QpBdOffsetC = 6 * (this.bit_depth_chroma - 8);
        this.Log2MinCbSizeY = this.log2_min_luma_coding_block_size;
        this.Log2CtbSizeY = this.Log2MinCbSizeY + this.log2_diff_max_min_luma_coding_block_size;
        this.MinCbSizeY = 1 << this.Log2MinCbSizeY;
        this.CtbSizeY = 1 << this.Log2CtbSizeY;
        if (this.chroma_format_idc == 0 || this.separate_colour_plane_flag != 0) {
            this.CtbWidthC = 0;
            this.CtbHeightC = 0;
        } else {
            this.CtbWidthC = this.CtbSizeY / this.SubWidthC;
            this.CtbHeightC = this.CtbSizeY / this.SubHeightC;
        }
        this.PicWidthInMinCbsY = HeicMath.ceilDiv(this.pic_width_in_luma_samples, this.MinCbSizeY);
        this.PicWidthInCtbsY = HeicMath.ceilDiv(this.pic_width_in_luma_samples, this.CtbSizeY);
        this.PicHeightInMinCbsY = HeicMath.ceilDiv(this.pic_height_in_luma_samples, this.MinCbSizeY);
        this.PicHeightInCtbsY = HeicMath.ceilDiv(this.pic_height_in_luma_samples, this.CtbSizeY);
        this.PicSizeInMinCbsY = this.PicWidthInMinCbsY * this.PicHeightInMinCbsY;
        this.PicSizeInCtbsY = this.PicWidthInCtbsY * this.PicHeightInCtbsY;
        this.PicSizeInSamplesY = this.pic_width_in_luma_samples * this.pic_height_in_luma_samples;
        this.Log2MinTrafoSize = this.log2_min_luma_transform_block_size;
        this.Log2MaxTrafoSize = this.log2_min_luma_transform_block_size + this.log2_diff_max_min_luma_transform_block_size;
        this.Log2MinPuSize = this.Log2MinCbSizeY - 1;
        this.PicWidthInMinPus = this.PicWidthInCtbsY << this.Log2CtbSizeY - this.Log2MinPuSize;
        this.PicHeightInMinPus = this.PicHeightInCtbsY << this.Log2CtbSizeY - this.Log2MinPuSize;
        this.Log2MinIpcmCbSizeY = this.log2_min_pcm_luma_coding_block_size;
        this.Log2MaxIpcmCbSizeY = this.log2_min_pcm_luma_coding_block_size + this.log2_diff_max_min_pcm_luma_coding_block_size;
        this.PicWidthInTbsY = this.PicWidthInCtbsY << this.Log2CtbSizeY - this.Log2MinTrafoSize;
        this.PicHeightInTbsY = this.PicHeightInCtbsY << this.Log2CtbSizeY - this.Log2MinTrafoSize;
        this.PicSizeInTbsY = this.PicWidthInTbsY * this.PicHeightInTbsY;
        this.PicWidthInSamplesC = this.pic_width_in_luma_samples / this.SubWidthC;
        this.PicHeightInSamplesC = this.pic_height_in_luma_samples / this.SubHeightC;
        this.PcmBitDepthY = this.pcm_sample_bit_depth_luma;
        this.PcmBitDepthC = this.pcm_sample_bit_depth_chroma;
        this.CoeffMinY = -(1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, this.BitDepthY + 6) : 15));
        this.CoeffMinC = -(1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, this.BitDepthC + 6) : 15));
        this.CoeffMaxY = (1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, this.BitDepthY + 6) : 15)) - 1;
        this.CoeffMaxC = (1 << (this.extended_precision_processing_flag != 0 ? Math.max(15, this.BitDepthC + 6) : 15)) - 1;
        this.WpOffsetBdShiftY = this.high_precision_offsets_enabled_flag != 0 ? 0 : this.BitDepthY - 8;
        this.WpOffsetBdShiftC = this.high_precision_offsets_enabled_flag != 0 ? 0 : this.BitDepthC - 8;
        this.WpOffsetHalfRangeY = 1 << (this.high_precision_offsets_enabled_flag != 0 ? this.BitDepthY - 1 : 7);
        this.WpOffsetHalfRangeC = 1 << (this.high_precision_offsets_enabled_flag != 0 ? this.BitDepthC - 1 : 7);
    }

    private void updateSpsRange(Bitstream reader) {
        this.transform_skip_rotation_enabled_flag = reader.readBit();
        this.transform_skip_context_enabled_flag = reader.readBit();
        this.implicit_rdpcm_enabled_flag = reader.readBit();
        this.explicit_rdpcm_enabled_flag = reader.readBit();
        this.extended_precision_processing_flag = reader.readBit();
        this.intra_smoothing_disabled_flag = reader.readBit();
        this.high_precision_offsets_enabled_flag = reader.readBit();
        this.persistent_rice_adaptation_enabled_flag = reader.readBit();
    }

    private static int getSubWidthC(int chroma_format_idc) {
        switch (chroma_format_idc) {
            case 1: 
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    private static int getSubHeightC(int chroma_format_idc) {
        if (chroma_format_idc == 1) {
            return 2;
        }
        return 1;
    }

    void setDefaults() {
        this.video_parameter_set_id = 0;
        this.max_sub_layers = 1;
        this.sps_temporal_id_nesting_flag = 1;
        this.profileTilerLevel.general.setDefaults(0, 6, 2);
        this.sps_seq_parameter_set_id = 0;
        this.chroma_format_idc = 1;
        this.separate_colour_plane_flag = 0;
        this.pic_width_in_luma_samples = 0;
        this.pic_height_in_luma_samples = 0;
        this.conformance_window_flag = 0;
        this.conf_win_left_offset = 0;
        this.conf_win_right_offset = 0;
        this.conf_win_top_offset = 0;
        this.conf_win_bottom_offset = 0;
        this.bit_depth_luma = 8;
        this.bit_depth_chroma = 8;
        this.log2_max_pic_order_cnt_lsb = 8;
        this.sps_sub_layer_ordering_info_present_flag = 0;
        this.sps_max_dec_pic_buffering[0] = 1;
        this.sps_max_num_reorder_pics[0] = 0;
        this.sps_max_latency_increase[0] = 0;
        this.set_CB_log2size_range(4, 4);
        this.set_TB_log2size_range(3, 4);
        this.max_transform_hierarchy_depth_inter = 1;
        this.max_transform_hierarchy_depth_intra = 1;
        this.scaling_list_enabled_flag = 0;
        this.sps_scaling_list_data_present_flag = 0;
        this.amp_enabled_flag = 0;
        this.sample_adaptive_offset_enabled_flag = 0;
        this.pcm_enabled_flag = 0;
        this.pcm_sample_bit_depth_luma = 8;
        this.pcm_sample_bit_depth_chroma = 8;
        this.pcm_loop_filter_disabled_flag = 1;
        this.long_term_ref_pics_present_flag = 0;
        this.num_long_term_ref_pics_sps = 0;
        this.sps_temporal_mvp_enabled_flag = 0;
        this.strong_intra_smoothing_enabled_flag = 0;
        this.vui_parameters_present_flag = 0;
        this.sps_extension_present_flag = 0;
        this.sps_range_extension_flag = 0;
    }

    void write(HImg img, Cabac out) {
        int firstLayer;
        int i2;
        out.write_bits(this.video_parameter_set_id, 4);
        out.write_bits(this.max_sub_layers - 1, 3);
        out.write_bit(this.sps_temporal_id_nesting_flag);
        this.profileTilerLevel.write(out, this.max_sub_layers);
        out.writeUE(this.sps_seq_parameter_set_id);
        out.writeUE(this.chroma_format_idc);
        if (this.chroma_format_idc == 3) {
            out.write_bit(this.separate_colour_plane_flag);
        }
        out.writeUE(this.pic_width_in_luma_samples);
        out.writeUE(this.pic_height_in_luma_samples);
        out.write_bit(this.conformance_window_flag);
        if (this.conformance_window_flag != 0) {
            out.writeUE(this.conf_win_left_offset);
            out.writeUE(this.conf_win_right_offset);
            out.writeUE(this.conf_win_top_offset);
            out.writeUE(this.conf_win_bottom_offset);
        }
        out.writeUE(this.bit_depth_luma - 8);
        out.writeUE(this.bit_depth_chroma - 8);
        out.writeUE(this.log2_max_pic_order_cnt_lsb - 4);
        out.write_bit(this.sps_sub_layer_ordering_info_present_flag);
        for (i2 = firstLayer = this.sps_sub_layer_ordering_info_present_flag != 0 ? 0 : this.max_sub_layers - 1; i2 <= this.max_sub_layers - 1; ++i2) {
            out.writeUE(this.sps_max_dec_pic_buffering[i2] - 1);
            out.writeUE(this.sps_max_num_reorder_pics[i2]);
            out.writeUE(this.sps_max_latency_increase[i2] + 1);
        }
        out.writeUE(this.log2_min_luma_coding_block_size - 3);
        out.writeUE(this.log2_diff_max_min_luma_coding_block_size);
        out.writeUE(this.log2_min_luma_transform_block_size - 2);
        out.writeUE(this.log2_diff_max_min_luma_transform_block_size);
        out.writeUE(this.max_transform_hierarchy_depth_inter);
        out.writeUE(this.max_transform_hierarchy_depth_intra);
        out.write_bit(this.scaling_list_enabled_flag);
        if (this.scaling_list_enabled_flag != 0) {
            out.write_bit(0);
        }
        out.write_bit(this.amp_enabled_flag);
        out.write_bit(this.sample_adaptive_offset_enabled_flag);
        out.write_bit(this.pcm_enabled_flag);
        if (this.pcm_enabled_flag != 0) {
            out.write_bits(this.pcm_sample_bit_depth_luma - 1, 4);
            out.write_bits(this.pcm_sample_bit_depth_chroma - 1, 4);
            out.writeUE(this.log2_min_pcm_luma_coding_block_size - 3);
            out.writeUE(this.log2_diff_max_min_pcm_luma_coding_block_size);
            out.write_bit(this.pcm_loop_filter_disabled_flag);
        }
        out.writeUE(this.num_short_term_ref_pic_sets);
        out.write_bit(this.long_term_ref_pics_present_flag);
        if (this.long_term_ref_pics_present_flag != 0) {
            out.writeUE(this.num_long_term_ref_pics_sps);
            for (i2 = 0; i2 < this.num_long_term_ref_pics_sps; ++i2) {
                out.write_bits(this.lt_ref_pic_poc_lsb_sps[i2], this.log2_max_pic_order_cnt_lsb);
                out.write_bit(this.used_by_curr_pic_lt_sps_flag[i2]);
            }
        }
        out.write_bit(this.sps_temporal_mvp_enabled_flag);
        out.write_bit(this.strong_intra_smoothing_enabled_flag);
        out.write_bit(this.vui_parameters_present_flag);
        out.write_bit(this.sps_extension_present_flag);
    }

    void set_CB_log2size_range(int mini, int maxi) {
        this.log2_min_luma_coding_block_size = mini;
        this.log2_diff_max_min_luma_coding_block_size = maxi - mini;
    }

    void set_TB_log2size_range(int mini, int maxi) {
        this.log2_min_luma_transform_block_size = mini;
        this.log2_diff_max_min_luma_transform_block_size = maxi - mini;
    }

    void setResolution(int w2, int h2) {
        this.pic_width_in_luma_samples = w2;
        this.pic_height_in_luma_samples = h2;
    }

    private static void skipVUI(Bitstream reader, Sps sps) {
        byte bitstream_restriction_flag;
        byte chroma_loc_info_present_flag;
        byte video_signal_type_present_flag;
        byte overscan_info_present_flag;
        int aspect_ratio_idc;
        boolean EXTENDED_SAR = false;
        byte aspect_ratio_info_present_flag = reader.readBit();
        if (aspect_ratio_info_present_flag != 0 && (aspect_ratio_idc = reader.readU8()) == 0) {
            int sar_width = reader.readU16();
            int n2 = reader.readU16();
        }
        if ((overscan_info_present_flag = reader.readBit()) != 0) {
            byte by = reader.readBit();
        }
        if ((video_signal_type_present_flag = reader.readBit()) != 0) {
            int video_format = reader.readBits(3);
            byte video_full_range_flag = reader.readBit();
            byte colour_description_present_flag = reader.readBit();
            if (colour_description_present_flag != 0) {
                int colour_primaries = reader.readU8();
                int transfer_characteristics = reader.readU8();
                int n3 = reader.readU8();
            }
        }
        if ((chroma_loc_info_present_flag = reader.readBit()) != 0) {
            int chroma_sample_loc_type_top_field = reader.ue();
            int n4 = reader.ue();
        }
        byte neutral_chroma_indication_flag = reader.readBit();
        byte field_seq_flag = reader.readBit();
        byte frame_field_info_present_flag = reader.readBit();
        byte default_display_window_flag = reader.readBit();
        if (default_display_window_flag != 0) {
            int def_disp_win_left_offset = reader.ue();
            int def_disp_win_right_offset = reader.ue();
            int def_disp_win_top_offset = reader.ue();
            int n5 = reader.ue();
        }
        byte vui_timing_info_present_flag = reader.readBit();
        if (reader.byteRemaining() == 0) {
            return;
        }
        if (vui_timing_info_present_flag != 0) {
            byte vui_hrd_parameters_present_flag;
            int vui_num_units_in_tick = reader.readU32();
            int vui_time_scale = reader.readU32();
            byte vui_poc_proportional_to_timing_flag = reader.readBit();
            if (vui_poc_proportional_to_timing_flag != 0) {
                int n6 = reader.ue();
            }
            if ((vui_hrd_parameters_present_flag = reader.readBit()) != 0) {
                Sps.skipHrd(reader, (byte)1, sps.max_sub_layers);
            }
        }
        if ((bitstream_restriction_flag = reader.readBit()) != 0) {
            byte tiles_fixed_structure_flag = reader.readBit();
            byte motion_vectors_over_pic_boundaries_flag = reader.readBit();
            byte restricted_ref_pic_lists_flag = reader.readBit();
            int min_spatial_segmentation_idc = reader.ue();
            int max_bytes_per_pic_denom = reader.ue();
            int max_bits_per_min_cu_denom = reader.ue();
            int log2_max_mv_length_horizontal = reader.ue();
            int n7 = reader.ue();
        }
    }

    private static void skipHrd(Bitstream reader, byte commonInfPresentFlag, int maxNumSubLayersMinus1) {
        LogWriter.writeLog(" reading HRD ..... ");
        if (commonInfPresentFlag != 0) {
            byte nal_hrd_parameters_present_flag = reader.readBit();
            byte vcl_hrd_parameters_present_flag = reader.readBit();
            if (nal_hrd_parameters_present_flag != 0 || vcl_hrd_parameters_present_flag != 0) {
                int sub_pic_cpb_params_in_pic_timing_sei_flag;
                byte sub_pic_hrd_params_present_flag = reader.readBit();
                if (sub_pic_hrd_params_present_flag != 0) {
                    int tick_divisor_minus2 = reader.readU8();
                    int du_cpb_removal_delay_increment_length_minus1 = reader.readBits(5);
                    sub_pic_cpb_params_in_pic_timing_sei_flag = reader.readBit();
                    int n2 = reader.readBits(5);
                }
                int bit_rate_scale = reader.readBits(4);
                int cpb_size_scale = reader.readBits(4);
                if (sub_pic_hrd_params_present_flag != 0) {
                    sub_pic_cpb_params_in_pic_timing_sei_flag = reader.readBits(4);
                }
                int initial_cpb_removal_delay_length_minus1 = reader.readBits(5);
                int au_cpb_removal_delay_length_minus1 = reader.readBits(5);
                int n3 = reader.readBits(5);
            }
        }
        byte[] fixed_pic_rate_general_flag = new byte[maxNumSubLayersMinus1];
        byte[] fixed_pic_rate_within_cvs_flag = new byte[maxNumSubLayersMinus1];
        byte[] elemental_duration_in_tc_minus1 = new byte[maxNumSubLayersMinus1];
        byte[] low_delay_hrd_flag = new byte[maxNumSubLayersMinus1];
        int[] cpb_cnt_minus1 = new int[maxNumSubLayersMinus1];
        for (int i2 = 0; i2 <= maxNumSubLayersMinus1; ++i2) {
            fixed_pic_rate_general_flag[i2] = reader.readBit();
            if (fixed_pic_rate_general_flag[i2] == 0) {
                fixed_pic_rate_within_cvs_flag[i2] = reader.readBit();
            }
            if (fixed_pic_rate_within_cvs_flag[i2] != 0) {
                elemental_duration_in_tc_minus1[i2] = reader.readBit();
            } else {
                low_delay_hrd_flag[i2] = reader.readBit();
            }
            if (low_delay_hrd_flag[i2] != 0) continue;
            cpb_cnt_minus1[i2] = reader.ue();
        }
    }
}

