/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.HImg;

class Scan {
    private static final int[] QP_4_YCBCR_INTRA_INTER = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] QP_8_YCBCR_INTRA = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 16, 17, 16, 17, 18, 17, 18, 18, 17, 18, 21, 19, 20, 21, 20, 19, 21, 24, 22, 22, 24, 24, 22, 22, 24, 25, 25, 27, 30, 27, 25, 25, 29, 31, 35, 35, 31, 29, 36, 41, 44, 41, 36, 47, 54, 54, 47, 65, 70, 65, 88, 88, 115};
    private static final int[] QP_8_YCBCR_INTER = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 20, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28, 28, 33, 33, 33, 33, 33, 41, 41, 41, 41, 54, 54, 54, 71, 71, 91};
    private static final int[][] SCANH = new int[6][];
    private static final int[][] SCANV = new int[6][];
    private static final int[][] SCAND = new int[6][];
    private static final int[][][] SCANPOS = new int[3][4][];
    int[][] scaling0;
    int[][] scaling1;
    int[][] scaling2;
    int[][] scaling3;

    Scan() {
    }

    private static void initScanH(int[] scan, int blkSize) {
        int i2 = 0;
        for (int y2 = 0; y2 < blkSize; ++y2) {
            for (int x2 = 0; x2 < blkSize; ++x2) {
                scan[i2] = x2 << 16 | y2;
                ++i2;
            }
        }
    }

    private static void initScanV(int[] scan, int blkSize) {
        int i2 = 0;
        for (int x2 = 0; x2 < blkSize; ++x2) {
            for (int y2 = 0; y2 < blkSize; ++y2) {
                scan[i2] = x2 << 16 | y2;
                ++i2;
            }
        }
    }

    private static void initScanD(int[] scan, int blkSize) {
        int i2 = 0;
        int x2 = 0;
        int y2 = 0;
        while (true) {
            if (y2 >= 0) {
                if (x2 < blkSize && y2 < blkSize) {
                    scan[i2] = x2 << 16 | y2;
                    ++i2;
                }
                --y2;
                ++x2;
                continue;
            }
            y2 = x2;
            x2 = 0;
            if (i2 >= blkSize * blkSize) break;
        }
    }

    static int[] get_scan_order(int log2BlockSize, int scanIdx) {
        switch (scanIdx) {
            case 0: {
                return SCAND[log2BlockSize];
            }
            case 1: {
                return SCANH[log2BlockSize];
            }
            case 2: {
                return SCANV[log2BlockSize];
            }
        }
        return new int[0];
    }

    static void fillScanPos(int[] pos, int loc, int x2, int y2, int scanIdx, int log2TrafoSize) {
        int yC;
        int xC;
        int lastScanPos = 16;
        int lastSubBlock = (1 << log2TrafoSize - 2) * (1 << log2TrafoSize - 2) - 1;
        int[] ScanOrderSub = Scan.get_scan_order(log2TrafoSize - 2, scanIdx);
        int[] ScanOrderPos = Scan.get_scan_order(2, scanIdx);
        do {
            if (lastScanPos == 0) {
                lastScanPos = 16;
                --lastSubBlock;
            }
            int S2 = ScanOrderSub[lastSubBlock];
            xC = (S2 >> 16 << 2) + (ScanOrderPos[--lastScanPos] >> 16);
            yC = ((S2 & 0xFFFF) << 2) + (ScanOrderPos[lastScanPos] & 0xFFFF);
        } while (xC != x2 || yC != y2);
        pos[loc] = lastSubBlock << 16 | lastScanPos;
    }

    int getScanPos(int x2, int y2, int scanIdx, int log2BlkSize) {
        return SCANPOS[scanIdx][log2BlkSize - 2][y2 * (1 << log2BlkSize) + x2];
    }

    void initScalingFactor() {
        int matrixId;
        this.scaling0 = new int[6][16];
        this.scaling1 = new int[6][64];
        this.scaling2 = new int[6][256];
        this.scaling3 = new int[6][1024];
        for (matrixId = 0; matrixId < 6; ++matrixId) {
            this.fillScalingFactor(this.scaling0[matrixId], QP_4_YCBCR_INTRA_INTER, 0);
        }
        for (matrixId = 0; matrixId < 3; ++matrixId) {
            this.fillScalingFactor(this.scaling1[matrixId + 0], QP_8_YCBCR_INTRA, 1);
            this.fillScalingFactor(this.scaling1[matrixId + 3], QP_8_YCBCR_INTER, 1);
        }
        for (matrixId = 0; matrixId < 3; ++matrixId) {
            this.fillScalingFactor(this.scaling2[matrixId + 0], QP_8_YCBCR_INTRA, 2);
            this.fillScalingFactor(this.scaling2[matrixId + 3], QP_8_YCBCR_INTER, 2);
        }
        this.fillScalingFactor(this.scaling3[0], QP_8_YCBCR_INTRA, 3);
        this.fillScalingFactor(this.scaling3[1], QP_8_YCBCR_INTER, 3);
    }

    void fillScalingFactor(int[] scalingFactors, int[] sclist, int sizeId) {
        switch (sizeId) {
            case 0: {
                int width = 4;
                int[] scan = Scan.get_scan_order(2, 0);
                for (int i2 = 0; i2 < 16; ++i2) {
                    int x2 = scan[i2] >> 16;
                    int y2 = scan[i2] & 0xFFFF;
                    scalingFactors[x2 + width * y2] = sclist[i2];
                }
                break;
            }
            case 1: {
                int width = 8;
                int[] scan = Scan.get_scan_order(3, 0);
                for (int i3 = 0; i3 < 64; ++i3) {
                    int x3 = scan[i3] >> 16;
                    int y3 = scan[i3] & 0xFFFF;
                    scalingFactors[x3 + width * y3] = sclist[i3];
                }
                break;
            }
            case 2: {
                int width = 8;
                int subWidth = 2;
                int[] scan = Scan.get_scan_order(3, 0);
                for (int i4 = 0; i4 < 64; ++i4) {
                    for (int dy = 0; dy < 2; ++dy) {
                        for (int dx = 0; dx < 2; ++dx) {
                            int x4 = scan[i4] >> 16;
                            int y4 = scan[i4] & 0xFFFF;
                            x4 = 2 * x4 + dx;
                            y4 = 2 * y4 + dy;
                            scalingFactors[x4 + width * subWidth * y4] = sclist[i4];
                        }
                    }
                }
                break;
            }
            case 3: {
                int width = 8;
                int subWidth = 4;
                int[] scan = Scan.get_scan_order(3, 0);
                for (int i5 = 0; i5 < 64; ++i5) {
                    for (int dy = 0; dy < 4; ++dy) {
                        for (int dx = 0; dx < 4; ++dx) {
                            int x5 = scan[i5] >> 16;
                            int y5 = scan[i5] & 0xFFFF;
                            x5 = 4 * x5 + dx;
                            y5 = 4 * y5 + dy;
                            scalingFactors[x5 + width * subWidth * y5] = sclist[i5];
                        }
                    }
                }
                break;
            }
        }
    }

    static void scale(Bitstream reader, HImg d2) {
        int[][] dc_coeff = new int[4][6];
        for (int sizeId = 0; sizeId < 4; ++sizeId) {
            int[][] scaling_list = new int[6][1024];
            block7: for (int matrixId = 0; matrixId < 6; matrixId += sizeId == 3 ? 3 : 1) {
                int scaling_list_dc;
                int len;
                int canonicalId = matrixId;
                if (sizeId == 3 && matrixId == 1) {
                    canonicalId = 3;
                }
                int n2 = len = sizeId == 0 ? 16 : 64;
                int[] factor = sizeId == 0 ? QP_4_YCBCR_INTRA_INTER : (canonicalId < 3 ? QP_8_YCBCR_INTRA : QP_8_YCBCR_INTER);
                int[] curList = scaling_list[matrixId];
                byte scaling_list_pred_mode_flag = reader.readBit();
                if (scaling_list_pred_mode_flag == 0) {
                    int scaling_list_pred_matrix_id_delta = reader.ue();
                    dc_coeff[sizeId][matrixId] = 16;
                    scaling_list_dc = 16;
                    if (scaling_list_pred_matrix_id_delta == 0) {
                        if (sizeId == 0) {
                            System.arraycopy(QP_4_YCBCR_INTRA_INTER, 0, curList, 0, 16);
                        } else {
                            if (canonicalId < 3) {
                                System.arraycopy(QP_8_YCBCR_INTRA, 0, curList, 0, 64);
                            } else {
                                System.arraycopy(QP_8_YCBCR_INTER, 0, curList, 0, 64);
                            }
                            System.arraycopy(factor, 0, curList, 0, len);
                        }
                    } else {
                        int mID = matrixId - scaling_list_pred_matrix_id_delta;
                        System.arraycopy(scaling_list[mID], 0, curList, 0, len);
                        scaling_list_dc = dc_coeff[sizeId][mID];
                        dc_coeff[sizeId][matrixId] = dc_coeff[sizeId][mID];
                    }
                } else {
                    int coefNum;
                    int nextCoef = 8;
                    int n3 = coefNum = sizeId == 0 ? 16 : 64;
                    if (sizeId > 1) {
                        scaling_list_dc = reader.se();
                        nextCoef = scaling_list_dc += 8;
                        dc_coeff[sizeId][matrixId] = scaling_list_dc;
                    } else {
                        scaling_list_dc = 16;
                    }
                    for (int i2 = 0; i2 < coefNum; ++i2) {
                        int slist_delta_coef = reader.se();
                        curList[i2] = nextCoef = (nextCoef + slist_delta_coef + 256) % 256;
                    }
                }
                switch (sizeId) {
                    case 0: {
                        d2.scan.fillScalingFactor(d2.scan.scaling0[matrixId], curList, 0);
                        continue block7;
                    }
                    case 1: {
                        d2.scan.fillScalingFactor(d2.scan.scaling1[matrixId], curList, 1);
                        continue block7;
                    }
                    case 2: {
                        d2.scan.fillScalingFactor(d2.scan.scaling2[matrixId], curList, 2);
                        d2.scan.scaling2[matrixId][0] = scaling_list_dc;
                        continue block7;
                    }
                    case 3: {
                        d2.scan.fillScalingFactor(d2.scan.scaling3[matrixId], curList, 3);
                        d2.scan.scaling3[matrixId][0] = scaling_list_dc;
                    }
                }
            }
        }
    }

    static {
        Scan.SCANH[0] = new int[16];
        Scan.SCANV[0] = new int[16];
        Scan.SCAND[0] = new int[16];
        for (int log2size = 1; log2size <= 5; ++log2size) {
            int blk = 1 << log2size;
            Scan.SCANH[log2size] = new int[blk * blk];
            Scan.SCANV[log2size] = new int[blk * blk];
            Scan.SCAND[log2size] = new int[blk * blk];
            Scan.initScanH(SCANH[log2size], blk);
            Scan.initScanV(SCANV[log2size], blk);
            Scan.initScanD(SCAND[log2size], blk);
        }
        for (int log2size = 2; log2size <= 5; ++log2size) {
            int tt = 1 << log2size;
            for (int scanIdx = 0; scanIdx < 3; ++scanIdx) {
                if (SCANPOS[scanIdx][log2size - 2] == null) {
                    Scan.SCANPOS[scanIdx][log2size - 2] = new int[tt * tt];
                }
                int[] ff = SCANPOS[scanIdx][log2size - 2];
                for (int y2 = 0; y2 < tt; ++y2) {
                    for (int x2 = 0; x2 < tt; ++x2) {
                        Scan.fillScanPos(ff, y2 * tt + x2, x2, y2, scanIdx, log2size);
                    }
                }
            }
        }
    }
}

