/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Sps;
import java.util.List;

class Rps {
    final int[] DeltaPocS0 = new int[16];
    final int[] DeltaPocS1 = new int[16];
    final int[] UsedByCurrPicS0 = new int[16];
    final int[] UsedByCurrPicS1 = new int[16];
    int NumNegativePics;
    int NumPositivePics;
    int NumDeltaPocs;
    int NumPocTotalCurr_shortterm_only;

    Rps() {
    }

    void reset() {
        this.NumNegativePics = 0;
        this.NumPositivePics = 0;
        this.NumDeltaPocs = 0;
        this.NumPocTotalCurr_shortterm_only = 0;
        for (int i2 = 0; i2 < 16; ++i2) {
            this.DeltaPocS0[i2] = 0;
            this.DeltaPocS1[i2] = 0;
            this.UsedByCurrPicS0[i2] = 0;
            this.UsedByCurrPicS1[i2] = 0;
        }
    }

    void compute_derived_values() {
        int i2;
        this.NumPocTotalCurr_shortterm_only = 0;
        for (i2 = 0; i2 < this.NumNegativePics; ++i2) {
            if (this.UsedByCurrPicS0[i2] == 0) continue;
            ++this.NumPocTotalCurr_shortterm_only;
        }
        for (i2 = 0; i2 < this.NumPositivePics; ++i2) {
            if (this.UsedByCurrPicS1[i2] == 0) continue;
            ++this.NumPocTotalCurr_shortterm_only;
        }
        this.NumDeltaPocs = this.NumNegativePics + this.NumPositivePics;
    }

    static void read(Bitstream br2, Sps sps, Rps out_set, int idxRps, List<Rps> sets, boolean sliceRefPicSet) {
        byte inter_ref_pic_set_prediction_flag = idxRps != 0 ? br2.readBit() : (byte)0;
        if (inter_ref_pic_set_prediction_flag != 0) {
            int dPoc;
            int j2;
            int delta_idx;
            int vlc;
            if (sliceRefPicSet) {
                delta_idx = vlc = br2.ue();
                ++delta_idx;
            } else {
                delta_idx = 1;
            }
            int RIdx = idxRps - delta_idx;
            assert (RIdx >= 0);
            byte delta_rps_sign = br2.readBit();
            int abs_delta_rps = vlc = br2.ue();
            int DeltaRPS = delta_rps_sign != 0 ? -abs_delta_rps : ++abs_delta_rps;
            int nDeltaPocsRIdx = sets.get((int)RIdx).NumDeltaPocs;
            int[] used_by_curr_pic_flag = new int[nDeltaPocsRIdx + 1];
            int[] use_delta_flag = new int[nDeltaPocsRIdx + 1];
            for (int j3 = 0; j3 <= nDeltaPocsRIdx; ++j3) {
                used_by_curr_pic_flag[j3] = br2.readBit();
                use_delta_flag[j3] = used_by_curr_pic_flag[j3] != 0 ? 1 : (int)br2.readBit();
            }
            int nNegativeRIdx = sets.get((int)RIdx).NumNegativePics;
            int nPositiveRIdx = sets.get((int)RIdx).NumPositivePics;
            int i2 = 0;
            for (j2 = nPositiveRIdx - 1; j2 >= 0; --j2) {
                dPoc = sets.get((int)RIdx).DeltaPocS1[j2] + DeltaRPS;
                if (dPoc >= 0 || use_delta_flag[nNegativeRIdx + j2] == 0) continue;
                out_set.DeltaPocS0[i2] = dPoc;
                out_set.UsedByCurrPicS0[i2] = used_by_curr_pic_flag[nNegativeRIdx + j2];
                ++i2;
            }
            if (DeltaRPS < 0 && use_delta_flag[nDeltaPocsRIdx] != 0) {
                out_set.DeltaPocS0[i2] = DeltaRPS;
                out_set.UsedByCurrPicS0[i2] = used_by_curr_pic_flag[nDeltaPocsRIdx];
                ++i2;
            }
            for (j2 = 0; j2 < nNegativeRIdx; ++j2) {
                dPoc = sets.get((int)RIdx).DeltaPocS0[j2] + DeltaRPS;
                if (dPoc >= 0 || use_delta_flag[j2] == 0) continue;
                out_set.DeltaPocS0[i2] = dPoc;
                out_set.UsedByCurrPicS0[i2] = used_by_curr_pic_flag[j2];
                ++i2;
            }
            out_set.NumNegativePics = i2;
            i2 = 0;
            for (j2 = nNegativeRIdx - 1; j2 >= 0; --j2) {
                dPoc = sets.get((int)RIdx).DeltaPocS0[j2] + DeltaRPS;
                if (dPoc <= 0 || use_delta_flag[j2] == 0) continue;
                out_set.DeltaPocS1[i2] = dPoc;
                out_set.UsedByCurrPicS1[i2] = used_by_curr_pic_flag[j2];
                ++i2;
            }
            if (DeltaRPS > 0 && use_delta_flag[nDeltaPocsRIdx] != 0) {
                out_set.DeltaPocS1[i2] = DeltaRPS;
                out_set.UsedByCurrPicS1[i2] = used_by_curr_pic_flag[nDeltaPocsRIdx];
                ++i2;
            }
            for (j2 = 0; j2 < nPositiveRIdx; ++j2) {
                dPoc = sets.get((int)RIdx).DeltaPocS1[j2] + DeltaRPS;
                if (dPoc <= 0 || use_delta_flag[nNegativeRIdx + j2] == 0) continue;
                out_set.DeltaPocS1[i2] = dPoc;
                out_set.UsedByCurrPicS1[i2] = used_by_curr_pic_flag[nNegativeRIdx + j2];
                ++i2;
            }
            out_set.NumPositivePics = i2;
        } else {
            int i3;
            int num_positive_pics;
            int num_negative_pics = br2.ue();
            if (num_negative_pics + (num_positive_pics = br2.ue()) > sps.sps_max_dec_pic_buffering[sps.max_sub_layers - 1]) {
                out_set.NumNegativePics = 0;
                out_set.NumPositivePics = 0;
                out_set.NumDeltaPocs = 0;
                out_set.NumPocTotalCurr_shortterm_only = 0;
                return;
            }
            out_set.NumNegativePics = num_negative_pics;
            out_set.NumPositivePics = num_positive_pics;
            int lastPocS = 0;
            for (i3 = 0; i3 < num_negative_pics; ++i3) {
                int delta_poc_s0 = br2.ue();
                byte used_by_curr_pic_s0_flag = br2.readBit();
                out_set.DeltaPocS0[i3] = lastPocS - ++delta_poc_s0;
                out_set.UsedByCurrPicS0[i3] = used_by_curr_pic_s0_flag;
                lastPocS = out_set.DeltaPocS0[i3];
            }
            lastPocS = 0;
            for (i3 = 0; i3 < num_positive_pics; ++i3) {
                int delta_poc_s1 = br2.ue();
                byte used_by_curr_pic_s1_flag = br2.readBit();
                out_set.DeltaPocS1[i3] = lastPocS + ++delta_poc_s1;
                out_set.UsedByCurrPicS1[i3] = used_by_curr_pic_s1_flag;
                lastPocS = out_set.DeltaPocS1[i3];
            }
        }
        out_set.compute_derived_values();
    }
}

