/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.ProfileData;

class ProfileTierLevel {
    final ProfileData general = new ProfileData();
    private final ProfileData[] sub_layer = new ProfileData[8];

    ProfileTierLevel() {
    }

    void read(Bitstream reader, int max_sub_layers) {
        int i2;
        this.general.profile_present_flag = 1;
        this.general.level_present_flag = 1;
        this.general.read(reader);
        for (i2 = 0; i2 < max_sub_layers - 1; ++i2) {
            this.sub_layer[i2] = new ProfileData();
            this.sub_layer[i2].profile_present_flag = reader.readBit();
            this.sub_layer[i2].level_present_flag = reader.readBit();
        }
        if (max_sub_layers > 1) {
            for (i2 = max_sub_layers - 1; i2 < 8; ++i2) {
                reader.readBits(2);
            }
        }
        for (i2 = 0; i2 < max_sub_layers - 1; ++i2) {
            this.sub_layer[i2].read(reader);
        }
    }

    void write(Cabac out, int max_sub_layers) {
        int i2;
        this.general.write(out);
        for (i2 = 0; i2 < max_sub_layers - 1; ++i2) {
            out.write_bit(this.sub_layer[i2].profile_present_flag);
            out.write_bit(this.sub_layer[i2].level_present_flag);
        }
        if (max_sub_layers > 1) {
            for (i2 = max_sub_layers - 1; i2 < 8; ++i2) {
                out.skip_bits(2);
            }
        }
        for (i2 = 0; i2 < max_sub_layers - 1; ++i2) {
            this.sub_layer[i2].write(out);
        }
    }
}

