/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.Scan;
import com.idrsolutions.image.heic.common.Sps;

class Pps {
    static final int DEFAULTQP = 0;
    int Log2MinCuQpDeltaSize;
    int Log2MaxTransformSkipSize;
    int Log2MinCuChromaQpOffsetSize;
    int[] colWidth = new int[1];
    int[] rowHeight = new int[1];
    int[] colBd = new int[2];
    int[] rowBd = new int[2];
    int[] CtbAddrRStoTS;
    int[] CtbAddrTStoRS;
    int[] TileId;
    int[] MinTbAddrZS;
    int[] TileIdRS;
    byte tiles_enabled_flag;
    int num_tile_columns = 1;
    int num_tile_rows = 1;
    private byte uniform_spacing_flag = 1;
    private byte loop_filter_across_tiles_enabled_flag = 1;
    int init_qp = 0;
    byte dependent_slice_segments_enabled_flag;
    byte output_flag_present_flag;
    int num_extra_slice_header_bits;
    byte cabac_init_present_flag;
    byte entropy_coding_sync_enabled_flag;
    byte slice_segment_header_extension_present_flag;
    byte scaling_list_data_present_flag;
    byte lists_modification_present_flag;
    byte sign_data_hiding_enabled_flag;
    byte transform_skip_enabled_flag;
    byte cu_qp_delta_enabled_flag;
    byte transquant_bypass_enabled_flag;
    byte weighted_pred_flag;
    byte weighted_bipred_flag;
    int pic_parameter_set_id;
    private int seq_parameter_set_id;
    int num_ref_idx_l0_default_active = 1;
    int num_ref_idx_l1_default_active = 1;
    byte constrained_intra_pred_flag;
    int cb_qp_offset;
    int cr_qp_offset;
    byte slice_chroma_qp_offsets_present_flag;
    int diff_cu_qp_delta_depth;
    byte loop_filter_across_slices_enabled_flag = 1;
    byte deblocking_filter_control_present_flag;
    byte deblocking_filter_override_enabled_flag;
    byte deblocking_filter_disabled_flag;
    int beta_offset;
    int tc_offset;
    private int log2_parallel_merge_level = 2;
    private byte range_extension_flag;
    private int extension_4bits;
    int log2_max_transform_skip_block_size = 2;
    byte cross_component_prediction_enabled_flag;
    byte chroma_qp_offset_list_enabled_flag;
    private int diff_cu_chroma_qp_offset_depth;
    int chroma_qp_offset_list_len;
    int[] cb_qp_offset_list;
    int[] cr_qp_offset_list;
    int log2_sao_offset_scale_luma;
    int log2_sao_offset_scale_chroma;

    Pps() {
    }

    void readPps(Bitstream reader, HImg d2, Sps sps) {
        this.setDefaults();
        this.pic_parameter_set_id = reader.ue();
        this.seq_parameter_set_id = reader.ue();
        this.dependent_slice_segments_enabled_flag = reader.readBit();
        this.output_flag_present_flag = reader.readBit();
        this.num_extra_slice_header_bits = reader.readBits(3);
        this.sign_data_hiding_enabled_flag = reader.readBit();
        this.cabac_init_present_flag = reader.readBit();
        this.num_ref_idx_l0_default_active = reader.ue() + 1;
        this.num_ref_idx_l1_default_active = reader.ue() + 1;
        this.init_qp = reader.se() + 26;
        this.constrained_intra_pred_flag = reader.readBit();
        this.transform_skip_enabled_flag = reader.readBit();
        this.cu_qp_delta_enabled_flag = reader.readBit();
        this.diff_cu_qp_delta_depth = this.cu_qp_delta_enabled_flag != 0 ? reader.ue() : 0;
        this.cb_qp_offset = reader.se();
        this.cr_qp_offset = reader.se();
        this.slice_chroma_qp_offsets_present_flag = reader.readBit();
        this.weighted_pred_flag = reader.readBit();
        this.weighted_bipred_flag = reader.readBit();
        this.transquant_bypass_enabled_flag = reader.readBit();
        this.tiles_enabled_flag = reader.readBit();
        this.entropy_coding_sync_enabled_flag = reader.readBit();
        if (this.tiles_enabled_flag != 0) {
            this.num_tile_columns = reader.ue() + 1;
            this.num_tile_rows = reader.ue() + 1;
            this.uniform_spacing_flag = reader.readBit();
            if (this.uniform_spacing_flag == 0) {
                int i2;
                int lastColumnWidth = sps.PicWidthInCtbsY;
                int lastRowHeight = sps.PicHeightInCtbsY;
                this.colWidth = new int[this.num_tile_columns];
                this.rowHeight = new int[this.num_tile_rows];
                for (i2 = 0; i2 < this.num_tile_columns - 1; ++i2) {
                    this.colWidth[i2] = reader.ue() + 1;
                    lastColumnWidth -= this.colWidth[i2];
                }
                this.colWidth[this.num_tile_columns - 1] = lastColumnWidth;
                for (i2 = 0; i2 < this.num_tile_rows - 1; ++i2) {
                    this.rowHeight[i2] = reader.ue() + 1;
                    lastRowHeight -= this.rowHeight[i2];
                }
                this.rowHeight[this.num_tile_rows - 1] = lastRowHeight;
            }
            this.loop_filter_across_tiles_enabled_flag = reader.readBit();
        } else {
            this.num_tile_columns = 1;
            this.num_tile_rows = 1;
            this.uniform_spacing_flag = 1;
            this.loop_filter_across_tiles_enabled_flag = 0;
        }
        this.beta_offset = 0;
        this.tc_offset = 0;
        this.loop_filter_across_slices_enabled_flag = reader.readBit();
        this.deblocking_filter_control_present_flag = reader.readBit();
        if (this.deblocking_filter_control_present_flag != 0) {
            this.deblocking_filter_override_enabled_flag = reader.readBit();
            this.deblocking_filter_disabled_flag = reader.readBit();
            if (this.deblocking_filter_disabled_flag == 0) {
                this.beta_offset = reader.se() * 2;
                this.tc_offset = reader.se() * 2;
            }
        } else {
            this.deblocking_filter_override_enabled_flag = 0;
            this.deblocking_filter_disabled_flag = 0;
        }
        this.scaling_list_data_present_flag = reader.readBit();
        if (this.scaling_list_data_present_flag != 0) {
            if (d2.scan.scaling0 == null) {
                d2.scan.initScalingFactor();
            }
            Scan.scale(reader, d2);
        }
        this.lists_modification_present_flag = reader.readBit();
        this.log2_parallel_merge_level = reader.ue() + 2;
        this.slice_segment_header_extension_present_flag = reader.readBit();
        byte extension_present_flag = reader.readBit();
        if (extension_present_flag != 0) {
            this.range_extension_flag = reader.readBit();
            reader.readBits(3);
            this.extension_4bits = reader.readBits(4);
        }
        if (this.range_extension_flag != 0) {
            this.updatePpsRange(reader);
        }
        this.deriveValues(sps);
        if (this.extension_4bits != 0) {
            while (reader.moreRbspData()) {
                reader.readBit();
            }
        }
        reader.readRbspTrailingBits();
    }

    private void updatePpsRange(Bitstream reader) {
        if (this.transform_skip_enabled_flag != 0) {
            this.log2_max_transform_skip_block_size = reader.ue() + 2;
        }
        this.cross_component_prediction_enabled_flag = reader.readBit();
        this.chroma_qp_offset_list_enabled_flag = reader.readBit();
        if (this.chroma_qp_offset_list_enabled_flag != 0) {
            this.diff_cu_chroma_qp_offset_depth = reader.ue();
            this.chroma_qp_offset_list_len = reader.ue() + 1;
            this.cb_qp_offset_list = new int[this.chroma_qp_offset_list_len];
            this.cr_qp_offset_list = new int[this.chroma_qp_offset_list_len];
            for (int i2 = 0; i2 < this.chroma_qp_offset_list_len; ++i2) {
                this.cb_qp_offset_list[i2] = reader.se();
                this.cr_qp_offset_list[i2] = reader.se();
            }
        }
        this.log2_sao_offset_scale_luma = reader.ue();
        this.log2_sao_offset_scale_chroma = reader.ue();
    }

    void deriveValues(Sps sps) {
        int x2;
        int y2;
        int i2;
        int i3;
        this.Log2MinCuQpDeltaSize = sps.Log2CtbSizeY - this.diff_cu_qp_delta_depth;
        this.Log2MinCuChromaQpOffsetSize = sps.Log2CtbSizeY - this.diff_cu_chroma_qp_offset_depth;
        this.Log2MaxTransformSkipSize = this.log2_max_transform_skip_block_size;
        if (this.uniform_spacing_flag != 0) {
            int i4;
            int[] colPos = new int[this.num_tile_columns + 1];
            for (i4 = 0; i4 <= this.num_tile_columns; ++i4) {
                colPos[i4] = i4 * sps.PicWidthInCtbsY / this.num_tile_columns;
            }
            for (i4 = 0; i4 < this.num_tile_columns; ++i4) {
                this.colWidth[i4] = colPos[i4 + 1] - colPos[i4];
            }
            int[] rowPos = new int[this.num_tile_rows + 1];
            for (i3 = 0; i3 <= this.num_tile_rows; ++i3) {
                rowPos[i3] = i3 * sps.PicHeightInCtbsY / this.num_tile_rows;
            }
            for (i3 = 0; i3 < this.num_tile_rows; ++i3) {
                this.rowHeight[i3] = rowPos[i3 + 1] - rowPos[i3];
            }
        }
        this.colBd[0] = 0;
        for (i2 = 0; i2 < this.num_tile_columns; ++i2) {
            this.colBd[i2 + 1] = this.colBd[i2] + this.colWidth[i2];
        }
        this.rowBd[0] = 0;
        for (i2 = 0; i2 < this.num_tile_rows; ++i2) {
            this.rowBd[i2 + 1] = this.rowBd[i2] + this.rowHeight[i2];
        }
        this.CtbAddrRStoTS = new int[sps.PicSizeInCtbsY];
        this.CtbAddrTStoRS = new int[sps.PicSizeInCtbsY];
        this.TileId = new int[sps.PicSizeInCtbsY];
        this.TileIdRS = new int[sps.PicSizeInCtbsY];
        this.MinTbAddrZS = new int[sps.PicSizeInTbsY];
        for (int ctbAddrRS = 0; ctbAddrRS < sps.PicSizeInCtbsY; ++ctbAddrRS) {
            int j2;
            int i5;
            int tbX = ctbAddrRS % sps.PicWidthInCtbsY;
            int tbY = ctbAddrRS / sps.PicWidthInCtbsY;
            int tileX = -1;
            int tileY = -1;
            for (i5 = 0; i5 < this.num_tile_columns; ++i5) {
                if (tbX < this.colBd[i5]) continue;
                tileX = i5;
            }
            for (j2 = 0; j2 < this.num_tile_rows; ++j2) {
                if (tbY < this.rowBd[j2]) continue;
                tileY = j2;
            }
            this.CtbAddrRStoTS[ctbAddrRS] = 0;
            for (i5 = 0; i5 < tileX; ++i5) {
                int n2 = ctbAddrRS;
                this.CtbAddrRStoTS[n2] = this.CtbAddrRStoTS[n2] + this.rowHeight[tileY] * this.colWidth[i5];
            }
            for (j2 = 0; j2 < tileY; ++j2) {
                int n3 = ctbAddrRS;
                this.CtbAddrRStoTS[n3] = this.CtbAddrRStoTS[n3] + sps.PicWidthInCtbsY * this.rowHeight[j2];
            }
            int n4 = ctbAddrRS;
            this.CtbAddrRStoTS[n4] = this.CtbAddrRStoTS[n4] + (tbY - this.rowBd[tileY]) * this.colWidth[tileX];
            int n5 = ctbAddrRS;
            this.CtbAddrRStoTS[n5] = this.CtbAddrRStoTS[n5] + (tbX - this.colBd[tileX]);
            this.CtbAddrTStoRS[this.CtbAddrRStoTS[ctbAddrRS]] = ctbAddrRS;
        }
        int tIdx = 0;
        for (int j3 = 0; j3 < this.num_tile_rows; ++j3) {
            for (i3 = 0; i3 < this.num_tile_columns; ++i3) {
                for (y2 = this.rowBd[j3]; y2 < this.rowBd[j3 + 1]; ++y2) {
                    for (x2 = this.colBd[i3]; x2 < this.colBd[i3 + 1]; ++x2) {
                        this.TileId[this.CtbAddrRStoTS[y2 * sps.PicWidthInCtbsY + x2]] = tIdx;
                        this.TileIdRS[y2 * sps.PicWidthInCtbsY + x2] = tIdx;
                    }
                }
                ++tIdx;
            }
        }
        for (y2 = 0; y2 < sps.PicHeightInTbsY; ++y2) {
            for (x2 = 0; x2 < sps.PicWidthInTbsY; ++x2) {
                int tbX = x2 << sps.Log2MinTrafoSize >> sps.Log2CtbSizeY;
                int tbY = y2 << sps.Log2MinTrafoSize >> sps.Log2CtbSizeY;
                int ctbAddrRS = sps.PicWidthInCtbsY * tbY + tbX;
                this.MinTbAddrZS[x2 + y2 * sps.PicWidthInTbsY] = this.CtbAddrRStoTS[ctbAddrRS] << (sps.Log2CtbSizeY - sps.Log2MinTrafoSize) * 2;
                int p2 = 0;
                for (int i6 = 0; i6 < sps.Log2CtbSizeY - sps.Log2MinTrafoSize; ++i6) {
                    int m2 = 1 << i6;
                    int m1 = (m2 & x2) != 0 ? m2 * m2 : 0;
                    int m22 = (m2 & y2) != 0 ? 2 * m2 * m2 : 0;
                    p2 += m1 + m22;
                }
                int n6 = x2 + y2 * sps.PicWidthInTbsY;
                this.MinTbAddrZS[n6] = this.MinTbAddrZS[n6] + p2;
            }
        }
    }

    boolean isTileStartCTB(int ctbX, int ctbY, HImg d2) {
        if (this.tiles_enabled_flag == 0) {
            return ctbX == 0 && ctbY == 0;
        }
        for (int i2 = 0; i2 < this.num_tile_columns; ++i2) {
            if (this.colBd[i2] != ctbX) continue;
            for (int k2 = 0; k2 < this.num_tile_rows; ++k2) {
                if (this.rowBd[k2] != ctbY) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    void setDefaults() {
        this.pic_parameter_set_id = 0;
        this.seq_parameter_set_id = 0;
        this.dependent_slice_segments_enabled_flag = 0;
        this.sign_data_hiding_enabled_flag = 0;
        this.cabac_init_present_flag = 0;
        this.num_ref_idx_l0_default_active = 1;
        this.num_ref_idx_l1_default_active = 1;
        this.init_qp = 0;
        this.constrained_intra_pred_flag = 0;
        this.transform_skip_enabled_flag = 0;
        this.cu_qp_delta_enabled_flag = 0;
        this.diff_cu_qp_delta_depth = 0;
        this.cb_qp_offset = 0;
        this.cr_qp_offset = 0;
        this.slice_chroma_qp_offsets_present_flag = 0;
        this.weighted_pred_flag = 0;
        this.weighted_bipred_flag = 0;
        this.output_flag_present_flag = 0;
        this.transquant_bypass_enabled_flag = 0;
        this.entropy_coding_sync_enabled_flag = 0;
        this.tiles_enabled_flag = 0;
        this.num_tile_columns = 1;
        this.num_tile_rows = 1;
        this.uniform_spacing_flag = 1;
        this.loop_filter_across_tiles_enabled_flag = 0;
        this.loop_filter_across_slices_enabled_flag = 0;
        this.deblocking_filter_control_present_flag = 0;
        this.deblocking_filter_override_enabled_flag = 0;
        this.deblocking_filter_disabled_flag = 0;
        this.beta_offset = 0;
        this.tc_offset = 0;
        this.scaling_list_data_present_flag = 0;
        this.lists_modification_present_flag = 0;
        this.log2_parallel_merge_level = 2;
        this.num_extra_slice_header_bits = 0;
        this.slice_segment_header_extension_present_flag = 0;
        this.range_extension_flag = 0;
    }

    void write(HImg img, Cabac out) {
        out.writeUE(this.pic_parameter_set_id);
        out.writeUE(this.seq_parameter_set_id);
        out.write_bit(this.dependent_slice_segments_enabled_flag);
        out.write_bit(this.output_flag_present_flag);
        out.write_bits(this.num_extra_slice_header_bits, 3);
        out.write_bit(this.sign_data_hiding_enabled_flag);
        out.write_bit(this.cabac_init_present_flag);
        out.writeUE(this.num_ref_idx_l0_default_active - 1);
        out.writeUE(this.num_ref_idx_l1_default_active - 1);
        out.writeSE(this.init_qp - 26);
        out.write_bit(this.constrained_intra_pred_flag);
        out.write_bit(this.transform_skip_enabled_flag);
        out.write_bit(this.cu_qp_delta_enabled_flag);
        if (this.cu_qp_delta_enabled_flag != 0) {
            out.writeUE(this.diff_cu_qp_delta_depth);
        }
        out.writeSE(this.cb_qp_offset);
        out.writeSE(this.cr_qp_offset);
        out.write_bit(this.slice_chroma_qp_offsets_present_flag);
        out.write_bit(this.weighted_pred_flag);
        out.write_bit(this.weighted_bipred_flag);
        out.write_bit(this.transquant_bypass_enabled_flag);
        out.write_bit(this.tiles_enabled_flag);
        out.write_bit(this.entropy_coding_sync_enabled_flag);
        if (this.tiles_enabled_flag != 0) {
            out.writeUE(this.num_tile_columns - 1);
            out.writeUE(this.num_tile_rows - 1);
            out.write_bit(this.uniform_spacing_flag);
            if (this.uniform_spacing_flag == 0) {
                int i2;
                for (i2 = 0; i2 < this.num_tile_columns - 1; ++i2) {
                    out.writeUE(this.colWidth[i2] - 1);
                }
                for (i2 = 0; i2 < this.num_tile_rows - 1; ++i2) {
                    out.writeUE(this.rowHeight[i2] - 1);
                }
            }
            out.write_bit(this.loop_filter_across_tiles_enabled_flag);
        }
        out.write_bit(this.loop_filter_across_slices_enabled_flag);
        out.write_bit(this.deblocking_filter_control_present_flag);
        if (this.deblocking_filter_control_present_flag != 0) {
            out.write_bit(this.deblocking_filter_override_enabled_flag);
            out.write_bit(this.deblocking_filter_disabled_flag);
            if (this.deblocking_filter_disabled_flag == 0) {
                out.writeSE(this.beta_offset / 2);
                out.writeSE(this.tc_offset / 2);
            }
        }
        out.write_bit(this.scaling_list_data_present_flag);
        out.write_bit(this.lists_modification_present_flag);
        out.writeUE(this.log2_parallel_merge_level - 2);
        out.write_bit(this.slice_segment_header_extension_present_flag);
        out.write_bit(this.range_extension_flag);
    }
}

