/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Cabac;
import com.idrsolutions.image.utility.DataReader;
import java.io.IOException;

class Nal {
    int nal_unit_type;
    int nuh_layer_id;
    int nuh_temporal_id;
    byte[] rbsp;

    Nal() {
    }

    static Nal readNal(DataReader reader, int nBytes) throws IOException {
        int h2 = reader.getU8() << 8 | reader.getU8() & 0xFF;
        Nal res = new Nal();
        res.nal_unit_type = h2 >> 9;
        res.nuh_layer_id = h2 >> 3 & 0x3F;
        res.nuh_temporal_id = h2 & 7;
        int len = nBytes - 2;
        res.rbsp = new byte[len];
        reader.read(res.rbsp);
        return res;
    }

    static void writeNal(Cabac out, int nal_unit_type, int nuh_layer_id, int nuh_temporal_id) {
        out.skip_bits(1);
        out.write_bits(nal_unit_type, 6);
        out.write_bits(nuh_layer_id, 6);
        out.write_bits(nuh_temporal_id + 1, 3);
    }

    boolean isVCL() {
        return this.nal_unit_type < 32;
    }

    boolean isIRAP() {
        return this.nal_unit_type >= 16 && this.nal_unit_type <= 23;
    }
}

