/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Sps;
import com.idrsolutions.image.heic.common.Type;
import java.util.Arrays;

class IntraPred {
    private static final int NOFFSET = 130;
    private final int[] outBorder = new int[260];
    private final boolean[] available = new boolean[260];
    private final int[] refAng = new int[260];
    private final int[] pF = new int[260];
    private int nT;
    private int cIdx;
    private int xB;
    private int yB;
    private int SubWidth;
    private int SubHeight;
    private boolean hasLeft;
    private boolean hasTop;
    private boolean hasTopRight;
    private boolean hasTopLeft;
    private int nBottom;
    private int nRight;
    private int nAvail;
    private int firstValue;

    IntraPred() {
    }

    void decode(HImg img, Sps sps, Pps pps, int xB0, int yB0, int predMode, int nT, int cIdx) {
        Arrays.fill(this.outBorder, 0);
        Arrays.fill(this.available, false);
        this.fillBorderSamples(img, sps, pps, xB0, yB0, nT, cIdx);
        if (sps.intra_smoothing_disabled_flag == 0 && (cIdx == 0 || sps.ChromaArrayType == 3)) {
            this.sampleFilter(sps, this.outBorder, nT, cIdx, predMode);
        }
        int[] dst = img.getImagePlane(cIdx);
        int dstStride = img.getImageStride(cIdx);
        int dstOffset = img.getImageStride(cIdx) * yB0 + xB0;
        switch (predMode) {
            case 0: {
                IntraPred.doPlanar(dst, dstStride, dstOffset, nT, this.outBorder);
                break;
            }
            case 1: {
                IntraPred.doDC(dst, dstStride, dstOffset, nT, cIdx, this.outBorder);
                break;
            }
            default: {
                int bit_depth = cIdx == 0 ? sps.BitDepthY : sps.BitDepthC;
                boolean disableIntraBoundaryFilter = sps.implicit_rdpcm_enabled_flag != 0 && img.get_cu_transquant_bypass(xB0, yB0);
                this.doAngular(dst, dstStride, dstOffset, bit_depth, disableIntraBoundaryFilter, predMode, nT, cIdx, this.outBorder);
            }
        }
    }

    private void sampleFilter(Sps sps, int[] p2, int nT, int cIdx, int predMode) {
        boolean filterFlag = false;
        if (predMode != 1 && nT != 4) {
            int minDistVerHor = Math.min(Math.abs(predMode - 26), Math.abs(predMode - 10));
            switch (nT) {
                case 8: {
                    filterFlag = minDistVerHor > 7;
                    break;
                }
                case 16: {
                    filterFlag = minDistVerHor > 1;
                    break;
                }
                case 32: {
                    boolean bl2 = filterFlag = minDistVerHor > 0;
                }
            }
        }
        if (filterFlag) {
            boolean biIntFlag = sps.strong_intra_smoothing_enabled_flag != 0 && cIdx == 0 && nT == 32 && Math.abs(p2[130] + p2[194] - 2 * p2[162]) < 1 << sps.BitDepthY - 5 && Math.abs(p2[130] + p2[66] - 2 * p2[98]) < 1 << sps.BitDepthY - 5;
            Arrays.fill(this.pF, 0);
            if (biIntFlag) {
                this.pF[130 - 2 * nT] = p2[130 - 2 * nT];
                this.pF[130 + 2 * nT] = p2[130 + 2 * nT];
                this.pF[130] = p2[130];
                for (int i2 = 1; i2 <= 63; ++i2) {
                    this.pF[130 - i2] = p2[130] + (i2 * (p2[66] - p2[130]) + 32 >> 6);
                    this.pF[130 + i2] = p2[130] + (i2 * (p2[194] - p2[130]) + 32 >> 6);
                }
            } else {
                this.pF[130 - 2 * nT] = p2[130 - 2 * nT];
                this.pF[130 + 2 * nT] = p2[130 + 2 * nT];
                for (int i3 = -(2 * nT - 1); i3 <= 2 * nT - 1; ++i3) {
                    this.pF[130 + i3] = p2[130 + i3 + 1] + 2 * p2[130 + i3] + p2[130 + i3 - 1] + 2 >> 2;
                }
            }
            System.arraycopy(this.pF, 130 - 2 * nT, p2, 130 - 2 * nT, 4 * nT + 1);
        }
    }

    private void fillBorderSamples(HImg img, Sps sps, Pps pps, int xB, int yB, int nT, int cIdx) {
        this.nT = nT;
        this.xB = xB;
        this.yB = yB;
        this.cIdx = cIdx;
        this.hasLeft = true;
        this.hasTop = true;
        this.hasTopRight = true;
        this.hasTopLeft = true;
        this.preproc(img, sps, pps);
        this.fillFromImage(img, sps, pps);
        this.sampleSubstitution(img);
    }

    private void preproc(HImg d2, Sps sps, Pps pps) {
        int toprightCTBTileID;
        this.SubWidth = this.cIdx == 0 ? 1 : sps.SubWidthC;
        this.SubHeight = this.cIdx == 0 ? 1 : sps.SubHeightC;
        int xBLuma = this.xB * this.SubWidth;
        int yBLuma = this.yB * this.SubHeight;
        int log2CtbSize = sps.Log2CtbSizeY;
        int picWidthInCtbs = sps.PicWidthInCtbsY;
        if (xBLuma == 0) {
            this.hasLeft = false;
            this.hasTopLeft = false;
        }
        if (yBLuma == 0) {
            this.hasTop = false;
            this.hasTopLeft = false;
            this.hasTopRight = false;
        }
        if (xBLuma + this.nT * this.SubWidth >= sps.pic_width_in_luma_samples) {
            this.hasTopRight = false;
        }
        int xCurrCtb = xBLuma >> log2CtbSize;
        int yCurrCtb = yBLuma >> log2CtbSize;
        int xLeftCtb = xBLuma - 1 >> log2CtbSize;
        int xRightCtb = xBLuma + this.nT * this.SubWidth >> log2CtbSize;
        int yTopCtb = yBLuma - 1 >> log2CtbSize;
        int currCTBSlice = d2.getSliceAddrRS(xCurrCtb, yCurrCtb);
        int leftCTBSlice = this.hasLeft ? d2.getSliceAddrRS(xLeftCtb, yCurrCtb) : -1;
        int topCTBSlice = this.hasTop ? d2.getSliceAddrRS(xCurrCtb, yTopCtb) : -1;
        int toprightCTBSlice = this.hasTopRight ? d2.getSliceAddrRS(xRightCtb, yTopCtb) : -1;
        int topleftCTBSlice = this.hasTopLeft ? d2.getSliceAddrRS(xLeftCtb, yTopCtb) : -1;
        int currCTBTileID = pps.TileIdRS[xCurrCtb + yCurrCtb * picWidthInCtbs];
        int leftCTBTileID = this.hasLeft ? pps.TileIdRS[xLeftCtb + yCurrCtb * picWidthInCtbs] : -1;
        int topCTBTileID = this.hasTop ? pps.TileIdRS[xCurrCtb + yTopCtb * picWidthInCtbs] : -1;
        int topleftCTBTileID = this.hasTopLeft ? pps.TileIdRS[xLeftCtb + yTopCtb * picWidthInCtbs] : -1;
        int n2 = toprightCTBTileID = this.hasTopRight ? pps.TileIdRS[xRightCtb + yTopCtb * picWidthInCtbs] : -1;
        if (leftCTBSlice != currCTBSlice || leftCTBTileID != currCTBTileID) {
            this.hasLeft = false;
        }
        if (topCTBSlice != currCTBSlice || topCTBTileID != currCTBTileID) {
            this.hasTop = false;
        }
        if (topleftCTBSlice != currCTBSlice || topleftCTBTileID != currCTBTileID) {
            this.hasTopLeft = false;
        }
        if (toprightCTBSlice != currCTBSlice || toprightCTBTileID != currCTBTileID) {
            this.hasTopRight = false;
        }
        this.nBottom = sps.pic_height_in_luma_samples - this.yB * this.SubHeight;
        this.nBottom = (this.nBottom + this.SubHeight - 1) / this.SubHeight;
        if (this.nBottom > 2 * this.nT) {
            this.nBottom = 2 * this.nT;
        }
        this.nRight = sps.pic_width_in_luma_samples - this.xB * this.SubWidth;
        this.nRight = (this.nRight + this.SubWidth - 1) / this.SubWidth;
        if (this.nRight > 2 * this.nT) {
            this.nRight = 2 * this.nT;
        }
        this.nAvail = 0;
    }

    private void fillFromImage(HImg d2, Sps sps, Pps pps) {
        int[] image = d2.getImagePlane(this.cIdx);
        int stride = d2.getImageStride(this.cIdx);
        int xBLuma = this.xB * this.SubWidth;
        int yBLuma = this.yB * this.SubHeight;
        int currBlockAddr = pps.MinTbAddrZS[(xBLuma >> sps.Log2MinTrafoSize) + (yBLuma >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
        for (int y2 = this.nBottom - 1; y2 >= 0; y2 -= 4) {
            boolean availableN;
            if (!this.hasLeft) continue;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB - 1) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB + y2) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean bl2 = availableN = NBlockAddr <= currBlockAddr;
            if (pps.constrained_intra_pred_flag != 0 && d2.getPredMode((this.xB - 1) * this.SubWidth, (this.yB + y2) * this.SubHeight) != 0) {
                availableN = false;
            }
            if (!availableN) continue;
            if (this.nAvail == 0) {
                this.firstValue = image[this.xB - 1 + (this.yB + y2) * stride];
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                this.available[130 - y2 + i2 - 1] = availableN;
                this.outBorder[130 - y2 + i2 - 1] = image[this.xB - 1 + (this.yB + y2 - i2) * stride];
            }
            this.nAvail += 4;
        }
        if (this.hasTopLeft) {
            boolean availableN;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB - 1) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB - 1) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean bl3 = availableN = NBlockAddr <= currBlockAddr;
            if (pps.constrained_intra_pred_flag != 0 && d2.getPredMode((this.xB - 1) * this.SubWidth, (this.yB - 1) * this.SubHeight) != 0) {
                availableN = false;
            }
            if (availableN) {
                if (this.nAvail == 0) {
                    this.firstValue = image[this.xB - 1 + (this.yB - 1) * stride];
                }
                this.outBorder[130] = image[this.xB - 1 + (this.yB - 1) * stride];
                this.available[130] = availableN;
                ++this.nAvail;
            }
        }
        for (int x2 = 0; x2 < this.nRight; x2 += 4) {
            boolean availableN;
            boolean borderAvailable;
            boolean bl4 = borderAvailable = x2 < this.nT ? this.hasTop : this.hasTopRight;
            if (!borderAvailable) continue;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB + x2) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB - 1) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean bl5 = availableN = NBlockAddr <= currBlockAddr;
            if (pps.constrained_intra_pred_flag != 0 && d2.getPredMode((this.xB + x2) * this.SubWidth, (this.yB - 1) * this.SubHeight) != 0) {
                availableN = false;
            }
            if (!availableN) continue;
            if (this.nAvail == 0) {
                this.firstValue = image[this.xB + x2 + (this.yB - 1) * stride];
            }
            for (int i3 = 0; i3 < 4; ++i3) {
                this.outBorder[130 + x2 + i3 + 1] = image[this.xB + x2 + i3 + (this.yB - 1) * stride];
                this.available[130 + x2 + i3 + 1] = availableN;
            }
            this.nAvail += 4;
        }
    }

    private void sampleSubstitution(HImg d2) {
        int bit_depth = d2.getBitDepth(this.cIdx);
        if (this.nAvail != 4 * this.nT + 1) {
            if (this.nAvail == 0) {
                Arrays.fill(this.outBorder, 130 - 2 * this.nT, 130 + 2 * this.nT + 1, 1 << bit_depth - 1);
            } else {
                if (!this.available[130 - 2 * this.nT]) {
                    this.outBorder[130 - 2 * this.nT] = this.firstValue;
                }
                int max = 2 * this.nT;
                for (int i2 = -2 * this.nT + 1; i2 <= max; ++i2) {
                    if (this.available[130 + i2]) continue;
                    this.outBorder[130 + i2] = this.outBorder[130 + i2 - 1];
                }
            }
        }
    }

    static void fillCandidates(HImg d2, Sps sps, int[] candModeList, int x2, int y2, int PUidx, boolean availableA, boolean availableB) {
        int candA = !availableA ? 1 : (d2.getPredMode(x2 - 1, y2) != 0 || d2.getPcmFlag(x2 - 1, y2) ? 1 : d2.getIntraPredModeAtIndex(PUidx - 1));
        int candB = !availableB ? 1 : (d2.getPredMode(x2, y2 - 1) != 0 || d2.getPcmFlag(x2, y2 - 1) ? 1 : (y2 - 1 < y2 >> sps.Log2CtbSizeY << sps.Log2CtbSizeY ? 1 : d2.getIntraPredModeAtIndex(PUidx - sps.PicWidthInMinPus)));
        IntraPred.fillCandidatesInternal(candModeList, candA, candB);
    }

    private static void fillCandidatesInternal(int[] candModeList, int candA, int candB) {
        if (candA == candB) {
            if (candA < 2) {
                candModeList[0] = 0;
                candModeList[1] = 1;
                candModeList[2] = 26;
            } else {
                candModeList[0] = candA;
                candModeList[1] = 2 + (candA - 2 - 1 + 32) % 32;
                candModeList[2] = 2 + (candA - 2 + 1) % 32;
            }
        } else {
            candModeList[0] = candA;
            candModeList[1] = candB;
            candModeList[2] = candA != 0 && candB != 0 ? 0 : (candA != 1 && candB != 1 ? 1 : 26);
        }
    }

    private static void doPlanar(int[] dst, int dstStride, int dstOffset, int nT, int[] b2) {
        int Log2_nT = HeicMath.log2(nT);
        for (int y2 = 0; y2 < nT; ++y2) {
            for (int x2 = 0; x2 < nT; ++x2) {
                dst[dstOffset + x2 + y2 * dstStride] = (nT - 1 - x2) * b2[129 - y2] + (x2 + 1) * b2[131 + nT] + (nT - 1 - y2) * b2[131 + x2] + (y2 + 1) * b2[129 - nT] + nT >> Log2_nT + 1;
            }
        }
    }

    private static void doDC(int[] dst, int dstStride, int dstOffset, int nT, int cIdx, int[] b2) {
        int x2;
        int Log2_nT = HeicMath.log2(nT);
        int dcVal = 0;
        for (int i2 = 0; i2 < nT; ++i2) {
            dcVal += b2[130 + i2 + 1];
            dcVal += b2[130 - i2 - 1];
        }
        dcVal += nT;
        dcVal >>= Log2_nT + 1;
        if (cIdx == 0 && nT < 32) {
            int y2;
            dst[dstOffset] = b2[129] + 2 * dcVal + b2[131] + 2 >> 2;
            for (x2 = 1; x2 < nT; ++x2) {
                dst[dstOffset + x2] = b2[130 + x2 + 1] + 3 * dcVal + 2 >> 2;
            }
            for (y2 = 1; y2 < nT; ++y2) {
                dst[dstOffset + y2 * dstStride] = b2[130 - y2 - 1] + 3 * dcVal + 2 >> 2;
            }
            for (y2 = 1; y2 < nT; ++y2) {
                for (x2 = 1; x2 < nT; ++x2) {
                    dst[dstOffset + x2 + y2 * dstStride] = dcVal;
                }
            }
        } else {
            for (int y3 = 0; y3 < nT; ++y3) {
                for (x2 = 0; x2 < nT; ++x2) {
                    dst[dstOffset + x2 + y3 * dstStride] = dcVal;
                }
            }
        }
    }

    private void doAngular(int[] dst, int dstStride, int planOffset, int bit_depth, boolean disableBoundary, int predMode, int nT, int cIdx, int[] b2) {
        block20: {
            int x2;
            int nT2;
            int angle;
            block19: {
                int y2;
                int x3;
                Arrays.fill(this.refAng, 0);
                angle = Type.INTRA_PRED_ANGLES[predMode];
                nT2 = nT << 1;
                if (predMode < 18) break block19;
                for (x3 = 0; x3 <= nT; ++x3) {
                    this.refAng[130 + x3] = b2[130 + x3];
                }
                if (angle < 0) {
                    int invAngle = Type.INV_ANGLES[predMode - 11];
                    if (nT * angle >> 5 < -1) {
                        for (x3 = nT * angle >> 5; x3 <= -1; ++x3) {
                            this.refAng[130 + x3] = b2[130 - (x3 * invAngle + 128 >> 8)];
                        }
                    }
                } else {
                    for (x3 = nT + 1; x3 <= nT2; ++x3) {
                        this.refAng[130 + x3] = b2[130 + x3];
                    }
                }
                for (y2 = 0; y2 < nT; ++y2) {
                    for (x3 = 0; x3 < nT; ++x3) {
                        int iIdx = (y2 + 1) * angle >> 5;
                        int iFact = (y2 + 1) * angle & 0x1F;
                        dst[planOffset + x3 + y2 * dstStride] = iFact != 0 ? (32 - iFact) * this.refAng[130 + x3 + iIdx + 1] + iFact * this.refAng[130 + x3 + iIdx + 2] + 16 >> 5 : this.refAng[130 + x3 + iIdx + 1];
                    }
                }
                if (predMode != 26 || cIdx != 0 || nT >= 32 || disableBoundary) break block20;
                for (y2 = 0; y2 < nT; ++y2) {
                    dst[planOffset + y2 * dstStride] = HeicMath.clipBitDepth(b2[131] + (b2[129 - y2] - b2[130] >> 1), bit_depth);
                }
                break block20;
            }
            for (x2 = 0; x2 <= nT; ++x2) {
                this.refAng[130 + x2] = b2[130 - x2];
            }
            if (angle < 0) {
                int invAngle = Type.INV_ANGLES[predMode - 11];
                if (nT * angle >> 5 < -1) {
                    for (x2 = nT * angle >> 5; x2 <= -1; ++x2) {
                        this.refAng[130 + x2] = b2[130 + (x2 * invAngle + 128 >> 8)];
                    }
                }
            } else {
                for (x2 = nT + 1; x2 <= nT2; ++x2) {
                    this.refAng[130 + x2] = b2[130 - x2];
                }
            }
            for (int y3 = 0; y3 < nT; ++y3) {
                for (x2 = 0; x2 < nT; ++x2) {
                    int iIdx = (x2 + 1) * angle >> 5;
                    int iFact = (x2 + 1) * angle & 0x1F;
                    dst[planOffset + x2 + y3 * dstStride] = iFact != 0 ? (32 - iFact) * this.refAng[130 + y3 + iIdx + 1] + iFact * this.refAng[130 + y3 + iIdx + 2] + 16 >> 5 : this.refAng[130 + y3 + iIdx + 1];
                }
            }
            if (predMode == 10 && cIdx == 0 && nT < 32 && !disableBoundary) {
                for (x2 = 0; x2 < nT; ++x2) {
                    dst[planOffset + x2] = HeicMath.clipBitDepth(b2[129] + (b2[131 + x2] - b2[130] >> 1), bit_depth);
                }
            }
        }
    }

    static int getIntraScanIdx(int log2TrafoSize, int predMode, int cIdx, int chromaType) {
        if (log2TrafoSize == 2 || log2TrafoSize == 3 && (cIdx == 0 || chromaType == 3)) {
            if (predMode >= 6 && predMode <= 14) {
                return 2;
            }
            if (predMode >= 22 && predMode <= 30) {
                return 1;
            }
        }
        return 0;
    }
}

