/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

final class HeicMath {
    private HeicMath() {
    }

    static int clip3(int x2, int y2, int z2) {
        return z2 < x2 ? x2 : Math.min(z2, y2);
    }

    static int clipBitDepth(int v2, int bitDepth) {
        int z2 = (1 << bitDepth) - 1;
        return Math.max(0, Math.min(v2, z2));
    }

    static int log2(int bits) {
        int log = 0;
        if ((bits & 0xFFFF0000) != 0) {
            bits >>>= 16;
            log = 16;
        }
        if (bits > 255) {
            bits >>>= 8;
            log += 8;
        }
        if (bits > 15) {
            bits >>>= 4;
            log += 4;
        }
        if (bits > 3) {
            bits >>>= 2;
            log += 2;
        }
        return log + (bits >>> 1);
    }

    static int log2Ceil(int val) {
        int n2 = 0;
        while (val > 1 << n2) {
            ++n2;
        }
        return n2;
    }

    static int ceilDiv(int num, int denom) {
        return (num + denom - 1) / denom;
    }
}

