/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Bitstream;
import com.idrsolutions.image.heic.common.Ctx;
import com.idrsolutions.image.heic.common.EContext;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.Nal;
import com.idrsolutions.image.heic.common.YuvDisplay;
import com.idrsolutions.image.metadata.Exif;
import com.idrsolutions.image.utility.Access;
import com.idrsolutions.image.utility.ByteWriter;
import com.idrsolutions.image.utility.DataByteBig;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.PixGet;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpedal.utils.LogWriter;

public final class HStruct {
    private HStruct() {
    }

    public static BufferedImage read(DataReader reader) throws IOException {
        IPCO ipco;
        BufferedImage auxlImage;
        HeifContext ctx = new HeifContext();
        ctx.read(reader);
        HeifImage hImage = ctx.primary_image;
        BufferedImage image = ctx.decodeImagePlanar(hImage.id);
        if (image == null) {
            int key;
            Iterator<Integer> iterator = ctx.all_images.keySet().iterator();
            while (iterator.hasNext() && (image = ctx.decodeImagePlanar(key = iterator.next().intValue())) == null) {
            }
        }
        if (image == null) {
            for (Box box : ctx.heif_file.topLevelBoxes) {
                if (box.hdr.short_type != 1835295092) continue;
                reader.moveTo(box.hdr.offset + box.hdr.header_size);
                byte[] data = new byte[(int)(box.hdr.box_size - (long)box.hdr.header_size)];
                reader.read(data);
                image = HeifContext.decodeHEVC(data);
            }
        }
        if (ctx.m_auxl_ID > -1 && (auxlImage = ctx.decodeImagePlanar(ctx.m_auxl_ID)) != null && (ipco = ctx.heif_file.ipcoBox) != null) {
            for (Box box : ipco.getChildren()) {
                if (box.hdr.short_type != 1635088451) continue;
                AUXC auxc = (AUXC)box;
                if (!"urn:mpeg:avc:2015:auxid:1".equals(auxc.aux_type) && !"urn:mpeg:hevc:2015:auxid:1".equals(auxc.aux_type)) continue;
                int iw = image.getWidth();
                int ih = image.getHeight();
                int dim = iw * ih;
                BufferedImage result = new BufferedImage(iw, ih, 6);
                byte[] rData = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[] aData = ((DataBufferByte)auxlImage.getRaster().getDataBuffer()).getData();
                byte[] iData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int r2 = 0;
                int i2 = 0;
                for (int j2 = 0; j2 < dim; ++j2) {
                    rData[r2++] = aData[j2 * (aData.length / dim)];
                    rData[r2++] = iData[i2++];
                    rData[r2++] = iData[i2++];
                    rData[r2++] = iData[i2++];
                }
                image = result;
                break;
            }
        }
        if (hImage != null && image != null && hImage.ispe_width != 0 && hImage.ispe_width != image.getWidth() && !ctx.isRotatedOrClapped) {
            image = HStruct.getCubicScaled(image, hImage.ispe_width, hImage.ispe_height);
        }
        return image;
    }

    private static BufferedImage getCubicScaled(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp scaleOP = new AffineTransformOp(scaleTransform, 3);
        return scaleOP.filter(image, new BufferedImage(width, height, image.getType()));
    }

    public static Rectangle readDimension(DataReader reader) throws IOException {
        Rectangle rect = new Rectangle();
        HeifContext ctx = new HeifContext();
        ctx.read(reader);
        HeifImage hImage = ctx.primary_image;
        if (hImage != null) {
            rect.width = hImage.ispe_width;
            rect.height = hImage.ispe_height;
            IPCO ipco_box = ctx.heif_file.ipcoBox;
            IPMA ipma_box = ctx.heif_file.ipmaBox;
            if (ipco_box != null && ipma_box != null) {
                List<Prop> props = ipco_box.get_properties_for_item_ID(ctx.primary_image.id, ipma_box);
                for (Prop prop : props) {
                    if (prop.property.hdr.short_type == 1769107316) {
                        IROT irot = (IROT)prop.property;
                        if (irot.rotation == 90 || irot.rotation == 270) {
                            int temp = rect.width;
                            rect.width = rect.height;
                            rect.height = temp;
                        }
                    }
                    if (prop.property.hdr.short_type != 1668047216) continue;
                    CLAP clap = (CLAP)prop.property;
                    rect.width = clap.getWidth();
                    rect.height = clap.getHeight();
                }
            }
        }
        return rect;
    }

    public static Exif readExif(DataReader reader) throws IOException {
        HeifContext ctx = new HeifContext();
        ctx.read(reader);
        return ctx.m_exif;
    }

    public static BufferedImage readThumbnail(DataReader reader) throws IOException {
        HeifContext ctx = new HeifContext();
        ctx.read(reader);
        if (ctx.m_thumbnail_ID > -1) {
            return ctx.decodeImagePlanar(ctx.m_thumbnail_ID);
        }
        if (ctx.m_exif != null && !ctx.m_exif.getIfdImages().isEmpty()) {
            return ctx.m_exif.getIfdImages().get(0);
        }
        if (ctx.primary_image.width < 257 && ctx.primary_image.height < 257) {
            return ctx.decodeImagePlanar(ctx.primary_image.id);
        }
        return null;
    }

    public static void write(BufferedImage bImg, ByteWriter writer) {
        HeifContext ctx = new HeifContext();
        ctx.encode_image(bImg);
        ctx.write(writer);
    }

    static BufferedImage doClap(BufferedImage img, CLAP clap) {
        int iw = img.getWidth();
        int ih = img.getHeight();
        int cw = clap.getWidth();
        int ch = clap.getHeight();
        int cx = clap.getLeft(iw);
        int cy = clap.getTop(ih);
        BufferedImage res = new BufferedImage(cw, ch, img.getType());
        PixGet pg = Access.getPixGet(img);
        for (int y2 = 0; y2 < ch; ++y2) {
            for (int x2 = 0; x2 < cw; ++x2) {
                int startX = cx + x2;
                int startY = cy + y2;
                if (startX < 0 || startY < 0 || !(startX < iw & startY < ih)) continue;
                res.setRGB(x2, y2, pg.getRGB(startX, startY));
            }
        }
        return res;
    }

    static String getTypeString(int v2) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)(v2 >> 24));
        sb.append((char)(v2 >> 16 & 0xFF));
        sb.append((char)(v2 >> 8 & 0xFF));
        sb.append((char)(v2 & 0xFF));
        return sb.toString();
    }

    private static class Overlay {
        final int[] bgColor = new int[4];
        int width;
        int height;
        Point[] offsets;

        private Overlay() {
        }

        void parse(int num_images, byte[] data) {
            int i2;
            byte flags = data[1];
            int field_len = (flags & 1) != 0 ? 4 : 2;
            int[] ptr = new int[]{2};
            for (i2 = 0; i2 < 4; ++i2) {
                int color;
                this.bgColor[i2] = color = Overlay.readUINT(data, ptr, 2);
            }
            this.width = Overlay.readUINT(data, ptr, field_len);
            this.height = Overlay.readUINT(data, ptr, field_len);
            this.offsets = new Point[num_images];
            for (i2 = 0; i2 < num_images; ++i2) {
                this.offsets[i2].x = Overlay.readINT(data, ptr, field_len);
                this.offsets[i2].y = Overlay.readINT(data, ptr, field_len);
            }
        }

        private static int readINT(byte[] data, int[] ptr, int len) {
            int high_bit = 128 << (len - 1) * 8;
            int val = 0;
            while (len-- != 0) {
                val <<= 8;
                val |= data[ptr[0]] & 0xFF;
                ptr[0] = ptr[0] + 1;
            }
            boolean negative = (val & high_bit) != 0;
            val &= ~high_bit;
            if (negative) {
                return -(high_bit - val);
            }
            return val;
        }

        private static int readUINT(byte[] data, int[] ptr, int len) {
            int val = 0;
            while (len-- != 0) {
                val <<= 8;
                val |= data[ptr[0]] & 0xFF;
                ptr[0] = ptr[0] + 1;
            }
            return val;
        }
    }

    private static class MetaData {
        int item_id;
        int item_type;
        String content_type;
        byte[] data;

        private MetaData() {
        }
    }

    private static class URL
    extends Box {
        URL(BoxHeader hdr) {
            super(hdr);
        }

        URL() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1970433056;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
        }
    }

    private static class CLAP
    extends Box {
        float widthN = 1.0f;
        float widthD = 1.0f;
        float heightN = 1.0f;
        float heightD = 1.0f;
        float horOffsetN;
        float horOffsetD = 1.0f;
        float verOffsetN;
        float verOffsetD = 1.0f;

        CLAP(BoxHeader hdr) {
            super(hdr);
        }

        CLAP() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1668047216;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.widthN = range.getU32();
            this.widthD = range.getU32();
            this.heightN = range.getU32();
            this.heightD = range.getU32();
            this.horOffsetN = range.getU32();
            this.horOffsetD = range.getU32();
            this.verOffsetN = range.getU32();
            this.verOffsetD = range.getU32();
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.putU32((int)this.widthN);
            writer.putU32((int)this.widthD);
            writer.putU32((int)this.heightN);
            writer.putU32((int)this.heightD);
            writer.putU32((int)this.horOffsetN);
            writer.putU32((int)this.horOffsetD);
            writer.putU32((int)this.verOffsetN);
            writer.putU32((int)this.verOffsetD);
            this.hdr.prepend_header(writer, box_start);
        }

        int getLeft(int iw) {
            float x2 = this.horOffsetN / this.horOffsetD + (float)((iw - 1) / 2);
            return (int)(x2 - (float)((this.getWidth() - 1) / 2));
        }

        int getTop(int ih) {
            float y2 = this.verOffsetN / this.verOffsetD + (float)((ih - 1) / 2);
            return (int)(y2 - (float)((this.getHeight() - 1) / 2));
        }

        int getWidth() {
            return Math.round(this.widthN / this.widthD);
        }

        int getHeight() {
            return Math.round(this.heightN / this.heightD);
        }
    }

    private static class DINF
    extends Box {
        DINF(BoxHeader hdr) {
            super(hdr);
        }
    }

    private static class GRPL
    extends Box {
        GRPL(BoxHeader hdr) {
            super(hdr);
        }
    }

    private static final class DREF
    extends Box {
        private DREF(BoxHeader hdr) {
            super(hdr);
        }

        private DREF() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1685218662;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            int nEntities = range.getU32();
            this.readChildren(range);
        }
    }

    private static final class IDAT
    extends Box {
        int data_start_pos;

        private IDAT(BoxHeader hdr) {
            super(hdr);
        }

        private IDAT() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768186228;
        }

        private void read_data(DataReader istr, long start, long length, ByteWriter out) throws IOException {
            istr.moveTo((int)((long)this.data_start_pos + start));
            byte[] temp = new byte[(int)length];
            istr.read(temp);
            out.write(temp);
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.data_start_pos = range.getPosition();
        }
    }

    private static class Reference {
        BoxHeader header = new BoxHeader();
        int from_item_ID;
        List<Integer> to_item_ID = new ArrayList<Integer>();

        private Reference() {
        }
    }

    private static final class IREF
    extends Box {
        private final List<Reference> m_references = new ArrayList<Reference>();

        private IREF(BoxHeader hdr) {
            super(hdr);
        }

        private IREF() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1769104742;
            this.hdr.is_full_box = true;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            int end = (int)((long)this.hdr.offset + this.hdr.box_size);
            while (range.getPosition() < end) {
                int i2;
                int nRefs;
                Reference ref = new Reference();
                ref.header.parse(range);
                if (this.hdr.version == 0) {
                    ref.from_item_ID = range.getU16();
                    nRefs = range.getU16();
                    for (i2 = 0; i2 < nRefs; ++i2) {
                        ref.to_item_ID.add(range.getU16());
                        if (range.getPosition() < end) {
                            continue;
                        }
                        break;
                    }
                } else {
                    ref.from_item_ID = range.getU32();
                    nRefs = range.getU16();
                    for (i2 = 0; i2 < nRefs; ++i2) {
                        ref.to_item_ID.add(range.getU32());
                        if (range.getPosition() < end) {
                            continue;
                        }
                        break;
                    }
                }
                this.m_references.add(ref);
            }
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            int id_size = this.hdr.version == 0 ? 2 : 4;
            for (Reference ref : this.m_references) {
                int box_size = 10 + id_size * (1 + ref.to_item_ID.size());
                writer.putU32(box_size);
                writer.putU32(ref.header.short_type);
                if (id_size == 2) {
                    writer.putU16(ref.from_item_ID);
                } else {
                    writer.putU32(ref.from_item_ID);
                }
                writer.putU16(ref.to_item_ID.size());
                for (int r2 : ref.to_item_ID) {
                    if (id_size == 2) {
                        writer.putU16(r2);
                        continue;
                    }
                    writer.putU32(r2);
                }
            }
            this.hdr.prepend_header(writer, box_start);
        }

        @Override
        void derive_box_version() {
            byte version = 0;
            block0: for (Reference ref : this.m_references) {
                if (ref.from_item_ID > 65535) {
                    version = 1;
                    break;
                }
                for (int r2 : ref.to_item_ID) {
                    if (r2 <= 65535) continue;
                    version = 1;
                    continue block0;
                }
            }
            this.hdr.version = version;
        }

        List<Reference> get_references_from(int itemID) {
            ArrayList<Reference> references = new ArrayList<Reference>();
            for (Reference ref : this.m_references) {
                if (ref.from_item_ID != itemID) continue;
                references.add(ref);
            }
            return references;
        }

        List<Integer> get_references(int itemID, int ref_type) {
            for (Reference ref : this.m_references) {
                if (ref.from_item_ID != itemID || ref.header.short_type != ref_type) continue;
                return ref.to_item_ID;
            }
            ArrayList<Integer> temp = new ArrayList<Integer>();
            return temp;
        }

        void add_reference(int from_id, int type, List<Integer> to_ids) {
            Reference ref = new Reference();
            ref.header.short_type = type;
            ref.from_item_ID = from_id;
            ref.to_item_ID = to_ids;
            this.m_references.add(ref);
        }
    }

    private static final class IMIR
    extends Box {
        int mirror;

        private IMIR(BoxHeader hdr) {
            super(hdr);
        }

        private IMIR() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768778098;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.mirror = range.getU8();
        }
    }

    private static final class IROT
    extends Box {
        int rotation;

        private IROT(BoxHeader hdr) {
            super(hdr);
        }

        private IROT() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1769107316;
        }

        @Override
        void parse(DataReader range) throws IOException {
            int rotation = range.getU8();
            this.rotation = (rotation &= 3) * 90;
        }
    }

    private static final class AUXC
    extends Box {
        String aux_type = "";
        List<Integer> aux_subtypes = new ArrayList<Integer>();

        private AUXC(BoxHeader hdr) {
            super(hdr);
        }

        private AUXC() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1635088451;
            this.hdr.is_full_box = true;
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.writeNullString(this.aux_type);
            for (int subtype : this.aux_subtypes) {
                writer.putByte((byte)subtype);
            }
            this.hdr.prepend_header(writer, box_start);
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            this.aux_type = this.readNameString(range);
            int end = (int)((long)this.hdr.offset + this.hdr.box_size);
            while (range.getPosition() < end) {
                this.aux_subtypes.add(range.getU8());
            }
        }
    }

    private static final class PIXI
    extends Box {
        byte[] bits_per_channel;

        private PIXI(BoxHeader hdr) {
            super(hdr);
        }

        private PIXI() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1885960297;
            this.hdr.is_full_box = true;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            int nc = range.getU8();
            this.bits_per_channel = new byte[nc];
            range.read(this.bits_per_channel);
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.putByte((byte)this.bits_per_channel.length);
            for (int i2 = 0; i2 < this.bits_per_channel.length; ++i2) {
                writer.putByte(this.bits_per_channel[i2]);
            }
            this.hdr.prepend_header(writer, box_start);
        }

        int get_num_channels() {
            return this.bits_per_channel.length;
        }

        int get_bits_per_channel(int channel) {
            return this.bits_per_channel[channel] & 0xFF;
        }
    }

    static interface ColorProfile {
        public int getType();

        public void write(ByteWriter var1);

        public void parse(DataReader var1) throws IOException;
    }

    private static class ColorProfileNCLX
    implements ColorProfile {
        int m_colour_primaries;
        int m_transfer_characteristics;
        int m_matrix_coefficients;
        boolean m_full_range_flag = true;

        private ColorProfileNCLX() {
        }

        @Override
        public int getType() {
            return 1852009592;
        }

        @Override
        public void write(ByteWriter writer) {
            writer.putU16(this.m_colour_primaries);
            writer.putU16(this.m_transfer_characteristics);
            writer.putU16(this.m_matrix_coefficients);
            writer.putByte((byte)(this.m_full_range_flag ? 128 : 0));
        }

        @Override
        public void parse(DataReader range) throws IOException {
            this.m_colour_primaries = range.getU16();
            this.m_transfer_characteristics = range.getU16();
            this.m_matrix_coefficients = range.getU16();
            this.m_full_range_flag = (range.getU8() & 0x80) != 0;
        }
    }

    private static final class ColorProfileRaw
    implements ColorProfile {
        int m_type;
        byte[] m_data;

        private ColorProfileRaw(int color_type, byte[] rawData) {
            this.m_type = color_type;
            this.m_data = rawData;
        }

        @Override
        public int getType() {
            return this.m_type;
        }

        byte[] getData() {
            return this.m_data;
        }

        @Override
        public void write(ByteWriter writer) {
            writer.write(this.m_data);
        }

        @Override
        public void parse(DataReader range) {
        }
    }

    private static final class COLR
    extends Box {
        private ColorProfile m_color_profile;

        private COLR(BoxHeader hdr) {
            super(hdr);
        }

        private COLR() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1668246642;
        }

        @Override
        void parse(DataReader range) throws IOException {
            int colour_type = range.getU32();
            if (colour_type == 1852009592) {
                this.m_color_profile = new ColorProfileNCLX();
                this.m_color_profile.parse(range);
            } else if (colour_type == 1886547814 || colour_type == 1917403971) {
                int profile_size = (int)(this.hdr.box_size - (long)this.hdr.header_size - 4L);
                byte[] rawData = new byte[profile_size];
                for (int i2 = 0; i2 < profile_size; ++i2) {
                    rawData[i2] = (byte)range.getU8();
                }
                this.m_color_profile = new ColorProfileRaw(colour_type, rawData);
            }
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.putU32(this.m_color_profile.getType());
            this.m_color_profile.write(writer);
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static class Entry {
        int item_ID;
        List<Prop> associations = new ArrayList<Prop>();

        private Entry() {
        }
    }

    private static class Prop {
        boolean essential;
        int index;
        Box property;

        private Prop() {
        }
    }

    private static final class IPMA
    extends Box {
        List<Entry> entries = new ArrayList<Entry>();

        private IPMA(BoxHeader hdr) {
            super(hdr);
        }

        private IPMA() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768975713;
            this.hdr.is_full_box = true;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            int entry_cnt = range.getU32();
            for (int i2 = 0; i2 < entry_cnt; ++i2) {
                Entry entry = new Entry();
                entry.item_ID = this.hdr.version < 1 ? range.getU16() : range.getU32();
                int assoc_cnt = range.getU8();
                for (int k2 = 0; k2 < assoc_cnt; ++k2) {
                    int index;
                    Prop association = new Prop();
                    if ((this.hdr.flags & 1) != 0) {
                        index = range.getU16();
                        association.essential = (index & 0x8000) != 0;
                        association.index = index & Short.MAX_VALUE;
                    } else {
                        index = range.getU8();
                        association.essential = (index & 0x80) != 0;
                        association.index = index & 0x7F;
                    }
                    entry.associations.add(association);
                }
                this.entries.add(entry);
            }
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            int entry_cnt = this.entries.size();
            writer.putU32(entry_cnt);
            for (Entry entry : this.entries) {
                if (this.hdr.version < 1) {
                    writer.putU16(entry.item_ID);
                } else {
                    writer.putU32(entry.item_ID);
                }
                int assoc_cnt = entry.associations.size();
                writer.putU8(assoc_cnt);
                for (Prop association : entry.associations) {
                    if ((this.hdr.flags & 1) != 0) {
                        writer.putU16((association.essential ? 32768 : 0) | association.index & Short.MAX_VALUE);
                        continue;
                    }
                    writer.putByte((byte)((association.essential ? 128 : 0) | association.index & 0x7F));
                }
            }
            this.hdr.prepend_header(writer, box_start);
        }

        List<Prop> get_properties_for_item_ID(int itemID) {
            for (Entry entry : this.entries) {
                if (entry.item_ID != itemID) continue;
                return entry.associations;
            }
            return null;
        }

        void add_property_for_item_ID(int itemID, Prop assoc) {
            int idx;
            for (idx = 0; idx < this.entries.size() && this.entries.get((int)idx).item_ID != itemID; ++idx) {
            }
            if (idx == this.entries.size()) {
                Entry entry = new Entry();
                entry.item_ID = itemID;
                this.entries.add(entry);
            }
            this.entries.get((int)idx).associations.add(assoc);
        }

        @Override
        void derive_box_version() {
            boolean version = false;
            boolean large_property_indices = false;
            for (Entry entry : this.entries) {
                if (entry.item_ID > 65535) {
                    version = true;
                }
                for (Prop assoc : entry.associations) {
                    if (assoc.index <= 127) continue;
                    large_property_indices = true;
                }
            }
            this.hdr.version = (byte)(version ? 1 : 0);
            this.hdr.flags = large_property_indices ? 1 : 0;
        }
    }

    private static final class ISPE
    extends Box {
        int image_width;
        int image_height;

        private ISPE(BoxHeader hdr) {
            super(hdr);
        }

        private ISPE() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1769173093;
            this.hdr.is_full_box = true;
        }

        void set_size(int w2, int h2) {
            this.image_width = w2;
            this.image_height = h2;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            this.image_width = range.getU32();
            this.image_height = range.getU32();
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.putU32(this.image_width);
            writer.putU32(this.image_height);
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static final class IPCO
    extends Box {
        private IPCO(BoxHeader hdr) {
            super(hdr);
        }

        private IPCO() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768973167;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.readChildren(range);
        }

        Box get_property_for_item_ID(int itemID, IPMA ipma, int boxType) {
            List<Prop> propAssocs = ipma.get_properties_for_item_ID(itemID);
            if (propAssocs == null) {
                return null;
            }
            List<Box> allProps = this.getChildren();
            for (Prop assoc : propAssocs) {
                if (assoc.index > allProps.size()) {
                    return null;
                }
                int lookup = assoc.index - 1;
                if (lookup < 0) continue;
                Box property = allProps.get(assoc.index - 1);
                if (property.hdr.short_type != boxType) continue;
                return property;
            }
            return null;
        }

        List<Prop> get_properties_for_item_ID(int itemID, IPMA ipma) {
            ArrayList<Prop> out = new ArrayList<Prop>();
            List<Prop> propAssocs = ipma.get_properties_for_item_ID(itemID);
            if (propAssocs == null) {
                return out;
            }
            List<Box> allProps = this.getChildren();
            for (Prop assoc : propAssocs) {
                if (assoc.index > allProps.size()) {
                    return out;
                }
                Prop prop = new Prop();
                prop.essential = assoc.essential;
                if (assoc.index <= 0) continue;
                prop.property = allProps.get(assoc.index - 1);
                out.add(prop);
            }
            return out;
        }
    }

    private static final class IPRP
    extends Box {
        private IPRP(BoxHeader hdr) {
            super(hdr);
        }

        private IPRP() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768977008;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.readChildren(range);
        }
    }

    private static final class IINF
    extends Box {
        private IINF(BoxHeader hdr) {
            super(hdr);
        }

        private IINF() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 0x69696E66;
            this.hdr.is_full_box = true;
        }

        @Override
        void parse(DataReader range) throws IOException {
            int item_count;
            this.hdr.parse_full_box_header(range);
            int nEntries_size = this.hdr.version > 0 ? 4 : 2;
            int n2 = item_count = nEntries_size == 2 ? range.getU16() : range.getU32();
            if (item_count != 0) {
                this.readChildren(range);
            }
        }

        @Override
        void write(ByteWriter writer) {
            int entrySize;
            int box_start = this.hdr.reserve_box_header_space(writer);
            int n2 = entrySize = this.hdr.version > 0 ? 4 : 2;
            if (entrySize == 4) {
                writer.putU32(this.m_children.size());
            } else {
                writer.putU16(this.m_children.size());
            }
            this.writeChildren(writer);
            this.hdr.prepend_header(writer, box_start);
        }

        @Override
        void derive_box_version() {
            this.hdr.version = (byte)(this.m_children.size() > 65535 ? 1 : 0);
        }
    }

    private static final class INFE
    extends Box {
        int item_ID;
        int item_protection_index;
        String item_name;
        String content_type;
        String content_encoding;
        int item_type = 1752589105;
        String item_uri_type;
        boolean hidden_item;

        private INFE(BoxHeader hdr) {
            super(hdr);
        }

        private INFE() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768842853;
            this.hdr.is_full_box = true;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            if (this.hdr.version <= 1) {
                this.item_ID = range.getU16();
                this.item_protection_index = range.getU16();
                this.item_name = this.readNameString(range);
                this.content_type = this.readNameString(range);
                this.content_encoding = this.readNameString(range);
            }
            if (this.hdr.version >= 2) {
                this.hidden_item = (this.hdr.flags & 1) != 0;
                this.item_ID = this.hdr.version == 2 ? range.getU16() : range.getU32();
                this.item_protection_index = range.getU16();
                this.item_type = range.getU32();
                this.item_name = this.readNameString(range);
                if (this.item_type == 1835625829) {
                    this.content_type = this.readNameString(range);
                    this.content_encoding = this.readNameString(range);
                } else if (this.item_type == 1970432288) {
                    this.item_uri_type = this.readNameString(range);
                }
            }
        }

        @Override
        void derive_box_version() {
            int min_version = 0;
            if (this.hidden_item) {
                min_version = Math.max(min_version, 2);
            }
            if (this.item_ID > 65535) {
                min_version = Math.max(min_version, 3);
            }
            if (this.item_type != 0) {
                min_version = Math.max(min_version, 2);
            }
            this.hdr.version = (byte)min_version;
        }

        void set_hidden_item(boolean hidden) {
            this.hidden_item = hidden;
            this.hdr.flags = this.hidden_item ? (this.hdr.flags |= 1) : (this.hdr.flags &= 0xFFFFFFFE);
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            if (this.hdr.version <= 1) {
                writer.putU16(this.item_ID);
                writer.putU16(this.item_protection_index);
                writer.writeNullString(this.item_name);
                writer.writeNullString(this.content_type);
                writer.writeNullString(this.content_encoding);
            }
            if (this.hdr.version >= 2) {
                if (this.hdr.version == 2) {
                    writer.putU16(this.item_ID);
                } else if (this.hdr.version == 3) {
                    writer.putU32(this.item_ID);
                }
                writer.putU16(this.item_protection_index);
                writer.putU32(this.item_type);
                writer.writeNullString(this.item_name);
                if (this.item_type == 1835625829) {
                    writer.writeNullString(this.content_type);
                    writer.writeNullString(this.content_encoding);
                } else if (this.item_type == 1970432288) {
                    writer.writeNullString(this.item_uri_type);
                }
            }
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static class Item {
        int item_ID;
        int construction_method;
        int data_reference_index;
        long base_offset;
        List<Extent> extents = new ArrayList<Extent>();

        private Item() {
        }
    }

    private static class Extent {
        long index;
        long offset;
        long length;
        byte[] data;
        int imageSize;

        private Extent() {
        }
    }

    private static final class ILOC
    extends Box {
        List<Item> m_items = new ArrayList<Item>();
        int m_iloc_box_start;
        byte m_user_defined_min_version;
        int m_offset_size = 4;
        int m_length_size = 4;
        int m_base_offset_size = 4;
        int m_index_size;

        private ILOC() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1768714083;
            this.hdr.is_full_box = true;
        }

        private ILOC(BoxHeader hdr) {
            super(hdr);
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            int values4 = range.getU16();
            int offset_size = values4 >> 12 & 0xF;
            int length_size = values4 >> 8 & 0xF;
            int base_offset_size = values4 >> 4 & 0xF;
            int index_size = this.hdr.version > 1 ? values4 & 0xF : 0;
            int item_count = this.hdr.version < 2 ? range.getU16() : range.getU32();
            for (int i2 = 0; i2 < item_count; ++i2) {
                Item item = new Item();
                item.item_ID = this.hdr.version < 2 ? range.getU16() : range.getU32();
                if (this.hdr.version >= 1) {
                    values4 = range.getU16();
                    item.construction_method = values4 & 0xF;
                }
                item.data_reference_index = range.getU16();
                item.base_offset = 0L;
                if (base_offset_size == 4) {
                    item.base_offset = range.getU32();
                } else if (base_offset_size == 8) {
                    item.base_offset = (long)range.getU32() * 1L << 32;
                    item.base_offset |= (long)range.getU32();
                }
                int extent_count = range.getU16();
                for (int e2 = 0; e2 < extent_count; ++e2) {
                    Extent extent = new Extent();
                    if (this.hdr.version > 1 && index_size > 0) {
                        if (index_size == 4) {
                            extent.index = range.getU32();
                        } else if (index_size == 8) {
                            extent.index = (long)range.getU32() * 1L << 32;
                            extent.index |= (long)range.getU32();
                        }
                    }
                    extent.offset = 0L;
                    if (offset_size == 4) {
                        extent.offset = range.getU32();
                    } else if (offset_size == 8) {
                        extent.offset = (long)range.getU32() * 1L << 32;
                        extent.offset |= (long)range.getU32();
                    }
                    extent.length = 0L;
                    if (length_size == 4) {
                        extent.length = range.getU32();
                    } else if (length_size == 8) {
                        extent.length = (long)range.getU32() * 1L << 32;
                        extent.length |= (long)range.getU32();
                    }
                    item.extents.add(extent);
                }
                this.m_items.add(item);
            }
        }

        static void readData(Item item, DataReader istr, IDAT idat, ByteWriter dest) throws IOException {
            for (Extent extent : item.extents) {
                if (item.construction_method == 0) {
                    istr.moveTo((int)(extent.offset + item.base_offset));
                    byte[] temp = new byte[(int)extent.length];
                    istr.read(temp);
                    dest.write(temp);
                    continue;
                }
                if (item.construction_method != 1) continue;
                idat.read_data(istr, extent.offset + item.base_offset, extent.length, dest);
            }
        }

        void appendData(int item_ID, byte[] data, int const_method, int imageSize) {
            int idx;
            for (idx = 0; idx < this.m_items.size() && this.m_items.get((int)idx).item_ID != item_ID; ++idx) {
            }
            if (idx == this.m_items.size()) {
                Item item = new Item();
                item.item_ID = item_ID;
                item.construction_method = const_method;
                this.m_items.add(item);
            }
            Extent extent = new Extent();
            extent.data = data;
            if (imageSize > 0) {
                extent.imageSize = imageSize;
            }
            this.m_items.get((int)idx).extents.add(extent);
        }

        @Override
        void derive_box_version() {
            byte min_version = this.m_user_defined_min_version;
            this.m_offset_size = 0;
            this.m_length_size = 0;
            this.m_base_offset_size = 0;
            this.m_index_size = 0;
            for (Item item : this.m_items) {
                if (item.item_ID > 65535) {
                    min_version = (byte)Math.max(min_version, 2);
                }
                if (item.construction_method == 0) continue;
                min_version = (byte)Math.max(min_version, 1);
            }
            this.m_offset_size = 4;
            this.m_length_size = 4;
            this.m_base_offset_size = 4;
            this.m_index_size = 4;
            this.hdr.version = min_version;
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            this.m_iloc_box_start = writer.bp;
            int nSkip = 0;
            nSkip += 2;
            nSkip += this.hdr.version < 2 ? 2 : 4;
            for (Item item : this.m_items) {
                nSkip += this.hdr.version < 2 ? 2 : 4;
                nSkip += this.hdr.version >= 1 ? 2 : 0;
                nSkip += 4 + this.m_base_offset_size;
                for (Extent extent : item.extents) {
                    if (this.hdr.version >= 1) {
                        nSkip += this.m_index_size;
                    }
                    nSkip += this.m_offset_size + this.m_length_size;
                }
            }
            writer.write(new byte[nSkip]);
            this.hdr.prepend_header(writer, box_start);
        }

        void write_mdat_after_iloc(ByteWriter writer) {
            int sum_mdat_size = 0;
            for (Item item : this.m_items) {
                if (item.construction_method != 0) continue;
                for (Extent extent : item.extents) {
                    if (extent.imageSize > 0) {
                        sum_mdat_size += extent.imageSize + 4;
                        continue;
                    }
                    sum_mdat_size += extent.data.length;
                }
            }
            writer.putU32(sum_mdat_size + 8);
            writer.putU32(1835295092);
            for (Item item : this.m_items) {
                item.base_offset = writer.bp;
                for (Extent extent : item.extents) {
                    extent.offset = (long)writer.bp - item.base_offset;
                    if (extent.imageSize > 0) {
                        extent.length = extent.imageSize + 4;
                        int size = extent.imageSize;
                        byte[] nal = new byte[]{(byte)(size >> 24 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size & 0xFF)};
                        writer.write(nal);
                        writer.write(extent.data);
                        continue;
                    }
                    extent.length = extent.data.length;
                    writer.write(extent.data);
                }
            }
            this.patch_iloc_header(writer);
        }

        private void patch_iloc_header(ByteWriter writer) {
            int old_pos = writer.bp;
            writer.bp = this.m_iloc_box_start;
            writer.putU8(this.m_offset_size << 4 | this.m_length_size);
            writer.putU8(this.m_base_offset_size << 4 | this.m_index_size);
            if (this.hdr.version < 2) {
                writer.putU16(this.m_items.size());
            } else {
                writer.putU32(this.m_items.size());
            }
            for (Item item : this.m_items) {
                if (this.hdr.version < 2) {
                    writer.putU16(item.item_ID);
                } else {
                    writer.putU32(item.item_ID);
                }
                if (this.hdr.version >= 1) {
                    writer.putU16(item.construction_method);
                }
                writer.putU16(item.data_reference_index);
                if (this.m_base_offset_size == 4) {
                    writer.putU32((int)item.base_offset);
                } else {
                    writer.putU64(item.base_offset);
                }
                writer.putU16(item.extents.size());
                for (Extent extent : item.extents) {
                    if (this.hdr.version >= 1 && this.m_index_size > 0) {
                        if (this.m_index_size == 4) {
                            writer.putU32((int)extent.index);
                        } else {
                            writer.putU64(extent.index);
                        }
                    }
                    if (this.m_offset_size == 4) {
                        writer.putU32((int)extent.offset);
                    } else {
                        writer.putU64(extent.offset);
                    }
                    if (this.m_length_size == 4) {
                        writer.putU32((int)extent.length);
                        continue;
                    }
                    writer.putU64(extent.length);
                }
            }
            writer.bp = old_pos;
        }
    }

    private static final class PITM
    extends Box {
        int item_ID = 1;

        private PITM() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1885959277;
            this.hdr.is_full_box = true;
        }

        private PITM(BoxHeader hdr) {
            super(hdr);
        }

        @Override
        void derive_box_version() {
            this.hdr.version = this.item_ID <= 65535 ? (byte)0 : 1;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            this.item_ID = this.hdr.version == 0 ? range.getU16() : range.getU32();
        }

        @Override
        void write(ByteWriter writer) {
            int boxStart = this.hdr.reserve_box_header_space(writer);
            if (this.hdr.version == 0) {
                writer.putU16(this.item_ID);
            } else {
                writer.putU32(this.item_ID);
            }
            this.hdr.prepend_header(writer, boxStart);
        }
    }

    private static final class HDLR
    extends Box {
        int handler_type = 1885954932;
        int pre_defined;
        String name = "";

        private HDLR() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1751411826;
            this.hdr.is_full_box = true;
        }

        private HDLR(BoxHeader hdr) {
            super(hdr);
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            this.pre_defined = range.getU32();
            this.handler_type = range.getU32();
            range.skip(12);
            this.name = this.readNameString(range);
        }

        @Override
        void write(ByteWriter writer) {
            int boxStart = this.hdr.reserve_box_header_space(writer);
            writer.putU32(this.pre_defined);
            writer.putU32(this.handler_type);
            for (int i2 = 0; i2 < 3; ++i2) {
                writer.putU32(0);
            }
            writer.writeNullString(this.name);
            this.hdr.prepend_header(writer, boxStart);
        }
    }

    private static final class PASP
    extends Box {
        int hSpacing;
        int vSpacing;

        private PASP(BoxHeader hdr) {
            super(hdr);
        }

        private PASP() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1885434736;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hSpacing = range.getU32();
            this.vSpacing = range.getU32();
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.putU32(this.hSpacing);
            writer.putU32(this.vSpacing);
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static final class MOOV
    extends Box {
        int offset;

        private MOOV(BoxHeader hdr) {
            super(hdr);
        }

        private MOOV() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1835295092;
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.readChildren(range);
        }
    }

    private static final class META
    extends Box {
        private META() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1835365473;
            this.hdr.is_full_box = true;
        }

        private META(BoxHeader hdr) {
            super(hdr);
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.hdr.parse_full_box_header(range);
            this.readChildren(range);
        }
    }

    private static final class FTYP
    extends Box {
        int major_brand;
        int minor_version;
        int[] compatible_brands;

        private FTYP() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1718909296;
        }

        private FTYP(BoxHeader hdr) {
            super(hdr);
        }

        boolean has_compatible_brand(int brand) {
            for (int c2 : this.compatible_brands) {
                if (brand != c2) continue;
                return true;
            }
            return false;
        }

        void add_compatible_brand(int brand) {
            if (this.compatible_brands == null) {
                this.compatible_brands = new int[1];
                this.compatible_brands[0] = brand;
            } else {
                int[] temp = new int[this.compatible_brands.length + 1];
                System.arraycopy(this.compatible_brands, 0, temp, 0, this.compatible_brands.length);
                temp[this.compatible_brands.length] = brand;
                this.compatible_brands = temp;
            }
        }

        @Override
        void parse(DataReader range) throws IOException {
            this.major_brand = range.getU32();
            this.minor_version = range.getU32();
            int nn = (int)((this.hdr.box_size - (long)this.hdr.header_size - 8L) / 4L);
            this.compatible_brands = new int[nn];
            for (int i2 = 0; i2 < nn; ++i2) {
                this.compatible_brands[i2] = range.getU32();
            }
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            writer.putU32(this.major_brand);
            writer.putU32(this.minor_version);
            for (int b2 : this.compatible_brands) {
                writer.putU32(b2);
            }
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static class ConfigAV1C {
        int version = 1;
        int seq_profile;
        int seq_level_idx_0;
        int seq_tier_0;
        int high_bitdepth;
        int twelve_bit;
        int monochrome;
        int chroma_subsampling_x;
        int chroma_subsampling_y;
        int chroma_sample_position;
        int initial_presentation_delay_present;
        int initial_presentation_delay_minus_one;

        private ConfigAV1C() {
        }
    }

    private static class ConfigHVCC {
        int configuration_version;
        int general_profile_space;
        int general_tier_flag;
        int general_profile_idc;
        int general_profile_compatibility_flags;
        int[] general_constraint_indicator_flags = new int[56];
        int general_level_idc;
        int min_spatial_segmentation_idc;
        int parallelism_type;
        int chroma_format;
        int bit_depth_luma;
        int bit_depth_chroma;
        int avg_frame_rate;
        int constant_frame_rate;
        int num_temporal_layers;
        int temporal_id_nested;
        int[] array_completeness;
        int[] NAL_unit_type;
        int[] numNalus;

        private ConfigHVCC() {
        }
    }

    private static class NalArray {
        int m_array_completeness;
        int m_nal_unit_type;
        List<byte[]> m_nal_units = new ArrayList<byte[]>();

        private NalArray() {
        }
    }

    private static class AV1C
    extends Box {
        ConfigAV1C m_configuration = new ConfigAV1C();

        AV1C(BoxHeader hdr) {
            super(hdr);
        }

        private AV1C() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1635135811;
        }

        @Override
        void parse(DataReader range) throws IOException {
            ConfigAV1C c2 = this.m_configuration;
            int bb2 = range.getU8();
            c2.version = bb2 & 0x7F;
            bb2 = range.getU8();
            c2.seq_profile = bb2 >> 5 & 7;
            c2.seq_level_idx_0 = bb2 & 0x1F;
            bb2 = range.getU8();
            c2.seq_tier_0 = bb2 >> 7 & 1;
            c2.high_bitdepth = bb2 >> 6 & 1;
            c2.twelve_bit = bb2 >> 5 & 1;
            c2.monochrome = bb2 >> 4 & 1;
            c2.chroma_subsampling_x = bb2 >> 3 & 1;
            c2.chroma_subsampling_y = bb2 >> 2 & 1;
            c2.chroma_sample_position = bb2 & 3;
            bb2 = range.getU8();
            c2.initial_presentation_delay_present = bb2 >> 4 & 1;
            if (c2.initial_presentation_delay_present != 0) {
                c2.initial_presentation_delay_minus_one = bb2 & 0xF;
            }
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            ConfigAV1C c2 = this.m_configuration;
            writer.putU8(c2.version | 0x80);
            writer.putU8((c2.seq_profile & 7) << 5 | c2.seq_level_idx_0 & 0x1F);
            writer.putU8((c2.seq_tier_0 != 0 ? 128 : 0) | (c2.high_bitdepth != 0 ? 64 : 0) | (c2.twelve_bit != 0 ? 32 : 0) | (c2.monochrome != 0 ? 16 : 0) | (c2.chroma_subsampling_x != 0 ? 8 : 0) | (c2.chroma_subsampling_y != 0 ? 4 : 0) | c2.chroma_sample_position & 3);
            writer.putU8(0);
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static final class HVCC
    extends Box {
        private ConfigHVCC m_configuration = new ConfigHVCC();
        int m_length_size = 4;
        List<NalArray> m_nal_array = new ArrayList<NalArray>();

        private HVCC(BoxHeader hdr) {
            super(hdr);
        }

        private HVCC() {
            this.hdr = new BoxHeader();
            this.hdr.short_type = 1752589123;
        }

        @Override
        void parse(DataReader range) throws IOException {
            ConfigHVCC c2 = this.m_configuration;
            c2.configuration_version = range.getU8();
            int bb2 = range.getU8();
            c2.general_profile_space = bb2 >> 6 & 3;
            c2.general_tier_flag = bb2 >> 5 & 1;
            c2.general_profile_idc = bb2 & 0x1F;
            c2.general_profile_compatibility_flags = range.getU32();
            for (int i2 = 0; i2 < 6; ++i2) {
                bb2 = range.getU8();
                for (int b2 = 0; b2 < 8; ++b2) {
                    c2.general_constraint_indicator_flags[i2 * 8 + b2] = bb2 >> 7 - b2 & 1;
                }
            }
            c2.general_level_idc = range.getU8();
            c2.min_spatial_segmentation_idc = range.getU16() & 0xFFF;
            c2.parallelism_type = range.getU8() & 3;
            c2.chroma_format = range.getU8() & 3;
            c2.bit_depth_luma = (range.getU8() & 7) + 8;
            c2.bit_depth_chroma = (range.getU8() & 7) + 8;
            c2.avg_frame_rate = range.getU16();
            bb2 = range.getU8();
            c2.constant_frame_rate = bb2 >> 6 & 3;
            c2.num_temporal_layers = bb2 >> 3 & 7;
            c2.temporal_id_nested = bb2 >> 2 & 1;
            this.m_length_size = (bb2 & 3) + 1 & 0xFF;
            int nArrays = range.getU8();
            for (int i3 = 0; i3 < nArrays; ++i3) {
                bb2 = range.getU8();
                NalArray array = new NalArray();
                array.m_array_completeness = bb2 >> 6 & 1;
                array.m_nal_unit_type = bb2 & 0x3F;
                int nUnits = range.getU16();
                for (int u2 = 0; u2 < nUnits; ++u2) {
                    int size = range.getU16();
                    if (size == 0) continue;
                    byte[] nalUnit = new byte[size];
                    range.read(nalUnit);
                    array.m_nal_units.add(nalUnit);
                }
                this.m_nal_array.add(array);
            }
        }

        @Override
        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            ConfigHVCC c2 = this.m_configuration;
            writer.putU8(c2.configuration_version);
            writer.putU8((c2.general_profile_space & 3) << 6 | (c2.general_tier_flag & 1) << 5 | c2.general_profile_idc & 0x1F);
            writer.putU32(c2.general_profile_compatibility_flags);
            for (int i2 = 0; i2 < 6; ++i2) {
                int bb2 = 0;
                for (int b2 = 0; b2 < 8; ++b2) {
                    if (c2.general_constraint_indicator_flags[i2 * 8 + b2] != 0) {
                        bb2 |= 1;
                    }
                    bb2 = bb2 << 1 & 0xFF;
                }
                writer.putU8(bb2);
            }
            writer.putU8(c2.general_level_idc);
            writer.putU16(c2.min_spatial_segmentation_idc & 0xFFF | 0xF000);
            writer.putU8(c2.parallelism_type | 0xFC);
            writer.putU8(c2.chroma_format | 0xFC);
            writer.putU8(c2.bit_depth_luma - 8 | 0xF8);
            writer.putU8(c2.bit_depth_chroma - 8 | 0xF8);
            writer.putU16(c2.avg_frame_rate);
            writer.putU8((c2.constant_frame_rate & 3) << 6 | (c2.num_temporal_layers & 7) << 3 | (c2.temporal_id_nested & 1) << 2 | this.m_length_size - 1 & 3);
            int nArrays = this.m_nal_array.size();
            writer.putU8(nArrays);
            for (NalArray array : this.m_nal_array) {
                writer.putU8((array.m_array_completeness & 1) << 6 | array.m_nal_unit_type & 0x3F);
                int nUnits = array.m_nal_units.size();
                writer.putU16(nUnits);
                for (byte[] nal_unit : array.m_nal_units) {
                    writer.putU16(nal_unit.length);
                    writer.write(nal_unit);
                }
            }
            this.hdr.prepend_header(writer, box_start);
        }

        void set_configuration(ConfigHVCC config) {
            this.m_configuration = config;
        }

        ConfigHVCC get_configuration() {
            return this.m_configuration;
        }

        void append_nal_data(byte[] nal) {
            NalArray array = new NalArray();
            array.m_array_completeness = 0;
            array.m_nal_unit_type = nal[0] >> 1;
            array.m_nal_units.add(nal);
            this.m_nal_array.add(array);
        }

        void get_headers(ByteWriter dest) {
            for (NalArray array : this.m_nal_array) {
                for (byte[] unit : array.m_nal_units) {
                    dest.putU32(unit.length);
                    dest.write(unit);
                }
            }
        }
    }

    private static class Box {
        List<Box> m_children = new ArrayList<Box>();
        BoxHeader hdr;

        Box() {
        }

        Box(BoxHeader hdr) {
            this.hdr = hdr;
        }

        void derive_box_version() {
            this.hdr.version = 0;
        }

        void derive_box_version_recursive() {
            this.derive_box_version();
            for (Box box : this.m_children) {
                box.derive_box_version_recursive();
            }
        }

        Box get_child_box(int sType) {
            for (Box box : this.m_children) {
                if (box.hdr.short_type != sType) continue;
                return box;
            }
            return null;
        }

        List<Box> get_child_boxes(int sType) {
            ArrayList<Box> res = new ArrayList<Box>();
            for (Box box : this.m_children) {
                if (box.hdr.short_type != sType) continue;
                res.add(box);
            }
            return res;
        }

        List<Box> getChildren() {
            return this.m_children;
        }

        int appendChild(Box box) {
            this.m_children.add(box);
            return this.m_children.size() - 1;
        }

        void parse(DataReader range) throws IOException {
            int content_size = (int)(this.hdr.box_size - (long)this.hdr.header_size);
            range.skip(content_size);
        }

        void readChildren(DataReader range) throws IOException {
            while ((long)(range.getPosition() - this.hdr.offset) < this.hdr.box_size) {
                Box box = new Box();
                box = box.read(range);
                this.m_children.add(box);
            }
        }

        void writeChildren(ByteWriter writer) {
            for (Box box : this.m_children) {
                box.derive_box_version();
                box.write(writer);
            }
        }

        String readNameString(DataReader reader) throws IOException {
            int c2;
            StringBuilder sb = new StringBuilder();
            while ((long)(reader.getPosition() - this.hdr.offset) < this.hdr.box_size && (c2 = reader.getU8()) != 0) {
                sb.append((char)c2);
            }
            return sb.toString();
        }

        Box read(DataReader range) throws IOException {
            Box box;
            BoxHeader hd = new BoxHeader();
            hd.parse(range);
            switch (hd.short_type) {
                case 1718909296: {
                    box = new FTYP(hd);
                    break;
                }
                case 1835365473: {
                    box = new META(hd);
                    break;
                }
                case 1751411826: {
                    box = new HDLR(hd);
                    break;
                }
                case 1885959277: {
                    box = new PITM(hd);
                    break;
                }
                case 1768714083: {
                    box = new ILOC(hd);
                    break;
                }
                case 0x69696E66: {
                    box = new IINF(hd);
                    break;
                }
                case 1768842853: {
                    box = new INFE(hd);
                    break;
                }
                case 1768977008: {
                    box = new IPRP(hd);
                    break;
                }
                case 1768973167: {
                    box = new IPCO(hd);
                    break;
                }
                case 1768975713: {
                    box = new IPMA(hd);
                    break;
                }
                case 1769173093: {
                    box = new ISPE(hd);
                    break;
                }
                case 1635088451: {
                    box = new AUXC(hd);
                    break;
                }
                case 1769107316: {
                    box = new IROT(hd);
                    break;
                }
                case 1768778098: {
                    box = new IMIR(hd);
                    break;
                }
                case 1769104742: {
                    box = new IREF(hd);
                    break;
                }
                case 1752589123: {
                    box = new HVCC(hd);
                    break;
                }
                case 1635135811: {
                    box = new AV1C(hd);
                    break;
                }
                case 1768186228: {
                    box = new IDAT(hd);
                    break;
                }
                case 1735553132: {
                    box = new GRPL(hd);
                    break;
                }
                case 1684631142: {
                    box = new DINF(hd);
                    break;
                }
                case 1685218662: {
                    box = new DREF(hd);
                    break;
                }
                case 1970433056: {
                    box = new URL(hd);
                    break;
                }
                case 1668246642: {
                    box = new COLR(hd);
                    break;
                }
                case 1885960297: {
                    box = new PIXI(hd);
                    break;
                }
                case 1668047216: {
                    box = new CLAP(hd);
                    break;
                }
                case 1836019574: {
                    box = new MOOV(hd);
                    break;
                }
                case 1885434736: {
                    box = new PASP(hd);
                    break;
                }
                default: {
                    box = new Box(hd);
                }
            }
            box.parse(range);
            range.moveTo((int)((long)hd.offset + hd.box_size));
            return box;
        }

        void write(ByteWriter writer) {
            int box_start = this.hdr.reserve_box_header_space(writer);
            this.writeChildren(writer);
            this.hdr.prepend_header(writer, box_start);
        }
    }

    private static class BoxHeader {
        int offset;
        long box_size;
        int header_size;
        int short_type;
        String name = "";
        private final int[] m_uuid_type = new int[16];
        boolean is_full_box;
        byte version;
        int flags;

        private BoxHeader() {
        }

        int[] get_type() {
            if (this.short_type == 1970628964) {
                return this.m_uuid_type;
            }
            int[] t2 = new int[]{this.short_type >> 24 & 0xFF, this.short_type >> 16 & 0xFF, this.short_type >> 8 & 0xFF, this.short_type & 0xFF};
            return t2;
        }

        String get_type_string() {
            StringBuilder sb = new StringBuilder();
            if (this.short_type == 1970628964) {
                for (int i2 = 0; i2 < 16; ++i2) {
                    sb.append(this.m_uuid_type[i2]);
                }
            } else {
                sb.append((char)(this.short_type >> 24));
                sb.append((char)(this.short_type >> 16 & 0xFF));
                sb.append((char)(this.short_type >> 8 & 0xFF));
                sb.append((char)(this.short_type & 0xFF));
            }
            return sb.toString();
        }

        void parse(DataReader range) throws IOException {
            this.offset = range.getPosition();
            this.box_size = range.getU32();
            this.short_type = range.getU32();
            this.name = this.get_type_string();
            this.header_size = 8;
            if (this.box_size < 0L) {
                this.box_size = range.getLength() - range.getPosition();
                return;
            }
            if (this.box_size == 1L) {
                long high = range.getU32();
                long low = range.getU32();
                this.box_size = high << 32 | low;
                this.header_size += 8;
            }
            if (this.short_type == 1970628964) {
                for (int i2 = 0; i2 < 16; ++i2) {
                    this.m_uuid_type[i2] = range.getU8();
                }
                this.header_size += 16;
            }
        }

        void parse_full_box_header(DataReader range) throws IOException {
            int data = range.getU32();
            this.version = (byte)(data >> 24);
            this.flags = data & 0xFFFFFF;
            this.is_full_box = true;
            this.header_size += 4;
        }

        int reserve_box_header_space(ByteWriter writer) {
            int start_pos = writer.bp;
            int hSize = this.is_full_box ? 12 : 8;
            writer.write(new byte[hSize]);
            return start_pos;
        }

        void prepend_header(ByteWriter writer, int boxStart) {
            int reserved_header_size = this.is_full_box ? 12 : 8;
            int hSize = 8;
            if (this.is_full_box) {
                hSize += 4;
            }
            if (this.short_type == 1970628964) {
                hSize += 16;
            }
            int data_size = writer.bp - boxStart - reserved_header_size;
            this.box_size = data_size + hSize;
            writer.bp = boxStart;
            writer.putU32((int)this.box_size);
            writer.putU32(this.short_type);
            if (this.short_type == 1970628964) {
                for (int i2 = 0; i2 < 16; ++i2) {
                    writer.putByte((byte)this.m_uuid_type[i2]);
                }
            }
            if (this.is_full_box) {
                writer.putU32(this.version << 24 | this.flags);
            }
            writer.bp = boxStart + (int)this.box_size;
        }
    }

    private static class ImageGrid {
        int rows;
        int cols;
        int outputWidth;
        int outputHeight;

        private ImageGrid() {
        }

        void parse(byte[] data) {
            int flags = data[1] & 0xFF;
            int field_size = (flags & 1) != 0 ? 32 : 16;
            this.rows = (data[2] & 0xFF) + 1;
            this.cols = (data[3] & 0xFF) + 1;
            if (field_size == 32) {
                this.outputWidth = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
                this.outputHeight = (data[8] & 0xFF) << 24 | (data[9] & 0xFF) << 16 | (data[10] & 0xFF) << 8 | data[11] & 0xFF;
            } else {
                this.outputWidth = (data[4] & 0xFF) << 8 | data[5] & 0xFF;
                this.outputHeight = (data[6] & 0xFF) << 8 | data[7] & 0xFF;
            }
        }
    }

    private static class HeifImage {
        int id;
        int width;
        int height;
        int ispe_width;
        int ispe_height;
        boolean is_primary;
        boolean is_alpha_channel;
        boolean is_depth_channel;
        boolean is_thumbnail;
        int alpha_channel_ref_id;
        int thumbnail_ref_id;
        int depth_channel_ref_id;
        HeifImage alpha_channel;
        List<HeifImage> thumbnails = new ArrayList<HeifImage>();
        HeifContext heif_context;
        MetaData meta;

        HeifImage() {
        }

        HeifImage(int id2, HeifContext ctx) {
            this.id = id2;
            this.heif_context = ctx;
        }

        void set_resolution(int w2, int h2) {
            this.width = w2;
            this.height = h2;
        }

        void set_ispe_resolution(int w2, int h2) {
            this.ispe_width = w2;
            this.ispe_height = h2;
        }

        private void set_is_thumbnail_of(int v2) {
            this.is_thumbnail = true;
            this.thumbnail_ref_id = this.id;
        }

        private void add_thumbnail(HeifImage t2) {
            this.thumbnails.add(t2);
        }

        private void set_is_alpha_channel_of(int v2) {
            this.is_alpha_channel = true;
            this.alpha_channel_ref_id = v2;
        }

        private void set_alpha_channel(HeifImage c2) {
            this.alpha_channel = c2;
        }

        private void encode_image_as_hevc(BufferedImage bImg) {
            int sw = bImg.getWidth();
            int sh = bImg.getHeight();
            int spsW = (sw + 7) / 8 * 8;
            int spsH = (sh + 7) / 8 * 8;
            BufferedImage toWrite = bImg;
            this.width = spsW;
            this.height = spsH;
            this.heif_context.heif_file.add_hvcC_property(this.id);
            List<byte[]> datas = EContext.encodeImage(toWrite, spsW, spsH);
            block3: for (byte[] data : datas) {
                int NAL_SPS = 33;
                if (data[0] >> 1 == 33) {
                    ConfigHVCC config = new ConfigHVCC();
                    int[] res = HeifImage.parse_sps_for_hvcC_configuration(data, config);
                    this.heif_context.heif_file.set_hvcC_configuration(this.id, config);
                    this.heif_context.heif_file.add_ispe_property(this.id, res[0], res[1]);
                    if (sw != spsW || sh != spsH) {
                        this.heif_context.heif_file.add_clap(this.id, sw, sh, spsW, spsH);
                    }
                    if (this.heif_context.hSpacing != 1 || this.heif_context.vSpacing != 1) {
                        this.heif_context.heif_file.add_pasp(this.id, this.heif_context.hSpacing, this.heif_context.vSpacing);
                    }
                }
                switch (data[0] >> 1) {
                    case 32: 
                    case 33: 
                    case 34: {
                        this.heif_context.heif_file.append_hvcC_nal_data(this.id, data);
                        continue block3;
                    }
                }
                this.heif_context.heif_file.append_iloc_data_with_4byte_size(this.id, data);
            }
        }

        private static int[] parse_sps_for_hvcC_configuration(byte[] data, ConfigHVCC config) {
            int value;
            int i2;
            byte[] sps = HeifImage.remove_start_code_emulation(data);
            Bitstream reader = new Bitstream(sps);
            reader.readBits(16);
            reader.readBits(4);
            int nMaxSubLayersMinus1 = reader.readBits(3);
            config.temporal_id_nested = reader.readBit();
            config.general_profile_space = reader.readBits(2);
            config.general_tier_flag = reader.readBits(1);
            config.general_profile_idc = reader.readBits(5);
            config.general_profile_compatibility_flags = reader.readBits(32);
            reader.readBits(16);
            reader.readBits(16);
            reader.readBits(16);
            config.general_level_idc = reader.readBits(8);
            byte[] layer_profile_present = new byte[nMaxSubLayersMinus1];
            byte[] layer_level_present = new byte[nMaxSubLayersMinus1];
            for (i2 = 0; i2 < nMaxSubLayersMinus1; ++i2) {
                layer_profile_present[i2] = reader.readBit();
                layer_level_present[i2] = reader.readBit();
            }
            for (i2 = 0; i2 < nMaxSubLayersMinus1; ++i2) {
                if (layer_profile_present[i2] != 0) {
                    reader.readBits(8);
                    reader.readBits(32);
                    reader.readBits(16);
                }
                if (layer_level_present[i2] == 0) continue;
                reader.readBits(8);
            }
            int dummy = reader.ue();
            config.chroma_format = value = reader.ue();
            if (config.chroma_format == 3) {
                reader.readBit();
            }
            int width = reader.ue();
            int height = reader.ue();
            byte conformance_window = reader.readBit();
            if (conformance_window != 0) {
                int left = reader.ue();
                int right = reader.ue();
                int top = reader.ue();
                int bottom = reader.ue();
                width -= 2 * (left + right);
                height -= 2 * (top + bottom);
            }
            value = reader.ue();
            config.bit_depth_luma = value + 8;
            value = reader.ue();
            config.bit_depth_chroma = value + 8;
            config.configuration_version = 1;
            config.min_spatial_segmentation_idc = 0;
            config.parallelism_type = 0;
            config.avg_frame_rate = 0;
            config.constant_frame_rate = 0;
            config.num_temporal_layers = 1;
            return new int[]{width, height};
        }

        private static byte[] remove_start_code_emulation(byte[] sps) {
            ByteWriter out_data = new ByteWriter();
            int size = sps.length;
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 + 2 < size && sps[i2] == 0 && sps[i2 + 1] == 0 && sps[i2 + 2] == 3) {
                    out_data.putByte((byte)0);
                    out_data.putByte((byte)0);
                    i2 += 2;
                    continue;
                }
                out_data.putByte(sps[i2]);
            }
            return out_data.toArray();
        }
    }

    private static class HeifContext {
        int hSpacing = 1;
        int vSpacing = 1;
        HeifFile heif_file;
        HeifImage primary_image;
        int m_thumbnail_ID = -1;
        int m_auxl_ID = -1;
        List<HeifImage> top_level_images = new ArrayList<HeifImage>();
        Map<Integer, HeifImage> all_images = new HashMap<Integer, HeifImage>();
        Exif m_exif;
        boolean isRotatedOrClapped;

        HeifContext() {
            this.heif_file = new HeifFile();
            this.heif_file.new_empty_file();
            this.all_images.clear();
            this.top_level_images.clear();
            this.primary_image = new HeifImage();
        }

        void read(DataReader reader) throws IOException {
            this.heif_file = new HeifFile();
            this.heif_file.read(reader);
            this.interpret_heif_file();
        }

        void write(ByteWriter writer) {
            this.heif_file.write(writer);
        }

        void remove_top_level_image(HeifImage image) {
            this.top_level_images.remove(image);
        }

        boolean item_type_is_image(int item_type) {
            return true;
        }

        private void interpret_heif_file() throws IOException {
            this.all_images.clear();
            this.top_level_images.clear();
            this.primary_image = new HeifImage();
            int[] image_IDs = this.heif_file.get_item_IDs();
            boolean primary_is_grid = false;
            for (int id2 : image_IDs) {
                INFE infe_box = this.heif_file.get_infe(id2);
                if (infe_box == null || !this.item_type_is_image(infe_box.item_type)) continue;
                Iterator<Reference> image = new HeifImage();
                this.all_images.put(id2, (HeifImage)((Object)image));
                if (infe_box.hidden_item) continue;
                if (id2 == this.heif_file.get_primary_image_ID()) {
                    ((HeifImage)((Object)image)).is_primary = true;
                    ((HeifImage)((Object)image)).id = id2;
                    this.primary_image = image;
                    primary_is_grid = infe_box.item_type == 1735551332;
                }
                this.top_level_images.add((HeifImage)((Object)image));
            }
            IREF iref_box = this.heif_file.irefBox;
            if (iref_box != null) {
                for (Integer key : this.all_images.keySet()) {
                    HeifImage image = this.all_images.get(key);
                    List<Reference> references = iref_box.get_references_from(image.id);
                    block6: for (Reference ref : iref_box.m_references) {
                        int refType = ref.header.short_type;
                        if (refType == 1953000802) {
                            for (Integer integer : ref.to_item_ID) {
                                if (ref.from_item_ID == this.primary_image.id && integer != this.primary_image.id) {
                                    this.primary_image.id = integer;
                                    this.m_thumbnail_ID = ref.from_item_ID;
                                    continue;
                                }
                                if (integer != this.primary_image.id) continue;
                                this.m_thumbnail_ID = ref.from_item_ID;
                                continue block6;
                            }
                            continue;
                        }
                        if (refType != 1635088492) continue;
                        for (Integer integer : ref.to_item_ID) {
                            if (integer != this.primary_image.id) continue;
                            this.m_auxl_ID = ref.from_item_ID;
                            continue block6;
                        }
                    }
                    for (Reference ref : references) {
                        int type = ref.header.short_type;
                        switch (type) {
                            case 1953000802: {
                                List<Integer> refs = ref.to_item_ID;
                                image.set_is_thumbnail_of(refs.get(0));
                                HeifImage master_iter = this.all_images.get(refs.get(0));
                                master_iter.add_thumbnail(image);
                                this.remove_top_level_image(image);
                                break;
                            }
                            case 1635088492: {
                                List properties = this.heif_file.get_properties(image.id);
                                AUXC auxC_property = null;
                                for (Prop property : properties) {
                                    auxC_property = (AUXC)property.property;
                                }
                                List<Integer> refs = ref.to_item_ID;
                                if (auxC_property != null && "urn:mpeg:avc:2015:auxid:1".equals(auxC_property.aux_type) || "urn:mpeg:hevc:2015:auxid:1".equals(auxC_property.aux_type)) {
                                    image.set_is_alpha_channel_of(refs.get(0));
                                    HeifImage master_iter = this.all_images.get(refs.get(0));
                                    master_iter.set_alpha_channel(image);
                                }
                                this.remove_top_level_image(image);
                                break;
                            }
                        }
                    }
                }
            }
            for (Integer key : this.all_images.keySet()) {
                HeifImage image = this.all_images.get(key);
                List properties = this.heif_file.get_properties(key);
                boolean ispe_read = false;
                boolean primary_colr_set = false;
                for (Prop prop : properties) {
                    boolean is_grid_item;
                    if (prop.property.hdr.short_type == 1769173093) {
                        ISPE ispe = (ISPE)prop.property;
                        int width = ispe.image_width;
                        int height = ispe.image_height;
                        image.set_resolution(width, height);
                        image.set_ispe_resolution(width, height);
                        ispe_read = true;
                    }
                    if (ispe_read && prop.property.hdr.short_type == 1769107316) {
                        IROT irot = (IROT)prop.property;
                        if (irot.rotation == 90 || irot.rotation == 270) {
                            image.set_resolution(image.height, image.width);
                        }
                    }
                    if (prop.property.hdr.short_type != 1668246642) continue;
                    COLR colr = (COLR)prop.property;
                    boolean bl2 = is_grid_item = !image.is_primary && !image.is_alpha_channel && !image.is_depth_channel;
                    if (!primary_is_grid || primary_colr_set || !is_grid_item) continue;
                    primary_colr_set = true;
                }
            }
            for (Object id3 : (Object)image_IDs) {
                int item_type = this.heif_file.get_item_type((int)id3);
                String content_type = this.heif_file.get_content_type((int)id3);
                if (item_type != 1165519206) continue;
                MetaData meta = new MetaData();
                meta.item_id = (int)id3;
                meta.item_type = item_type;
                meta.content_type = content_type;
                meta.data = this.heif_file.get_compressed_image_data((int)id3);
                if (meta.data.length > 0) {
                    this.m_exif = Exif.readExif(meta.data);
                }
                if (iref_box == null) continue;
                List<Reference> references = iref_box.get_references_from((int)id3);
                for (Reference ref : references) {
                    int exif_image_id;
                    HeifImage imgOwner;
                    List<Integer> refs;
                    if (ref.header.short_type != 1667527523 || (refs = ref.to_item_ID).isEmpty() || (imgOwner = this.all_images.get(exif_image_id = refs.get(0).intValue())) == null) continue;
                    imgOwner.meta = meta;
                }
            }
        }

        List<HeifImage> get_top_level_images() {
            return this.top_level_images;
        }

        boolean is_image(int id2) {
            return this.all_images.containsKey(id2);
        }

        BufferedImage decodeImagePlanar(int id2) throws IOException {
            if (!this.heif_file.image_exists(id2)) {
                return null;
            }
            int item_type = this.heif_file.get_item_type(id2);
            BufferedImage image = null;
            switch (item_type) {
                case 1752589105: {
                    byte[] data = this.heif_file.get_compressed_image_data(id2);
                    image = HeifContext.decodeHEVC(data);
                    break;
                }
                case 1635135811: {
                    LogWriter.writeLog("AVI decoding is not supported in Heic Images");
                    break;
                }
                case 1768187246: {
                    image = this.decodeDerivedImage(id2);
                    break;
                }
                case 1735551332: {
                    byte[] data = this.heif_file.get_compressed_image_data(id2);
                    image = this.decodeGridImage(id2, data);
                    break;
                }
                case 1768912492: {
                    byte[] data = this.heif_file.get_compressed_image_data(id2);
                    image = this.decodeOverlay(id2, data);
                }
            }
            if (image != null) {
                IPCO ipco_box = this.heif_file.ipcoBox;
                IPMA ipma_box = this.heif_file.ipmaBox;
                List<Prop> props = ipco_box.get_properties_for_item_ID(id2, ipma_box);
                for (Prop prop : props) {
                    if (prop.property.hdr.short_type == 1769107316) {
                        IROT irot = (IROT)prop.property;
                        image = HeifContext.doRotation(image, irot.rotation);
                        this.isRotatedOrClapped = true;
                    }
                    if (prop.property.hdr.short_type == 1768778098) {
                        IMIR imir = (IMIR)prop.property;
                        HeifContext.doMirror(image, imir.mirror);
                    }
                    if (prop.property.hdr.short_type != 1668047216) continue;
                    CLAP clap = (CLAP)prop.property;
                    image = HStruct.doClap(image, clap);
                    this.isRotatedOrClapped = true;
                }
            }
            return image;
        }

        private static BufferedImage doRotation(BufferedImage image, int rotation) {
            int width = image.getWidth();
            int height = image.getHeight();
            PixGet pg = Access.getPixGet(image);
            switch (rotation) {
                case 90: {
                    BufferedImage res = new BufferedImage(height, width, image.getType());
                    for (int i2 = 0; i2 < width; ++i2) {
                        for (int j2 = 0; j2 < height; ++j2) {
                            res.setRGB(j2, width - 1 - i2, pg.getRGB(i2, j2));
                        }
                    }
                    return res;
                }
                case 270: {
                    BufferedImage res = new BufferedImage(height, width, image.getType());
                    for (int i3 = 0; i3 < width; ++i3) {
                        for (int j3 = 0; j3 < height; ++j3) {
                            res.setRGB(height - 1 - j3, i3, pg.getRGB(i3, j3));
                        }
                    }
                    return res;
                }
                case 180: {
                    HeifContext.doMirror(image, 0);
                    HeifContext.doMirror(image, 1);
                    return image;
                }
            }
            return image;
        }

        private static void doMirror(BufferedImage image, int mirror) {
            byte[] v2 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            int nc = image.getColorModel().getNumComponents();
            int h2 = image.getHeight();
            int w2 = image.getWidth();
            if (mirror == 0) {
                int ii = h2 / 2;
                int ww = w2 * nc;
                byte[] aa2 = new byte[ww];
                byte[] bb2 = new byte[ww];
                for (int i2 = 0; i2 < ii; ++i2) {
                    int aOffset = i2 * ww;
                    int bOffset = (h2 - i2 - 1) * ww;
                    System.arraycopy(v2, aOffset, aa2, 0, ww);
                    System.arraycopy(v2, bOffset, bb2, 0, ww);
                    System.arraycopy(aa2, 0, v2, bOffset, ww);
                    System.arraycopy(bb2, 0, v2, aOffset, ww);
                }
            } else {
                int jj = w2 / 2;
                byte[] t2 = new byte[nc];
                for (int i3 = 0; i3 < h2; ++i3) {
                    for (int j2 = 0; j2 < jj; ++j2) {
                        int aOffset = (i3 * w2 + j2) * nc;
                        int bOffset = (i3 * w2 + w2 - j2 - 1) * nc;
                        for (int k2 = 0; k2 < nc; ++k2) {
                            t2[k2] = v2[aOffset + k2];
                            v2[aOffset + k2] = v2[bOffset + k2];
                            v2[bOffset + k2] = t2[k2];
                        }
                    }
                }
            }
        }

        private BufferedImage decodeOverlay(int id2, byte[] data) throws IOException {
            IREF iref_box = this.heif_file.irefBox;
            List<Integer> image_references = iref_box.get_references(id2, 1684630887);
            Overlay overlay = new Overlay();
            overlay.parse(image_references.size(), data);
            int w2 = overlay.width;
            int h2 = overlay.height;
            BufferedImage image = new BufferedImage(w2, h2, 5);
            int[] bkg_color = overlay.bgColor;
            for (int i2 = 0; i2 < image_references.size(); ++i2) {
                BufferedImage overlay_img = this.decodeImagePlanar(image_references.get(i2));
                int dx = overlay.offsets[i2].x;
                int dy = overlay.offsets[i2].y;
                HeifContext.placeTile(image, overlay_img, dx, dy);
            }
            return image;
        }

        private static BufferedImage decodeHEVC(byte[] data) throws IOException {
            BufferedImage image = null;
            DataByteBig reader = new DataByteBig(data);
            Ctx ctx = new Ctx();
            ctx.img = new HImg();
            while (reader.getPosition() < reader.getLength()) {
                int len = reader.getU32();
                Nal nal = Nal.readNal(reader, len);
                switch (nal.nal_unit_type) {
                    case 32: {
                        ctx.readVps(nal.rbsp);
                        break;
                    }
                    case 33: {
                        ctx.readSps(nal.rbsp);
                        break;
                    }
                    case 34: {
                        ctx.readPps(nal.rbsp);
                    }
                }
                if (!nal.isIRAP()) continue;
                ctx.readSlice(nal);
            }
            switch (ctx.sps.chroma_format_idc) {
                case 1: {
                    image = YuvDisplay.fromYUV420(ctx.img);
                    break;
                }
                case 2: {
                    image = YuvDisplay.fromYUV422(ctx.img);
                    break;
                }
                case 3: {
                    image = YuvDisplay.fromYUV444(ctx.img);
                    break;
                }
                case 0: {
                    image = YuvDisplay.fromMonoGray(ctx.img.getWidth(0), ctx.img.getHeight(0), ctx.img.getImagePlane(0));
                }
            }
            return image;
        }

        private BufferedImage decodeDerivedImage(int id2) throws IOException {
            IREF iref_box = this.heif_file.irefBox;
            List<Integer> refs = iref_box.get_references(id2, 1684630887);
            int reference_image_id = refs.get(0);
            return this.decodeImagePlanar(reference_image_id);
        }

        private BufferedImage decodeGridImage(int ID2, byte[] grid_data) throws IOException {
            ImageGrid grid = new ImageGrid();
            grid.parse(grid_data);
            IREF iref_box = this.heif_file.irefBox;
            List<Integer> image_references = iref_box.get_references(ID2, 1684630887);
            IPMA ipma = this.heif_file.ipmaBox;
            IPCO ipco = this.heif_file.ipcoBox;
            PIXI pixi = (PIXI)ipco.get_property_for_item_ID(ID2, ipma, 1885960297);
            int w2 = grid.outputWidth;
            int h2 = grid.outputHeight;
            BufferedImage bImg = new BufferedImage(w2, h2, 5);
            int y0 = 0;
            int reference_idx = 0;
            for (int y2 = 0; y2 < grid.rows; ++y2) {
                int x0 = 0;
                int tile_height = 0;
                for (int x2 = 0; x2 < grid.cols; ++x2) {
                    int tileID = image_references.get(reference_idx);
                    HeifImage tileImg = this.all_images.get(tileID);
                    int src_width = tileImg.width;
                    int src_height = tileImg.height;
                    this.decodeTile(tileID, bImg, x0, y0);
                    x0 += src_width;
                    tile_height = src_height;
                    ++reference_idx;
                }
                y0 += tile_height;
            }
            return bImg;
        }

        private void decodeTile(int tileID, BufferedImage img, int x2, int y2) throws IOException {
            BufferedImage tileImg = this.decodeImagePlanar(tileID);
            HeifContext.placeTile(img, tileImg, x2, y2);
        }

        private static void placeTile(BufferedImage img, BufferedImage tileImg, int x2, int y2) {
            byte[] dByte = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            byte[] tByte = ((DataBufferByte)tileImg.getRaster().getDataBuffer()).getData();
            int tw = tileImg.getWidth();
            int th = tileImg.getHeight();
            int nComp = tileImg.getColorModel().getNumComponents();
            int mainStripLen = img.getWidth() * nComp;
            int w2 = Math.min(tw, img.getWidth() - x2);
            int h2 = Math.min(th, img.getHeight() - y2);
            int subStripLen = w2 * nComp;
            int twStripLen = tw * nComp;
            int xc = x2 * nComp;
            for (int i2 = 0; i2 < h2; ++i2) {
                int tOffset = i2 * twStripLen;
                int dOffset = (i2 + y2) * mainStripLen + xc;
                System.arraycopy(tByte, tOffset, dByte, dOffset, subStripLen);
            }
        }

        void encode_image(BufferedImage bImage) {
            this.heif_file.set_brand(1);
            int image_id = this.heif_file.add_new_image(1752589105);
            HeifImage out_image = new HeifImage(image_id, this);
            this.top_level_images.add(out_image);
            out_image.encode_image_as_hevc(bImage);
        }
    }

    private static class HeifFile {
        DataReader m_input_stream;
        private final List<Box> topLevelBoxes = new ArrayList<Box>();
        private META metaBox = new META();
        private FTYP ftypBox = new FTYP();
        private HDLR hdlrBox = new HDLR();
        private PITM pitmBox = new PITM();
        private IPRP iprpBox = new IPRP();
        private IPCO ipcoBox = new IPCO();
        private IPMA ipmaBox = new IPMA();
        private ILOC ilocBox = new ILOC();
        private IDAT idatBox = new IDAT();
        private IREF irefBox = new IREF();
        private IINF iinfBox = new IINF();
        private final Map<Integer, INFE> infeBoxes = new HashMap<Integer, INFE>();

        private HeifFile() {
        }

        void read(DataReader reader) throws IOException {
            this.m_input_stream = reader;
            while (reader.getPosition() + 4 < reader.getLength()) {
                Box box = new Box();
                box = box.read(reader);
                this.topLevelBoxes.add(box);
                switch (box.hdr.short_type) {
                    case 1835365473: {
                        this.metaBox = (META)box;
                        break;
                    }
                    case 1718909296: {
                        this.ftypBox = (FTYP)box;
                    }
                }
            }
            this.hdlrBox = (HDLR)this.metaBox.get_child_box(1751411826);
            this.pitmBox = (PITM)this.metaBox.get_child_box(1885959277);
            this.iprpBox = (IPRP)this.metaBox.get_child_box(1768977008);
            if (this.iprpBox != null) {
                this.ipcoBox = (IPCO)this.iprpBox.get_child_box(1768973167);
                this.ipmaBox = (IPMA)this.iprpBox.get_child_box(1768975713);
            }
            this.ilocBox = (ILOC)this.metaBox.get_child_box(1768714083);
            this.idatBox = (IDAT)this.metaBox.get_child_box(1768186228);
            this.irefBox = (IREF)this.metaBox.get_child_box(1769104742);
            this.iinfBox = (IINF)this.metaBox.get_child_box(0x69696E66);
            if (this.iinfBox != null) {
                List<Box> infe_boxes = this.iinfBox.get_child_boxes(1768842853);
                for (Box box : infe_boxes) {
                    INFE infe_box = (INFE)box;
                    this.infeBoxes.put(infe_box.item_ID, infe_box);
                }
            }
        }

        void new_empty_file() {
            if (this.m_input_stream != null) {
                this.m_input_stream.moveTo(0);
            }
            this.topLevelBoxes.clear();
            this.ftypBox = new FTYP();
            this.hdlrBox = new HDLR();
            this.metaBox = new META();
            this.ipcoBox = new IPCO();
            this.ipmaBox = new IPMA();
            this.ilocBox = new ILOC();
            this.iinfBox = new IINF();
            this.irefBox = new IREF();
            this.iprpBox = new IPRP();
            this.pitmBox = new PITM();
            this.metaBox.appendChild(this.hdlrBox);
            this.metaBox.appendChild(this.pitmBox);
            this.metaBox.appendChild(this.ilocBox);
            this.metaBox.appendChild(this.iinfBox);
            this.metaBox.appendChild(this.iprpBox);
            this.iprpBox.appendChild(this.ipcoBox);
            this.iprpBox.appendChild(this.ipmaBox);
            this.infeBoxes.clear();
            this.topLevelBoxes.add(this.ftypBox);
            this.topLevelBoxes.add(this.metaBox);
        }

        int get_num_images() {
            return this.infeBoxes.size();
        }

        int get_primary_image_ID() {
            return this.pitmBox.item_ID;
        }

        private int[] get_item_IDs() {
            int[] res = new int[this.infeBoxes.size()];
            int p2 = 0;
            for (Integer integer : this.infeBoxes.keySet()) {
                res[p2++] = integer;
            }
            return res;
        }

        boolean image_exists(int ID2) {
            return this.infeBoxes.containsKey(ID2);
        }

        private INFE get_infe(int id2) {
            return this.infeBoxes.get(id2);
        }

        int get_item_type(int ID2) {
            INFE infe = this.get_infe(ID2);
            return infe.item_type;
        }

        String get_content_type(int ID2) {
            INFE infe = this.get_infe(ID2);
            return infe.content_type;
        }

        private List<Prop> get_properties(int id2) {
            return this.ipcoBox.get_properties_for_item_ID(id2, this.ipmaBox);
        }

        byte[] get_compressed_image_data(int id2) throws IOException {
            ByteWriter out = new ByteWriter();
            INFE infe = this.get_infe(id2);
            int item_type = infe.item_type;
            List<Item> items = this.ilocBox.m_items;
            Item item = null;
            for (Item i2 : items) {
                if (i2.item_ID != id2) continue;
                item = i2;
                break;
            }
            if (item == null) {
                throw new IOException("item id : " + id2 + " has no compressed data");
            }
            if (item_type == 1752589105) {
                List<Prop> props = this.ipcoBox.get_properties_for_item_ID(id2, this.ipmaBox);
                HVCC hvccBox = null;
                for (Prop prop : props) {
                    if (prop.property.hdr.short_type != 1752589123 || (hvccBox = (HVCC)prop.property) == null) continue;
                    break;
                }
                if (hvccBox == null) {
                    throw new IOException("no hvcc box found in data");
                }
                hvccBox.get_headers(out);
                ILOC.readData(item, this.m_input_stream, this.idatBox, out);
            } else {
                ILOC.readData(item, this.m_input_stream, this.idatBox, out);
            }
            return out.toArray();
        }

        int get_image_chroma_from_config(int imageID) {
            Box box = this.ipcoBox.get_property_for_item_ID(imageID, this.ipmaBox, 1752589123);
            if (box != null) {
                HVCC hvcC_box = (HVCC)box;
                return hvcC_box.get_configuration().chroma_format;
            }
            return 0;
        }

        int get_luma_bpp_from_config(int imageID) {
            Box box = this.ipcoBox.get_property_for_item_ID(imageID, this.ipmaBox, 1752589123);
            if (box != null) {
                HVCC hvcC_box = (HVCC)box;
                return hvcC_box.get_configuration().bit_depth_luma;
            }
            return 8;
        }

        int get_chroma_bpp_from_config(int imageID) {
            Box box = this.ipcoBox.get_property_for_item_ID(imageID, this.ipmaBox, 1752589123);
            if (box != null) {
                HVCC hvcC_box = (HVCC)box;
                return hvcC_box.get_configuration().bit_depth_chroma;
            }
            return 8;
        }

        void write(ByteWriter writer) {
            for (Box bb2 : this.topLevelBoxes) {
                bb2.derive_box_version();
                bb2.write(writer);
            }
            this.ilocBox.write_mdat_after_iloc(writer);
        }

        void set_brand(int format) {
            switch (format) {
                case 1: {
                    this.ftypBox.major_brand = 1751476579;
                    this.ftypBox.minor_version = 0;
                    this.ftypBox.add_compatible_brand(1835623985);
                    this.ftypBox.add_compatible_brand(1751476579);
                    break;
                }
                case 4: {
                    this.ftypBox.major_brand = 1635150182;
                    this.ftypBox.minor_version = 0;
                    this.ftypBox.add_compatible_brand(1835623985);
                    this.ftypBox.add_compatible_brand(1635150182);
                    break;
                }
                default: {
                    LogWriter.writeLog("Unknown compression brand set");
                }
            }
        }

        int get_unused_item_id() {
            int id2 = 1;
            while (true) {
                boolean id_exists = false;
                for (Integer key : this.infeBoxes.keySet()) {
                    INFE infe = this.infeBoxes.get(key);
                    if (infe.item_ID != id2) continue;
                    id_exists = true;
                    break;
                }
                if (!id_exists) {
                    return id2;
                }
                ++id2;
            }
        }

        int add_new_image(int item_type) {
            INFE box = this.add_new_infe_box(item_type);
            return box.item_ID;
        }

        INFE add_new_infe_box(int item_type) {
            int id2 = this.get_unused_item_id();
            INFE infe = new INFE();
            infe.item_ID = id2;
            infe.hidden_item = false;
            infe.item_type = item_type;
            this.infeBoxes.put(id2, infe);
            this.iinfBox.appendChild(infe);
            return infe;
        }

        void add_ispe_property(int id2, int width, int height) {
            ISPE ispe = new ISPE();
            ispe.set_size(width, height);
            int index = this.ipcoBox.appendChild(ispe);
            Prop assoc = new Prop();
            assoc.essential = false;
            assoc.index = index + 1;
            this.ipmaBox.add_property_for_item_ID(id2, assoc);
        }

        void add_hvcC_property(int id2) {
            HVCC hvcC = new HVCC();
            int index = this.ipcoBox.appendChild(hvcC);
            Prop assoc = new Prop();
            assoc.essential = true;
            assoc.index = index + 1;
            this.ipmaBox.add_property_for_item_ID(id2, assoc);
        }

        void add_clap(int id2, int sw, int sh, int dw, int dh) {
            CLAP clap = new CLAP();
            clap.widthN = sw;
            clap.widthD = 1.0f;
            clap.heightN = sh;
            clap.heightD = 1.0f;
            clap.horOffsetN = (sw - 1) / 2 - (dw - 1) / 2;
            clap.verOffsetN = (sh - 1) / 2 - (dh - 1) / 2;
            int index = this.ipcoBox.appendChild(clap);
            Prop assoc = new Prop();
            assoc.essential = true;
            assoc.index = index + 1;
            this.ipmaBox.add_property_for_item_ID(id2, assoc);
        }

        void add_pasp(int id2, int hScaling, int vScaling) {
            PASP pasp = new PASP();
            pasp.hSpacing = hScaling;
            pasp.vSpacing = vScaling;
            int index = this.ipcoBox.appendChild(pasp);
            Prop assoc = new Prop();
            assoc.essential = true;
            assoc.index = index + 1;
            this.ipmaBox.add_property_for_item_ID(id2, assoc);
        }

        void append_hvcC_nal_data(int id2, byte[] nal_data) {
            HVCC hvcC = (HVCC)this.ipcoBox.get_property_for_item_ID(id2, this.ipmaBox, 1752589123);
            hvcC.append_nal_data(nal_data);
        }

        void append_iloc_data(int id2, byte[] nal_packets) {
            this.ilocBox.appendData(id2, nal_packets, 0, 0);
        }

        void set_hvcC_configuration(int id2, ConfigHVCC config) {
            HVCC hvcC = (HVCC)this.ipcoBox.get_property_for_item_ID(id2, this.ipmaBox, 1752589123);
            hvcC.set_configuration(config);
        }

        void append_iloc_data_with_4byte_size(int id2, byte[] data) {
            this.ilocBox.appendData(id2, data, 0, data.length);
        }

        void set_primary_item_id(int id2) {
            this.pitmBox.item_ID = id2;
        }

        void add_iref_reference(int type, int from, List<Integer> to) {
            if (this.irefBox == null) {
                this.irefBox = new IREF();
                this.metaBox.appendChild(this.irefBox);
            }
            this.irefBox.add_reference(type, from, to);
        }
    }
}

