/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Ecb;
import com.idrsolutions.image.heic.common.Etb;

class EtbMatrix {
    Ecb[] mCTBs;
    int mWidthCtbs;
    int mHeightCtbs;
    int mLog2CtbSize;

    EtbMatrix() {
    }

    void alloc(int w2, int h2, int log2CtbSize) {
        int ctbSize = 1 << log2CtbSize;
        this.mWidthCtbs = w2 + ctbSize - 1 >> log2CtbSize;
        this.mHeightCtbs = h2 + ctbSize - 1 >> log2CtbSize;
        this.mLog2CtbSize = log2CtbSize;
        this.mCTBs = new Ecb[this.mWidthCtbs * this.mHeightCtbs];
    }

    Ecb getCB(int px, int py) {
        int xCTB = px >> this.mLog2CtbSize;
        int yCTB = py >> this.mLog2CtbSize;
        int idx = xCTB + yCTB * this.mWidthCtbs;
        Ecb cb = this.mCTBs[idx];
        if (cb == null) {
            return null;
        }
        while (cb.split_cu_flag) {
            int xHalf = cb.x + (1 << cb.log2Size - 1);
            int yHalf = cb.y + (1 << cb.log2Size - 1);
            cb = px < xHalf ? (py < yHalf ? cb.children[0] : cb.children[2]) : (py < yHalf ? cb.children[1] : cb.children[3]);
            if (cb != null) continue;
            return null;
        }
        return cb;
    }

    Etb getTB(int x2, int y2) {
        Ecb cb = this.getCB(x2, y2);
        if (cb == null) {
            return null;
        }
        Etb tb = cb.transform_tree;
        if (tb == null) {
            return null;
        }
        return tb.getTB(x2, y2);
    }

    void setCTB(int xCTB, int yCTB, Ecb ctb) {
        int idx = xCTB + yCTB * this.mWidthCtbs;
        this.mCTBs[idx] = ctb;
    }

    Ecb getCTB(int xCTB, int yCTB) {
        int idx = xCTB + yCTB * this.mWidthCtbs;
        return this.mCTBs[idx];
    }

    Ecb getCTBRootPointer(int x2, int y2) {
        int idx = (x2 >>= this.mLog2CtbSize) + (y2 >>= this.mLog2CtbSize) * this.mWidthCtbs;
        return this.mCTBs[idx];
    }

    void setCTBRootPointer(int x2, int y2, Ecb ecb) {
        int idx = (x2 >>= this.mLog2CtbSize) + (y2 >>= this.mLog2CtbSize) * this.mWidthCtbs;
        this.mCTBs[idx] = ecb;
    }
}

