/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Ecb;

class Etb {
    Etb parent;
    final Ecb cb;
    final short x;
    final short y;
    boolean split_transform_flag;
    byte trafoDepth;
    byte blkIdx;
    final byte log2Size;
    byte intra_mode = 1;
    byte intra_mode_chroma = 1;
    final int[] cbf = new int[]{0, 0, 0};
    final Etb[] children = new Etb[4];
    int[][] coeff;

    Etb(int x2, int y2, byte log2TbSize, Ecb cb) {
        this.x = (short)x2;
        this.y = (short)y2;
        this.log2Size = log2TbSize;
        this.cb = cb;
    }

    void alloc_coeff_memory(int cIdx, int tbSize) {
        if (this.coeff == null) {
            this.coeff = new int[3][];
        }
        this.coeff[cIdx] = new int[tbSize * tbSize];
    }

    void set_cbf_flags_from_children() {
        this.cbf[0] = 0;
        this.cbf[1] = 0;
        this.cbf[2] = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.cbf[0] = this.cbf[0] | this.children[i2].cbf[0];
            this.cbf[1] = this.cbf[1] | this.children[i2].cbf[1];
            this.cbf[2] = this.cbf[2] | this.children[i2].cbf[2];
        }
    }

    boolean isZeroBlock() {
        return this.cbf[0] == 0 && this.cbf[1] == 0 && this.cbf[2] == 0;
    }

    Etb getTB(int px, int py) {
        if (this.split_transform_flag) {
            Etb child;
            int xHalf = this.x + (1 << this.log2Size - 1);
            int yHalf = this.y + (1 << this.log2Size - 1);
            if (px < xHalf) {
                child = py < yHalf ? this.children[0] : this.children[2];
            } else {
                Etb etb = child = py < yHalf ? this.children[1] : this.children[3];
            }
            if (child == null) {
                return null;
            }
            return child.getTB(px, py);
        }
        return this;
    }

    void clearData(int cIdx) {
        for (Etb cc : this.children) {
            if (cc == null) continue;
            cc.clearData(cIdx);
        }
        this.coeff[cIdx] = null;
    }
}

