/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.heic.common;

import com.idrsolutions.image.heic.common.Ecb;
import com.idrsolutions.image.heic.common.Etb;
import com.idrsolutions.image.heic.common.EtbMatrix;
import com.idrsolutions.image.heic.common.HImg;
import com.idrsolutions.image.heic.common.HeicMath;
import com.idrsolutions.image.heic.common.Pps;
import com.idrsolutions.image.heic.common.Sps;
import com.idrsolutions.image.heic.common.Type;
import java.util.Arrays;

class EIntraPred {
    private static final int NOFFSET = 130;
    int nT;
    int cIdx;
    int xB;
    int yB;
    int nBottom;
    int nRight;
    int nAvail;
    int firstValue;
    int SubWidth;
    int SubHeight;
    private final boolean[] available = new boolean[260];
    private final int[] out_border = new int[260];
    private final int[] refAng = new int[260];
    private boolean hasLeft;
    private boolean hasTop;
    private boolean hasTopRight;
    private boolean hasTopLeft;

    EIntraPred() {
    }

    static void fillIntraPredModeCandidates(int[] candModeList, int x2, int y2, boolean availableA, boolean availableB, EtbMatrix ctbs, Sps sps) {
        int candIntraPredModeB;
        int candIntraPredModeA;
        if (!availableA) {
            candIntraPredModeA = 1;
        } else {
            Ecb cbL = ctbs.getCB(x2 - 1, y2);
            if (cbL.predMode != 0) {
                candIntraPredModeA = 1;
            } else {
                Etb tbL = cbL.getTB(x2 - 1, y2);
                candIntraPredModeA = tbL.intra_mode;
            }
        }
        if (!availableB) {
            candIntraPredModeB = 1;
        } else {
            Ecb cbA = ctbs.getCB(x2, y2 - 1);
            if (cbA.predMode != 0) {
                candIntraPredModeB = 1;
            } else if (y2 - 1 < y2 >> sps.Log2CtbSizeY << sps.Log2CtbSizeY) {
                candIntraPredModeB = 1;
            } else {
                Etb tbA = cbA.getTB(x2, y2 - 1);
                candIntraPredModeB = tbA.intra_mode;
            }
        }
        EIntraPred.fillIntraPredModeCandidates(candModeList, candIntraPredModeA, candIntraPredModeB);
    }

    private static void fillIntraPredModeCandidates(int[] candModeList, int modeA, int modeB) {
        if (modeA == modeB) {
            if (modeA < 2) {
                candModeList[0] = 0;
                candModeList[1] = 1;
                candModeList[2] = 26;
            } else {
                candModeList[0] = modeA;
                candModeList[1] = 2 + (modeA - 2 - 1 + 32) % 32;
                candModeList[2] = 2 + (modeA - 2 + 1) % 32;
            }
        } else {
            candModeList[0] = modeA;
            candModeList[1] = modeB;
            candModeList[2] = modeA != 0 && modeB != 0 ? 0 : (modeA != 1 && modeB != 1 ? 1 : 26);
        }
    }

    private void fillFromCtbtree(HImg d2, Sps sps, Pps pps, EtbMatrix ctbs) {
        int yN;
        int xN;
        byte[] image = d2.getImagePlaneByte(this.cIdx);
        int stride = d2.getImageStride(this.cIdx);
        int xBLuma = this.xB * this.SubWidth;
        int yBLuma = this.yB * this.SubHeight;
        int currBlockAddr = pps.MinTbAddrZS[(xBLuma >> sps.Log2MinTrafoSize) + (yBLuma >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
        for (int y2 = this.nBottom - 1; y2 >= 0; y2 -= 4) {
            if (!this.hasLeft) continue;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB - 1) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB + y2) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean availableN = NBlockAddr <= currBlockAddr;
            xN = this.xB - 1;
            yN = this.yB + y2;
            Ecb cb = ctbs.getCB(xN * this.SubWidth, yN * this.SubHeight);
            if (pps.constrained_intra_pred_flag != 0 && cb.predMode != 0) {
                availableN = false;
            }
            if (!availableN) continue;
            if (this.nAvail == 0) {
                this.firstValue = image[this.xB - 1 + (this.yB + y2) * stride];
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                this.available[130 - y2 + i2 - 1] = availableN;
                this.out_border[130 - y2 + i2 - 1] = image[this.xB - 1 + (this.yB + y2 - i2) * stride];
            }
            this.nAvail += 4;
        }
        if (this.hasTopLeft) {
            int NBlockAddr = pps.MinTbAddrZS[((this.xB - 1) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB - 1) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean availableN = NBlockAddr <= currBlockAddr;
            xN = this.xB - 1;
            yN = this.yB - 1;
            Ecb cb = ctbs.getCB(xN * this.SubWidth, yN * this.SubHeight);
            if (pps.constrained_intra_pred_flag != 0 && cb.predMode != 0) {
                availableN = false;
            }
            if (availableN) {
                this.out_border[130] = image[this.xB - 1 + (this.yB - 1) * stride];
                this.available[130] = availableN;
                if (this.nAvail == 0) {
                    this.firstValue = this.out_border[0];
                }
                ++this.nAvail;
            }
        }
        for (int x2 = 0; x2 < this.nRight; x2 += 4) {
            boolean borderAvailable;
            boolean bl2 = borderAvailable = x2 < this.nT ? this.hasTop : this.hasTopRight;
            if (!borderAvailable) continue;
            int NBlockAddr = pps.MinTbAddrZS[((this.xB + x2) * this.SubWidth >> sps.Log2MinTrafoSize) + ((this.yB - 1) * this.SubHeight >> sps.Log2MinTrafoSize) * sps.PicWidthInTbsY];
            boolean availableN = NBlockAddr <= currBlockAddr;
            xN = this.xB + x2;
            yN = this.yB - 1;
            Ecb cb = ctbs.getCB(xN * this.SubWidth, yN * this.SubHeight);
            if (pps.constrained_intra_pred_flag != 0 && cb.predMode != 0) {
                availableN = false;
            }
            if (!availableN) continue;
            if (this.nAvail == 0) {
                this.firstValue = image[this.xB + x2 + (this.yB - 1) * stride];
            }
            for (int i3 = 0; i3 < 4; ++i3) {
                this.out_border[130 + x2 + i3 + 1] = image[this.xB + x2 + i3 + (this.yB - 1) * stride];
                this.available[130 + x2 + i3 + 1] = availableN;
            }
            this.nAvail += 4;
        }
    }

    void fill_border_samples_from_tree(HImg img, Sps sps, Pps pps, Etb tb, EtbMatrix ctbs, int cIdx) {
        this.nT = 1 << tb.log2Size;
        this.xB = tb.x;
        this.yB = tb.y;
        if (sps.chroma_format_idc != 3 && cIdx > 0) {
            this.xB >>= 1;
            this.yB >>= 1;
            this.nT >>= 1;
            if (tb.log2Size == 2) {
                this.xB = tb.parent.x >> 1;
                this.yB = tb.parent.y >> 1;
                this.nT = 4;
            }
        }
        this.cIdx = cIdx;
        this.hasLeft = true;
        this.hasTop = true;
        this.hasTopRight = true;
        this.hasTopLeft = true;
        this.preproc(img, sps, pps);
        this.fillFromCtbtree(img, sps, pps, ctbs);
        this.referenceSampleSubstitution();
    }

    private void referenceSampleSubstitution() {
        if (this.nAvail != 4 * this.nT + 1) {
            if (this.nAvail == 0) {
                Arrays.fill(this.out_border, 130 - 2 * this.nT, 130 + 2 * this.nT + 1, 0);
            } else {
                if (!this.available[130 + -2 * this.nT]) {
                    this.out_border[130 - 2 * this.nT] = this.firstValue;
                }
                int nt2 = this.nT << 1;
                for (int i2 = -2 * this.nT + 1; i2 <= nt2; ++i2) {
                    if (this.available[130 + i2]) continue;
                    this.out_border[130 + i2] = this.out_border[130 + i2 - 1];
                }
            }
        }
    }

    private void preproc(HImg img, Sps sps, Pps pps) {
        int toprightCTBTileID;
        this.SubWidth = this.cIdx == 0 ? 1 : sps.SubWidthC;
        this.SubHeight = this.cIdx == 0 ? 1 : sps.SubHeightC;
        int xBLuma = this.xB * this.SubWidth;
        int yBLuma = this.yB * this.SubHeight;
        int log2CtbSize = sps.Log2CtbSizeY;
        int picWidthInCtbs = sps.PicWidthInCtbsY;
        if (xBLuma == 0) {
            this.hasLeft = false;
            this.hasTopLeft = false;
        }
        if (yBLuma == 0) {
            this.hasTop = false;
            this.hasTopLeft = false;
            this.hasTopRight = false;
        }
        if (xBLuma + this.nT * this.SubWidth >= sps.pic_width_in_luma_samples) {
            this.hasTopRight = false;
        }
        int xCurrCtb = xBLuma >> log2CtbSize;
        int yCurrCtb = yBLuma >> log2CtbSize;
        int xLeftCtb = xBLuma - 1 >> log2CtbSize;
        int xRightCtb = xBLuma + this.nT * this.SubWidth >> log2CtbSize;
        int yTopCtb = yBLuma - 1 >> log2CtbSize;
        int currCTBSlice = img.getSliceAddrRS(xCurrCtb, yCurrCtb);
        int leftCTBSlice = this.hasLeft ? img.getSliceAddrRS(xLeftCtb, yCurrCtb) : -1;
        int topCTBSlice = this.hasTop ? img.getSliceAddrRS(xCurrCtb, yTopCtb) : -1;
        int toprightCTBSlice = this.hasTopRight ? img.getSliceAddrRS(xRightCtb, yTopCtb) : -1;
        int topleftCTBSlice = this.hasTopLeft ? img.getSliceAddrRS(xLeftCtb, yTopCtb) : -1;
        int currCTBTileID = pps.TileIdRS[xCurrCtb + yCurrCtb * picWidthInCtbs];
        int leftCTBTileID = this.hasLeft ? pps.TileIdRS[xLeftCtb + yCurrCtb * picWidthInCtbs] : -1;
        int topCTBTileID = this.hasTop ? pps.TileIdRS[xCurrCtb + yTopCtb * picWidthInCtbs] : -1;
        int topleftCTBTileID = this.hasTopLeft ? pps.TileIdRS[xLeftCtb + yTopCtb * picWidthInCtbs] : -1;
        int n2 = toprightCTBTileID = this.hasTopRight ? pps.TileIdRS[xRightCtb + yTopCtb * picWidthInCtbs] : -1;
        if (leftCTBSlice != currCTBSlice || leftCTBTileID != currCTBTileID) {
            this.hasLeft = false;
        }
        if (topCTBSlice != currCTBSlice || topCTBTileID != currCTBTileID) {
            this.hasTop = false;
        }
        if (topleftCTBSlice != currCTBSlice || topleftCTBTileID != currCTBTileID) {
            this.hasTopLeft = false;
        }
        if (toprightCTBSlice != currCTBSlice || toprightCTBTileID != currCTBTileID) {
            this.hasTopRight = false;
        }
        this.nBottom = img.Height - this.yB * this.SubHeight;
        this.nBottom = (this.nBottom + this.SubHeight - 1) / this.SubHeight;
        if (this.nBottom > 2 * this.nT) {
            this.nBottom = 2 * this.nT;
        }
        this.nRight = img.Width - this.xB * this.SubWidth;
        this.nRight = (this.nRight + this.SubWidth - 1) / this.SubWidth;
        if (this.nRight > 2 * this.nT) {
            this.nRight = 2 * this.nT;
        }
        this.nAvail = 0;
        int start = 130 - 2 * this.nT;
        int len = 4 * this.nT + 1;
        Arrays.fill(this.available, start, start + len, false);
    }

    void decode_intra_prediction_from_tree(HImg img, Sps sps, Pps pps, Etb tb, int[] dst, EtbMatrix ctbs, int cIdx) {
        byte intraPredMode = cIdx == 0 ? tb.intra_mode : tb.intra_mode_chroma;
        int nT = 1 << tb.log2Size;
        if (cIdx > 0 && tb.log2Size > 2 && sps.chroma_format_idc == 1) {
            nT >>= 1;
        }
        int dstStride = nT;
        boolean dstOffset = false;
        Arrays.fill(this.out_border, 0);
        this.fill_border_samples_from_tree(img, sps, pps, tb, ctbs, cIdx);
        if (sps.intra_smoothing_disabled_flag == 0 && (cIdx == 0 || sps.ChromaArrayType == 3)) {
            EIntraPred.intraPredictionSampleFiltering(sps, this.out_border, nT, cIdx, intraPredMode);
        }
        switch (intraPredMode) {
            case 0: {
                EIntraPred.intraPredictionPlanar(dst, 0, dstStride, nT, this.out_border);
                break;
            }
            case 1: {
                EIntraPred.intraPredictionDC(dst, 0, dstStride, nT, cIdx, this.out_border);
                break;
            }
            default: {
                int bit_depth = img.getBitDepth(cIdx);
                boolean disableIntraBoundaryFilter = sps.implicit_rdpcm_enabled_flag != 0 && tb.cb.cu_transquant_bypass_flag;
                this.intraPredictionAngular(dst, 0, dstStride, bit_depth, disableIntraBoundaryFilter, tb.x, tb.y, intraPredMode, nT, cIdx, this.out_border);
            }
        }
    }

    private static void intraPredictionSampleFiltering(Sps sps, int[] p2, int nT, int cIdx, int intraPredMode) {
        boolean filterFlag = false;
        if (intraPredMode == 1 || nT == 4) {
            filterFlag = false;
        } else {
            int minDistVerHor = Math.min(Math.abs(intraPredMode - 26), Math.abs(intraPredMode - 10));
            switch (nT) {
                case 8: {
                    filterFlag = minDistVerHor > 7;
                    break;
                }
                case 16: {
                    filterFlag = minDistVerHor > 1;
                    break;
                }
                case 32: {
                    boolean bl2 = filterFlag = minDistVerHor > 0;
                }
            }
        }
        if (filterFlag) {
            boolean biIntFlag = sps.strong_intra_smoothing_enabled_flag != 0 && cIdx == 0 && nT == 32 && Math.abs(p2[130] + p2[194] - 2 * p2[162]) < 1 << sps.BitDepthY - 5 && Math.abs(p2[130] + p2[66] - 2 * p2[98]) < 1 << sps.BitDepthY - 5;
            int[] pF = new int[259];
            if (biIntFlag) {
                pF[130 + -2 * nT] = p2[130 - 2 * nT];
                pF[130 + 2 * nT] = p2[130 + 2 * nT];
                pF[130] = p2[130];
                for (int i2 = 1; i2 <= 63; ++i2) {
                    pF[130 - i2] = p2[130] + (i2 * (p2[66] - p2[130]) + 32 >> 6);
                    pF[130 + i2] = p2[130] + (i2 * (p2[194] - p2[130]) + 32 >> 6);
                }
            } else {
                pF[130 + -2 * nT] = p2[130 - 2 * nT];
                pF[130 + 2 * nT] = p2[130 + 2 * nT];
                int max = 2 * nT - 1;
                for (int i3 = -(2 * nT - 1); i3 <= max; ++i3) {
                    pF[130 + i3] = p2[130 + i3 + 1] + 2 * p2[130 + i3] + p2[130 + i3 - 1] + 2 >> 2;
                }
            }
            System.arraycopy(pF, 130 - 2 * nT, p2, 130 - 2 * nT, 4 * nT + 1);
        }
    }

    private static void intraPredictionPlanar(int[] dst, int dstOffset, int dstStride, int nT, int[] p2) {
        int Log2_nT = HeicMath.log2(nT);
        for (int y2 = 0; y2 < nT; ++y2) {
            for (int x2 = 0; x2 < nT; ++x2) {
                dst[dstOffset + x2 + y2 * dstStride] = (nT - 1 - x2) * p2[129 - y2] + (x2 + 1) * p2[131 + nT] + (nT - 1 - y2) * p2[131 + x2] + (y2 + 1) * p2[129 - nT] + nT >> Log2_nT + 1;
            }
        }
    }

    private static void intraPredictionDC(int[] dst, int dstOffset, int dstStride, int nT, int cIdx, int[] p2) {
        int y2;
        int Log2_nT = HeicMath.log2(nT);
        int dcVal = 0;
        for (int i2 = 0; i2 < nT; ++i2) {
            dcVal += p2[130 + i2 + 1];
            dcVal += p2[130 - i2 - 1];
        }
        dcVal += nT;
        dcVal >>= Log2_nT + 1;
        if (cIdx == 0 && nT < 32) {
            dst[dstOffset] = p2[129] + 2 * dcVal + p2[131] + 2 >> 2;
            for (int x2 = 1; x2 < nT; ++x2) {
                dst[dstOffset + x2] = p2[130 + x2 + 1] + 3 * dcVal + 2 >> 2;
            }
            for (y2 = 1; y2 < nT; ++y2) {
                dst[dstOffset + y2 * dstStride] = p2[130 - y2 - 1] + 3 * dcVal + 2 >> 2;
            }
            for (y2 = 1; y2 < nT; ++y2) {
                for (int x3 = 1; x3 < nT; ++x3) {
                    dst[dstOffset + x3 + y2 * dstStride] = dcVal;
                }
            }
        } else {
            for (y2 = 0; y2 < nT; ++y2) {
                for (int x4 = 0; x4 < nT; ++x4) {
                    dst[dstOffset + x4 + y2 * dstStride] = dcVal;
                }
            }
        }
    }

    private void intraPredictionAngular(int[] dst, int dstOffset, int dstStride, int bit_depth, boolean disableIntraBoundaryFilter, int xB0, int yB0, int intraPredMode, int nT, int cIdx, int[] p2) {
        block20: {
            int x2;
            int intraPredAngle;
            block19: {
                int y2;
                int x3;
                Arrays.fill(this.refAng, 0);
                intraPredAngle = Type.INTRA_PRED_ANGLES[intraPredMode];
                if (intraPredMode < 18) break block19;
                for (x3 = 0; x3 <= nT; ++x3) {
                    this.refAng[130 + x3] = p2[130 + x3];
                }
                if (intraPredAngle < 0) {
                    int invAngle = Type.INV_ANGLES[intraPredMode - 11];
                    if (nT * intraPredAngle >> 5 < -1) {
                        for (int x4 = nT * intraPredAngle >> 5; x4 <= -1; ++x4) {
                            int xx = x4 * invAngle + 128 >> 8;
                            this.refAng[130 + x4] = p2[130 - xx];
                        }
                    }
                } else {
                    for (x3 = nT + 1; x3 <= 2 * nT; ++x3) {
                        this.refAng[130 + x3] = p2[130 + x3];
                    }
                }
                for (y2 = 0; y2 < nT; ++y2) {
                    for (int x5 = 0; x5 < nT; ++x5) {
                        int iIdx = (y2 + 1) * intraPredAngle >> 5;
                        int iFact = (y2 + 1) * intraPredAngle & 0x1F;
                        dst[dstOffset + x5 + y2 * dstStride] = iFact != 0 ? (32 - iFact) * this.refAng[130 + x5 + iIdx + 1] + iFact * this.refAng[130 + x5 + iIdx + 2] + 16 >> 5 : this.refAng[130 + x5 + iIdx + 1];
                    }
                }
                if (intraPredMode != 26 || cIdx != 0 || nT >= 32 || disableIntraBoundaryFilter) break block20;
                for (y2 = 0; y2 < nT; ++y2) {
                    dst[dstOffset + 0 + y2 * dstStride] = HeicMath.clipBitDepth(p2[131] + (p2[129 - y2] - p2[130] >> 1), bit_depth);
                }
                break block20;
            }
            for (x2 = 0; x2 <= nT; ++x2) {
                this.refAng[130 + x2] = p2[130 - x2];
            }
            if (intraPredAngle < 0) {
                int invAngle = Type.INV_ANGLES[intraPredMode - 11];
                if (nT * intraPredAngle >> 5 < -1) {
                    for (int x6 = nT * intraPredAngle >> 5; x6 <= -1; ++x6) {
                        int xx = x6 * invAngle + 128 >> 8;
                        this.refAng[130 + x6] = p2[130 + xx];
                    }
                }
            } else {
                for (x2 = nT + 1; x2 <= 2 * nT; ++x2) {
                    this.refAng[130 + x2] = p2[130 - x2];
                }
            }
            for (int y3 = 0; y3 < nT; ++y3) {
                for (int x7 = 0; x7 < nT; ++x7) {
                    int iIdx = (x7 + 1) * intraPredAngle >> 5;
                    int iFact = (x7 + 1) * intraPredAngle & 0x1F;
                    dst[dstOffset + x7 + y3 * dstStride] = iFact != 0 ? (32 - iFact) * this.refAng[130 + y3 + iIdx + 1] + iFact * this.refAng[130 + y3 + iIdx + 2] + 16 >> 5 : this.refAng[130 + y3 + iIdx + 1];
                }
            }
            if (intraPredMode == 10 && cIdx == 0 && nT < 32 && !disableIntraBoundaryFilter) {
                for (int x8 = 0; x8 < nT; ++x8) {
                    dst[dstOffset + x8] = HeicMath.clipBitDepth(p2[129] + (p2[131 + x8] - p2[130] >> 1), bit_depth);
                }
            }
        }
    }

    int find_intra_pred_mode(int mode, int[] candModeList) {
        int temp;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (candModeList[i2] != mode) continue;
            return i2;
        }
        if (candModeList[0] > candModeList[1]) {
            temp = candModeList[0];
            candModeList[0] = candModeList[1];
            candModeList[1] = temp;
        }
        if (candModeList[0] > candModeList[2]) {
            temp = candModeList[0];
            candModeList[0] = candModeList[2];
            candModeList[2] = temp;
        }
        if (candModeList[1] > candModeList[2]) {
            temp = candModeList[1];
            candModeList[1] = candModeList[2];
            candModeList[2] = temp;
        }
        int intraMode = mode;
        for (int i3 = 2; i3 >= 0; --i3) {
            if (intraMode < candModeList[i3]) continue;
            --intraMode;
        }
        return -intraMode - 1;
    }
}

