/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.bmp;

import com.idrsolutions.image.Encoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.bmp.options.BmpEncoderOptions;
import com.idrsolutions.image.encoder.options.EncoderOptions;
import com.idrsolutions.image.png.data.BitWriter;
import com.idrsolutions.image.util.ImageUtils;
import com.idrsolutions.image.utility.BitReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BmpEncoder
extends JDeliImage
implements Encoder {
    private BmpEncoderOptions bmpEncoderOptions = new BmpEncoderOptions();

    public BmpEncoder(EncoderOptions format) {
        if (format != null) {
            this.bmpEncoderOptions = (BmpEncoderOptions)format;
        }
    }

    public BmpEncoder() {
    }

    public BmpEncoderOptions getEncoderOptions() {
        return this.bmpEncoderOptions;
    }

    @Override
    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        int ih;
        int iw;
        BufferedImage imageToCompress = ImageUtils.fixSubBufferedImage(image);
        BufferedImage test = BmpEncoder.testIndexed(imageToCompress, iw = imageToCompress.getWidth(), ih = imageToCompress.getHeight());
        if (test != null) {
            imageToCompress = test;
        }
        int bps = BmpEncoder.getBPS(imageToCompress);
        int rowSize = (iw * bps + 31) / 32 * 4;
        int pixArrayLen = rowSize * ih;
        BmpEncoder.putLe16(outputStream, 19778);
        BmpEncoder.putLe32(outputStream, pixArrayLen + 54);
        BmpEncoder.putLe32(outputStream, 0);
        int offset = 54;
        int padding = 0;
        int nCol = 1 << bps;
        int type = imageToCompress.getType();
        if (type == 13 || type == 12 || type == 10) {
            nCol = image.getColorModel().getClass() == IndexColorModel.class ? ((IndexColorModel)image.getColorModel()).getMapSize() : nCol;
            padding = nCol * 4;
            offset += padding;
        }
        BmpEncoder.putLe32(outputStream, offset);
        BmpEncoder.putLe32(outputStream, 40);
        BmpEncoder.putLe32(outputStream, iw);
        BmpEncoder.putLe32(outputStream, ih);
        BmpEncoder.putLe16(outputStream, 1);
        BmpEncoder.putLe16(outputStream, bps);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, pixArrayLen);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? nCol : 0);
        BmpEncoder.putLe32(outputStream, padding > 0 ? nCol : 0);
        if (padding > 0) {
            BmpEncoder.addPadding(imageToCompress, outputStream);
        }
        BmpEncoder.writeImage(imageToCompress, outputStream, bps, rowSize);
    }

    private static BufferedImage testIndexed(BufferedImage image, int iw, int ih) {
        int nComp = image.getColorModel().getNumComponents();
        int p2 = 0;
        int a10 = 255;
        int cp = 0;
        int count = 0;
        int dim = iw * ih;
        int[] countMap = new int[256];
        byte[] cpArr = new byte[dim];
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 7: {
                byte[] pixBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < dim; ++i2) {
                    int hasInd;
                    if (nComp == 4) {
                        a10 = pixBytes[p2++] & 0xFF;
                    }
                    int b2 = pixBytes[p2++] & 0xFF;
                    int g2 = pixBytes[p2++] & 0xFF;
                    int r2 = pixBytes[p2++] & 0xFF;
                    int v2 = a10 << 24 | r2 << 16 | g2 << 8 | b2;
                    if (count < 255) {
                        hasInd = -1;
                        int ii = count + 1;
                        for (int j2 = 0; j2 < ii; ++j2) {
                            if (countMap[j2] != v2) continue;
                            hasInd = j2;
                            break;
                        }
                        if (hasInd == -1) {
                            countMap[count] = v2;
                            hasInd = count++;
                        }
                    } else {
                        return null;
                    }
                    cpArr[cp++] = (byte)hasInd;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < dim; ++i3) {
                    int hasInd;
                    int v3 = pixInts[i3];
                    if (count < 255) {
                        hasInd = -1;
                        int ii = count + 1;
                        for (int j3 = 0; j3 < ii; ++j3) {
                            if (countMap[j3] != v3) continue;
                            hasInd = j3;
                            break;
                        }
                        if (hasInd == -1) {
                            countMap[count] = v3;
                            hasInd = count++;
                        }
                    } else {
                        return null;
                    }
                    cpArr[cp++] = (byte)hasInd;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return BmpEncoder.getOptimizedImage(iw, ih, count, nComp, countMap, cpArr);
    }

    private static BufferedImage getOptimizedImage(int iw, int ih, int nColors, int nComp, int[] countMap, byte[] cpArr) {
        int[] palette = new int[nColors];
        System.arraycopy(countMap, 0, palette, 0, nColors);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BitWriter bw = new BitWriter(bos);
        int bps = BmpEncoder.getAvailableBps(nColors);
        int paletteLen = 1 << bps;
        int gap = 8 - iw * bps % 8;
        int cp = 0;
        for (int y2 = 0; y2 < ih; ++y2) {
            for (int x2 = 0; x2 < iw; ++x2) {
                bw.writeBits(cpArr[cp++], bps);
            }
            if (gap == 8) continue;
            bw.writeBits(0, gap);
        }
        bw.end();
        byte[] aa2 = new byte[paletteLen];
        byte[] rr = new byte[paletteLen];
        byte[] gg = new byte[paletteLen];
        byte[] bb2 = new byte[paletteLen];
        for (int i2 = 0; i2 < nColors; ++i2) {
            int v2 = palette[i2];
            aa2[i2] = (byte)(v2 >> 24 & 0xFF);
            rr[i2] = (byte)(v2 >> 16 & 0xFF);
            gg[i2] = (byte)(v2 >> 8 & 0xFF);
            bb2[i2] = (byte)(v2 & 0xFF);
        }
        IndexColorModel cm = nComp == 4 ? new IndexColorModel(bps, paletteLen, rr, gg, bb2, aa2) : new IndexColorModel(bps, paletteLen, rr, gg, bb2);
        BufferedImage img = bps <= 4 ? new BufferedImage(iw, ih, 12, cm) : new BufferedImage(iw, ih, 13, cm);
        byte[] dd = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        System.arraycopy(bos.toByteArray(), 0, dd, 0, dd.length);
        return img;
    }

    private static int getAvailableBps(int nColors) {
        switch (nColors) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        if (nColors <= 16) {
            return 4;
        }
        return 8;
    }

    private static void writeImage(BufferedImage image, OutputStream os, int bps, int rowSize) throws IOException {
        switch (image.getType()) {
            case 12: {
                BmpEncoder.encodeBinary(image, bps, os);
                break;
            }
            case 10: 
            case 13: {
                BmpEncoder.encodeGrayOrIndexed(image, os, rowSize);
                break;
            }
            case 5: {
                BmpEncoder.encodeBYTE_BGR(image, os, rowSize);
                break;
            }
            case 6: 
            case 7: {
                BmpEncoder.encodeBYTE_ABGR(image, os);
                break;
            }
            case 4: {
                BmpEncoder.encodeINT_BGR(image, os, rowSize);
                break;
            }
            case 1: {
                BmpEncoder.encodeINT_RGB(image, os, rowSize);
                break;
            }
            case 2: 
            case 3: {
                BmpEncoder.encodeINT_ARGB(image, os);
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                converted.getGraphics().drawImage(image, 0, 0, null);
                BmpEncoder.encodeBYTE_BGR(converted, os, rowSize);
            }
        }
    }

    private static void addPadding(BufferedImage image, OutputStream outputStream) throws IOException {
        switch (image.getType()) {
            case 10: {
                for (int i2 = 0; i2 < 256; ++i2) {
                    byte v2 = (byte)i2;
                    outputStream.write(new byte[]{v2, v2, v2, -1});
                }
                break;
            }
            case 12: 
            case 13: {
                IndexColorModel icm = (IndexColorModel)image.getColorModel();
                int nCols = icm.getMapSize();
                byte[] r2 = new byte[nCols];
                byte[] g2 = new byte[nCols];
                byte[] b2 = new byte[nCols];
                byte[] a10 = new byte[nCols];
                icm.getReds(r2);
                icm.getGreens(g2);
                icm.getBlues(b2);
                icm.getAlphas(a10);
                for (int i3 = 0; i3 < nCols; ++i3) {
                    outputStream.write(new byte[]{b2[i3], g2[i3], r2[i3], a10[i3]});
                }
                break;
            }
            default: {
                for (int i4 = 0; i4 < 256; ++i4) {
                    outputStream.write(new byte[]{(byte)i4, (byte)i4, (byte)i4, -1});
                }
            }
        }
    }

    private static void encodeBinary(BufferedImage image, int bps, OutputStream os) {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int iw = image.getWidth();
        int ih = image.getHeight();
        int rowSize8 = (iw * bps + 31) / 32 * 4 * 8;
        int iwx = rowSize8 - iw * bps;
        BitReader br2 = new BitReader(pix);
        BitWriter bw = new BitWriter(os);
        int buf8 = (iw * bps + 7) / 8;
        for (int y2 = ih - 1; y2 >= 0; --y2) {
            br2.moovBoundary(buf8 * y2);
            for (int x2 = 0; x2 < iw; ++x2) {
                bw.writeBits(br2.readBits(bps), bps);
            }
            for (int i2 = 0; i2 < iwx; ++i2) {
                bw.writeBits(0, 1);
            }
        }
        bw.end();
    }

    private static void encodeGrayOrIndexed(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int balance = rowSize - image.getWidth();
        for (int y2 = image.getHeight() - 1; y2 >= 0; --y2) {
            int p2 = y2 * image.getWidth();
            int xx = image.getWidth();
            for (int x2 = 0; x2 < xx; ++x2) {
                os.write(pix[p2++] & 0xFF);
            }
            for (int i2 = 0; i2 < balance; ++i2) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_BGR(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y2 = image.getHeight() - 1; y2 >= 0; --y2) {
            int p2 = y2 * image.getWidth() * 3;
            int xx = image.getWidth();
            for (int x2 = 0; x2 < xx; ++x2) {
                os.write(pix[p2++] & 0xFF);
                os.write(pix[p2++] & 0xFF);
                os.write(pix[p2++] & 0xFF);
            }
            for (int i2 = 0; i2 < pad; ++i2) {
                os.write(0);
            }
        }
    }

    private static void encodeBYTE_ABGR(BufferedImage image, OutputStream os) throws IOException {
        byte[] pix = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int iw = image.getWidth();
        int ih = image.getHeight();
        for (int y2 = ih - 1; y2 >= 0; --y2) {
            int p2 = y2 * iw * 4;
            for (int x2 = 0; x2 < iw; ++x2) {
                os.write(pix[p2 + 1] & 0xFF);
                os.write(pix[p2 + 2] & 0xFF);
                os.write(pix[p2 + 3] & 0xFF);
                os.write(pix[p2] & 0xFF);
                p2 += 4;
            }
        }
    }

    private static void encodeINT_BGR(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y2 = image.getHeight() - 1; y2 >= 0; --y2) {
            int p2 = y2 * image.getWidth();
            int xx = image.getWidth();
            for (int x2 = 0; x2 < xx; ++x2) {
                int t2 = pix[p2++];
                os.write(t2 >> 16 & 0xFF);
                os.write(t2 >> 8 & 0xFF);
                os.write(t2 & 0xFF);
            }
            for (int i2 = 0; i2 < pad; ++i2) {
                os.write(0);
            }
        }
    }

    private static void encodeINT_RGB(BufferedImage image, OutputStream os, int rowSize) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pad = rowSize > image.getWidth() * 3 ? rowSize - image.getWidth() * 3 : 0;
        for (int y2 = image.getHeight() - 1; y2 >= 0; --y2) {
            int p2 = y2 * image.getWidth();
            int xx = image.getWidth();
            for (int x2 = 0; x2 < xx; ++x2) {
                int t2 = pix[p2++];
                os.write(t2 & 0xFF);
                os.write(t2 >> 8 & 0xFF);
                os.write(t2 >> 16 & 0xFF);
            }
            for (int i2 = 0; i2 < pad; ++i2) {
                os.write(0);
            }
        }
    }

    private static void encodeINT_ARGB(BufferedImage image, OutputStream os) throws IOException {
        int[] pix = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y2 = image.getHeight() - 1; y2 >= 0; --y2) {
            int p2 = y2 * image.getWidth();
            int xx = image.getWidth();
            for (int x2 = 0; x2 < xx; ++x2) {
                int t2 = pix[p2++];
                os.write(t2 & 0xFF);
                os.write(t2 >> 8 & 0xFF);
                os.write(t2 >> 16 & 0xFF);
                os.write(t2 >> 24 & 0xFF);
            }
        }
    }

    private static void putLe16(OutputStream os, int v2) throws IOException {
        os.write(v2 & 0xFF);
        os.write(v2 >> 8 & 0xFF);
    }

    private static void putLe32(OutputStream os, int v2) throws IOException {
        os.write(v2 & 0xFF);
        os.write(v2 >> 8 & 0xFF);
        os.write(v2 >> 16 & 0xFF);
        os.write(v2 >> 24 & 0xFF);
    }

    private static int getBPS(BufferedImage image) {
        switch (image.getType()) {
            case 12: {
                return image.getColorModel().getPixelSize();
            }
            case 10: 
            case 13: {
                return 8;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 32;
            }
        }
        return 24;
    }
}

