/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.bmp;

import com.idrsolutions.image.Decoder;
import com.idrsolutions.image.JDeliImage;
import com.idrsolutions.image.utility.BitReader;
import com.idrsolutions.image.utility.BmpInfo;
import com.idrsolutions.image.utility.DataByteLittle;
import com.idrsolutions.image.utility.DataFileLittle;
import com.idrsolutions.image.utility.DataReader;
import com.idrsolutions.image.utility.ToolARGB;
import com.idrsolutions.image.utility.ToolBinary;
import com.idrsolutions.image.utility.ToolGray;
import com.idrsolutions.image.utility.ToolIndex;
import com.idrsolutions.image.utility.ToolRGB;
import com.idrsolutions.image.utility.Tooler;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;

public class BmpDecoder
extends JDeliImage
implements Decoder {
    private static final int TYPE_BM = 19778;
    private static final int TYPE_BA = 16706;
    private static final int TYPE_CI = 18755;
    private static final int TYPE_CP = 20547;
    private static final int TYPE_IC = 17225;
    private static final int TYPE_PT = 21584;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;
    private static final int BI_JPEG = 4;
    private static final int BI_PNG = 5;
    private static final int BI_BI_ALPHABITFIELDS = 6;
    private static final int BI_CMYK = 11;
    private static final int BI_CMYKRLE8 = 12;
    private static final int BI_CMYKRLE4 = 13;

    @Override
    public BufferedImage read(byte[] bmpData) throws IOException {
        DataByteLittle reader = new DataByteLittle(bmpData);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        BufferedImage img = info.nPalColor == 0 ? BmpDecoder.getImageNormal(info, reader) : BmpDecoder.getImagePalette(info, reader);
        reader.close();
        return BmpDecoder.optimiseImage(img);
    }

    @Override
    public BufferedImage read(File bmpFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(bmpFile);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        BufferedImage img = info.nPalColor == 0 ? BmpDecoder.getImageNormal(info, reader) : BmpDecoder.getImagePalette(info, reader);
        reader.close();
        return BmpDecoder.optimiseImage(img);
    }

    @Override
    public Rectangle readDimension(File bmpFile) throws IOException {
        DataFileLittle reader = new DataFileLittle(bmpFile);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        reader.close();
        return new Rectangle(info.width, info.height);
    }

    @Override
    public Rectangle readDimension(byte[] bmpData) throws IOException {
        DataByteLittle reader = new DataByteLittle(bmpData);
        BmpInfo info = BmpDecoder.getBmpInfo(reader);
        return new Rectangle(info.width, info.height);
    }

    private static BmpInfo getBmpInfo(DataReader reader) throws IOException {
        BmpInfo info = new BmpInfo();
        info.type = reader.getU16();
        if (info.type == 19778 || info.type == 16706 || info.type == 18755 || info.type == 20547 || info.type == 17225 || info.type == 21584) {
            info.size = reader.getU32();
            reader.skip(4);
            info.offset = reader.getU32();
            info.headerSize = reader.getU32();
            info.width = reader.getU32();
            info.height = reader.getU32();
            if (info.width < 0) {
                info.hFlip = true;
                info.width = Math.abs(info.width);
            }
            if (info.height < 0) {
                info.vFlip = true;
                info.height = Math.abs(info.height);
            }
            info.nPlane = reader.getU16();
            info.bpp = reader.getU16();
            info.compress = reader.getU32();
            info.rawSize = reader.getU32();
            info.hRes = reader.getU32();
            info.vRes = reader.getU32();
            info.nPalColor = reader.getU32();
            info.nImpColor = reader.getU32();
            if (info.compress == 3) {
                info.maskR = reader.getU32();
                info.maskG = reader.getU32();
                info.maskB = reader.getU32();
                info.maskA = reader.getU32();
            }
        } else {
            throw new IOException("Invalid BMP File");
        }
        return info;
    }

    private static BufferedImage getImageNormal(BmpInfo info, DataReader reader) throws IOException {
        reader.moveTo(info.offset);
        switch (info.compress) {
            case 0: {
                return BmpDecoder.getFromRGB(info, reader);
            }
            case 3: {
                return BmpDecoder.getFromBITFIELDS(info, reader);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                throw new IOException("Current compression mode not yet supported");
            }
        }
        return null;
    }

    private static BufferedImage getFromRGB(BmpInfo info, DataReader reader) throws IOException {
        switch (info.bpp) {
            case 1: 
            case 2: 
            case 4: {
                return BmpDecoder.handleUpto8Bit(info, reader);
            }
            case 8: {
                return BmpDecoder.handle8Bit(info, reader);
            }
            case 24: {
                return BmpDecoder.handle24Bit(info, reader);
            }
            case 32: {
                return BmpDecoder.handle32Bit(info, reader);
            }
        }
        return null;
    }

    private static BufferedImage handle32Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolARGB tool = new ToolARGB(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                int v2 = reader.getU32();
                int a10 = v2 >>> 24;
                int r2 = v2 >> 16 & 0xFF;
                int g2 = v2 >> 8 & 0xFF;
                int b2 = v2 & 0xFF;
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, a10 << 24 | r2 << 16 | g2 << 8 | b2);
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage handle24Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolRGB tool = new ToolRGB(info.width, info.height);
        int iwx = (int)(Math.ceil((double)(info.width * 24) / 32.0) * 4.0) - info.width * 3;
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                int v2 = reader.getU24();
                int r2 = v2 >> 16;
                int g2 = v2 >> 8 & 0xFF;
                int b2 = v2 & 0xFF;
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, r2 << 16 | g2 << 8 | b2);
            }
            if (iwx == 0) continue;
            for (int i2 = 0; i2 < iwx; ++i2) {
                reader.getU8();
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage handle8Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolGray tool = new ToolGray(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, reader.getU8());
            }
        }
        return tool.getBufferedImage();
    }

    private static BufferedImage handleUpto8Bit(BmpInfo info, DataReader reader) throws IOException {
        ToolBinary tool = new ToolBinary(info.width, info.height, info.bpp);
        int bitsPerLine = (info.width * info.bpp + 31) / 32 * 4;
        int dataLen = info.rawSize == 0 ? bitsPerLine * info.height : info.rawSize;
        byte[] small = new byte[dataLen];
        reader.read(small);
        int iwx = bitsPerLine * 8 - info.width * info.bpp;
        BitReader br2 = new BitReader(small);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, br2.readBits(info.bpp));
            }
            if (iwx == 0) continue;
            br2.readBits(iwx);
        }
        return tool.getBufferedImage();
    }

    private static int[] handleFlipped(int w2, int h2, boolean vFlipped, boolean hFlipped) {
        int heightStart = h2 - 1;
        int widthEnd = w2;
        int heightEnd = 0;
        int widthStart = 0;
        if (vFlipped) {
            heightEnd = -heightStart;
            heightStart = 0;
        }
        if (hFlipped) {
            widthStart = -widthEnd;
            widthEnd = 0;
        }
        return new int[]{heightStart, heightEnd, widthStart, widthEnd};
    }

    private static BufferedImage getFromBITFIELDS(BmpInfo info, DataReader reader) throws IOException {
        long[] mv = new long[]{info.maskA, info.maskR, info.maskG, info.maskB};
        long[] ls = new long[4];
        long[] rs = new long[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            long v2 = mv[i2];
            if (v2 == 0L) continue;
            while ((v2 & 1L) == 0L) {
                v2 >>>= 1;
                int n2 = i2;
                rs[n2] = rs[n2] + 1L;
            }
            v2 = mv[i2];
            while ((v2 >> 31 & 1L) == 0L) {
                v2 <<= 1;
                int n3 = i2;
                ls[n3] = ls[n3] + 1L;
            }
            int n4 = i2;
            ls[n4] = ls[n4] % 8L;
        }
        Tooler tool = null;
        switch (info.bpp) {
            case 16: {
                tool = BmpDecoder.handle16bit(info, reader, ls, rs);
                break;
            }
            case 24: {
                tool = BmpDecoder.handle24Bit(info, reader, ls, rs);
                break;
            }
            case 32: {
                tool = BmpDecoder.handle32Bit(info, reader, ls, rs);
                break;
            }
        }
        if (tool == null) {
            return null;
        }
        return tool.getBufferedImage();
    }

    private static Tooler handle32Bit(BmpInfo info, DataReader reader, long[] ls, long[] rs) throws IOException {
        ToolARGB tool = new ToolARGB(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                int v2 = reader.getU32();
                int r2 = (v2 & info.maskR) >>> (int)rs[1] << (int)ls[1];
                int g2 = (v2 & info.maskG) >>> (int)rs[2] << (int)ls[2];
                int b2 = (v2 & info.maskB) >>> (int)rs[3] << (int)ls[3];
                int a10 = (v2 & info.maskA) >>> (int)rs[0] << (int)ls[0];
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, a10 << 24 | r2 << 16 | g2 << 8 | b2);
            }
        }
        return tool;
    }

    private static Tooler handle24Bit(BmpInfo info, DataReader reader, long[] ls, long[] rs) throws IOException {
        ToolRGB tool = new ToolRGB(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                int v2 = reader.getU24();
                int r2 = (v2 & info.maskR) >>> (int)rs[1] << (int)ls[1];
                int g2 = (v2 & info.maskG) >>> (int)rs[2] << (int)ls[2];
                int b2 = (v2 & info.maskB) >>> (int)rs[3] << (int)ls[3];
                int a10 = (v2 & info.maskA) >>> (int)rs[0] << (int)ls[0];
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, a10 << 24 | r2 << 16 | g2 << 8 | b2);
            }
        }
        return tool;
    }

    private static Tooler handle16bit(BmpInfo info, DataReader reader, long[] ls, long[] rs) throws IOException {
        ToolGray tool = new ToolGray(info.width, info.height);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y2 = heightStart; y2 >= heightEnd; --y2) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                int v2 = reader.getU16();
                int r2 = (v2 & info.maskR) >>> (int)rs[1] << (int)ls[1];
                int g2 = (v2 & info.maskG) >>> (int)rs[2] << (int)ls[2];
                int b2 = (v2 & info.maskB) >>> (int)rs[3] << (int)ls[3];
                int a10 = (v2 & info.maskA) >>> (int)rs[0] << (int)ls[0];
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y2 : y2, a10 << 24 | r2 << 16 | g2 << 8 | b2);
            }
        }
        return tool;
    }

    private static BufferedImage getImagePalette(BmpInfo info, DataReader reader) throws IOException {
        int nCol = (int)Math.pow(2.0, info.bpp);
        byte[] rr = new byte[nCol];
        byte[] gg = new byte[nCol];
        byte[] bb2 = new byte[nCol];
        for (int i2 = 0; i2 < info.nPalColor; ++i2) {
            bb2[i2] = (byte)reader.getU8();
            gg[i2] = (byte)reader.getU8();
            rr[i2] = (byte)reader.getU8();
            reader.getU8();
        }
        reader.moveTo(info.offset);
        int stripe = (info.width * info.bpp + 31) / 32 * 4;
        int buf8 = (info.width * info.bpp + 7) / 8;
        switch (info.bpp) {
            case 1: 
            case 2: 
            case 4: {
                IndexColorModel cm = new IndexColorModel(info.bpp, 1 << info.bpp, rr, gg, bb2);
                BufferedImage img = new BufferedImage(info.width, info.height, 12, cm);
                byte[] data = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                int dataLen = info.rawSize == 0 ? stripe * info.height : info.rawSize;
                byte[] small = new byte[dataLen];
                reader.read(small);
                int rawIdx = 0;
                for (int y2 = info.height - 1; y2 >= 0; --y2) {
                    int imgIdx = y2 * buf8;
                    System.arraycopy(small, rawIdx, data, imgIdx, buf8);
                    rawIdx += stripe;
                }
                return img;
            }
        }
        ToolIndex tool = new ToolIndex(info.width, info.height, info.bpp, rr, gg, bb2);
        int[] heightandwidth = BmpDecoder.handleFlipped(info.width, info.height, info.vFlip, info.hFlip);
        int heightStart = heightandwidth[0];
        int heightEnd = heightandwidth[1];
        int widthStart = heightandwidth[2];
        int widthEnd = heightandwidth[3];
        for (int y3 = heightStart; y3 >= heightEnd; --y3) {
            for (int x2 = widthStart; x2 < widthEnd; ++x2) {
                tool.set(info.hFlip ? -x2 : x2, info.vFlip ? -y3 : y3, reader.getU8());
            }
        }
        return tool.getBufferedImage();
    }
}

