/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.Pixel;

class Wedge {
    static final int WEDGE_HORIZONTAL = 0;
    static final int WEDGE_VERTICAL = 1;
    static final int WEDGE_OBLIQUE27 = 2;
    static final int WEDGE_OBLIQUE63 = 3;
    static final int WEDGE_OBLIQUE117 = 4;
    static final int WEDGE_OBLIQUE153 = 5;
    static final int N_WEDGE_DIRECTIONS = 8;

    Wedge() {
    }

    static void insert_border(int[] dst, int[] src, int ctr) {
        int dstPos = 0;
        int srcPos = 0;
        if (ctr > 4) {
            Pixel.set(dst, dstPos, ctr - 4);
        }
        Pixel.cpy(dst, dstPos + Math.max(ctr, 4) - 4, src, srcPos + Math.max(4 - ctr, 0), Math.min(64 - ctr, 8));
        if (ctr < 60) {
            Pixel.set(dst, dstPos + ctr + 4, 64, 60 - ctr);
        }
    }

    static void transpose(int[] dst, int dstOff, int[] src, int srcOff) {
        int y2 = 0;
        int y_off = 0;
        while (y2 < 64) {
            int x2 = 0;
            int x_off = 0;
            while (x2 < 64) {
                dst[dstOff + x_off + y2] = src[srcOff + y_off + x2];
                ++x2;
                x_off += 64;
            }
            ++y2;
            y_off += 64;
        }
    }

    static void hflip(int[] dst, int dstOff, int[] src, int srcOff) {
        int y2 = 0;
        int y_off = 0;
        while (y2 < 64) {
            for (int x2 = 0; x2 < 64; ++x2) {
                dst[dstOff + y_off + 64 - 1 - x2] = src[srcOff + y_off + x2];
            }
            ++y2;
            y_off += 64;
        }
    }

    static void invert(int[] dst, int dstOff, int[] src, int srcOff, int w2, int h2) {
        int y2 = 0;
        int y_off = 0;
        while (y2 < h2) {
            for (int x2 = 0; x2 < w2; ++x2) {
                dst[dstOff + y_off + x2] = 64 - src[srcOff + y_off + x2];
            }
            ++y2;
            y_off += w2;
        }
    }

    static void copy2d(int[] dst, int dstPos, int[] src, int srcPos, int sign, int w2, int h2, int x_off, int y_off) {
        srcPos += y_off * 64 + x_off;
        if (sign != 0) {
            for (int y2 = 0; y2 < h2; ++y2) {
                for (int x2 = 0; x2 < w2; ++x2) {
                    dst[dstPos + x2] = 64 - src[srcPos + x2];
                }
                srcPos += 64;
                dstPos += w2;
            }
        } else {
            for (int y3 = 0; y3 < h2; ++y3) {
                Pixel.cpy(dst, dstPos, src, srcPos, w2);
                srcPos += 64;
                dstPos += w2;
            }
        }
    }
}

