/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.Av1;
import com.idrsolutions.image.avif.data.Frame;
import com.idrsolutions.image.avif.data.GBit;
import com.idrsolutions.image.avif.data.Sequence;
import com.idrsolutions.image.avif.data.Thread;

class Obu {
    String obuName;
    int obuValue;
    static final int EINVAL = 22;
    static final int ENOENT = 2;

    Obu() {
    }

    static final int DAV1D_ERR(int e2) {
        return -e2;
    }

    static int check_trailing_bits(GBit gb, int strict_std_compliance) {
        int size;
        int trailing_one_bit = gb.get_bit();
        if (strict_std_compliance == 0) {
            return 0;
        }
        if (trailing_one_bit == 0 || gb.state != 0L) {
            return Obu.DAV1D_ERR(22);
        }
        for (size = gb.ptr_end - gb.ptr; size > 0 && gb.data[gb.ptr + size - 1] == 0; --size) {
        }
        if (size != 0) {
            return Obu.DAV1D_ERR(22);
        }
        return 0;
    }

    static int parse_seq_hdr(Sequence.Header hdr, GBit gb, int strictMode) {
        hdr.profile = gb.get_bits(3);
        hdr.still_picture = gb.get_bit();
        hdr.reduced_still_picture_header = gb.get_bit();
        if (hdr.reduced_still_picture_header != 0) {
            hdr.num_operating_points = 1;
            hdr.operating_points[0].major_level = gb.get_bits(3);
            hdr.operating_points[0].minor_level = gb.get_bits(2);
            hdr.operating_points[0].initial_display_delay = 10;
        } else {
            hdr.timing_info_present = gb.get_bit();
            if (hdr.timing_info_present != 0) {
                hdr.num_units_in_tick = gb.get_bits(32);
                hdr.time_scale = gb.get_bits(32);
                hdr.equal_picture_interval = gb.get_bit();
                if (hdr.equal_picture_interval != 0) {
                    int num_ticks_per_picture = gb.get_vlc();
                    hdr.num_ticks_per_picture = num_ticks_per_picture + 1;
                }
                hdr.decoder_model_info_present = gb.get_bit();
                if (hdr.decoder_model_info_present != 0) {
                    hdr.encoder_decoder_buffer_delay_length = gb.get_bits(5) + 1;
                    hdr.num_units_in_decoding_tick = gb.get_bits(32);
                    hdr.buffer_removal_delay_length = gb.get_bits(5) + 1;
                    hdr.frame_presentation_delay_length = gb.get_bits(5) + 1;
                }
            }
            hdr.display_model_info_present = gb.get_bit();
            hdr.num_operating_points = gb.get_bits(5) + 1;
            for (int i2 = 0; i2 < hdr.num_operating_points; ++i2) {
                Sequence.OperatingPoint op = hdr.operating_points[i2];
                op.idc = gb.get_bits(12);
                op.major_level = 2 + gb.get_bits(3);
                op.minor_level = gb.get_bits(2);
                if (op.major_level > 3) {
                    op.tier = gb.get_bit();
                }
                if (hdr.decoder_model_info_present != 0) {
                    op.decoder_model_param_present = gb.get_bit();
                    if (op.decoder_model_param_present != 0) {
                        Sequence.OperatingParameterInfo opi = hdr.operating_parameter_info[i2];
                        opi.decoder_buffer_delay = gb.get_bits(hdr.encoder_decoder_buffer_delay_length);
                        opi.encoder_buffer_delay = gb.get_bits(hdr.encoder_decoder_buffer_delay_length);
                        opi.low_delay_mode = gb.get_bit();
                    }
                }
                if (hdr.display_model_info_present != 0) {
                    op.display_model_param_present = gb.get_bit();
                }
                op.initial_display_delay = op.display_model_param_present != 0 ? gb.get_bits(4) + 1 : 10;
            }
        }
        hdr.width_n_bits = gb.get_bits(4) + 1;
        hdr.height_n_bits = gb.get_bits(4) + 1;
        hdr.max_width = gb.get_bits(hdr.width_n_bits) + 1;
        hdr.max_height = gb.get_bits(hdr.height_n_bits) + 1;
        if (hdr.reduced_still_picture_header == 0) {
            hdr.frame_id_numbers_present = gb.get_bit();
            if (hdr.frame_id_numbers_present != 0) {
                hdr.delta_frame_id_n_bits = gb.get_bits(4) + 2;
                hdr.frame_id_n_bits = gb.get_bits(3) + hdr.delta_frame_id_n_bits + 1;
            }
        }
        hdr.sb128 = gb.get_bit();
        hdr.filter_intra = gb.get_bit();
        hdr.intra_edge_filter = gb.get_bit();
        if (hdr.reduced_still_picture_header != 0) {
            hdr.screen_content_tools = 2;
            hdr.force_integer_mv = 2;
        } else {
            hdr.inter_intra = gb.get_bit();
            hdr.masked_compound = gb.get_bit();
            hdr.warped_motion = gb.get_bit();
            hdr.dual_filter = gb.get_bit();
            hdr.order_hint = gb.get_bit();
            if (hdr.order_hint != 0) {
                hdr.jnt_comp = gb.get_bit();
                hdr.ref_frame_mvs = gb.get_bit();
            }
            int n2 = hdr.screen_content_tools = gb.get_bit() != 0 ? 2 : gb.get_bit();
            int n3 = hdr.screen_content_tools != 0 ? (gb.get_bit() != 0 ? 2 : gb.get_bit()) : (hdr.force_integer_mv = 2);
            if (hdr.order_hint != 0) {
                hdr.order_hint_n_bits = gb.get_bits(3) + 1;
            }
        }
        hdr.super_res = gb.get_bit();
        hdr.cdef = gb.get_bit();
        hdr.restoration = gb.get_bit();
        hdr.hbd = gb.get_bit();
        if (hdr.profile == 2 && hdr.hbd != 0) {
            hdr.hbd += gb.get_bit();
        }
        if (hdr.profile != 1) {
            hdr.monochrome = gb.get_bit();
        }
        hdr.color_description_present = gb.get_bit();
        if (hdr.color_description_present != 0) {
            hdr.pri = gb.get_bits(8);
            hdr.trc = gb.get_bits(8);
            hdr.mtrx = gb.get_bits(8);
        } else {
            hdr.pri = 2;
            hdr.trc = 2;
            hdr.mtrx = 2;
        }
        if (hdr.monochrome != 0) {
            hdr.color_range = gb.get_bit();
            hdr.layout = 0;
            hdr.ss_ver = 1;
            hdr.ss_hor = 1;
            hdr.chr = 0;
        } else if (hdr.pri == 1 && hdr.trc == 13 && hdr.mtrx == 0) {
            hdr.layout = 3;
            hdr.color_range = 1;
        } else {
            hdr.color_range = gb.get_bit();
            switch (hdr.profile) {
                case 0: {
                    hdr.layout = 1;
                    hdr.ss_ver = 1;
                    hdr.ss_hor = 1;
                    break;
                }
                case 1: {
                    hdr.layout = 3;
                    break;
                }
                case 2: {
                    if (hdr.hbd == 2) {
                        hdr.ss_hor = gb.get_bit();
                        if (hdr.ss_hor != 0) {
                            hdr.ss_ver = gb.get_bit();
                        }
                    } else {
                        hdr.ss_hor = 1;
                    }
                    hdr.layout = hdr.ss_hor != 0 ? (hdr.ss_ver != 0 ? 1 : 2) : 3;
                }
            }
            int n4 = hdr.chr = hdr.ss_hor != 0 & hdr.ss_ver != 0 ? gb.get_bits(2) : 0;
        }
        if (hdr.monochrome == 0) {
            hdr.separate_uv_delta_q = gb.get_bit();
        }
        hdr.film_grain_present = gb.get_bit();
        return Obu.check_trailing_bits(gb, strictMode);
    }

    static int parse_sequence_header(Sequence.Header out, byte[] bytes, int sz) {
        GBit gb = new GBit(bytes);
        do {
            gb.get_bit();
            int type = gb.get_bits(4);
            int has_extension = gb.get_bit();
            int has_length_field = gb.get_bit();
            gb.get_bits(1 + 8 * has_extension);
            int obu_end = gb.ptr_end;
            if (has_length_field != 0) {
                int len = (int)gb.get_uleb128();
                obu_end = gb.ptr + len;
            }
            if (type == 1) {
                Obu.parse_seq_hdr(out, gb, 0);
                gb.bytealign_get_bits();
            }
            gb.ptr = obu_end;
        } while (gb.ptr < gb.ptr_end);
        return 0;
    }

    static int read_frame_size(Av1.Context c2, GBit gb, int use_ref) {
        Sequence.Header seqhdr = c2.seq_hdr;
        Frame.Header hdr = c2.frame_hdr;
        if (use_ref != 0) {
            for (int i2 = 0; i2 < 7; ++i2) {
                if (gb.get_bit() == 0) continue;
                Thread.Picture ref = c2.refs[c2.frame_hdr.refidx[i2]].p;
                hdr.width[1] = ref.p.frame_hdr.width[1];
                hdr.height = ref.p.frame_hdr.height;
                hdr.render_width = ref.p.frame_hdr.render_width;
                hdr.render_height = ref.p.frame_hdr.render_height;
                int n2 = hdr.super_res_enabled = seqhdr.super_res != 0 && gb.get_bit() != 0 ? 1 : 0;
                if (hdr.super_res_enabled != 0) {
                    int d2 = hdr.super_res_width_scale_denominator = 9 + gb.get_bits(3);
                    hdr.width[0] = Math.max((hdr.width[1] * 8 + (d2 >> 1)) / d2, Math.min(16, hdr.width[1]));
                } else {
                    hdr.super_res_width_scale_denominator = 8;
                    hdr.width[0] = hdr.width[1];
                }
                return 0;
            }
        }
        if (hdr.frame_size_override != 0) {
            hdr.width[1] = gb.get_bits(seqhdr.width_n_bits) + 1;
            hdr.height = gb.get_bits(seqhdr.height_n_bits) + 1;
        } else {
            hdr.width[1] = seqhdr.max_width;
            hdr.height = seqhdr.max_height;
        }
        int n3 = hdr.super_res_enabled = seqhdr.super_res != 0 && gb.get_bit() != 0 ? 1 : 0;
        if (hdr.super_res_enabled != 0) {
            int d3 = hdr.super_res_width_scale_denominator = 9 + gb.get_bits(3);
            hdr.width[0] = Math.max((hdr.width[1] * 8 + (d3 >> 1)) / d3, Math.min(16, hdr.width[1]));
        } else {
            hdr.super_res_width_scale_denominator = 8;
            hdr.width[0] = hdr.width[1];
        }
        hdr.have_render_size = gb.get_bit();
        if (hdr.have_render_size != 0) {
            hdr.render_width = gb.get_bits(16) + 1;
            hdr.render_height = gb.get_bits(16) + 1;
        } else {
            hdr.render_width = hdr.width[1];
            hdr.render_height = hdr.height;
        }
        return 0;
    }

    static int tile_log2(int sz, int tgt) {
        int k2 = 0;
        while (sz << k2 < tgt) {
            ++k2;
        }
        return k2;
    }

    static void parse_tile_hdr(Av1.Context c2, GBit gb) {
        int have_tile_pos;
        int n_tiles = c2.frame_hdr.tiling_cols * c2.frame_hdr.tiling_rows;
        int n2 = have_tile_pos = n_tiles > 1 ? gb.get_bit() : 0;
        if (have_tile_pos != 0) {
            int n_bits = c2.frame_hdr.tiling_log2_cols + c2.frame_hdr.tiling_log2_rows;
            c2.tile[c2.n_tile_data].start = gb.get_bits(n_bits);
            c2.tile[c2.n_tile_data].end = gb.get_bits(n_bits);
        } else {
            c2.tile[c2.n_tile_data].start = 0;
            c2.tile[c2.n_tile_data].end = n_tiles - 1;
        }
    }
}

