/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.D;

class Msac {
    static final int EC_WIN_SIZE = 8;
    static final int EC_PROB_SHIFT = 6;
    static final int EC_MIN_PROB = 4;

    Msac() {
    }

    static void ctx_refill(Context s2) {
        int c2;
        byte[] buf = s2.buf;
        int buf_pos = s2.buf_pos;
        int buf_end = s2.buf_end;
        int dif = s2.dif;
        for (c2 = 8 - s2.cnt - 24; c2 >= 0 && buf_pos < buf_end; c2 -= 8) {
            int vv = buf[buf_pos++] & 0xFF;
            dif ^= vv << c2;
        }
        s2.dif = dif;
        s2.cnt = 8 - c2 - 24;
        s2.buf_pos = buf_pos;
    }

    static void ctx_norm(Context s2, int dif, int rng) {
        int d2 = 0xF ^ (0x1F ^ D.clz(rng));
        s2.cnt -= d2;
        s2.dif = (dif + 1 << d2) - 1;
        s2.rng = rng << d2;
        if (s2.cnt < 0) {
            Msac.ctx_refill(s2);
        }
    }

    static int msac_decode_bool_equi(Context s2) {
        int dif = s2.dif;
        int r2 = s2.rng;
        int v2 = (r2 >> 8 << 7) + 4;
        int vw = v2 << -8;
        int ret = dif >= vw ? 1 : 0;
        v2 += ret * (r2 - 2 * v2);
        Msac.ctx_norm(s2, dif -= ret * vw, v2);
        return ret == 0 ? 1 : 0;
    }

    static int msac_decode_bool(Context s2, int f2) {
        int dif = s2.dif;
        int r2 = s2.rng;
        int v2 = ((r2 >> 8) * (f2 >> 6) >> 1) + 4;
        int vw = v2 << -8;
        int ret = dif >= vw ? 1 : 0;
        v2 += ret * (r2 - 2 * v2);
        Msac.ctx_norm(s2, dif -= ret * vw, v2);
        return ret == 0 ? 1 : 0;
    }

    static int inv_recenter(int r2, int v2) {
        if (v2 > r2 << 1) {
            return v2;
        }
        if ((v2 & 1) == 0) {
            return (v2 >> 1) + r2;
        }
        return r2 - (v2 + 1 >> 1);
    }

    static int msac_decode_bools(Context s2, int n2) {
        int v2 = 0;
        while (n2-- != 0) {
            v2 = v2 << 1 | Msac.msac_decode_bool_equi(s2);
        }
        return v2;
    }

    static int msac_decode_uniform(Context s2, int n2) {
        int l2 = D.ulog2(n2) + 1;
        int m2 = (1 << l2) - n2;
        int v2 = Msac.msac_decode_bools(s2, l2 - 1);
        return v2 < m2 ? v2 : (v2 << 1) - m2 + Msac.msac_decode_bool_equi(s2);
    }

    static int msac_decode_subexp(Context s2, int ref, int n2, int k2) {
        int a10 = 0;
        if (Msac.msac_decode_bool_equi(s2) != 0) {
            if (Msac.msac_decode_bool_equi(s2) != 0) {
                k2 += Msac.msac_decode_bool_equi(s2) + 1;
            }
            a10 = 1 << k2;
        }
        int v2 = Msac.msac_decode_bools(s2, k2) + a10;
        return ref * 2 <= n2 ? Msac.inv_recenter(ref, v2) : n2 - 1 - Msac.inv_recenter(n2 - 1 - ref, v2);
    }

    static int msac_decode_symbol_adapt(Context s2, int[] cdf, int n_symbols) {
        int u2;
        int c2 = s2.dif >> -8;
        int r2 = s2.rng >> 8;
        int v2 = s2.rng;
        int val = -1;
        do {
            u2 = v2;
            v2 = r2 * (cdf[++val] >> 6);
            v2 >>= 1;
        } while (c2 < (v2 += 4 * (n_symbols - val)));
        Msac.ctx_norm(s2, s2.dif - (v2 << -8), u2 - v2);
        if (s2.allow_update_cdf != 0) {
            int i2;
            int count = cdf[n_symbols];
            int rate = 4 + (count >> 4) + (n_symbols > 2 ? 1 : 0);
            for (i2 = 0; i2 < val; ++i2) {
                int n2 = i2;
                cdf[n2] = cdf[n2] + (32768 - cdf[i2] >> rate);
            }
            while (i2 < n_symbols) {
                int n3 = i2;
                cdf[n3] = cdf[n3] - (cdf[i2] >> rate);
                ++i2;
            }
            cdf[n_symbols] = count + (count < 32 ? 1 : 0);
        }
        return val;
    }

    static int msac_decode_bool_adapt(Context s2, int[] cdf) {
        int bit = Msac.msac_decode_bool(s2, cdf[0]);
        if (s2.allow_update_cdf != 0) {
            int count = cdf[1];
            int rate = 4 + (count >> 4);
            cdf[0] = bit != 0 ? cdf[0] + (32768 - cdf[0] >> rate) : cdf[0] - (cdf[0] >> rate);
            cdf[1] = count + (count < 32 ? 1 : 0);
        }
        return bit;
    }

    int msac_decode_hi_tok_c(Context s2, int[] cdf) {
        int tok_br = Msac.msac_decode_symbol_adapt(s2, cdf, 3);
        int tok = 3 + tok_br;
        if (tok_br == 3) {
            tok_br = Msac.msac_decode_symbol_adapt(s2, cdf, 3);
            tok = 6 + tok_br;
            if (tok_br == 3) {
                tok_br = Msac.msac_decode_symbol_adapt(s2, cdf, 3);
                tok = 9 + tok_br;
                if (tok_br == 3) {
                    tok = 12 + Msac.msac_decode_symbol_adapt(s2, cdf, 3);
                }
            }
        }
        return tok;
    }

    void msac_init(Context s2, byte[] data, int sz, int disable_cdf_update_flag) {
        s2.buf = data;
        s2.buf_pos = 0;
        s2.buf_end = data.length;
        s2.dif = 127;
        s2.rng = 32768;
        s2.cnt = -15;
        s2.allow_update_cdf = disable_cdf_update_flag == 0 ? 1 : 0;
        Msac.ctx_refill(s2);
    }

    static class Context {
        byte[] buf;
        int buf_pos;
        int buf_end;
        int dif;
        int cnt;
        int rng;
        int allow_update_cdf;

        Context() {
        }
    }
}

