/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.D;
import com.idrsolutions.image.avif.data.Pixel;
import com.idrsolutions.image.avif.data.Tables;

class MC {
    private static final int PREP_BIAS = 8192;

    MC() {
    }

    static void put_c(int[] dst, int dstPos, int dst_stride, int[] src, int srcPos, int src_stride, int w2, int h2) {
        do {
            Pixel.cpy(dst, dstPos, src, srcPos, w2);
            dstPos += dst_stride;
            srcPos += src_stride;
        } while (--h2 != 0);
    }

    static void prep_c(int[] tmp, int tmpPos, int[] src, int srcPos, int src_stride, int w2, int h2) {
        int intermediate_bits = D.get_intermediate_bits(255);
        do {
            for (int x2 = 0; x2 < w2; ++x2) {
                tmp[tmpPos + x2] = (src[srcPos + x2] << intermediate_bits) - 8192;
            }
            tmpPos += w2;
            srcPos += src_stride;
        } while (--h2 != 0);
    }

    static int FILTER_8TAP(int[] src, int srcPos, int x2, int[] F2, int stride) {
        return F2[0] * src[srcPos + x2 + -3 * stride] + F2[1] * src[srcPos + x2 + -2 * stride] + F2[2] * src[srcPos + x2 + -1 * stride] + F2[3] * src[srcPos + x2 + 0 * stride] + F2[4] * src[srcPos + x2 + 1 * stride] + F2[5] * src[srcPos + x2 + 2 * stride] + F2[6] * src[srcPos + x2 + 3 * stride] + F2[7] * src[srcPos + x2 + 4 * stride];
    }

    static int FILTER_8TAP_RND(int[] src, int srcPos, int x2, int[] F2, int stride, int sh) {
        return MC.FILTER_8TAP(src, srcPos, x2, F2, stride) + (1 << sh >> 1) >> sh;
    }

    static int FILTER_8TAP_RND2(int[] src, int srcPos, int x2, int[] F2, int stride, int rnd, int sh) {
        return MC.FILTER_8TAP(src, srcPos, x2, F2, stride) + rnd >> sh;
    }

    static int FILTER_8TAP_CLIP(int[] src, int srcPos, int x2, int[] F2, int stride, int sh) {
        return D.clipU8(MC.FILTER_8TAP_RND(src, srcPos, x2, F2, stride, sh));
    }

    static int FILTER_8TAP_CLIP2(int[] src, int srcPos, int x2, int[] F2, int stride, int rnd, int sh) {
        return D.clipU8(MC.FILTER_8TAP_RND2(src, srcPos, x2, F2, stride, rnd, sh));
    }

    static int[] GET_H_FILTER(int w2, int mx, int filter_type) {
        return mx == 0 ? null : (w2 > 4 ? Tables.mc_subpel_filters[filter_type & 3][mx - 1] : Tables.mc_subpel_filters[3 + (filter_type & 1)][mx - 1]);
    }

    static int[] GET_V_FILTER(int h2, int my, int filter_type) {
        return my == 0 ? null : (h2 > 4 ? Tables.mc_subpel_filters[filter_type >> 2][my - 1] : Tables.mc_subpel_filters[3 + (filter_type >> 2 & 1)][my - 1]);
    }

    static void put_8tap_c(int[] dst, int dstPos, int dst_stride, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my, int filter_type) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int intermediate_rnd = 32 + (1 << 6 - intermediate_bits >> 1);
        int[] fh = MC.GET_H_FILTER(w2, mx, filter_type);
        int[] fv = MC.GET_V_FILTER(h2, my, filter_type);
        if (fh != null && fh[0] != 0) {
            if (fv != null && fv[0] != 0) {
                int tmp_h = h2 + 7;
                int[] mid = new int[17280];
                int mid_ptr = 0;
                srcPos -= src_stride * 3;
                do {
                    for (int x2 = 0; x2 < w2; ++x2) {
                        mid[mid_ptr + x2] = MC.FILTER_8TAP_RND(src, srcPos, x2, fh, 1, 6 - intermediate_bits);
                    }
                    mid_ptr += 128;
                    srcPos += src_stride;
                } while (--tmp_h != 0);
                int[] temp = new int[mid.length + 384];
                System.arraycopy(mid, 0, temp, 0, mid.length);
                mid = temp;
                mid_ptr = 0;
                do {
                    for (int x3 = 0; x3 < w2; ++x3) {
                        dst[dstPos + x3] = MC.FILTER_8TAP_CLIP(mid, mid_ptr, x3, fv, 128, 6 + intermediate_bits);
                    }
                    mid_ptr += 128;
                    dstPos += dst_stride;
                } while (--h2 != 0);
            } else {
                do {
                    for (int x4 = 0; x4 < w2; ++x4) {
                        dst[dstPos + x4] = MC.FILTER_8TAP_CLIP2(src, srcPos, x4, fh, 1, intermediate_rnd, 6);
                    }
                    dstPos += dst_stride;
                    srcPos += src_stride;
                } while (--h2 != 0);
            }
        } else if (fv != null) {
            do {
                for (int x5 = 0; x5 < w2; ++x5) {
                    dst[dstPos + x5] = MC.FILTER_8TAP_CLIP(src, srcPos, x5, fv, src_stride, 6);
                }
                dstPos += dst_stride;
                srcPos += src_stride;
            } while (--h2 != 0);
        } else {
            MC.put_c(dst, dstPos, dst_stride, src, srcPos, src_stride, w2, h2);
        }
    }

    static void put_8tap_scaled_c(int[] dst, int dstPos, int dst_stride, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my, int dx, int dy, int filter_type) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int intermediate_rnd = 1 << intermediate_bits >> 1;
        int tmp_h = ((h2 - 1) * dy + my >> 10) + 8;
        int[] mid = new int[33664];
        int mid_ptr = 0;
        srcPos -= src_stride * 3;
        do {
            int imx = mx;
            int ioff = 0;
            for (int x2 = 0; x2 < w2; ++x2) {
                int[] fh = MC.GET_H_FILTER(imx >> 6, w2, filter_type);
                mid[mid_ptr + x2] = fh != null && fh[0] != 0 ? MC.FILTER_8TAP_RND(src, srcPos, ioff, fh, 1, 6 - intermediate_bits) : src[ioff] << intermediate_bits;
                ioff += (imx += dx) >> 10;
                imx &= 0x3FF;
            }
            mid_ptr += 128;
            srcPos += src_stride;
        } while (--tmp_h != 0);
        int[] temp = new int[mid.length + 384];
        System.arraycopy(mid, 0, temp, 0, mid.length);
        mid = temp;
        mid_ptr = 0;
        for (int y2 = 0; y2 < h2; ++y2) {
            int[] fv = MC.GET_V_FILTER(my >> 6, h2, filter_type);
            for (int x3 = 0; x3 < w2; ++x3) {
                dst[dstPos + x3] = fv != null && fv[0] != 0 ? MC.FILTER_8TAP_CLIP(mid, mid_ptr, x3, fv, 128, 6 + intermediate_bits) : D.clipU8(mid[mid_ptr + x3] + intermediate_rnd >> intermediate_bits);
            }
            mid_ptr += ((my += dy) >> 10) * 128;
            my &= 0x3FF;
            dstPos += dst_stride;
        }
    }

    static void prep_8tap_c(int[] tmp, int tmpPos, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my, int filter_type) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int[] fh = MC.GET_H_FILTER(w2, mx, filter_type);
        int[] fv = MC.GET_V_FILTER(h2, my, filter_type);
        if (fh != null && fh[0] != 0) {
            if (fv != null && fv[0] != 0) {
                int tmp_h = h2 + 7;
                int[] mid = new int[17280];
                int mid_ptr = 0;
                srcPos -= src_stride * 3;
                do {
                    for (int x2 = 0; x2 < w2; ++x2) {
                        mid[mid_ptr + x2] = MC.FILTER_8TAP_RND(src, srcPos, x2, fh, 1, 6 - intermediate_bits);
                    }
                    mid_ptr += 128;
                    srcPos += src_stride;
                } while (--tmp_h != 0);
                int[] temp = new int[mid.length + 384];
                System.arraycopy(mid, 0, temp, 0, mid.length);
                mid = temp;
                mid_ptr = 0;
                do {
                    for (int x3 = 0; x3 < w2; ++x3) {
                        int t2;
                        tmp[tmpPos + x3] = t2 = MC.FILTER_8TAP_RND(mid, mid_ptr, x3, fv, 128, 6) - 8192;
                    }
                    mid_ptr += 128;
                    tmpPos += w2;
                } while (--h2 != 0);
            } else {
                do {
                    for (int x4 = 0; x4 < w2; ++x4) {
                        tmp[tmpPos + x4] = MC.FILTER_8TAP_RND(src, srcPos, x4, fh, 1, 6 - intermediate_bits) - 8192;
                    }
                    tmpPos += w2;
                    srcPos += src_stride;
                } while (--h2 != 0);
            }
        } else if (fv != null && fv[0] != 0) {
            do {
                for (int x5 = 0; x5 < w2; ++x5) {
                    tmp[tmpPos + x5] = MC.FILTER_8TAP_RND(src, srcPos, x5, fv, src_stride, 6 - intermediate_bits) - 8192;
                }
                tmpPos += w2;
                srcPos += src_stride;
            } while (--h2 != 0);
        } else {
            MC.prep_c(tmp, tmpPos, src, srcPos, src_stride, w2, h2);
        }
    }

    static void prep_8tap_scaled_c(int[] tmp, int tmpPos, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my, int dx, int dy, int filter_type) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int tmp_h = ((h2 - 1) * dy + my >> 10) + 8;
        int[] mid = new int[33664];
        int mid_ptr = 0;
        srcPos -= src_stride * 3;
        do {
            int imx = mx;
            int ioff = 0;
            for (int x2 = 0; x2 < w2; ++x2) {
                int[] fh = MC.GET_H_FILTER(imx >> 6, w2, filter_type);
                mid[mid_ptr + x2] = fh != null && fh[0] != 0 ? MC.FILTER_8TAP_RND(src, srcPos, ioff, fh, 1, 6 - intermediate_bits) : src[ioff] << intermediate_bits;
                ioff += (imx += dx) >> 10;
                imx &= 0x3FF;
            }
            mid_ptr += 128;
            srcPos += src_stride;
        } while (--tmp_h != 0);
        int[] temp = new int[mid.length + 384];
        System.arraycopy(mid, 0, temp, 0, mid.length);
        mid = temp;
        for (int y2 = 0; y2 < h2; ++y2) {
            int[] fv = MC.GET_V_FILTER(my >> 6, h2, filter_type);
            for (int x3 = 0; x3 < w2; ++x3) {
                tmp[tmpPos + x3] = (fv != null && fv[0] != 0 ? MC.FILTER_8TAP_RND(mid, mid_ptr, x3, fv, 128, 6) : mid[mid_ptr + x3]) - 8192;
            }
            mid_ptr += ((my += dy) >> 10) * 128;
            my &= 0x3FF;
            tmpPos += w2;
        }
    }

    private static final int FILTER_BILIN(int[] src, int srcPos, int x2, int mxy, int stride) {
        return 16 * src[srcPos + x2] + mxy * (src[srcPos + x2 + stride] - src[srcPos + x2]);
    }

    private static final int FILTER_BILIN_RND(int[] src, int srcPos, int x2, int mxy, int stride, int sh) {
        return MC.FILTER_BILIN(src, srcPos, x2, mxy, stride) + (1 << sh >> 1) >> sh;
    }

    static final int FILTER_BILIN_CLIP(int[] src, int srcPos, int x2, int mxy, int stride, int sh) {
        return MC.FILTER_BILIN_RND(src, srcPos, x2, mxy, stride, sh);
    }

    static void put_bilin_c(int[] dst, int dstPos, int dst_stride, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int intermediate_rnd = 1 << intermediate_bits >> 1;
        if (mx != 0) {
            if (my != 0) {
                int x2;
                int[] mid = new int[16512];
                int mid_ptr = 0;
                int tmp_h = h2 + 1;
                do {
                    for (x2 = 0; x2 < w2; ++x2) {
                        mid[mid_ptr + x2] = MC.FILTER_BILIN_RND(src, srcPos, x2, mx, 1, 4 - intermediate_bits);
                    }
                    mid_ptr += 128;
                    srcPos += src_stride;
                } while (--tmp_h != 0);
                mid_ptr = 0;
                do {
                    for (x2 = 0; x2 < w2; ++x2) {
                        dst[dstPos + x2] = MC.FILTER_BILIN_CLIP(mid, mid_ptr, x2, my, 128, 4 + intermediate_bits);
                    }
                    mid_ptr += 128;
                    dstPos += dst_stride;
                } while (--h2 != 0);
            } else {
                do {
                    for (int x3 = 0; x3 < w2; ++x3) {
                        int px = MC.FILTER_BILIN_RND(src, srcPos, x3, mx, 1, 4 - intermediate_bits);
                        dst[dstPos + x3] = D.clipU8(px + intermediate_rnd >> intermediate_bits);
                    }
                    dstPos += dst_stride;
                    srcPos += src_stride;
                } while (--h2 != 0);
            }
        } else if (my != 0) {
            do {
                for (int x4 = 0; x4 < w2; ++x4) {
                    dst[dstPos + x4] = MC.FILTER_BILIN_CLIP(src, srcPos, x4, my, src_stride, 4);
                }
                dstPos += dst_stride;
                srcPos += src_stride;
            } while (--h2 != 0);
        } else {
            MC.put_c(dst, dstPos, dst_stride, src, srcPos, src_stride, w2, h2);
        }
    }

    static void prep_bilin_c(int[] tmp, int tmpPos, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my) {
        int intermediate_bits = D.get_intermediate_bits(255);
        if (mx != 0) {
            if (my != 0) {
                int x2;
                int[] mid = new int[16512];
                int mid_ptr = 0;
                int tmp_h = h2 + 1;
                do {
                    for (x2 = 0; x2 < w2; ++x2) {
                        mid[mid_ptr + x2] = MC.FILTER_BILIN_RND(src, srcPos, x2, mx, 1, 4 - intermediate_bits);
                    }
                    mid_ptr += 128;
                    srcPos += src_stride;
                } while (--tmp_h != 0);
                mid_ptr = 0;
                do {
                    for (x2 = 0; x2 < w2; ++x2) {
                        tmp[tmpPos + x2] = MC.FILTER_BILIN_RND(mid, mid_ptr, x2, my, 128, 4) - 8192;
                    }
                    mid_ptr += 128;
                    tmpPos += w2;
                } while (--h2 != 0);
            } else {
                do {
                    for (int x3 = 0; x3 < w2; ++x3) {
                        tmp[tmpPos + x3] = MC.FILTER_BILIN_RND(src, srcPos, x3, mx, 1, 4 - intermediate_bits) - 8192;
                    }
                    tmpPos += w2;
                    srcPos += src_stride;
                } while (--h2 != 0);
            }
        } else if (my != 0) {
            do {
                for (int x4 = 0; x4 < w2; ++x4) {
                    tmp[tmpPos + x4] = MC.FILTER_BILIN_RND(src, srcPos, x4, my, src_stride, 4 - intermediate_bits) - 8192;
                }
                tmpPos += w2;
                srcPos += src_stride;
            } while (--h2 != 0);
        } else {
            MC.prep_c(tmp, tmpPos, src, srcPos, src_stride, w2, h2);
        }
    }

    static void prep_bilin_scaled_c(int[] tmp, int tmpPos, int[] src, int srcPos, int src_stride, int w2, int h2, int mx, int my, int dx, int dy) {
        int x2;
        int intermediate_bits = D.get_intermediate_bits(255);
        int tmp_h = ((h2 - 1) * dy + my >> 10) + 2;
        int[] mid = new int[32896];
        int mid_ptr = 0;
        do {
            int imx = mx;
            int ioff = 0;
            for (x2 = 0; x2 < w2; ++x2) {
                mid[mid_ptr + x2] = MC.FILTER_BILIN_RND(src, srcPos, ioff, imx >> 6, 1, 4 - intermediate_bits);
                ioff += (imx += dx) >> 10;
                imx &= 0x3FF;
            }
            mid_ptr += 128;
            srcPos += src_stride;
        } while (--tmp_h != 0);
        mid_ptr = 0;
        do {
            for (x2 = 0; x2 < w2; ++x2) {
                tmp[tmpPos + x2] = MC.FILTER_BILIN_RND(mid, mid_ptr, x2, my >> 6, 128, 4) - 8192;
            }
            mid_ptr += ((my += dy) >> 10) * 128;
            my &= 0x3FF;
            tmpPos += w2;
        } while (--h2 != 0);
    }

    static void avg_c(int[] dst, int dstPos, int dst_stride, int[] tmp1, int tmp1Pos, int[] tmp2, int tmp2Pos, int w2, int h2) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int sh = intermediate_bits + 1;
        int rnd = (1 << intermediate_bits) + 16384;
        do {
            for (int x2 = 0; x2 < w2; ++x2) {
                dst[dstPos + x2] = D.clipU8(tmp1[tmp1Pos + x2] + tmp2[tmp2Pos + x2] + rnd >> sh);
            }
            tmp1Pos += w2;
            tmp2Pos += w2;
            dstPos += dst_stride;
        } while (--h2 != 0);
    }

    static void w_avg_c(int[] dst, int dstPos, int dst_stride, int[] tmp1, int tmp1Pos, int[] tmp2, int tmp2Pos, int w2, int h2, int weight) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int sh = intermediate_bits + 4;
        int rnd = (8 << intermediate_bits) + 131072;
        do {
            for (int x2 = 0; x2 < w2; ++x2) {
                dst[dstPos + x2] = D.clipU8(tmp1[tmp1Pos + x2] * weight + tmp2[tmp2Pos + x2] * (16 - weight) + rnd >> sh);
            }
            tmp1Pos += w2;
            tmp2Pos += w2;
            dstPos += dst_stride;
        } while (--h2 != 0);
    }

    static void mask_c(int[] dst, int dstPos, int dst_stride, int[] tmp1, int tmp1Pos, int[] tmp2, int tmp2Pos, int w2, int h2, int[] mask, int maskPos) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int sh = intermediate_bits + 6;
        int rnd = (32 << intermediate_bits) + 524288;
        do {
            for (int x2 = 0; x2 < w2; ++x2) {
                dst[dstPos + x2] = D.clipU8(tmp1[tmp1Pos + x2] * mask[maskPos + x2] + tmp2[tmp2Pos + x2] * (64 - mask[x2]) + rnd >> sh);
            }
            tmp1Pos += w2;
            tmp2Pos += w2;
            maskPos += w2;
            dstPos += dst_stride;
        } while (--h2 != 0);
    }

    private static int blend_px(int a10, int b2, int m2) {
        return a10 * (64 - m2) + b2 * m2 + 32 >> 6;
    }

    static void blend_c(int[] dst, int dstPos, int dst_stride, int[] tmp, int tmpPos, int w2, int h2, int[] mask, int maskPos) {
        do {
            for (int x2 = 0; x2 < w2; ++x2) {
                dst[dstPos + x2] = MC.blend_px(dst[dstPos + x2], tmp[tmpPos + x2], mask[maskPos + x2]);
            }
            dstPos += dst_stride;
            tmpPos += w2;
            maskPos += w2;
        } while (--h2 != 0);
    }

    static void blend_v_c(int[] dst, int dstPos, int dst_stride, int[] tmp, int tmpPos, int w2, int h2) {
        int maskPos = w2;
        int[] mask = Tables.obmc_masks;
        do {
            for (int x2 = 0; x2 < w2 * 3 >> 2; ++x2) {
                dst[dstPos + x2] = MC.blend_px(dst[dstPos + x2], tmp[tmpPos + x2], mask[maskPos + x2]);
            }
            dstPos += dst_stride;
            tmpPos += w2;
        } while (--h2 != 0);
    }

    static void blend_h_c(int[] dst, int dstPos, int dst_stride, int[] tmp, int tmpPos, int w2, int h2) {
        int maskPos = h2;
        int[] mask = Tables.obmc_masks;
        h2 = h2 * 3 >> 2;
        do {
            int m2 = mask[maskPos++];
            for (int x2 = 0; x2 < w2; ++x2) {
                dst[dstPos + x2] = MC.blend_px(dst[dstPos + x2], tmp[tmpPos + x2], m2);
            }
            dstPos += dst_stride;
            tmpPos += w2;
        } while (--h2 != 0);
    }

    static void w_mask_c(int[] dst, int dstPos, int dst_stride, int[] tmp1, int tmp1Pos, int[] tmp2, int tmp2Pos, int w2, int h2, int[] mask, int maskPos, int sign, int ss_hor, int ss_ver) {
        int intermediate_bits = D.get_intermediate_bits(255);
        int bitdepth = D.bitdepth_from_max(255);
        int sh = intermediate_bits + 6;
        int rnd = (32 << intermediate_bits) + 524288;
        int mask_sh = bitdepth + intermediate_bits - 4;
        int mask_rnd = 1 << mask_sh - 5;
        do {
            for (int x2 = 0; x2 < w2; ++x2) {
                int m2 = Math.min(38 + (Math.abs(tmp1[tmp1Pos + x2] - tmp2[tmp2Pos + x2]) + mask_rnd >> mask_sh), 64);
                dst[dstPos + x2] = D.clipU8(tmp1[tmp1Pos + x2] * m2 + tmp2[tmp2Pos + x2] * (64 - m2) + rnd >> sh);
                if (ss_hor != 0) {
                    int n2 = Math.min(38 + (Math.abs(tmp1[tmp1Pos + ++x2] - tmp2[tmp2Pos + x2]) + mask_rnd >> mask_sh), 64);
                    dst[dstPos + x2] = D.clipU8(tmp1[tmp1Pos + x2] * n2 + tmp2[tmp2Pos + x2] * (64 - n2) + rnd >> sh);
                    if (h2 != 0 & ss_ver != 0) {
                        mask[maskPos + (x2 >> 1)] = m2 + n2 + mask[maskPos + (x2 >> 1)] + 2 - sign >> 2;
                        continue;
                    }
                    if (ss_ver != 0) {
                        mask[maskPos + (x2 >> 1)] = m2 + n2;
                        continue;
                    }
                    mask[maskPos + (x2 >> 1)] = m2 + n2 + 1 - sign >> 1;
                    continue;
                }
                mask[maskPos + x2] = m2;
            }
            tmp1Pos += w2;
            tmp2Pos += w2;
            dstPos += dst_stride;
            if (ss_ver != 0 && (h2 & 1) == 0) continue;
            maskPos += w2 >> ss_hor;
        } while (--h2 != 0);
    }

    private static int FILTER_WARP_RND(int[] src, int srcPos, int x2, int[] F2, int stride, int sh) {
        return F2[0] * src[srcPos + x2 - 3 * stride] + F2[1] * src[srcPos + x2 - 2 * stride] + F2[2] * src[srcPos + x2 - 1 * stride] + F2[3] * src[srcPos + x2 + 0 * stride] + F2[4] * src[srcPos + x2 + 1 * stride] + F2[5] * src[srcPos + x2 + 2 * stride] + F2[6] * src[srcPos + x2 + 3 * stride] + F2[7] * src[srcPos + x2 + 4 * stride] + (1 << sh >> 1) >> sh;
    }

    private static int FILTER_WARP_CLIP(int[] src, int srcPos, int x2, int[] F2, int stride, int sh) {
        return D.clipU8(MC.FILTER_WARP_RND(src, srcPos, x2, F2, stride, sh));
    }

    static void warp_affine_8x8_c(int[] dst, int dstPos, int dst_stride, int[] src, int srcPos, int src_stride, int[] abcd, int mx, int my) {
        int[] filter;
        int x2;
        int intermediate_bits = D.get_intermediate_bits(255);
        int[] mid = new int[120];
        int mid_ptr = 0;
        srcPos -= 3 * src_stride;
        int y2 = 0;
        while (y2 < 15) {
            x2 = 0;
            int tmx = mx;
            while (x2 < 8) {
                filter = Tables.mc_warp_filter[64 + (tmx + 512 >> 10)];
                mid[mid_ptr + x2] = MC.FILTER_WARP_RND(src, srcPos, x2, filter, 1, 7 - intermediate_bits);
                ++x2;
                tmx += abcd[0];
            }
            srcPos += src_stride;
            mid_ptr += 8;
            ++y2;
            mx += abcd[1];
        }
        mid_ptr = 24;
        y2 = 0;
        while (y2 < 8) {
            x2 = 0;
            int tmy = my;
            while (x2 < 8) {
                filter = Tables.mc_warp_filter[64 + (tmy + 512 >> 10)];
                dst[dstPos + x2] = MC.FILTER_WARP_CLIP(mid, mid_ptr, x2, filter, 8, 7 + intermediate_bits);
                ++x2;
                tmy += abcd[2];
            }
            mid_ptr += 8;
            dstPos += dst_stride;
            ++y2;
            my += abcd[3];
        }
    }

    static void warp_affine_8x8t_c(int[] tmp, int tmpPos, int tmp_stride, int[] src, int srcPos, int src_stride, int[] abcd, int mx, int my) {
        int[] filter;
        int x2;
        int intermediate_bits = D.get_intermediate_bits(255);
        int[] mid = new int[120];
        int mid_ptr = 0;
        srcPos -= 3 * src_stride;
        int y2 = 0;
        while (y2 < 15) {
            x2 = 0;
            int tmx = mx;
            while (x2 < 8) {
                filter = Tables.mc_warp_filter[64 + (tmx + 512 >> 10)];
                mid[mid_ptr + x2] = MC.FILTER_WARP_RND(src, srcPos, x2, filter, 1, 7 - intermediate_bits);
                ++x2;
                tmx += abcd[0];
            }
            srcPos += src_stride;
            mid_ptr += 8;
            ++y2;
            mx += abcd[1];
        }
        mid_ptr = 24;
        y2 = 0;
        while (y2 < 8) {
            x2 = 0;
            int tmy = my;
            while (x2 < 8) {
                filter = Tables.mc_warp_filter[64 + (tmy + 512 >> 10)];
                tmp[tmpPos + x2] = MC.FILTER_WARP_RND(mid, mid_ptr, x2, filter, 8, 7) - 8192;
                ++x2;
                tmy += abcd[2];
            }
            mid_ptr += 8;
            tmpPos += tmp_stride;
            ++y2;
            my += abcd[3];
        }
    }

    static void resize_c(int[] dst, int dstPos, int dst_stride, int[] src, int srcPos, int src_stride, int dst_w, int h2, int src_w, int dx, int mx0) {
        do {
            int mx = mx0;
            int src_x = -1;
            for (int x2 = 0; x2 < dst_w; ++x2) {
                int[] F2 = Tables.resize_filter[mx >> 8];
                dst[dstPos + x2] = D.clipU8(-(F2[0] * src[srcPos + D.clip(src_x - 3, 0, src_w - 1)] + F2[1] * src[srcPos + D.clip(src_x - 2, 0, src_w - 1)] + F2[2] * src[srcPos + D.clip(src_x - 1, 0, src_w - 1)] + F2[3] * src[srcPos + D.clip(src_x + 0, 0, src_w - 1)] + F2[4] * src[srcPos + D.clip(src_x + 1, 0, src_w - 1)] + F2[5] * src[srcPos + D.clip(src_x + 2, 0, src_w - 1)] + F2[6] * src[srcPos + D.clip(src_x + 3, 0, src_w - 1)] + F2[7] * src[srcPos + D.clip(src_x + 4, 0, src_w - 1)]) + 64 >> 7);
                src_x += (mx += dx) >> 14;
                mx &= 0x3FFF;
            }
            dstPos += dst_stride;
            srcPos += src_stride;
        } while (--h2 != 0);
    }

    static class DSPContext {
        boolean debug;

        DSPContext() {
        }
    }
}

