/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.Av1;
import com.idrsolutions.image.avif.data.D;

class LoopFilter {
    LoopFilter() {
    }

    private static int clipU8(int x2) {
        return x2 < 0 ? 0 : Math.min(x2, 255);
    }

    private static int clip(int x2, int mn, int mx) {
        return x2 < mn ? mn : Math.min(x2, mx);
    }

    private static int clip_diff(int v2, int bitdepth_min_8) {
        return LoopFilter.clip(v2, -128 * (1 << bitdepth_min_8), 128 * (1 << bitdepth_min_8) - 1);
    }

    static void loop_filter(int[] dst, int dstPos, int E2, int I2, int H2, int stridea, int strideb, int wd) {
        int bitdepth_min_8 = D.bitdepth_from_max(255) - 8;
        int F2 = 1 << bitdepth_min_8;
        E2 <<= bitdepth_min_8;
        I2 <<= bitdepth_min_8;
        H2 <<= bitdepth_min_8;
        int i2 = 0;
        while (i2 < 4) {
            boolean fm;
            int p6 = 0;
            int p5 = 0;
            int p4 = 0;
            int p3 = 0;
            int p2 = 0;
            int p1 = dst[dstPos + strideb * -2];
            int p0 = dst[dstPos + strideb * -1];
            int q0 = dst[dstPos + strideb * 0];
            int q1 = dst[dstPos + strideb * 1];
            int q2 = 0;
            int q3 = 0;
            int q4 = 0;
            int q5 = 0;
            int q6 = 0;
            boolean flat8out = false;
            boolean flat8in = false;
            boolean bl2 = fm = Math.abs(p1 - p0) <= I2 && Math.abs(q1 - q0) <= I2 && Math.abs(p0 - q0) * 2 + (Math.abs(p1 - q1) >> 1) <= E2;
            if (wd > 4) {
                p2 = dst[dstPos + strideb * -3];
                q2 = dst[dstPos + strideb * 2];
                fm &= Math.abs(p2 - p1) <= I2 && Math.abs(q2 - q1) <= I2;
                if (wd > 6) {
                    p3 = dst[dstPos + strideb * -4];
                    q3 = dst[dstPos + strideb * 3];
                    fm &= Math.abs(p3 - p2) <= I2 && Math.abs(q3 - q2) <= I2;
                }
            }
            if (fm) {
                if (wd >= 16) {
                    p6 = dst[dstPos + strideb * -7];
                    p5 = dst[dstPos + strideb * -6];
                    p4 = dst[dstPos + strideb * -5];
                    q4 = dst[dstPos + strideb * 4];
                    q5 = dst[dstPos + strideb * 5];
                    q6 = dst[dstPos + strideb * 6];
                    boolean bl3 = flat8out = Math.abs(p6 - p0) <= F2 && Math.abs(p5 - p0) <= F2 && Math.abs(p4 - p0) <= F2 && Math.abs(q4 - q0) <= F2 && Math.abs(q5 - q0) <= F2 && Math.abs(q6 - q0) <= F2;
                }
                if (wd >= 6) {
                    boolean bl4 = flat8in = Math.abs(p2 - p0) <= F2 && Math.abs(p1 - p0) <= F2 && Math.abs(q1 - q0) <= F2 && Math.abs(q2 - q0) <= F2;
                }
                if (wd >= 8) {
                    flat8in &= Math.abs(p3 - p0) <= F2 && Math.abs(q3 - q0) <= F2;
                }
                if (wd >= 16 && flat8out & flat8in) {
                    dst[dstPos + strideb * -6] = p6 + p6 + p6 + p6 + p6 + p6 * 2 + p5 * 2 + p4 * 2 + p3 + p2 + p1 + p0 + q0 + 8 >> 4;
                    dst[dstPos + strideb * -5] = p6 + p6 + p6 + p6 + p6 + p5 * 2 + p4 * 2 + p3 * 2 + p2 + p1 + p0 + q0 + q1 + 8 >> 4;
                    dst[dstPos + strideb * -4] = p6 + p6 + p6 + p6 + p5 + p4 * 2 + p3 * 2 + p2 * 2 + p1 + p0 + q0 + q1 + q2 + 8 >> 4;
                    dst[dstPos + strideb * -3] = p6 + p6 + p6 + p5 + p4 + p3 * 2 + p2 * 2 + p1 * 2 + p0 + q0 + q1 + q2 + q3 + 8 >> 4;
                    dst[dstPos + strideb * -2] = p6 + p6 + p5 + p4 + p3 + p2 * 2 + p1 * 2 + p0 * 2 + q0 + q1 + q2 + q3 + q4 + 8 >> 4;
                    dst[dstPos + strideb * -1] = p6 + p5 + p4 + p3 + p2 + p1 * 2 + p0 * 2 + q0 * 2 + q1 + q2 + q3 + q4 + q5 + 8 >> 4;
                    dst[dstPos + strideb * 0] = p5 + p4 + p3 + p2 + p1 + p0 * 2 + q0 * 2 + q1 * 2 + q2 + q3 + q4 + q5 + q6 + 8 >> 4;
                    dst[dstPos + strideb * 1] = p4 + p3 + p2 + p1 + p0 + q0 * 2 + q1 * 2 + q2 * 2 + q3 + q4 + q5 + q6 + q6 + 8 >> 4;
                    dst[dstPos + strideb * 2] = p3 + p2 + p1 + p0 + q0 + q1 * 2 + q2 * 2 + q3 * 2 + q4 + q5 + q6 + q6 + q6 + 8 >> 4;
                    dst[dstPos + strideb * 3] = p2 + p1 + p0 + q0 + q1 + q2 * 2 + q3 * 2 + q4 * 2 + q5 + q6 + q6 + q6 + q6 + 8 >> 4;
                    dst[dstPos + strideb * 4] = p1 + p0 + q0 + q1 + q2 + q3 * 2 + q4 * 2 + q5 * 2 + q6 + q6 + q6 + q6 + q6 + 8 >> 4;
                    dst[dstPos + strideb * 5] = p0 + q0 + q1 + q2 + q3 + q4 * 2 + q5 * 2 + q6 * 2 + q6 + q6 + q6 + q6 + q6 + 8 >> 4;
                } else if (wd >= 8 && flat8in) {
                    dst[dstPos + strideb * -3] = p3 + p3 + p3 + 2 * p2 + p1 + p0 + q0 + 4 >> 3;
                    dst[dstPos + strideb * -2] = p3 + p3 + p2 + 2 * p1 + p0 + q0 + q1 + 4 >> 3;
                    dst[dstPos + strideb * -1] = p3 + p2 + p1 + 2 * p0 + q0 + q1 + q2 + 4 >> 3;
                    dst[dstPos + strideb * 0] = p2 + p1 + p0 + 2 * q0 + q1 + q2 + q3 + 4 >> 3;
                    dst[dstPos + strideb * 1] = p1 + p0 + q0 + 2 * q1 + q2 + q3 + q3 + 4 >> 3;
                    dst[dstPos + strideb * 2] = p0 + q0 + q1 + 2 * q2 + q3 + q3 + q3 + 4 >> 3;
                } else if (wd == 6 && flat8in) {
                    dst[dstPos + strideb * -2] = p2 + 2 * p2 + 2 * p1 + 2 * p0 + q0 + 4 >> 3;
                    dst[dstPos + strideb * -1] = p2 + 2 * p1 + 2 * p0 + 2 * q0 + q1 + 4 >> 3;
                    dst[dstPos + strideb * 0] = p1 + 2 * p0 + 2 * q0 + 2 * q1 + q2 + 4 >> 3;
                    dst[dstPos + strideb * 1] = p0 + 2 * q0 + 2 * q1 + 2 * q2 + q2 + 4 >> 3;
                } else {
                    int f2;
                    int f1;
                    int f3;
                    boolean hev;
                    boolean bl5 = hev = Math.abs(p1 - p0) > H2 || Math.abs(q1 - q0) > H2;
                    if (hev) {
                        f3 = LoopFilter.clip_diff(p1 - q1, bitdepth_min_8);
                        f3 = LoopFilter.clip_diff(3 * (q0 - p0) + f3, bitdepth_min_8);
                        f1 = Math.min(f3 + 4, (128 << bitdepth_min_8) - 1) >> 3;
                        f2 = Math.min(f3 + 3, (128 << bitdepth_min_8) - 1) >> 3;
                        dst[dstPos + strideb * -1] = LoopFilter.clipU8(p0 + f2);
                        dst[dstPos + strideb * 0] = LoopFilter.clipU8(q0 - f1);
                    } else {
                        f3 = LoopFilter.clip_diff(3 * (q0 - p0), bitdepth_min_8);
                        f1 = Math.min(f3 + 4, (128 << bitdepth_min_8) - 1) >> 3;
                        f2 = Math.min(f3 + 3, (128 << bitdepth_min_8) - 1) >> 3;
                        dst[dstPos + strideb * -1] = LoopFilter.clipU8(p0 + f2);
                        dst[dstPos + strideb * 0] = LoopFilter.clipU8(q0 - f1);
                        f3 = f1 + 1 >> 1;
                        dst[dstPos + strideb * -2] = LoopFilter.clipU8(p1 + f3);
                        dst[dstPos + strideb * 1] = LoopFilter.clipU8(q1 - f3);
                    }
                }
            }
            ++i2;
            dstPos += stridea;
        }
    }

    static void loop_filter_h_sb128y_c(int[] dst, int stride, int[] vmask, int[][] l2, int b4_stride, Av1.FilterLUT lut, int h2) {
        int vm = vmask[0] | vmask[1] | vmask[2];
        int dstPos = 0;
        int lPos = 0;
        int y2 = 1;
        while ((vm & ~(y2 - 1)) != 0) {
            if ((vm & y2) != 0) {
                int L2;
                int n2 = L2 = l2[lPos][0] != 0 ? l2[lPos][0] : l2[lPos - 1][0];
                if (L2 != 0) {
                    int H2 = L2 >> 4;
                    int E2 = lut.e[L2];
                    int I2 = lut.i[L2];
                    int idx = (vmask[2] & y2) != 0 ? 2 : ((vmask[1] & y2) == 0 ? 0 : 1);
                    LoopFilter.loop_filter(dst, dstPos, E2, I2, H2, stride, 1, 4 << idx);
                }
            }
            y2 <<= 1;
            dstPos += 4 * stride;
            lPos += b4_stride;
        }
    }

    static void loop_filter_v_sb128y_c(int[] dst, int stride, int[] vmask, int[][] l2, int b4_stride, Av1.FilterLUT lut, int w2) {
        int vm = vmask[0] | vmask[1] | vmask[2];
        int dstPos = 0;
        int lPos = 0;
        int x2 = 1;
        while ((vm & ~(x2 - 1)) != 0) {
            if ((vm & x2) != 0) {
                int L2;
                int n2 = L2 = l2[lPos][0] != 0 ? l2[lPos][0] : l2[lPos - b4_stride][0];
                if (L2 != 0) {
                    int H2 = L2 >> 4;
                    int E2 = lut.e[L2];
                    int I2 = lut.i[L2];
                    int idx = (vmask[2] & x2) != 0 ? 2 : ((vmask[1] & x2) == 0 ? 0 : 1);
                    LoopFilter.loop_filter(dst, dstPos, E2, I2, H2, 1, stride, 4 << idx);
                }
            }
            x2 <<= 1;
            dstPos += 4;
            ++lPos;
        }
    }

    static void loop_filter_h_sb128uv_c(int[] dst, int stride, int[] vmask, int[][] l2, int b4_stride, Av1.FilterLUT lut, int h2) {
        int vm = vmask[0] | vmask[1];
        int lPos = 0;
        int dstPos = 0;
        int y2 = 1;
        while ((vm & ~(y2 - 1)) != 0) {
            if ((vm & y2) != 0) {
                int L2;
                int n2 = L2 = l2[lPos][0] != 0 ? l2[lPos][0] : l2[lPos - 1][0];
                if (L2 != 0) {
                    int H2 = L2 >> 4;
                    int E2 = lut.e[L2];
                    int I2 = lut.i[L2];
                    int idx = (vmask[1] & y2) == 0 ? 0 : 1;
                    LoopFilter.loop_filter(dst, dstPos, E2, I2, H2, stride, 1, 4 + 2 * idx);
                }
            }
            y2 <<= 1;
            dstPos += 4 * stride;
            lPos += b4_stride;
        }
    }

    static void loop_filter_v_sb128uv_c(int[] dst, int stride, int[] vmask, int[][] l2, int b4_stride, Av1.FilterLUT lut, int w2) {
        int vm = vmask[0] | vmask[1];
        int lPos = 0;
        int dstPos = 0;
        int x2 = 1;
        while ((vm & ~(x2 - 1)) != 0) {
            if ((vm & x2) != 0) {
                int L2;
                int n2 = L2 = l2[lPos][0] != 0 ? l2[lPos][0] : l2[lPos - b4_stride][0];
                if (L2 != 0) {
                    int H2 = L2 >> 4;
                    int E2 = lut.e[L2];
                    int I2 = lut.i[L2];
                    int idx = (vmask[1] & x2) == 0 ? 0 : 1;
                    LoopFilter.loop_filter(dst, dstPos, E2, I2, H2, 1, stride, 4 + 2 * idx);
                }
            }
            x2 <<= 1;
            dstPos += 4;
            ++lPos;
        }
    }

    static class ModeRefDeltas {
        int[] mode_delta = new int[2];
        int[] ref_delta = new int[8];

        ModeRefDeltas() {
        }
    }

    static class DSPContext {
        boolean debug;

        DSPContext() {
        }
    }
}

