/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.D;
import com.idrsolutions.image.avif.data.Pixel;
import com.idrsolutions.image.avif.data.Tables;

class Ipred {
    private static final int[] foldedTable = new int[]{63, 30, 3, 32, 59, 14, 11, 33, 60, 24, 50, 9, 55, 19, 21, 34, 61, 29, 2, 53, 51, 23, 41, 18, 56, 28, 1, 43, 46, 27, 0, 35, 62, 31, 58, 4, 5, 49, 54, 6, 15, 52, 12, 40, 7, 42, 45, 16, 25, 57, 48, 13, 10, 39, 8, 44, 20, 47, 38, 22, 17, 37, 36, 26};

    Ipred() {
    }

    static int bitScanForward(long b2) {
        b2 ^= b2 - 1L;
        int folded = (int)b2 ^ (int)(b2 >>> 32);
        return foldedTable[folded * 2015959759 >>> 26];
    }

    static int ctz(long mask) {
        return Ipred.bitScanForward(mask);
    }

    static int dc_gen_top(int[] topleft, int topLeftPos, int width) {
        int dc = width >> 1;
        for (int i2 = 0; i2 < width; ++i2) {
            dc += topleft[topLeftPos + 1 + i2];
        }
        return dc >> Ipred.ctz(width);
    }

    static void splat_dc(int[] dst, int dstPos, int stride, int width, int height, int dc) {
        long dcN = (long)dc * 0x1000100010001L;
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; x2 += 4) {
                dst[dstPos + x2] = (int)dcN;
            }
            dstPos += stride;
        }
    }

    static int apply_sign(int v2, int s2) {
        return s2 < 0 ? -v2 : v2;
    }

    static void cfl_pred(int[] dst, int dstPos, int stride, int width, int height, int dc, int[] ac2, int acPos, int alpha) {
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int diff = alpha * ac2[acPos + x2];
                dst[dstPos + x2] = D.clipU8(dc + Ipred.apply_sign(Math.abs(diff) + 32 >> 6, diff));
            }
            acPos += width;
            dstPos += stride;
        }
    }

    static int dc_gen_left(int[] topleft, int topLeftPos, int height) {
        int dc = height >> 1;
        for (int i2 = 0; i2 < height; ++i2) {
            dc += topleft[topLeftPos - (1 + i2)];
        }
        return dc >> Ipred.ctz(height);
    }

    static void ipred_dc_left_c(int[] dst, int dstPos, int stride, int[] topleft, int topleftPos, int width, int height) {
        Ipred.splat_dc(dst, dstPos, stride, width, height, Ipred.dc_gen_left(topleft, topleftPos, height));
    }

    static int dc_gen(int[] topleft, int topLeftPos, int width, int height) {
        int i2;
        int dc = width + height >> 1;
        for (i2 = 0; i2 < width; ++i2) {
            dc += topleft[topLeftPos + i2 + 1];
        }
        for (i2 = 0; i2 < height; ++i2) {
            dc += topleft[topLeftPos - (i2 + 1)];
        }
        dc >>= Ipred.ctz(width + height);
        if (width != height) {
            dc *= width > height * 2 || height > width * 2 ? 26215 : 43691;
            dc >>= 17;
        }
        return dc;
    }

    static void ipred_dc_c(int[] dst, int dstPos, int stride, int[] topleft, int topLeftPos, int width, int height) {
        Ipred.splat_dc(dst, dstPos, stride, width, height, Ipred.dc_gen(topleft, topLeftPos, width, height));
    }

    static void ipred_dc_top_c(int[] dst, int dstPos, int stride, int[] topleft, int topLeftPos, int width, int height) {
        Ipred.splat_dc(dst, dstPos, stride, width, height, Ipred.dc_gen_top(topleft, topLeftPos, width));
    }

    static void ipred_dc_128_c(int[] dst, int dstPos, int stride, int[] topleft, int topLeftPos, int width, int height) {
        int dc = 128;
        Ipred.splat_dc(dst, dstPos, stride, width, height, 128);
    }

    static void ipred_cfl_top_c(int[] dst, int dstPos, int stride, int[] topleft, int topLeftPos, int width, int height, int[] ac2, int acPos, int alpha) {
        Ipred.cfl_pred(dst, dstPos, stride, width, height, Ipred.dc_gen_top(topleft, topLeftPos, width), ac2, acPos, alpha);
    }

    static void ipred_cfl_left_c(int[] dst, int dstPos, int stride, int[] topleft, int topLeftPos, int width, int height, int[] ac2, int acPos, int alpha) {
        int dc = Ipred.dc_gen_left(topleft, topLeftPos, height);
        Ipred.cfl_pred(dst, dstPos, stride, width, height, Ipred.dc_gen_top(topleft, topLeftPos, width), ac2, acPos, alpha);
    }

    static void ipred_v_c(int[] dst, int dstPos, int stride, int[] topleft, int topleftPos, int width, int height) {
        for (int y2 = 0; y2 < height; ++y2) {
            Pixel.cpy(dst, dstPos, topleft, topleftPos + 1, width);
            dstPos += stride;
        }
    }

    static void ipred_h_c(int[] dst, int dstPos, int stride, int[] topleft, int topLeftPos, int width, int height) {
        for (int y2 = 0; y2 < height; ++y2) {
            Pixel.set(dst, topleft[topLeftPos - (1 + y2)], width);
            dstPos += stride;
        }
    }

    static void ipred_paeth_c(int[] dst, int dstPos, int stride, int[] tl_ptr, int tlPos, int width, int height) {
        int topleft = tl_ptr[tlPos];
        for (int y2 = 0; y2 < height; ++y2) {
            int left = tl_ptr[-(y2 + 1)];
            for (int x2 = 0; x2 < width; ++x2) {
                int top = tl_ptr[tlPos + 1 + x2];
                int base = left + top - topleft;
                int ldiff = Math.abs(left - base);
                int tdiff = Math.abs(top - base);
                int tldiff = Math.abs(topleft - base);
                dst[dstPos + x2] = ldiff <= tdiff && ldiff <= tldiff ? left : (tdiff <= tldiff ? top : topleft);
            }
            dstPos += stride;
        }
    }

    static void ipred_smooth_c(int[] dst, int dstPos, int stride, int[] topleft, int topleftPos, int width, int height, int[][] sm_weights) {
        int[] weights_hor = sm_weights[width];
        int[] weights_ver = sm_weights[height];
        int right = topleft[width];
        int bottom = topleft[-height];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int pred = weights_ver[y2] * topleft[topleftPos + 1 + x2] + (256 - weights_ver[y2]) * bottom + weights_hor[x2] * topleft[topleftPos - (1 + y2)] + (256 - weights_hor[x2]) * right;
                dst[dstPos + x2] = pred + 256 >> 9;
            }
            dstPos += stride;
        }
    }

    static void ipred_smooth_v_c(int[] dst, int dstPos, int stride, int[] topleft, int topleftPos, int width, int height, int[][] sm_weights) {
        int[] weights_ver = sm_weights[height];
        int bottom = topleft[-height];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int pred = weights_ver[y2] * topleft[1 + x2] + (256 - weights_ver[y2]) * bottom;
                dst[dstPos + x2] = pred + 128 >> 8;
            }
            dstPos += stride;
        }
    }

    static void ipred_smooth_h_c(int[] dst, int dstPos, int stride, int[] topleft, int topleftPos, int width, int height, int[][] sm_weights) {
        int[] weights_hor = sm_weights[width];
        int right = topleft[width];
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                int pred = weights_hor[x2] * topleft[-(y2 + 1)] + (256 - weights_hor[x2]) * right;
                dst[dstPos + x2] = pred + 128 >> 8;
            }
            dstPos += stride;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int get_filter_strength(int wh, int angle, int is_sm) {
        if (is_sm != 0) {
            if (wh <= 8) {
                if (angle >= 64) {
                    return 2;
                }
                if (angle < 40) return 0;
                return 1;
            }
            if (wh <= 16) {
                if (angle >= 48) {
                    return 2;
                }
                if (angle < 20) return 0;
                return 1;
            }
            if (wh > 24) return 3;
            if (angle < 4) return 0;
            return 3;
        }
        if (wh <= 8) {
            if (angle < 56) return 0;
            return 1;
        }
        if (wh <= 16) {
            if (angle < 40) return 0;
            return 1;
        }
        if (wh <= 24) {
            if (angle >= 32) {
                return 3;
            }
            if (angle >= 16) {
                return 2;
            }
            if (angle < 8) return 0;
            return 1;
        }
        if (wh > 32) return 3;
        if (angle >= 32) {
            return 3;
        }
        if (angle < 4) return 1;
        return 2;
    }

    static void filter_edge(int[] out, int outPos, int sz, int lim_from, int lim_to, int[] inp, int inpPos, int from, int to, int strength) {
        int i2;
        byte[][] kernel = new byte[][]{{0, 4, 8, 4, 0}, {0, 5, 6, 5, 0}, {2, 4, 4, 4, 2}};
        for (i2 = 0; i2 < Math.min(sz, lim_from); ++i2) {
            out[outPos + i2] = inp[inpPos + D.clip(i2, from, to - 1)];
        }
        while (i2 < Math.min(lim_to, sz)) {
            int s2 = 0;
            for (int j2 = 0; j2 < 5; ++j2) {
                s2 += inp[inpPos + D.clip(i2 - 2 + j2, from, to - 1)] * kernel[strength - 1][j2];
            }
            out[outPos + i2] = s2 + 8 >> 4;
            ++i2;
        }
        while (i2 < sz) {
            out[outPos + i2] = inp[inpPos + D.clip(i2, from, to - 1)];
            ++i2;
        }
    }

    static int get_upsample(int wh, int angle, int is_sm) {
        return angle < 40 && wh <= 16 >> is_sm ? 1 : 0;
    }

    static void upsample_edge(int[] out, int outPos, int hsz, int[] inp, int inpPos, int froms, int toos) {
        int i2;
        byte[] kernel = new byte[]{-1, 9, 9, -1};
        for (i2 = 0; i2 < hsz - 1; ++i2) {
            out[outPos + i2 * 2] = inp[inpPos + D.clip(i2, froms, toos - 1)];
            int s2 = 0;
            for (int j2 = 0; j2 < 4; ++j2) {
                s2 += inp[inpPos + D.clip(i2 + j2 - 1, froms, toos - 1)] * kernel[j2];
            }
            out[outPos + i2 * 2 + 1] = D.clipU8(s2 + 8 >> 4);
        }
        out[outPos + i2 * 2] = inp[inpPos + D.clip(i2, froms, toos - 1)];
    }

    static void ipred_z1_c(int[] dst, int dstPos, int stride, int[] topleft, int topleftPos, int width, int height, int angle) {
        int max_base_x;
        int[] top;
        int upsample_above;
        int is_sm = angle >> 9 & 1;
        int enable_intra_edge_filter = angle >> 10;
        int dx = Tables.dr_intra_derivative[(angle &= 0x1FF) >> 1];
        int[] top_out = new int[128];
        int topPos = 0;
        int n2 = upsample_above = enable_intra_edge_filter != 0 ? Ipred.get_upsample(width + height, 90 - angle, is_sm) : 0;
        if (upsample_above != 0) {
            Ipred.upsample_edge(top_out, 0, width + height, topleft, topleftPos + 1, -1, width + Math.min(width, height));
            top = top_out;
            max_base_x = 2 * (width + height) - 2;
            dx <<= 1;
        } else {
            int filter_strength;
            int n3 = filter_strength = enable_intra_edge_filter != 0 ? Ipred.get_filter_strength(width + height, 90 - angle, is_sm) : 0;
            if (filter_strength != 0) {
                Ipred.filter_edge(top_out, 0, width + height, 0, width + height, topleft, topleftPos + 1, -1, width + Math.min(width, height), filter_strength);
                top = top_out;
                max_base_x = width + height - 1;
            } else {
                top = topleft;
                topPos = topleftPos + 1;
                max_base_x = width + Math.min(width, height) - 1;
            }
        }
        int base_inc = 1 + upsample_above;
        int y2 = 0;
        int xpos = dx;
        while (y2 < height) {
            int frac = xpos & 0x3E;
            int x2 = 0;
            int base = xpos >> 6;
            while (x2 < width) {
                if (base >= max_base_x) {
                    Pixel.set(dst, dstPos + x2, top[topPos + max_base_x], width - x2);
                    break;
                }
                int v2 = top[topPos + base] * (64 - frac) + top[topPos + base + 1] * frac;
                dst[dstPos + x2] = v2 + 32 >> 6;
                ++x2;
                base += base_inc;
            }
            ++y2;
            dstPos += stride;
            xpos += dx;
        }
    }

    static void ipred_z2_c(int[] dst, int dstPos, int stride, int[] topleft_in, int topleft_inPos, int width, int height, int angle, int max_width, int max_height) {
        int filter_strength;
        int[] edge;
        int is_sm = angle >> 9 & 1;
        int enable_intra_edge_filter = angle >> 10;
        int dy = Tables.dr_intra_derivative[(angle &= 0x1FF) - 90 >> 1];
        int dx = Tables.dr_intra_derivative[180 - angle >> 1];
        int upsample_left = enable_intra_edge_filter != 0 ? Ipred.get_upsample(width + height, 180 - angle, is_sm) : 0;
        int upsample_above = enable_intra_edge_filter != 0 ? Ipred.get_upsample(width + height, angle - 90, is_sm) : 0;
        int[] topleft = edge = new int[129];
        int topLeftPos = 0;
        if (upsample_above != 0) {
            Ipred.upsample_edge(topleft, topLeftPos, width + 1, topleft_in, topleft_inPos, 0, width + 1);
            dx <<= 1;
        } else {
            int n2 = filter_strength = enable_intra_edge_filter != 0 ? Ipred.get_filter_strength(width + height, angle - 90, is_sm) : 0;
            if (filter_strength != 0) {
                Ipred.filter_edge(topleft, topLeftPos + 1, width, 0, max_width, topleft_in, 1, -1, width, filter_strength);
            } else {
                Pixel.cpy(topleft, topLeftPos + 1, topleft_in, topleft_inPos + 1, width);
            }
        }
        if (upsample_left != 0) {
            Ipred.upsample_edge(topleft, topLeftPos + -height * 2, height + 1, topleft_in, topleft_inPos - height, 0, height + 1);
            dy <<= 1;
        } else {
            int n3 = filter_strength = enable_intra_edge_filter != 0 ? Ipred.get_filter_strength(width + height, 180 - angle, is_sm) : 0;
            if (filter_strength != 0) {
                Ipred.filter_edge(topleft, topLeftPos - height, height, height - max_height, height, topleft_in, topleft_inPos - height, 0, height + 1, filter_strength);
            } else {
                Pixel.cpy(topleft, topLeftPos - height, topleft_in, topleft_inPos - height, height);
            }
        }
        topleft = topleft_in;
        topLeftPos = topleft_inPos;
        int base_inc_x = 1 + upsample_above;
        int[] left = topleft;
        int leftPos = topLeftPos - (1 + upsample_left);
        int y2 = 0;
        int xpos = (1 + upsample_above << 6) - dx;
        while (y2 < height) {
            int base_x = xpos >> 6;
            int frac_x = xpos & 0x3E;
            int x2 = 0;
            int ypos = (y2 << 6 + upsample_left) - dy;
            while (x2 < width) {
                int v2;
                if (base_x >= 0) {
                    v2 = topleft[base_x] * (64 - frac_x) + topleft[base_x + 1] * frac_x;
                } else {
                    int base_y = ypos >> 6;
                    int frac_y = ypos & 0x3E;
                    v2 = left[leftPos - base_y] * (64 - frac_y) + left[leftPos - (base_y + 1)] * frac_y;
                }
                dst[dstPos + x2] = v2 + 32 >> 6;
                ++x2;
                base_x += base_inc_x;
                ypos -= dy;
            }
            ++y2;
            xpos -= dx;
            dstPos += stride;
        }
    }

    static void pal_pred_c(int[] dst, int dstPos, int stride, int[] pal, int[] idx, int idxPos, int w2, int h2) {
        for (int y2 = 0; y2 < h2; ++y2) {
            for (int x2 = 0; x2 < w2; x2 += 2) {
                int i2 = idx[idxPos++];
                dst[dstPos + x2] = pal[i2 & 7];
                dst[dstPos + x2 + 1] = pal[i2 >> 4];
            }
            dstPos += stride;
        }
    }

    static class DSPContext {
        DSPContext() {
        }

        static void applyPred(int predId, int[] dst, int stride, int[] topleft, int width, int height, int[][] sm_weights, int angle, int max_width, int max_height) {
            int dstPos = 0;
            int topleftPos = 0;
            switch (predId) {
                case 0: {
                    Ipred.ipred_dc_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 16: {
                    Ipred.ipred_dc_128_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 15: {
                    Ipred.ipred_dc_top_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 3: {
                    Ipred.ipred_dc_left_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 2: {
                    Ipred.ipred_h_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 1: {
                    Ipred.ipred_v_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 12: {
                    Ipred.ipred_paeth_c(dst, dstPos, stride, topleft, topleftPos, width, height);
                    break;
                }
                case 9: {
                    Ipred.ipred_smooth_c(dst, dstPos, stride, topleft, topleftPos, width, height, sm_weights);
                    break;
                }
                case 10: {
                    Ipred.ipred_smooth_v_c(dst, dstPos, stride, topleft, topleftPos, width, height, sm_weights);
                    break;
                }
                case 11: {
                    Ipred.ipred_smooth_h_c(dst, dstPos, stride, topleft, topleftPos, width, height, sm_weights);
                    break;
                }
                case 17: {
                    Ipred.ipred_z1_c(dst, dstPos, stride, topleft, topleftPos, width, height, angle);
                    break;
                }
                case 18: {
                    Ipred.ipred_z2_c(dst, dstPos, stride, topleft, topleftPos, width, height, angle, max_width, max_height);
                    break;
                }
                case 19: {
                    break;
                }
            }
        }

        static void applyCflAC() {
        }

        static void applyCflPred(int predId, int[] dst, int stride, int[] topleft, int width, int height, int[] ac2, int alpha) {
            int dstPos = 0;
            int topLeftPos = 0;
            int acPos = 0;
            switch (predId) {
                case 0: {
                    break;
                }
                case 16: {
                    break;
                }
                case 15: {
                    Ipred.ipred_cfl_top_c(dst, dstPos, stride, topleft, topLeftPos, width, height, ac2, acPos, alpha);
                    break;
                }
                case 3: {
                    Ipred.ipred_cfl_left_c(dst, dstPos, stride, topleft, topLeftPos, width, height, ac2, acPos, alpha);
                }
            }
        }

        static void applyPalPred(int[] dst, int dstPos, int stride, int[] pal, int[] topleft, int topLeftPos, int width, int height) {
            Ipred.pal_pred_c(dst, dstPos, stride, pal, topleft, topLeftPos, width, height);
        }
    }
}

