/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

class GBit {
    long state;
    int bits_left;
    int error;
    int ptr;
    int ptr_start;
    int ptr_end;
    byte[] data = null;

    GBit(byte[] data) {
        this.data = data;
        this.ptr = 0;
        this.ptr_start = 0;
        this.ptr_end = data.length;
        this.state = 0L;
        this.bits_left = 0;
        this.error = 0;
    }

    int get_bit() {
        if (this.bits_left == 0) {
            if (this.ptr >= this.ptr_end) {
                this.error = 1;
            } else {
                long ss = this.data[this.ptr++] & 0xFF;
                this.bits_left = 7;
                this.state = ss << 57;
                return (int)(ss >>> 7);
            }
        }
        long ss = this.state;
        --this.bits_left;
        this.state = ss << 1;
        return (int)(ss >>> 63);
    }

    void refill(int n2) {
        long ss = 0L;
        do {
            if (this.ptr >= this.ptr_end) {
                this.error = 1;
                if (ss != 0L) break;
                return;
            }
            ss = ss << 8 | (long)(this.data[this.ptr++] & 0xFF);
            this.bits_left += 8;
        } while (n2 > this.bits_left);
        this.state |= ss << 64 - this.bits_left;
    }

    int get_bits(int n2) {
        if (n2 > this.bits_left) {
            this.refill(n2);
        }
        long ss = this.state;
        this.bits_left -= n2;
        this.state = ss << n2;
        return (int)(ss >>> (int)(64L - (long)n2));
    }

    long get_uleb128() {
        int more;
        long val = 0L;
        int i2 = 0;
        do {
            int v2 = this.get_bits(8);
            more = v2 & 0x80;
            val |= (long)(v2 & 0x7F) << i2;
        } while (more != 0 && (i2 += 7) < 56);
        return val;
    }

    int get_uniform(int max) {
        int l2 = GBit.FloorLog2(max) + 1;
        int m2 = (1 << l2) - max;
        int v2 = this.get_bits(l2 - 1);
        return v2 < m2 ? v2 : (v2 << 1) - m2 + this.get_bit();
    }

    int get_vlc() {
        int num_zeros = 0;
        while (this.get_bit() == 0) {
            if (++num_zeros <= 31) continue;
            return 0;
        }
        if (num_zeros != 0) {
            return this.get_bits(num_zeros) + (1 << num_zeros) - 1;
        }
        return 0;
    }

    static int inv_recenter(int r2, int v2) {
        if (v2 > r2 << 1) {
            return v2;
        }
        if ((v2 & 1) == 0) {
            return (v2 >> 1) + r2;
        }
        return r2 - (v2 + 1 >> 1);
    }

    int get_bits_subexp_u(int ref, int n2) {
        int v2 = 0;
        int i2 = 0;
        while (true) {
            int b2;
            int n3 = b2 = i2 != 0 ? 3 + i2 - 1 : 3;
            if (n2 < v2 + 3 * (1 << b2)) {
                v2 += this.get_uniform(n2 - v2 + 1);
                break;
            }
            if (this.get_bit() == 0) {
                v2 += this.get_bits(b2);
                break;
            }
            v2 += 1 << b2;
            ++i2;
        }
        return ref * 2 <= n2 ? GBit.inv_recenter(ref, v2) : n2 - GBit.inv_recenter(n2 - ref, v2);
    }

    int get_bits_subexp(int ref, int n2) {
        return this.get_bits_subexp_u(ref + (1 << n2), 2 << n2) - (1 << n2);
    }

    private static int FloorLog2(int x2) {
        int s2 = 0;
        while (x2 != 0) {
            x2 >>= 1;
            ++s2;
        }
        return s2 - 1;
    }

    void bytealign_get_bits() {
        this.bits_left = 0;
        this.state = 0L;
    }
}

