/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.D;
import com.idrsolutions.image.avif.data.Pixel;
import com.idrsolutions.image.avif.data.Tables;

class FilmGrain {
    private static final int SCALING_SIZE = 256;

    FilmGrain() {
    }

    static int get_random_number(int bits, int[] state) {
        int r2 = state[0];
        int bit = (r2 >> 0 ^ r2 >> 1 ^ r2 >> 3 ^ r2 >> 12) & 1;
        state[0] = r2 >> 1 | bit << 15;
        return state[0] >> 16 - bits & (1 << bits) - 1;
    }

    static int round2(int x2, int shift) {
        return x2 + (1 << shift >> 1) >> shift;
    }

    static void generate_grain_y_c(int[][] buf, Data data) {
        int bitdepth_min_8 = D.bitdepth_from_max(255) - 8;
        int seed = data.seed;
        int shift = 4 - bitdepth_min_8 + data.grain_scale_shift;
        int grain_ctr = 128 << bitdepth_min_8;
        int grain_min = -grain_ctr;
        int grain_max = grain_ctr - 1;
        for (int y2 = 0; y2 < 73; ++y2) {
            for (int x2 = 0; x2 < 82; ++x2) {
                int[] temp = new int[]{seed};
                int value = FilmGrain.get_random_number(11, temp);
                seed = temp[0];
                buf[y2][x2] = FilmGrain.round2(Tables.gaussian_sequence[value], shift);
            }
        }
        int ar_pad = 3;
        int ar_lag = data.ar_coeff_lag;
        for (int y3 = 3; y3 < 73; ++y3) {
            for (int x3 = 3; x3 < 79; ++x3) {
                int[] coeff = data.ar_coeffs_y;
                int coeffPos = 0;
                int sum = 0;
                for (int dy = -ar_lag; dy <= 0; ++dy) {
                    for (int dx = -ar_lag; dx <= ar_lag && (dx != 0 || dy != 0); ++dx) {
                        int cc = coeff[coeffPos++];
                        sum += cc * buf[y3 + dy][x3 + dx];
                    }
                }
                int grain = buf[y3][x3] + FilmGrain.round2(sum, data.ar_coeff_shift);
                buf[y3][x3] = D.clip(grain, grain_min, grain_max);
            }
        }
    }

    static void generate_grain_uv_c(int[][] buf, int[][] buf_y, Data data, int uv, int subx, int suby) {
        int bitdepth_min_8 = D.bitdepth_from_max(255) - 8;
        int seed = data.seed ^ (uv != 0 ? 18904 : 46372);
        int shift = 4 - bitdepth_min_8 + data.grain_scale_shift;
        int grain_ctr = 128 << bitdepth_min_8;
        int grain_min = -grain_ctr;
        int grain_max = grain_ctr - 1;
        int chromaW = subx != 0 ? 44 : 82;
        int chromaH = suby != 0 ? 38 : 73;
        for (int y2 = 0; y2 < chromaH; ++y2) {
            for (int x2 = 0; x2 < chromaW; ++x2) {
                int[] temp = new int[]{seed};
                int value = FilmGrain.get_random_number(11, temp);
                seed = temp[0];
                buf[y2][x2] = FilmGrain.round2(Tables.gaussian_sequence[value], shift);
            }
        }
        int ar_pad = 3;
        int ar_lag = data.ar_coeff_lag;
        for (int y3 = 3; y3 < chromaH; ++y3) {
            for (int x3 = 3; x3 < chromaW - 3; ++x3) {
                int[] coeff = data.ar_coeffs_uv[uv];
                int coefPos = 0;
                int sum = 0;
                block4: for (int dy = -ar_lag; dy <= 0; ++dy) {
                    for (int dx = -ar_lag; dx <= ar_lag; ++dx) {
                        if (dx == 0 && dy == 0) {
                            if (data.num_y_points == 0) continue block4;
                            int luma = 0;
                            int lumaX = (x3 - 3 << subx) + 3;
                            int lumaY = (y3 - 3 << suby) + 3;
                            for (int i2 = 0; i2 <= suby; ++i2) {
                                for (int j2 = 0; j2 <= subx; ++j2) {
                                    luma += buf_y[lumaY + i2][lumaX + j2];
                                }
                            }
                            luma = FilmGrain.round2(luma, subx + suby);
                            int cc = coeff[coefPos];
                            sum += luma * cc;
                            continue block4;
                        }
                        int cc = coeff[coefPos++];
                        sum += cc * buf[y3 + dy][x3 + dx];
                    }
                }
                int grain = buf[y3][x3] + FilmGrain.round2(sum, data.ar_coeff_shift);
                buf[y3][x3] = D.clip(grain, grain_min, grain_max);
            }
        }
    }

    static int sample_lut(int[][] grain_lut, int[][] offsets, int subx, int suby, int bx, int by, int x2, int y2) {
        int randval = offsets[bx][by];
        int offx = 3 + (2 >> subx) * (3 + (randval >> 4));
        int offy = 3 + (2 >> suby) * (3 + (randval & 0xF));
        return grain_lut[offy + y2 + (32 >> suby) * by][offx + x2 + (32 >> subx) * bx];
    }

    static void generate_scaling(int bitdepth, int[][] points, int num, int[] scaling) {
        boolean shift_x = false;
        int scaling_size = 256;
        if (num == 0) {
            Pixel.set(scaling, 0, 256);
            return;
        }
        Pixel.set(scaling, points[0][1], points[0][0] << 0);
        for (int i2 = 0; i2 < num - 1; ++i2) {
            int bx = points[i2][0];
            int by = points[i2][1];
            int ex = points[i2 + 1][0];
            int ey = points[i2 + 1][1];
            int dx = ex - bx;
            int dy = ey - by;
            int delta = dy * ((65536 + (dx >> 1)) / dx);
            int d2 = 32768;
            for (int x2 = 0; x2 < dx; ++x2) {
                scaling[bx + x2 << 0] = by + (d2 >> 16);
                d2 += delta;
            }
        }
        int n2 = points[num - 1][0] << 0;
        Pixel.set(scaling, n2, points[num - 1][1], 256 - n2);
    }

    static class DSPContext {
        DSPContext() {
        }

        static void generateGrainY() {
        }

        static void generate_grain_uv(int v2) {
        }
    }

    static class Data {
        int seed;
        int num_y_points;
        int[][] y_points = new int[14][2];
        int chroma_scaling_from_luma;
        int[] num_uv_points = new int[2];
        int[][][] uv_points = new int[2][10][2];
        int scaling_shift;
        int ar_coeff_lag;
        int[] ar_coeffs_y = new int[24];
        int[][] ar_coeffs_uv = new int[2][28];
        int ar_coeff_shift;
        int grain_scale_shift;
        int[] uv_mult = new int[2];
        int[] uv_luma_mult = new int[2];
        int[] uv_offset = new int[2];
        int overlap_flag;
        int clip_to_restricted_range;

        Data() {
        }
    }
}

