/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.Frame;
import com.idrsolutions.image.avif.data.Sequence;
import com.idrsolutions.image.avif.data.Tables;

public class Decode {
    static final int[][] ss_size_mul = new int[][]{{4, 4}, {6, 5}, {8, 6}, {12, 8}};

    static int clipU8(int x2) {
        return x2 < 0 ? 0 : Math.min(x2, 255);
    }

    static void init_quant_tables(Sequence.Header seq_hdr, Frame.Header frame_hdr, int qidx, int[][][] dq) {
        for (int i2 = 0; i2 < (frame_hdr.segmentation_enabled != 0 ? 8 : 1); ++i2) {
            int yac = frame_hdr.segmentation_enabled != 0 ? Decode.clipU8(qidx + frame_hdr.segmentation_seg_data.d[i2].delta_q) : qidx;
            int ydc = Decode.clipU8(yac + frame_hdr.quant_ydc_delta);
            int uac = Decode.clipU8(yac + frame_hdr.quant_uac_delta);
            int udc = Decode.clipU8(yac + frame_hdr.quant_udc_delta);
            int vac = Decode.clipU8(yac + frame_hdr.quant_vac_delta);
            int vdc = Decode.clipU8(yac + frame_hdr.quant_vdc_delta);
            dq[i2][0][0] = Tables.dq_tbl[seq_hdr.hbd][ydc][0];
            dq[i2][0][1] = Tables.dq_tbl[seq_hdr.hbd][yac][1];
            dq[i2][1][0] = Tables.dq_tbl[seq_hdr.hbd][udc][0];
            dq[i2][1][1] = Tables.dq_tbl[seq_hdr.hbd][uac][1];
            dq[i2][2][0] = Tables.dq_tbl[seq_hdr.hbd][vdc][0];
            dq[i2][2][1] = Tables.dq_tbl[seq_hdr.hbd][vac][1];
        }
    }

    static int neg_deinterleave(int diff, int ref, int max) {
        if (ref == 0) {
            return diff;
        }
        if (ref >= max - 1) {
            return max - diff - 1;
        }
        if (2 * ref < max) {
            if (diff <= 2 * ref) {
                if ((diff & 1) != 0) {
                    return ref + (diff + 1 >> 1);
                }
                return ref - (diff >> 1);
            }
            return diff;
        }
        if (diff <= 2 * (max - ref - 1)) {
            if ((diff & 1) != 0) {
                return ref + (diff + 1 >> 1);
            }
            return ref - (diff >> 1);
        }
        return max - (diff + 1);
    }

    static int findoddzero(byte[] buf, int len) {
        for (int n2 = 0; n2 < len; ++n2) {
            if (buf[n2 * 2] != 0) continue;
            return 1;
        }
        return 0;
    }

    static void order_palette(int[] pal_idx, int palIdxPos, int stride, int i2, int first, int last, int[][] order, int[] ctx) {
        boolean have_top = i2 > first;
        palIdxPos += first + (i2 - first) * stride;
        int j2 = first;
        int n2 = 0;
        while (j2 >= last) {
            int v2;
            boolean have_left = j2 > 0;
            int mask = 0;
            int o_idx = 0;
            if (!have_left) {
                ctx[n2] = 0;
                v2 = pal_idx[palIdxPos - stride];
                order[n2][o_idx++] = v2;
                mask |= 1 << v2;
            } else if (!have_top) {
                ctx[n2] = 0;
                v2 = pal_idx[palIdxPos - 1];
                order[n2][o_idx++] = v2;
                mask |= 1 << v2;
            } else {
                int v3;
                boolean same_l_tl;
                int tl;
                boolean same_t_tl;
                int t2 = pal_idx[palIdxPos - stride];
                int l2 = pal_idx[palIdxPos - 1];
                boolean same_t_l = t2 == l2;
                boolean same_all = same_t_l & (same_t_tl = t2 == (tl = pal_idx[palIdxPos - (stride + 1)])) & (same_l_tl = l2 == tl);
                if (same_all) {
                    ctx[n2] = 4;
                    v3 = t2;
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                } else if (same_t_l) {
                    ctx[n2] = 3;
                    v3 = t2;
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                    v3 = tl;
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                } else if (same_t_tl | same_l_tl) {
                    ctx[n2] = 2;
                    v3 = tl;
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                    v3 = same_t_tl ? l2 : t2;
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                } else {
                    ctx[n2] = 1;
                    v3 = Math.min(t2, l2);
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                    v3 = Math.max(t2, l2);
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                    v3 = tl;
                    order[n2][o_idx++] = v3;
                    mask |= 1 << v3;
                }
            }
            int m2 = 1;
            int bit = 0;
            while (m2 < 256) {
                if ((mask & m2) == 0) {
                    order[n2][o_idx++] = bit;
                }
                m2 <<= 1;
                ++bit;
            }
            have_top = true;
            --j2;
            ++n2;
            palIdxPos += stride - 1;
        }
    }

    static int get_prev_frame_segid(Frame.Context f2, int by, int bx, int w4, int h4, int[] ref_seg_map, int ref_seg_mapPos, int stride) {
        int seg_id = 8;
        ref_seg_mapPos += by * stride + bx;
        do {
            for (int x2 = 0; x2 < w4; ++x2) {
                seg_id = Math.min(seg_id, ref_seg_map[ref_seg_mapPos + x2]);
            }
            ref_seg_mapPos += stride;
        } while (--h4 > 0 && seg_id != 0);
        return seg_id;
    }

    static int get_upscale_x0(int in_w, int out_w, int step) {
        int err = out_w * step - (in_w << 14);
        int x0 = (-(out_w - in_w << 13) + (out_w >> 1)) / out_w + 128 - err / 2;
        return x0 & 0x3FFF;
    }
}

