/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.Cdef;
import com.idrsolutions.image.avif.data.D;
import com.idrsolutions.image.avif.data.Pixel;
import com.idrsolutions.image.avif.data.Tables;

class Cdef2 {
    Cdef2() {
    }

    static void backup2lines(int[] dst, int[] src, int[] stride, int layout) {
        int dstPos = 0;
        int srcPos = 0;
        int y_stride = stride[0];
        if (y_stride < 0) {
            Pixel.cpy(dst, dstPos + y_stride, src, srcPos + 7 * y_stride, -2 * y_stride);
        } else {
            Pixel.cpy(dst, dstPos, src, srcPos + 6 * y_stride, 2 * y_stride);
        }
        if (layout != 0) {
            int uv_stride = stride[1];
            if (uv_stride < 0) {
                int uv_off = layout == 1 ? 3 : 7;
                Pixel.cpy(dst, dstPos + 1 + uv_stride, src, srcPos + 1 + uv_off * uv_stride, -2 * uv_stride);
                Pixel.cpy(dst, dstPos + 2 + uv_stride, src, srcPos + 2 + uv_off * uv_stride, -2 * uv_stride);
            } else {
                int uv_off = layout == 1 ? 2 : 6;
                Pixel.cpy(dst, dstPos + 1, src, srcPos + 1 + uv_off * uv_stride, 2 * uv_stride);
                Pixel.cpy(dst, dstPos + 2, src, srcPos + 2 + uv_off * uv_stride, 2 * uv_stride);
            }
        }
    }

    static void backup2x8(int[][] dst, int[][] src, int[] src_stride, int x_off, int layout, int flag) {
        int y_off = 0;
        if ((flag & 1) != 0) {
            int y2 = 0;
            while (y2 < 8) {
                Pixel.cpy(dst[0], y2, src[0], y_off + x_off - 2, 2);
                ++y2;
                y_off += src_stride[0];
            }
        }
        if (layout == 0 || (flag & 2) == 0) {
            return;
        }
        int ss_ver = layout == 1 ? 1 : 0;
        int ss_hor = layout != 3 ? 1 : 0;
        x_off >>= ss_hor;
        y_off = 0;
        int y3 = 0;
        while (y3 < 8 >> ss_ver) {
            Pixel.cpy(dst[1], y3, src[1], y_off + x_off - 2, 2);
            Pixel.cpy(dst[2], y3, src[2], y_off + x_off - 2, 2);
            ++y3;
            y_off += src_stride[1];
        }
    }

    static int adjust_strength(int strength, int var) {
        if (var == 0) {
            return 0;
        }
        int i2 = var >> 6 != 0 ? Math.min(D.ulog2(var >> 6), 12) : 0;
        return strength * (4 + i2) + 8 >> 4;
    }

    static int constrain(int diff, int threshold, int shift) {
        int adiff = Math.abs(diff);
        return D.apply_sign(Math.min(adiff, Math.max(0, threshold - (adiff >> shift))), diff);
    }

    private static void fill(int[] tmp, int tmpPos, int stride, int w2, int h2) {
        int INT16_MIN = Short.MIN_VALUE;
        for (int y2 = 0; y2 < h2; ++y2) {
            for (int x2 = 0; x2 < w2; ++x2) {
                tmp[tmpPos + x2] = Short.MIN_VALUE;
            }
            tmpPos += stride;
        }
    }

    static void padding(int[] tmp, int tmpPos, int tmp_stride, int[] src, int srcPos, int src_stride, int[][] left, int[] top, int topPos, int[] bottom, int bottomPos, int w2, int h2, int edges) {
        int x2;
        int y2;
        int x_start = -2;
        int x_end = w2 + 2;
        int y_start = -2;
        int y_end = h2 + 2;
        if ((edges & 4) == 0) {
            Cdef2.fill(tmp, tmpPos - 2 - 2 * tmp_stride, tmp_stride, w2 + 4, 2);
            y_start = 0;
        }
        if ((edges & 8) == 0) {
            Cdef2.fill(tmp, tmpPos + h2 * tmp_stride - 2, tmp_stride, w2 + 4, 2);
            y_end -= 2;
        }
        if ((edges & 1) == 0) {
            Cdef2.fill(tmp, tmpPos + y_start * tmp_stride - 2, tmp_stride, 2, y_end - y_start);
            x_start = 0;
        }
        if ((edges & 2) == 0) {
            Cdef2.fill(tmp, tmpPos + y_start * tmp_stride + w2, tmp_stride, 2, y_end - y_start);
            x_end -= 2;
        }
        for (y2 = y_start; y2 < 0; ++y2) {
            for (x2 = x_start; x2 < x_end; ++x2) {
                tmp[tmpPos + x2 + y2 * tmp_stride] = top[topPos + x2];
            }
            topPos += src_stride;
        }
        for (y2 = 0; y2 < h2; ++y2) {
            for (x2 = x_start; x2 < 0; ++x2) {
                tmp[tmpPos + x2 + y2 * tmp_stride] = left[y2][2 + x2];
            }
        }
        for (y2 = 0; y2 < h2; ++y2) {
            int n2 = x2 = y2 < h2 ? 0 : x_start;
            while (x2 < x_end) {
                tmp[tmpPos + x2] = src[srcPos + x2];
                ++x2;
            }
            srcPos += src_stride;
            tmpPos += tmp_stride;
        }
        for (y2 = h2; y2 < y_end; ++y2) {
            for (x2 = x_start; x2 < x_end; ++x2) {
                tmp[tmpPos + x2] = bottom[bottomPos + x2];
            }
            bottomPos += src_stride;
            tmpPos += tmp_stride;
        }
    }

    static void cdef_filter_block_c(int[] dst, int dstPos, int dst_stride, int[][] left, int[] top, int topPos, int[] bottom, int bottomPos, int pri_strength, int sec_strength, int dir, int damping, int w2, int h2, int edges) {
        int tmp_stride = 12;
        int[] tmp = new int[144 + 2 * tmp_stride + 2];
        int tmpPos = 0;
        Cdef2.padding(tmp, tmpPos, tmp_stride, dst, dstPos, dst_stride, left, top, topPos, bottom, bottomPos, w2, h2, edges);
        if (pri_strength != 0) {
            int bitdepth_min_8 = D.bitdepth_from_max(255) - 8;
            int pri_tap = 4 - (pri_strength >> bitdepth_min_8 & 1);
            int pri_shift = Math.max(0, damping - D.ulog2(pri_strength));
            if (sec_strength != 0) {
                int sec_shift = damping - D.ulog2(sec_strength);
                do {
                    for (int x2 = 0; x2 < w2; ++x2) {
                        int px = dst[dstPos + x2];
                        int sum = 0;
                        int max = px;
                        int min = px;
                        int pri_tap_k = pri_tap;
                        for (int k2 = 0; k2 < 2; ++k2) {
                            int off1 = Tables.cdef_directions[dir + 2][k2];
                            int p0 = tmp[tmpPos + x2 + off1];
                            int p1 = tmp[tmpPos + x2 - off1];
                            sum += pri_tap_k * Cdef2.constrain(p0 - px, pri_strength, pri_shift);
                            sum += pri_tap_k * Cdef2.constrain(p1 - px, pri_strength, pri_shift);
                            pri_tap_k = pri_tap_k & 3 | 2;
                            min = Math.min(p0, min);
                            max = Math.max(p0, max);
                            min = Math.min(p1, min);
                            max = Math.max(p1, max);
                            int off2 = Tables.cdef_directions[dir + 4][k2];
                            int off3 = Tables.cdef_directions[dir + 0][k2];
                            int s0 = tmp[tmpPos + x2 + off2];
                            int s1 = tmp[tmpPos + x2 - off2];
                            int s2 = tmp[tmpPos + x2 + off3];
                            int s3 = tmp[tmpPos + x2 - off3];
                            int sec_tap = 2 - k2;
                            sum += sec_tap * Cdef2.constrain(s0 - px, sec_strength, sec_shift);
                            sum += sec_tap * Cdef2.constrain(s1 - px, sec_strength, sec_shift);
                            sum += sec_tap * Cdef2.constrain(s2 - px, sec_strength, sec_shift);
                            sum += sec_tap * Cdef2.constrain(s3 - px, sec_strength, sec_shift);
                            min = Math.min(s0, min);
                            max = Math.max(s0, max);
                            min = Math.min(s1, min);
                            max = Math.max(s1, max);
                            min = Math.min(s2, min);
                            max = Math.max(s2, max);
                            min = Math.min(s3, min);
                            max = Math.max(s3, max);
                        }
                        int ss = sum < 0 ? 1 : 0;
                        dst[dstPos + x2] = D.clip(px + (sum - ss + 8 >> 4), min, max);
                    }
                    dstPos += dst_stride;
                    tmpPos += tmp_stride;
                } while (--h2 != 0);
            } else {
                do {
                    for (int x3 = 0; x3 < w2; ++x3) {
                        int px = dst[dstPos + x3];
                        int sum = 0;
                        int pri_tap_k = pri_tap;
                        for (int k3 = 0; k3 < 2; ++k3) {
                            int off = Tables.cdef_directions[dir + 2][k3];
                            int p0 = tmp[tmpPos + x3 + off];
                            int p1 = tmp[tmpPos + x3 - off];
                            sum += pri_tap_k * Cdef2.constrain(p0 - px, pri_strength, pri_shift);
                            sum += pri_tap_k * Cdef2.constrain(p1 - px, pri_strength, pri_shift);
                            pri_tap_k = pri_tap_k & 3 | 2;
                        }
                        int ss = sum < 0 ? 1 : 0;
                        dst[dstPos + x3] = px + (sum - ss + 8 >> 4);
                    }
                    dstPos += dst_stride;
                    tmpPos += tmp_stride;
                } while (--h2 != 0);
            }
        } else {
            int sec_shift = damping - D.ulog2(sec_strength);
            do {
                for (int x4 = 0; x4 < w2; ++x4) {
                    int px = dst[dstPos + x4];
                    int sum = 0;
                    for (int k4 = 0; k4 < 2; ++k4) {
                        int off1 = Tables.cdef_directions[dir + 4][k4];
                        int off2 = Tables.cdef_directions[dir + 0][k4];
                        int s0 = tmp[tmpPos + x4 + off1];
                        int s1 = tmp[tmpPos + x4 - off1];
                        int s2 = tmp[tmpPos + x4 + off2];
                        int s3 = tmp[tmpPos + x4 - off2];
                        int sec_tap = 2 - k4;
                        sum += sec_tap * Cdef2.constrain(s0 - px, sec_strength, sec_shift);
                        sum += sec_tap * Cdef2.constrain(s1 - px, sec_strength, sec_shift);
                        sum += sec_tap * Cdef2.constrain(s2 - px, sec_strength, sec_shift);
                        sum += sec_tap * Cdef2.constrain(s3 - px, sec_strength, sec_shift);
                    }
                    int ss = sum < 0 ? 1 : 0;
                    dst[dstPos + x4] = px + (sum - ss + 8 >> 4);
                }
                dstPos += dst_stride;
                tmpPos += tmp_stride;
            } while (--h2 != 0);
        }
    }

    /*
     * Opcode count of 27998 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        Cdef.av1_default_coef_cdf[2].skip = new int[][][]{new int[][]{{Cdef.CDF1(29614)}, {Cdef.CDF1(9068)}, {Cdef.CDF1(12924)}, {Cdef.CDF1(19538)}, {Cdef.CDF1(17737)}, {Cdef.CDF1(24619)}, {Cdef.CDF1(30642)}, {Cdef.CDF1(4119)}, {Cdef.CDF1(16026)}, {Cdef.CDF1(25657)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(31957)}, {Cdef.CDF1(3230)}, {Cdef.CDF1(11153)}, {Cdef.CDF1(18123)}, {Cdef.CDF1(20143)}, {Cdef.CDF1(26536)}, {Cdef.CDF1(31986)}, {Cdef.CDF1(3050)}, {Cdef.CDF1(14603)}, {Cdef.CDF1(25155)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(32363)}, {Cdef.CDF1(10692)}, {Cdef.CDF1(19090)}, {Cdef.CDF1(24357)}, {Cdef.CDF1(24442)}, {Cdef.CDF1(28312)}, {Cdef.CDF1(32169)}, {Cdef.CDF1(3648)}, {Cdef.CDF1(15690)}, {Cdef.CDF1(26815)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(30669)}, {Cdef.CDF1(3832)}, {Cdef.CDF1(11663)}, {Cdef.CDF1(18889)}, {Cdef.CDF1(19782)}, {Cdef.CDF1(23313)}, {Cdef.CDF1(31330)}, {Cdef.CDF1(5124)}, {Cdef.CDF1(18719)}, {Cdef.CDF1(28468)}, {Cdef.CDF1(3082)}, {Cdef.CDF1(20982)}, {Cdef.CDF1(29443)}}, new int[][]{{Cdef.CDF1(28573)}, {Cdef.CDF1(3183)}, {Cdef.CDF1(17802)}, {Cdef.CDF1(25977)}, {Cdef.CDF1(26677)}, {Cdef.CDF1(27832)}, {Cdef.CDF1(32387)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}};
        Cdef.av1_default_coef_cdf[2].eob_bin_16 = new int[][][]{new int[][]{Cdef.CDFN(4016, 4897, 8881, 14968), Cdef.CDFN(716, 1105, 2646, 10056)}, new int[][]{Cdef.CDFN(11139, 13270, 18241, 23566), Cdef.CDFN(3192, 5032, 10297, 19755)}};
        Cdef.av1_default_coef_cdf[2].eob_bin_32 = new int[][][]{new int[][]{Cdef.CDFN(2515, 3003, 4452, 8162, 16041), Cdef.CDFN(574, 821, 1836, 5089, 13128)}, new int[][]{Cdef.CDFN(13468, 16303, 20361, 25105, 29281), Cdef.CDFN(3542, 5502, 10415, 16760, 25644)}};
        Cdef.av1_default_coef_cdf[2].eob_bin_64 = new int[][][]{new int[][]{Cdef.CDFN(2374, 2772, 4583, 7276, 12288, 19706), Cdef.CDFN(497, 810, 1315, 3000, 7004, 15641)}, new int[][]{Cdef.CDFN(15050, 17126, 21410, 24886, 28156, 30726), Cdef.CDFN(4034, 6290, 10235, 14982, 21214, 28491)}};
        Cdef.av1_default_coef_cdf[2].eob_bin_128 = new int[][][]{new int[][]{Cdef.CDFN(1366, 1738, 2527, 5016, 9355, 15797, 24643), Cdef.CDFN(354, 558, 944, 2760, 7287, 14037, 21779)}, new int[][]{Cdef.CDFN(13627, 16246, 20173, 24429, 27948, 30415, 31863), Cdef.CDFN(6275, 9889, 14769, 23164, 27988, 30493, 32272)}};
        Cdef.av1_default_coef_cdf[2].eob_bin_256 = new int[][][]{new int[][]{Cdef.CDFN(3089, 3920, 6038, 9460, 14266, 19881, 25766, 29176), Cdef.CDFN(1084, 2358, 3488, 5122, 11483, 18103, 26023, 29799)}, new int[][]{Cdef.CDFN(11514, 13794, 17480, 20754, 24361, 27378, 29492, 31277), Cdef.CDFN(6571, 9610, 15516, 21826, 29092, 30829, 31842, 32708)}};
        Cdef.av1_default_coef_cdf[2].eob_bin_512 = new int[][]{Cdef.CDFN(2624, 3936, 6480, 9686, 13979, 17726, 23267, 28410, 31078), Cdef.CDFN(12015, 14769, 19588, 22052, 24222, 25812, 27300, 29219, 32114)};
        Cdef.av1_default_coef_cdf[2].eob_bin_1024 = new int[][]{Cdef.CDFN(2784, 3831, 7041, 10521, 14847, 18844, 23155, 26682, 29229, 31045), Cdef.CDFN(9577, 12466, 17739, 20750, 22061, 23215, 24601, 25483, 25843, 32056)};
        Cdef.av1_default_coef_cdf[2].eob_hi_bit = new int[][][][]{new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(18983)}, {Cdef.CDF1(20512)}, {Cdef.CDF1(14885)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(20090)}, {Cdef.CDF1(19444)}, {Cdef.CDF1(17286)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(19139)}, {Cdef.CDF1(21487)}, {Cdef.CDF1(18959)}, {Cdef.CDF1(20910)}, {Cdef.CDF1(19089)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(20536)}, {Cdef.CDF1(20664)}, {Cdef.CDF1(20625)}, {Cdef.CDF1(19123)}, {Cdef.CDF1(14862)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(19833)}, {Cdef.CDF1(21502)}, {Cdef.CDF1(17485)}, {Cdef.CDF1(20267)}, {Cdef.CDF1(18353)}, {Cdef.CDF1(23329)}, {Cdef.CDF1(21478)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(22041)}, {Cdef.CDF1(23434)}, {Cdef.CDF1(20001)}, {Cdef.CDF1(20554)}, {Cdef.CDF1(20951)}, {Cdef.CDF1(20145)}, {Cdef.CDF1(15562)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(23312)}, {Cdef.CDF1(21607)}, {Cdef.CDF1(16526)}, {Cdef.CDF1(18957)}, {Cdef.CDF1(18034)}, {Cdef.CDF1(18934)}, {Cdef.CDF1(24247)}, {Cdef.CDF1(16921)}, {Cdef.CDF1(17080)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(26579)}, {Cdef.CDF1(24910)}, {Cdef.CDF1(18637)}, {Cdef.CDF1(19800)}, {Cdef.CDF1(20388)}, {Cdef.CDF1(9887)}, {Cdef.CDF1(15642)}, {Cdef.CDF1(30198)}, {Cdef.CDF1(24721)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(26998)}, {Cdef.CDF1(16737)}, {Cdef.CDF1(17838)}, {Cdef.CDF1(18922)}, {Cdef.CDF1(19515)}, {Cdef.CDF1(18636)}, {Cdef.CDF1(17333)}, {Cdef.CDF1(15776)}, {Cdef.CDF1(22658)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}};
        Cdef.av1_default_coef_cdf[2].eob_base_tok = new int[][][][]{new int[][][]{new int[][]{Cdef.CDFN(20092, 30774), Cdef.CDFN(30695, 32020), Cdef.CDFN(31131, 32103), Cdef.CDFN(28666, 30870)}, new int[][]{Cdef.CDFN(27258, 31095), Cdef.CDFN(31804, 32623), Cdef.CDFN(31763, 32528), Cdef.CDFN(31438, 32506)}}, new int[][][]{new int[][]{Cdef.CDFN(18049, 30489), Cdef.CDFN(31706, 32286), Cdef.CDFN(32163, 32473), Cdef.CDFN(31550, 32184)}, new int[][]{Cdef.CDFN(27116, 30842), Cdef.CDFN(31971, 32598), Cdef.CDFN(32088, 32576), Cdef.CDFN(32067, 32664)}}, new int[][][]{new int[][]{Cdef.CDFN(12854, 29093), Cdef.CDFN(32272, 32558), Cdef.CDFN(32667, 32729), Cdef.CDFN(32306, 32585)}, new int[][]{Cdef.CDFN(25476, 30366), Cdef.CDFN(32169, 32687), Cdef.CDFN(32479, 32689), Cdef.CDFN(31673, 32634)}}, new int[][][]{new int[][]{Cdef.CDFN(2809, 19301), Cdef.CDFN(32205, 32622), Cdef.CDFN(32338, 32730), Cdef.CDFN(31786, 32616)}, new int[][]{Cdef.CDFN(22737, 29105), Cdef.CDFN(30810, 32362), Cdef.CDFN(30014, 32627), Cdef.CDFN(30528, 32574)}}, new int[][][]{new int[][]{Cdef.CDFN(935, 3382), Cdef.CDFN(30789, 31909), Cdef.CDFN(32466, 32756), Cdef.CDFN(30860, 32513)}, new int[][]{Cdef.CDFN(10923, 21845), Cdef.CDFN(10923, 21845), Cdef.CDFN(10923, 21845), Cdef.CDFN(10923, 21845)}}};
        Cdef.av1_default_coef_cdf[2].base_tok = new int[][][][]{new int[][][]{new int[][]{Cdef.CDFN(8896, 16227, 20630), Cdef.CDFN(23629, 31782, 32527), Cdef.CDFN(15173, 27755, 31321), Cdef.CDFN(10158, 21233, 27382), Cdef.CDFN(6420, 14857, 21558), Cdef.CDFN(3269, 8155, 12646), Cdef.CDFN(24835, 32009, 32496), Cdef.CDFN(16509, 28421, 31579), Cdef.CDFN(10957, 21514, 27418), Cdef.CDFN(7881, 15930, 22096), Cdef.CDFN(5388, 10960, 15918), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(20745, 30773, 32093), Cdef.CDFN(15200, 27221, 30861), Cdef.CDFN(13032, 20873, 25667), Cdef.CDFN(12285, 18663, 23494), Cdef.CDFN(11563, 17481, 21489), Cdef.CDFN(26260, 31982, 32320), Cdef.CDFN(15397, 28083, 31100), Cdef.CDFN(9742, 19217, 24824), Cdef.CDFN(3261, 9629, 15362), Cdef.CDFN(1480, 4322, 7499), Cdef.CDFN(27599, 32256, 32460), Cdef.CDFN(16857, 27659, 30774), Cdef.CDFN(9551, 18290, 23748), Cdef.CDFN(3052, 8933, 14103), Cdef.CDFN(2021, 5910, 9787), Cdef.CDFN(29005, 32015, 32392), Cdef.CDFN(17677, 27694, 30863), Cdef.CDFN(9204, 17356, 23219), Cdef.CDFN(2403, 7516, 12814), Cdef.CDFN(8192, 16384, 24576)}, new int[][]{Cdef.CDFN(10808, 22056, 26896), Cdef.CDFN(25739, 32313, 32676), Cdef.CDFN(17288, 30203, 32221), Cdef.CDFN(11359, 24878, 29896), Cdef.CDFN(6949, 17767, 24893), Cdef.CDFN(4287, 11796, 18071), Cdef.CDFN(27880, 32521, 32705), Cdef.CDFN(19038, 31004, 32414), Cdef.CDFN(12564, 26345, 30768), Cdef.CDFN(8269, 19947, 26779), Cdef.CDFN(5674, 14657, 21674), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(25742, 32319, 32671), Cdef.CDFN(19557, 31164, 32454), Cdef.CDFN(13381, 26381, 30755), Cdef.CDFN(10101, 21466, 26722), Cdef.CDFN(9209, 19650, 26825), Cdef.CDFN(27107, 31917, 32432), Cdef.CDFN(18056, 28893, 31203), Cdef.CDFN(10200, 21434, 26764), Cdef.CDFN(4660, 12913, 19502), Cdef.CDFN(2368, 6930, 12504), Cdef.CDFN(26960, 32158, 32613), Cdef.CDFN(18628, 30005, 32031), Cdef.CDFN(10233, 22442, 28232), Cdef.CDFN(5471, 14630, 21516), Cdef.CDFN(3235, 10767, 17109), Cdef.CDFN(27696, 32440, 32692), Cdef.CDFN(20032, 31167, 32438), Cdef.CDFN(8700, 21341, 28442), Cdef.CDFN(5662, 14831, 21795), Cdef.CDFN(8192, 16384, 24576)}}, new int[][][]{new int[][]{Cdef.CDFN(9704, 17294, 21132), Cdef.CDFN(26762, 32278, 32633), Cdef.CDFN(18382, 29620, 31819), Cdef.CDFN(10891, 23475, 28723), Cdef.CDFN(6358, 16583, 23309), Cdef.CDFN(3248, 9118, 14141), Cdef.CDFN(27204, 32573, 32699), Cdef.CDFN(19818, 30824, 32329), Cdef.CDFN(11772, 25120, 30041), Cdef.CDFN(6995, 18033, 25039), Cdef.CDFN(3752, 10442, 16098), Cdef.CDFN(27222, 32256, 32559), Cdef.CDFN(15356, 28399, 31475), Cdef.CDFN(8821, 20635, 27057), Cdef.CDFN(5511, 14404, 21239), Cdef.CDFN(2935, 8222, 13051), Cdef.CDFN(24875, 32120, 32529), Cdef.CDFN(15233, 28265, 31445), Cdef.CDFN(8605, 20570, 26932), Cdef.CDFN(5431, 14413, 21196), Cdef.CDFN(2994, 8341, 13223), Cdef.CDFN(28201, 32604, 32700), Cdef.CDFN(21041, 31446, 32456), Cdef.CDFN(13221, 26213, 30475), Cdef.CDFN(8255, 19385, 26037), Cdef.CDFN(4930, 12585, 18830), Cdef.CDFN(28768, 32448, 32627), Cdef.CDFN(19705, 30561, 32021), Cdef.CDFN(11572, 23589, 28220), Cdef.CDFN(5532, 15034, 21446), Cdef.CDFN(2460, 7150, 11456), Cdef.CDFN(29874, 32619, 32699), Cdef.CDFN(21621, 31071, 32201), Cdef.CDFN(12511, 24747, 28992), Cdef.CDFN(6281, 16395, 22748), Cdef.CDFN(3246, 9278, 14497), Cdef.CDFN(29715, 32625, 32712), Cdef.CDFN(20958, 31011, 32283), Cdef.CDFN(11233, 23671, 28806), Cdef.CDFN(6012, 16128, 22868), Cdef.CDFN(3427, 9851, 15414)}, new int[][]{Cdef.CDFN(11016, 22111, 26794), Cdef.CDFN(25946, 32357, 32677), Cdef.CDFN(17890, 30452, 32252), Cdef.CDFN(11678, 25142, 29816), Cdef.CDFN(6720, 17534, 24584), Cdef.CDFN(4230, 11665, 17820), Cdef.CDFN(28400, 32623, 32747), Cdef.CDFN(21164, 31668, 32575), Cdef.CDFN(13572, 27388, 31182), Cdef.CDFN(8234, 20750, 27358), Cdef.CDFN(5065, 14055, 20897), Cdef.CDFN(28981, 32547, 32705), Cdef.CDFN(18681, 30543, 32239), Cdef.CDFN(10919, 24075, 29286), Cdef.CDFN(6431, 17199, 24077), Cdef.CDFN(3819, 10464, 16618), Cdef.CDFN(26870, 32467, 32693), Cdef.CDFN(19041, 30831, 32347), Cdef.CDFN(11794, 25211, 30016), Cdef.CDFN(6888, 18019, 24970), Cdef.CDFN(4370, 12363, 18992), Cdef.CDFN(29578, 32670, 32744), Cdef.CDFN(23159, 32007, 32613), Cdef.CDFN(15315, 28669, 31676), Cdef.CDFN(9298, 22607, 28782), Cdef.CDFN(6144, 15913, 22968), Cdef.CDFN(28110, 32499, 32669), Cdef.CDFN(21574, 30937, 32015), Cdef.CDFN(12759, 24818, 28727), Cdef.CDFN(6545, 16761, 23042), Cdef.CDFN(3649, 10597, 16833), Cdef.CDFN(28163, 32552, 32728), Cdef.CDFN(22101, 31469, 32464), Cdef.CDFN(13160, 25472, 30143), Cdef.CDFN(7303, 18684, 25468), Cdef.CDFN(5241, 13975, 20955), Cdef.CDFN(28400, 32631, 32744), Cdef.CDFN(22104, 31793, 32603), Cdef.CDFN(13557, 26571, 30846), Cdef.CDFN(7749, 19861, 26675), Cdef.CDFN(4873, 14030, 21234)}}, new int[][][]{new int[][]{Cdef.CDFN(9800, 17635, 21073), Cdef.CDFN(26153, 31885, 32527), Cdef.CDFN(15038, 27852, 31006), Cdef.CDFN(8718, 20564, 26486), Cdef.CDFN(5128, 14076, 20514), Cdef.CDFN(2636, 7566, 11925), Cdef.CDFN(27551, 32504, 32701), Cdef.CDFN(18310, 30054, 32100), Cdef.CDFN(10211, 23420, 29082), Cdef.CDFN(6222, 16876, 23916), Cdef.CDFN(3462, 9954, 15498), Cdef.CDFN(29991, 32633, 32721), Cdef.CDFN(19883, 30751, 32201), Cdef.CDFN(11141, 24184, 29285), Cdef.CDFN(6420, 16940, 23774), Cdef.CDFN(3392, 9753, 15118), Cdef.CDFN(28465, 32616, 32712), Cdef.CDFN(19850, 30702, 32244), Cdef.CDFN(10983, 24024, 29223), Cdef.CDFN(6294, 16770, 23582), Cdef.CDFN(3244, 9283, 14509), Cdef.CDFN(30023, 32717, 32748), Cdef.CDFN(22940, 32032, 32626), Cdef.CDFN(14282, 27928, 31473), Cdef.CDFN(8562, 21327, 27914), Cdef.CDFN(4846, 13393, 19919), Cdef.CDFN(29981, 32590, 32695), Cdef.CDFN(20465, 30963, 32166), Cdef.CDFN(11479, 23579, 28195), Cdef.CDFN(5916, 15648, 22073), Cdef.CDFN(3031, 8605, 13398), Cdef.CDFN(31146, 32691, 32739), Cdef.CDFN(23106, 31724, 32444), Cdef.CDFN(13783, 26738, 30439), Cdef.CDFN(7852, 19468, 25807), Cdef.CDFN(3860, 11124, 16853), Cdef.CDFN(31014, 32724, 32748), Cdef.CDFN(23629, 32109, 32628), Cdef.CDFN(14747, 28115, 31403), Cdef.CDFN(8545, 21242, 27478), Cdef.CDFN(4574, 12781, 19067)}, new int[][]{Cdef.CDFN(9185, 19694, 24688), Cdef.CDFN(26081, 31985, 32621), Cdef.CDFN(16015, 29000, 31787), Cdef.CDFN(10542, 23690, 29206), Cdef.CDFN(6732, 17945, 24677), Cdef.CDFN(3916, 11039, 16722), Cdef.CDFN(28224, 32566, 32744), Cdef.CDFN(19100, 31138, 32485), Cdef.CDFN(12528, 26620, 30879), Cdef.CDFN(7741, 20277, 26885), Cdef.CDFN(4566, 12845, 18990), Cdef.CDFN(29933, 32593, 32718), Cdef.CDFN(17670, 30333, 32155), Cdef.CDFN(10385, 23600, 28909), Cdef.CDFN(6243, 16236, 22407), Cdef.CDFN(3976, 10389, 16017), Cdef.CDFN(28377, 32561, 32738), Cdef.CDFN(19366, 31175, 32482), Cdef.CDFN(13327, 27175, 31094), Cdef.CDFN(8258, 20769, 27143), Cdef.CDFN(4703, 13198, 19527), Cdef.CDFN(31086, 32706, 32748), Cdef.CDFN(22853, 31902, 32583), Cdef.CDFN(14759, 28186, 31419), Cdef.CDFN(9284, 22382, 28348), Cdef.CDFN(5585, 15192, 21868), Cdef.CDFN(28291, 32652, 32746), Cdef.CDFN(19849, 32107, 32571), Cdef.CDFN(14834, 26818, 29214), Cdef.CDFN(10306, 22594, 28672), Cdef.CDFN(6615, 17384, 23384), Cdef.CDFN(28947, 32604, 32745), Cdef.CDFN(25625, 32289, 32646), Cdef.CDFN(18758, 28672, 31403), Cdef.CDFN(10017, 23430, 28523), Cdef.CDFN(6862, 15269, 22131), Cdef.CDFN(23933, 32509, 32739), Cdef.CDFN(19927, 31495, 32631), Cdef.CDFN(11903, 26023, 30621), Cdef.CDFN(7026, 20094, 27252), Cdef.CDFN(5998, 18106, 24437)}}, new int[][][]{new int[][]{Cdef.CDFN(4456, 11274, 15533), Cdef.CDFN(21219, 29079, 31616), Cdef.CDFN(11173, 23774, 28567), Cdef.CDFN(7282, 18293, 24263), Cdef.CDFN(4890, 13286, 19115), Cdef.CDFN(1890, 5508, 8659), Cdef.CDFN(26651, 32136, 32647), Cdef.CDFN(14630, 28254, 31455), Cdef.CDFN(8716, 21287, 27395), Cdef.CDFN(5615, 15331, 22008), Cdef.CDFN(2675, 7700, 12150), Cdef.CDFN(29954, 32526, 32690), Cdef.CDFN(16126, 28982, 31633), Cdef.CDFN(9030, 21361, 27352), Cdef.CDFN(5411, 14793, 21271), Cdef.CDFN(2943, 8422, 13163), Cdef.CDFN(29539, 32601, 32730), Cdef.CDFN(18125, 30385, 32201), Cdef.CDFN(10422, 24090, 29468), Cdef.CDFN(6468, 17487, 24438), Cdef.CDFN(2970, 8653, 13531), Cdef.CDFN(30912, 32715, 32748), Cdef.CDFN(20666, 31373, 32497), Cdef.CDFN(12509, 26640, 30917), Cdef.CDFN(8058, 20629, 27290), Cdef.CDFN(4231, 12006, 18052), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}, new int[][]{Cdef.CDFN(10202, 20633, 25484), Cdef.CDFN(27336, 31445, 32352), Cdef.CDFN(12420, 24384, 28552), Cdef.CDFN(7648, 18115, 23856), Cdef.CDFN(5662, 14341, 19902), Cdef.CDFN(3611, 10328, 15390), Cdef.CDFN(30945, 32616, 32736), Cdef.CDFN(18682, 30505, 32253), Cdef.CDFN(11513, 25336, 30203), Cdef.CDFN(7449, 19452, 26148), Cdef.CDFN(4482, 13051, 18886), Cdef.CDFN(32022, 32690, 32747), Cdef.CDFN(18578, 30501, 32146), Cdef.CDFN(11249, 23368, 28631), Cdef.CDFN(5645, 16958, 22158), Cdef.CDFN(5009, 11444, 16637), Cdef.CDFN(31357, 32710, 32748), Cdef.CDFN(21552, 31494, 32504), Cdef.CDFN(13891, 27677, 31340), Cdef.CDFN(9051, 22098, 28172), Cdef.CDFN(5190, 13377, 19486), Cdef.CDFN(32364, 32740, 32748), Cdef.CDFN(24839, 31907, 32551), Cdef.CDFN(17160, 28779, 31696), Cdef.CDFN(12452, 24137, 29602), Cdef.CDFN(6165, 15389, 22477), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}}, new int[][][]{new int[][]{Cdef.CDFN(2575, 7281, 11077), Cdef.CDFN(14002, 20866, 25402), Cdef.CDFN(6343, 15056, 19658), Cdef.CDFN(4474, 11858, 17041), Cdef.CDFN(2865, 8299, 12534), Cdef.CDFN(1344, 3949, 6391), Cdef.CDFN(24720, 31239, 32459), Cdef.CDFN(12585, 25356, 29968), Cdef.CDFN(7181, 18246, 24444), Cdef.CDFN(5025, 13667, 19885), Cdef.CDFN(2521, 7304, 11605), Cdef.CDFN(29908, 32252, 32584), Cdef.CDFN(17421, 29156, 31575), Cdef.CDFN(9889, 22188, 27782), Cdef.CDFN(5878, 15647, 22123), Cdef.CDFN(2814, 8665, 13323), Cdef.CDFN(30183, 32568, 32713), Cdef.CDFN(18528, 30195, 32049), Cdef.CDFN(10982, 24606, 29657), Cdef.CDFN(6957, 18165, 25231), Cdef.CDFN(3508, 10118, 15468), Cdef.CDFN(31761, 32736, 32748), Cdef.CDFN(21041, 31328, 32546), Cdef.CDFN(12568, 26732, 31166), Cdef.CDFN(8052, 20720, 27733), Cdef.CDFN(4336, 12192, 18396), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}, new int[][]{Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}}};
        Cdef.av1_default_coef_cdf[2].dc_sign = new int[][][]{new int[][]{{Cdef.CDF1(16000)}, {Cdef.CDF1(13056)}, {Cdef.CDF1(18816)}}, new int[][]{{Cdef.CDF1(15232)}, {Cdef.CDF1(12928)}, {Cdef.CDF1(17280)}}};
        Cdef.av1_default_coef_cdf[2].br_tok = new int[][][][]{new int[][][]{new int[][]{Cdef.CDFN(16138, 22223, 25509), Cdef.CDFN(15347, 22430, 26332), Cdef.CDFN(9614, 16736, 21332), Cdef.CDFN(6600, 12275, 16907), Cdef.CDFN(4811, 9424, 13547), Cdef.CDFN(3748, 7809, 11420), Cdef.CDFN(2254, 4587, 6890), Cdef.CDFN(15196, 20284, 23177), Cdef.CDFN(18317, 25469, 28451), Cdef.CDFN(13918, 21651, 25842), Cdef.CDFN(10052, 17150, 21995), Cdef.CDFN(7499, 13630, 18587), Cdef.CDFN(6158, 11417, 16003), Cdef.CDFN(4014, 7785, 11252), Cdef.CDFN(15048, 21067, 24384), Cdef.CDFN(18202, 25346, 28553), Cdef.CDFN(14302, 22019, 26356), Cdef.CDFN(10839, 18139, 23166), Cdef.CDFN(8715, 15744, 20806), Cdef.CDFN(7536, 13576, 18544), Cdef.CDFN(5413, 10335, 14498)}, new int[][]{Cdef.CDFN(17394, 24501, 27895), Cdef.CDFN(15889, 23420, 27185), Cdef.CDFN(11561, 19133, 23870), Cdef.CDFN(8285, 14812, 19844), Cdef.CDFN(6496, 12043, 16550), Cdef.CDFN(4771, 9574, 13677), Cdef.CDFN(3603, 6830, 10144), Cdef.CDFN(21656, 27704, 30200), Cdef.CDFN(21324, 27915, 30511), Cdef.CDFN(17327, 25336, 28997), Cdef.CDFN(13417, 21381, 26033), Cdef.CDFN(10132, 17425, 22338), Cdef.CDFN(8580, 15016, 19633), Cdef.CDFN(5694, 11477, 16411), Cdef.CDFN(24116, 29780, 31450), Cdef.CDFN(23853, 29695, 31591), Cdef.CDFN(20085, 27614, 30428), Cdef.CDFN(15326, 24335, 28575), Cdef.CDFN(11814, 19472, 24810), Cdef.CDFN(10221, 18611, 24767), Cdef.CDFN(7689, 14558, 20321)}}, new int[][][]{new int[][]{Cdef.CDFN(16214, 22380, 25770), Cdef.CDFN(14213, 21304, 25295), Cdef.CDFN(9213, 15823, 20455), Cdef.CDFN(6395, 11758, 16139), Cdef.CDFN(4779, 9187, 13066), Cdef.CDFN(3821, 7501, 10953), Cdef.CDFN(2293, 4567, 6795), Cdef.CDFN(15859, 21283, 23820), Cdef.CDFN(18404, 25602, 28726), Cdef.CDFN(14325, 21980, 26206), Cdef.CDFN(10669, 17937, 22720), Cdef.CDFN(8297, 14642, 19447), Cdef.CDFN(6746, 12389, 16893), Cdef.CDFN(4324, 8251, 11770), Cdef.CDFN(16532, 21631, 24475), Cdef.CDFN(20667, 27150, 29668), Cdef.CDFN(16728, 24510, 28175), Cdef.CDFN(12861, 20645, 25332), Cdef.CDFN(10076, 17361, 22417), Cdef.CDFN(8395, 14940, 19963), Cdef.CDFN(5731, 10683, 14912)}, new int[][]{Cdef.CDFN(14433, 21155, 24938), Cdef.CDFN(14658, 21716, 25545), Cdef.CDFN(9923, 16824, 21557), Cdef.CDFN(6982, 13052, 17721), Cdef.CDFN(5419, 10503, 15050), Cdef.CDFN(4852, 9162, 13014), Cdef.CDFN(3271, 6395, 9630), Cdef.CDFN(22210, 27833, 30109), Cdef.CDFN(20750, 27368, 29821), Cdef.CDFN(16894, 24828, 28573), Cdef.CDFN(13247, 21276, 25757), Cdef.CDFN(10038, 17265, 22563), Cdef.CDFN(8587, 14947, 20327), Cdef.CDFN(5645, 11371, 15252), Cdef.CDFN(22027, 27526, 29714), Cdef.CDFN(23098, 29146, 31221), Cdef.CDFN(19886, 27341, 30272), Cdef.CDFN(15609, 23747, 28046), Cdef.CDFN(11993, 20065, 24939), Cdef.CDFN(9637, 18267, 23671), Cdef.CDFN(7625, 13801, 19144)}}, new int[][][]{new int[][]{Cdef.CDFN(14438, 20798, 24089), Cdef.CDFN(12621, 19203, 23097), Cdef.CDFN(8177, 14125, 18402), Cdef.CDFN(5674, 10501, 14456), Cdef.CDFN(4236, 8239, 11733), Cdef.CDFN(3447, 6750, 9806), Cdef.CDFN(1986, 3950, 5864), Cdef.CDFN(16208, 22099, 24930), Cdef.CDFN(16537, 24025, 27585), Cdef.CDFN(12780, 20381, 24867), Cdef.CDFN(9767, 16612, 21416), Cdef.CDFN(7686, 13738, 18398), Cdef.CDFN(6333, 11614, 15964), Cdef.CDFN(3941, 7571, 10836), Cdef.CDFN(22819, 27422, 29202), Cdef.CDFN(22224, 28514, 30721), Cdef.CDFN(17660, 25433, 28913), Cdef.CDFN(13574, 21482, 26002), Cdef.CDFN(10629, 17977, 22938), Cdef.CDFN(8612, 15298, 20265), Cdef.CDFN(5607, 10491, 14596)}, new int[][]{Cdef.CDFN(13569, 19800, 23206), Cdef.CDFN(13128, 19924, 23869), Cdef.CDFN(8329, 14841, 19403), Cdef.CDFN(6130, 10976, 15057), Cdef.CDFN(4682, 8839, 12518), Cdef.CDFN(3656, 7409, 10588), Cdef.CDFN(2577, 5099, 7412), Cdef.CDFN(22427, 28684, 30585), Cdef.CDFN(20913, 27750, 30139), Cdef.CDFN(15840, 24109, 27834), Cdef.CDFN(12308, 20029, 24569), Cdef.CDFN(10216, 16785, 21458), Cdef.CDFN(8309, 14203, 19113), Cdef.CDFN(6043, 11168, 15307), Cdef.CDFN(23166, 28901, 30998), Cdef.CDFN(21899, 28405, 30751), Cdef.CDFN(18413, 26091, 29443), Cdef.CDFN(15233, 23114, 27352), Cdef.CDFN(12683, 20472, 25288), Cdef.CDFN(10702, 18259, 23409), Cdef.CDFN(8125, 14464, 19226)}}, new int[][][]{new int[][]{Cdef.CDFN(9040, 14786, 18360), Cdef.CDFN(9979, 15718, 19415), Cdef.CDFN(7913, 13918, 18311), Cdef.CDFN(5859, 10889, 15184), Cdef.CDFN(4593, 8677, 12510), Cdef.CDFN(3820, 7396, 10791), Cdef.CDFN(1730, 3471, 5192), Cdef.CDFN(11803, 18365, 22709), Cdef.CDFN(11419, 18058, 22225), Cdef.CDFN(9418, 15774, 20243), Cdef.CDFN(7539, 13325, 17657), Cdef.CDFN(6233, 11317, 15384), Cdef.CDFN(5137, 9656, 13545), Cdef.CDFN(2977, 5774, 8349), Cdef.CDFN(21207, 27246, 29640), Cdef.CDFN(19547, 26578, 29497), Cdef.CDFN(16169, 23871, 27690), Cdef.CDFN(12820, 20458, 25018), Cdef.CDFN(10224, 17332, 22214), Cdef.CDFN(8526, 15048, 19884), Cdef.CDFN(5037, 9410, 13118)}, new int[][]{Cdef.CDFN(12339, 17329, 20140), Cdef.CDFN(13505, 19895, 23225), Cdef.CDFN(9847, 16944, 21564), Cdef.CDFN(7280, 13256, 18348), Cdef.CDFN(4712, 10009, 14454), Cdef.CDFN(4361, 7914, 12477), Cdef.CDFN(2870, 5628, 7995), Cdef.CDFN(20061, 25504, 28526), Cdef.CDFN(15235, 22878, 26145), Cdef.CDFN(12985, 19958, 24155), Cdef.CDFN(9782, 16641, 21403), Cdef.CDFN(9456, 16360, 20760), Cdef.CDFN(6855, 12940, 18557), Cdef.CDFN(5661, 10564, 15002), Cdef.CDFN(25656, 30602, 31894), Cdef.CDFN(22570, 29107, 31092), Cdef.CDFN(18917, 26423, 29541), Cdef.CDFN(15940, 23649, 27754), Cdef.CDFN(12803, 20581, 25219), Cdef.CDFN(11082, 18695, 23376), Cdef.CDFN(7939, 14373, 19005)}}};
        Cdef.av1_default_coef_cdf[3].skip = new int[][][]{new int[][]{{Cdef.CDF1(26887)}, {Cdef.CDF1(6729)}, {Cdef.CDF1(10361)}, {Cdef.CDF1(17442)}, {Cdef.CDF1(15045)}, {Cdef.CDF1(22478)}, {Cdef.CDF1(29072)}, {Cdef.CDF1(2713)}, {Cdef.CDF1(11861)}, {Cdef.CDF1(20773)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(31903)}, {Cdef.CDF1(2044)}, {Cdef.CDF1(7528)}, {Cdef.CDF1(14618)}, {Cdef.CDF1(16182)}, {Cdef.CDF1(24168)}, {Cdef.CDF1(31037)}, {Cdef.CDF1(2786)}, {Cdef.CDF1(11194)}, {Cdef.CDF1(20155)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(32510)}, {Cdef.CDF1(8430)}, {Cdef.CDF1(17318)}, {Cdef.CDF1(24154)}, {Cdef.CDF1(23674)}, {Cdef.CDF1(28789)}, {Cdef.CDF1(32139)}, {Cdef.CDF1(3440)}, {Cdef.CDF1(13117)}, {Cdef.CDF1(22702)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(31671)}, {Cdef.CDF1(2056)}, {Cdef.CDF1(11746)}, {Cdef.CDF1(16852)}, {Cdef.CDF1(18635)}, {Cdef.CDF1(24715)}, {Cdef.CDF1(31484)}, {Cdef.CDF1(4656)}, {Cdef.CDF1(16074)}, {Cdef.CDF1(24704)}, {Cdef.CDF1(1806)}, {Cdef.CDF1(14645)}, {Cdef.CDF1(25336)}}, new int[][]{{Cdef.CDF1(31539)}, {Cdef.CDF1(8433)}, {Cdef.CDF1(20576)}, {Cdef.CDF1(27904)}, {Cdef.CDF1(27852)}, {Cdef.CDF1(30026)}, {Cdef.CDF1(32441)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}};
        Cdef.av1_default_coef_cdf[3].eob_bin_16 = new int[][][]{new int[][]{Cdef.CDFN(6708, 8958, 14746, 22133), Cdef.CDFN(1222, 2074, 4783, 15410)}, new int[][]{Cdef.CDFN(19575, 21766, 26044, 29709), Cdef.CDFN(7297, 10767, 19273, 28194)}};
        Cdef.av1_default_coef_cdf[3].eob_bin_32 = new int[][][]{new int[][]{Cdef.CDFN(4617, 5709, 8446, 13584, 23135), Cdef.CDFN(1156, 1702, 3675, 9274, 20539)}, new int[][]{Cdef.CDFN(22086, 24282, 27010, 29770, 31743), Cdef.CDFN(7699, 10897, 20891, 26926, 31628)}};
        Cdef.av1_default_coef_cdf[3].eob_bin_64 = new int[][][]{new int[][]{Cdef.CDFN(6307, 7541, 12060, 16358, 22553, 27865), Cdef.CDFN(1289, 2320, 3971, 7926, 14153, 24291)}, new int[][]{Cdef.CDFN(24212, 25708, 28268, 30035, 31307, 32049), Cdef.CDFN(8726, 12378, 19409, 26450, 30038, 32462)}};
        Cdef.av1_default_coef_cdf[3].eob_bin_128 = new int[][][]{new int[][]{Cdef.CDFN(3472, 4885, 7489, 12481, 18517, 24536, 29635), Cdef.CDFN(886, 1731, 3271, 8469, 15569, 22126, 28383)}, new int[][]{Cdef.CDFN(24313, 26062, 28385, 30107, 31217, 31898, 32345), Cdef.CDFN(9165, 13282, 21150, 30286, 31894, 32571, 32712)}};
        Cdef.av1_default_coef_cdf[3].eob_bin_256 = new int[][][]{new int[][]{Cdef.CDFN(5348, 7113, 11820, 15924, 22106, 26777, 30334, 31757), Cdef.CDFN(2453, 4474, 6307, 8777, 16474, 22975, 29000, 31547)}, new int[][]{Cdef.CDFN(23110, 24597, 27140, 28894, 30167, 30927, 31392, 32094), Cdef.CDFN(9998, 17661, 25178, 28097, 31308, 32038, 32403, 32695)}};
        Cdef.av1_default_coef_cdf[3].eob_bin_512 = new int[][]{Cdef.CDFN(5927, 7809, 10923, 14597, 19439, 24135, 28456, 31142, 32060), Cdef.CDFN(21093, 23043, 25742, 27658, 29097, 29716, 30073, 30820, 31956)};
        Cdef.av1_default_coef_cdf[3].eob_bin_1024 = new int[][]{Cdef.CDFN(6698, 8334, 11961, 15762, 20186, 23862, 27434, 29326, 31082, 32050), Cdef.CDFN(20569, 22426, 25569, 26859, 28053, 28913, 29486, 29724, 29807, 32570)};
        Cdef.av1_default_coef_cdf[3].eob_hi_bit = new int[][][][]{new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(20177)}, {Cdef.CDF1(20789)}, {Cdef.CDF1(20262)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(21416)}, {Cdef.CDF1(20855)}, {Cdef.CDF1(23410)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(20238)}, {Cdef.CDF1(21057)}, {Cdef.CDF1(19159)}, {Cdef.CDF1(22337)}, {Cdef.CDF1(20159)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(20125)}, {Cdef.CDF1(20559)}, {Cdef.CDF1(21707)}, {Cdef.CDF1(22296)}, {Cdef.CDF1(17333)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(19941)}, {Cdef.CDF1(20527)}, {Cdef.CDF1(21470)}, {Cdef.CDF1(22487)}, {Cdef.CDF1(19558)}, {Cdef.CDF1(22354)}, {Cdef.CDF1(20331)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(22752)}, {Cdef.CDF1(25006)}, {Cdef.CDF1(22075)}, {Cdef.CDF1(21576)}, {Cdef.CDF1(17740)}, {Cdef.CDF1(21690)}, {Cdef.CDF1(19211)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(21442)}, {Cdef.CDF1(22358)}, {Cdef.CDF1(18503)}, {Cdef.CDF1(20291)}, {Cdef.CDF1(19945)}, {Cdef.CDF1(21294)}, {Cdef.CDF1(21178)}, {Cdef.CDF1(19400)}, {Cdef.CDF1(10556)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(24648)}, {Cdef.CDF1(24949)}, {Cdef.CDF1(20708)}, {Cdef.CDF1(23905)}, {Cdef.CDF1(20501)}, {Cdef.CDF1(9558)}, {Cdef.CDF1(9423)}, {Cdef.CDF1(30365)}, {Cdef.CDF1(19253)}}}, new int[][][]{new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(26064)}, {Cdef.CDF1(22098)}, {Cdef.CDF1(19613)}, {Cdef.CDF1(20525)}, {Cdef.CDF1(17595)}, {Cdef.CDF1(16618)}, {Cdef.CDF1(20497)}, {Cdef.CDF1(18989)}, {Cdef.CDF1(15513)}}, new int[][]{{Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}, {Cdef.CDF1(16384)}}}};
        Cdef.av1_default_coef_cdf[3].eob_base_tok = new int[][][][]{new int[][][]{new int[][]{Cdef.CDFN(22497, 31198), Cdef.CDFN(31715, 32495), Cdef.CDFN(31606, 32337), Cdef.CDFN(30388, 31990)}, new int[][]{Cdef.CDFN(27877, 31584), Cdef.CDFN(32170, 32728), Cdef.CDFN(32155, 32688), Cdef.CDFN(32219, 32702)}}, new int[][][]{new int[][]{Cdef.CDFN(21457, 31043), Cdef.CDFN(31951, 32483), Cdef.CDFN(32153, 32562), Cdef.CDFN(31473, 32215)}, new int[][]{Cdef.CDFN(27558, 31151), Cdef.CDFN(32020, 32640), Cdef.CDFN(32097, 32575), Cdef.CDFN(32242, 32719)}}, new int[][][]{new int[][]{Cdef.CDFN(19980, 30591), Cdef.CDFN(32219, 32597), Cdef.CDFN(32581, 32706), Cdef.CDFN(31803, 32287)}, new int[][]{Cdef.CDFN(26473, 30507), Cdef.CDFN(32431, 32723), Cdef.CDFN(32196, 32611), Cdef.CDFN(31588, 32528)}}, new int[][][]{new int[][]{Cdef.CDFN(24647, 30463), Cdef.CDFN(32412, 32695), Cdef.CDFN(32468, 32720), Cdef.CDFN(31269, 32523)}, new int[][]{Cdef.CDFN(28482, 31505), Cdef.CDFN(32152, 32701), Cdef.CDFN(31732, 32598), Cdef.CDFN(31767, 32712)}}, new int[][][]{new int[][]{Cdef.CDFN(12358, 24977), Cdef.CDFN(31331, 32385), Cdef.CDFN(32634, 32756), Cdef.CDFN(30411, 32548)}, new int[][]{Cdef.CDFN(10923, 21845), Cdef.CDFN(10923, 21845), Cdef.CDFN(10923, 21845), Cdef.CDFN(10923, 21845)}}};
        Cdef.av1_default_coef_cdf[3].base_tok = new int[][][][]{new int[][][]{new int[][]{Cdef.CDFN(7062, 16472, 22319), Cdef.CDFN(24538, 32261, 32674), Cdef.CDFN(13675, 28041, 31779), Cdef.CDFN(8590, 20674, 27631), Cdef.CDFN(5685, 14675, 22013), Cdef.CDFN(3655, 9898, 15731), Cdef.CDFN(26493, 32418, 32658), Cdef.CDFN(16376, 29342, 32090), Cdef.CDFN(10594, 22649, 28970), Cdef.CDFN(8176, 17170, 24303), Cdef.CDFN(5605, 12694, 19139), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(23888, 31902, 32542), Cdef.CDFN(18612, 29687, 31987), Cdef.CDFN(16245, 24852, 29249), Cdef.CDFN(15765, 22608, 27559), Cdef.CDFN(19895, 24699, 27510), Cdef.CDFN(28401, 32212, 32457), Cdef.CDFN(15274, 27825, 30980), Cdef.CDFN(9364, 18128, 24332), Cdef.CDFN(2283, 8193, 15082), Cdef.CDFN(1228, 3972, 7881), Cdef.CDFN(29455, 32469, 32620), Cdef.CDFN(17981, 28245, 31388), Cdef.CDFN(10921, 20098, 26240), Cdef.CDFN(3743, 11829, 18657), Cdef.CDFN(2374, 9593, 15715), Cdef.CDFN(31068, 32466, 32635), Cdef.CDFN(20321, 29572, 31971), Cdef.CDFN(10771, 20255, 27119), Cdef.CDFN(2795, 10410, 17361), Cdef.CDFN(8192, 16384, 24576)}, new int[][]{Cdef.CDFN(9320, 22102, 27840), Cdef.CDFN(27057, 32464, 32724), Cdef.CDFN(16331, 30268, 32309), Cdef.CDFN(10319, 23935, 29720), Cdef.CDFN(6189, 16448, 24106), Cdef.CDFN(3589, 10884, 18808), Cdef.CDFN(29026, 32624, 32748), Cdef.CDFN(19226, 31507, 32587), Cdef.CDFN(12692, 26921, 31203), Cdef.CDFN(7049, 19532, 27635), Cdef.CDFN(7727, 15669, 23252), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(28056, 32625, 32748), Cdef.CDFN(22383, 32075, 32669), Cdef.CDFN(15417, 27098, 31749), Cdef.CDFN(18127, 26493, 27190), Cdef.CDFN(5461, 16384, 21845), Cdef.CDFN(27982, 32091, 32584), Cdef.CDFN(19045, 29868, 31972), Cdef.CDFN(10397, 22266, 27932), Cdef.CDFN(5990, 13697, 21500), Cdef.CDFN(1792, 6912, 15104), Cdef.CDFN(28198, 32501, 32718), Cdef.CDFN(21534, 31521, 32569), Cdef.CDFN(11109, 25217, 30017), Cdef.CDFN(5671, 15124, 26151), Cdef.CDFN(4681, 14043, 18725), Cdef.CDFN(28688, 32580, 32741), Cdef.CDFN(22576, 32079, 32661), Cdef.CDFN(10627, 22141, 28340), Cdef.CDFN(9362, 14043, 28087), Cdef.CDFN(8192, 16384, 24576)}}, new int[][][]{new int[][]{Cdef.CDFN(7754, 16948, 22142), Cdef.CDFN(25670, 32330, 32691), Cdef.CDFN(15663, 29225, 31994), Cdef.CDFN(9878, 23288, 29158), Cdef.CDFN(6419, 17088, 24336), Cdef.CDFN(3859, 11003, 17039), Cdef.CDFN(27562, 32595, 32725), Cdef.CDFN(17575, 30588, 32399), Cdef.CDFN(10819, 24838, 30309), Cdef.CDFN(7124, 18686, 25916), Cdef.CDFN(4479, 12688, 19340), Cdef.CDFN(28385, 32476, 32673), Cdef.CDFN(15306, 29005, 31938), Cdef.CDFN(8937, 21615, 28322), Cdef.CDFN(5982, 15603, 22786), Cdef.CDFN(3620, 10267, 16136), Cdef.CDFN(27280, 32464, 32667), Cdef.CDFN(15607, 29160, 32004), Cdef.CDFN(9091, 22135, 28740), Cdef.CDFN(6232, 16632, 24020), Cdef.CDFN(4047, 11377, 17672), Cdef.CDFN(29220, 32630, 32718), Cdef.CDFN(19650, 31220, 32462), Cdef.CDFN(13050, 26312, 30827), Cdef.CDFN(9228, 20870, 27468), Cdef.CDFN(6146, 15149, 21971), Cdef.CDFN(30169, 32481, 32623), Cdef.CDFN(17212, 29311, 31554), Cdef.CDFN(9911, 21311, 26882), Cdef.CDFN(4487, 13314, 20372), Cdef.CDFN(2570, 7772, 12889), Cdef.CDFN(30924, 32613, 32708), Cdef.CDFN(19490, 30206, 32107), Cdef.CDFN(11232, 23998, 29276), Cdef.CDFN(6769, 17955, 25035), Cdef.CDFN(4398, 12623, 19214), Cdef.CDFN(30609, 32627, 32722), Cdef.CDFN(19370, 30582, 32287), Cdef.CDFN(10457, 23619, 29409), Cdef.CDFN(6443, 17637, 24834), Cdef.CDFN(4645, 13236, 20106)}, new int[][]{Cdef.CDFN(8626, 20271, 26216), Cdef.CDFN(26707, 32406, 32711), Cdef.CDFN(16999, 30329, 32286), Cdef.CDFN(11445, 25123, 30286), Cdef.CDFN(6411, 18828, 25601), Cdef.CDFN(6801, 12458, 20248), Cdef.CDFN(29918, 32682, 32748), Cdef.CDFN(20649, 31739, 32618), Cdef.CDFN(12879, 27773, 31581), Cdef.CDFN(7896, 21751, 28244), Cdef.CDFN(5260, 14870, 23698), Cdef.CDFN(29252, 32593, 32731), Cdef.CDFN(17072, 30460, 32294), Cdef.CDFN(10653, 24143, 29365), Cdef.CDFN(6536, 17490, 23983), Cdef.CDFN(4929, 13170, 20085), Cdef.CDFN(28137, 32518, 32715), Cdef.CDFN(18171, 30784, 32407), Cdef.CDFN(11437, 25436, 30459), Cdef.CDFN(7252, 18534, 26176), Cdef.CDFN(4126, 13353, 20978), Cdef.CDFN(31162, 32726, 32748), Cdef.CDFN(23017, 32222, 32701), Cdef.CDFN(15629, 29233, 32046), Cdef.CDFN(9387, 22621, 29480), Cdef.CDFN(6922, 17616, 25010), Cdef.CDFN(28838, 32265, 32614), Cdef.CDFN(19701, 30206, 31920), Cdef.CDFN(11214, 22410, 27933), Cdef.CDFN(5320, 14177, 23034), Cdef.CDFN(5049, 12881, 17827), Cdef.CDFN(27484, 32471, 32734), Cdef.CDFN(21076, 31526, 32561), Cdef.CDFN(12707, 26303, 31211), Cdef.CDFN(8169, 21722, 28219), Cdef.CDFN(6045, 19406, 27042), Cdef.CDFN(27753, 32572, 32745), Cdef.CDFN(20832, 31878, 32653), Cdef.CDFN(13250, 27356, 31674), Cdef.CDFN(7718, 21508, 29858), Cdef.CDFN(7209, 18350, 25559)}}, new int[][][]{new int[][]{Cdef.CDFN(7876, 16901, 21741), Cdef.CDFN(24001, 31898, 32625), Cdef.CDFN(14529, 27959, 31451), Cdef.CDFN(8273, 20818, 27258), Cdef.CDFN(5278, 14673, 21510), Cdef.CDFN(2983, 8843, 14039), Cdef.CDFN(28016, 32574, 32732), Cdef.CDFN(17471, 30306, 32301), Cdef.CDFN(10224, 24063, 29728), Cdef.CDFN(6602, 17954, 25052), Cdef.CDFN(4002, 11585, 17759), Cdef.CDFN(30190, 32634, 32739), Cdef.CDFN(17497, 30282, 32270), Cdef.CDFN(10229, 23729, 29538), Cdef.CDFN(6344, 17211, 24440), Cdef.CDFN(3849, 11189, 17108), Cdef.CDFN(28570, 32583, 32726), Cdef.CDFN(17521, 30161, 32238), Cdef.CDFN(10153, 23565, 29378), Cdef.CDFN(6455, 17341, 24443), Cdef.CDFN(3907, 11042, 17024), Cdef.CDFN(30689, 32715, 32748), Cdef.CDFN(21546, 31840, 32610), Cdef.CDFN(13547, 27581, 31459), Cdef.CDFN(8912, 21757, 28309), Cdef.CDFN(5548, 15080, 22046), Cdef.CDFN(30783, 32540, 32685), Cdef.CDFN(17540, 29528, 31668), Cdef.CDFN(10160, 21468, 26783), Cdef.CDFN(4724, 13393, 20054), Cdef.CDFN(2702, 8174, 13102), Cdef.CDFN(31648, 32686, 32742), Cdef.CDFN(20954, 31094, 32337), Cdef.CDFN(12420, 25698, 30179), Cdef.CDFN(7304, 19320, 26248), Cdef.CDFN(4366, 12261, 18864), Cdef.CDFN(31581, 32723, 32748), Cdef.CDFN(21373, 31586, 32525), Cdef.CDFN(12744, 26625, 30885), Cdef.CDFN(7431, 20322, 26950), Cdef.CDFN(4692, 13323, 20111)}, new int[][]{Cdef.CDFN(7833, 18369, 24095), Cdef.CDFN(26650, 32273, 32702), Cdef.CDFN(16371, 29961, 32191), Cdef.CDFN(11055, 24082, 29629), Cdef.CDFN(6892, 18644, 25400), Cdef.CDFN(5006, 13057, 19240), Cdef.CDFN(29834, 32666, 32748), Cdef.CDFN(19577, 31335, 32570), Cdef.CDFN(12253, 26509, 31122), Cdef.CDFN(7991, 20772, 27711), Cdef.CDFN(5677, 15910, 23059), Cdef.CDFN(30109, 32532, 32720), Cdef.CDFN(16747, 30166, 32252), Cdef.CDFN(10134, 23542, 29184), Cdef.CDFN(5791, 16176, 23556), Cdef.CDFN(4362, 10414, 17284), Cdef.CDFN(29492, 32626, 32748), Cdef.CDFN(19894, 31402, 32525), Cdef.CDFN(12942, 27071, 30869), Cdef.CDFN(8346, 21216, 27405), Cdef.CDFN(6572, 17087, 23859), Cdef.CDFN(32035, 32735, 32748), Cdef.CDFN(22957, 31838, 32618), Cdef.CDFN(14724, 28572, 31772), Cdef.CDFN(10364, 23999, 29553), Cdef.CDFN(7004, 18433, 25655), Cdef.CDFN(27528, 32277, 32681), Cdef.CDFN(16959, 31171, 32096), Cdef.CDFN(10486, 23593, 27962), Cdef.CDFN(8192, 16384, 23211), Cdef.CDFN(8937, 17873, 20852), Cdef.CDFN(27715, 32002, 32615), Cdef.CDFN(15073, 29491, 31676), Cdef.CDFN(11264, 24576, 28672), Cdef.CDFN(2341, 18725, 23406), Cdef.CDFN(7282, 18204, 25486), Cdef.CDFN(28547, 32213, 32657), Cdef.CDFN(20788, 29773, 32239), Cdef.CDFN(6780, 21469, 30508), Cdef.CDFN(5958, 14895, 23831), Cdef.CDFN(16384, 21845, 27307)}}, new int[][][]{new int[][]{Cdef.CDFN(5992, 14304, 19765), Cdef.CDFN(22612, 31238, 32456), Cdef.CDFN(13456, 27162, 31087), Cdef.CDFN(8001, 20062, 26504), Cdef.CDFN(5168, 14105, 20764), Cdef.CDFN(2632, 7771, 12385), Cdef.CDFN(27034, 32344, 32709), Cdef.CDFN(15850, 29415, 31997), Cdef.CDFN(9494, 22776, 28841), Cdef.CDFN(6151, 16830, 23969), Cdef.CDFN(3461, 10039, 15722), Cdef.CDFN(30134, 32569, 32731), Cdef.CDFN(15638, 29422, 31945), Cdef.CDFN(9150, 21865, 28218), Cdef.CDFN(5647, 15719, 22676), Cdef.CDFN(3402, 9772, 15477), Cdef.CDFN(28530, 32586, 32735), Cdef.CDFN(17139, 30298, 32292), Cdef.CDFN(10200, 24039, 29685), Cdef.CDFN(6419, 17674, 24786), Cdef.CDFN(3544, 10225, 15824), Cdef.CDFN(31333, 32726, 32748), Cdef.CDFN(20618, 31487, 32544), Cdef.CDFN(12901, 27217, 31232), Cdef.CDFN(8624, 21734, 28171), Cdef.CDFN(5104, 14191, 20748), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}, new int[][]{Cdef.CDFN(11206, 21090, 26561), Cdef.CDFN(28759, 32279, 32671), Cdef.CDFN(14171, 27952, 31569), Cdef.CDFN(9743, 22907, 29141), Cdef.CDFN(6871, 17886, 24868), Cdef.CDFN(4960, 13152, 19315), Cdef.CDFN(31077, 32661, 32748), Cdef.CDFN(19400, 31195, 32515), Cdef.CDFN(12752, 26858, 31040), Cdef.CDFN(8370, 22098, 28591), Cdef.CDFN(5457, 15373, 22298), Cdef.CDFN(31697, 32706, 32748), Cdef.CDFN(17860, 30657, 32333), Cdef.CDFN(12510, 24812, 29261), Cdef.CDFN(6180, 19124, 24722), Cdef.CDFN(5041, 13548, 17959), Cdef.CDFN(31552, 32716, 32748), Cdef.CDFN(21908, 31769, 32623), Cdef.CDFN(14470, 28201, 31565), Cdef.CDFN(9493, 22982, 28608), Cdef.CDFN(6858, 17240, 24137), Cdef.CDFN(32543, 32752, 32756), Cdef.CDFN(24286, 32097, 32666), Cdef.CDFN(15958, 29217, 32024), Cdef.CDFN(10207, 24234, 29958), Cdef.CDFN(6929, 18305, 25652), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}}, new int[][][]{new int[][]{Cdef.CDFN(4137, 10847, 15682), Cdef.CDFN(17824, 27001, 30058), Cdef.CDFN(10204, 22796, 28291), Cdef.CDFN(6076, 15935, 22125), Cdef.CDFN(3852, 10937, 16816), Cdef.CDFN(2252, 6324, 10131), Cdef.CDFN(25840, 32016, 32662), Cdef.CDFN(15109, 28268, 31531), Cdef.CDFN(9385, 22231, 28340), Cdef.CDFN(6082, 16672, 23479), Cdef.CDFN(3318, 9427, 14681), Cdef.CDFN(30594, 32574, 32718), Cdef.CDFN(16836, 29552, 31859), Cdef.CDFN(9556, 22542, 28356), Cdef.CDFN(6305, 16725, 23540), Cdef.CDFN(3376, 9895, 15184), Cdef.CDFN(29383, 32617, 32745), Cdef.CDFN(18891, 30809, 32401), Cdef.CDFN(11688, 25942, 30687), Cdef.CDFN(7468, 19469, 26651), Cdef.CDFN(3909, 11358, 17012), Cdef.CDFN(31564, 32736, 32748), Cdef.CDFN(20906, 31611, 32600), Cdef.CDFN(13191, 27621, 31537), Cdef.CDFN(8768, 22029, 28676), Cdef.CDFN(5079, 14109, 20906), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}, new int[][]{Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576), Cdef.CDFN(8192, 16384, 24576)}}};
        Cdef.av1_default_coef_cdf[3].dc_sign = new int[][][]{new int[][]{{Cdef.CDF1(16000)}, {Cdef.CDF1(13056)}, {Cdef.CDF1(18816)}}, new int[][]{{Cdef.CDF1(15232)}, {Cdef.CDF1(12928)}, {Cdef.CDF1(17280)}}};
        Cdef.av1_default_coef_cdf[3].br_tok = new int[][][][]{new int[][][]{new int[][]{Cdef.CDFN(18315, 24289, 27551), Cdef.CDFN(16854, 24068, 27835), Cdef.CDFN(10140, 17927, 23173), Cdef.CDFN(6722, 12982, 18267), Cdef.CDFN(4661, 9826, 14706), Cdef.CDFN(3832, 8165, 12294), Cdef.CDFN(2795, 6098, 9245), Cdef.CDFN(17145, 23326, 26672), Cdef.CDFN(20733, 27680, 30308), Cdef.CDFN(16032, 24461, 28546), Cdef.CDFN(11653, 20093, 25081), Cdef.CDFN(9290, 16429, 22086), Cdef.CDFN(7796, 14598, 19982), Cdef.CDFN(6502, 12378, 17441), Cdef.CDFN(21681, 27732, 30320), Cdef.CDFN(22389, 29044, 31261), Cdef.CDFN(19027, 26731, 30087), Cdef.CDFN(14739, 23755, 28624), Cdef.CDFN(11358, 20778, 25511), Cdef.CDFN(10995, 18073, 24190), Cdef.CDFN(9162, 14990, 20617)}, new int[][]{Cdef.CDFN(21425, 27952, 30388), Cdef.CDFN(18062, 25838, 29034), Cdef.CDFN(11956, 19881, 24808), Cdef.CDFN(7718, 15000, 20980), Cdef.CDFN(5702, 11254, 16143), Cdef.CDFN(4898, 9088, 16864), Cdef.CDFN(3679, 6776, 11907), Cdef.CDFN(23294, 30160, 31663), Cdef.CDFN(24397, 29896, 31836), Cdef.CDFN(19245, 27128, 30593), Cdef.CDFN(13202, 19825, 26404), Cdef.CDFN(11578, 19297, 23957), Cdef.CDFN(8073, 13297, 21370), Cdef.CDFN(5461, 10923, 19745), Cdef.CDFN(27367, 30521, 31934), Cdef.CDFN(24904, 30671, 31940), Cdef.CDFN(23075, 28460, 31299), Cdef.CDFN(14400, 23658, 30417), Cdef.CDFN(13885, 23882, 28325), Cdef.CDFN(14746, 22938, 27853), Cdef.CDFN(5461, 16384, 27307)}}, new int[][][]{new int[][]{Cdef.CDFN(18274, 24813, 27890), Cdef.CDFN(15537, 23149, 27003), Cdef.CDFN(9449, 16740, 21827), Cdef.CDFN(6700, 12498, 17261), Cdef.CDFN(4988, 9866, 14198), Cdef.CDFN(4236, 8147, 11902), Cdef.CDFN(2867, 5860, 8654), Cdef.CDFN(17124, 23171, 26101), Cdef.CDFN(20396, 27477, 30148), Cdef.CDFN(16573, 24629, 28492), Cdef.CDFN(12749, 20846, 25674), Cdef.CDFN(10233, 17878, 22818), Cdef.CDFN(8525, 15332, 20363), Cdef.CDFN(6283, 11632, 16255), Cdef.CDFN(20466, 26511, 29286), Cdef.CDFN(23059, 29174, 31191), Cdef.CDFN(19481, 27263, 30241), Cdef.CDFN(15458, 23631, 28137), Cdef.CDFN(12416, 20608, 25693), Cdef.CDFN(10261, 18011, 23261), Cdef.CDFN(8016, 14655, 19666)}, new int[][]{Cdef.CDFN(17616, 24586, 28112), Cdef.CDFN(15809, 23299, 27155), Cdef.CDFN(10767, 18890, 23793), Cdef.CDFN(7727, 14255, 18865), Cdef.CDFN(6129, 11926, 16882), Cdef.CDFN(4482, 9704, 14861), Cdef.CDFN(3277, 7452, 11522), Cdef.CDFN(22956, 28551, 30730), Cdef.CDFN(22724, 28937, 30961), Cdef.CDFN(18467, 26324, 29580), Cdef.CDFN(13234, 20713, 25649), Cdef.CDFN(11181, 17592, 22481), Cdef.CDFN(8291, 18358, 24576), Cdef.CDFN(7568, 11881, 14984), Cdef.CDFN(24948, 29001, 31147), Cdef.CDFN(25674, 30619, 32151), Cdef.CDFN(20841, 26793, 29603), Cdef.CDFN(14669, 24356, 28666), Cdef.CDFN(11334, 23593, 28219), Cdef.CDFN(8922, 14762, 22873), Cdef.CDFN(8301, 13544, 20535)}}, new int[][][]{new int[][]{Cdef.CDFN(17113, 23733, 27081), Cdef.CDFN(14139, 21406, 25452), Cdef.CDFN(8552, 15002, 19776), Cdef.CDFN(5871, 11120, 15378), Cdef.CDFN(4455, 8616, 12253), Cdef.CDFN(3469, 6910, 10386), Cdef.CDFN(2255, 4553, 6782), Cdef.CDFN(18224, 24376, 27053), Cdef.CDFN(19290, 26710, 29614), Cdef.CDFN(14936, 22991, 27184), Cdef.CDFN(11238, 18951, 23762), Cdef.CDFN(8786, 15617, 20588), Cdef.CDFN(7317, 13228, 18003), Cdef.CDFN(5101, 9512, 13493), Cdef.CDFN(22639, 28222, 30210), Cdef.CDFN(23216, 29331, 31307), Cdef.CDFN(19075, 26762, 29895), Cdef.CDFN(15014, 23113, 27457), Cdef.CDFN(11938, 19857, 24752), Cdef.CDFN(9942, 17280, 22282), Cdef.CDFN(7167, 13144, 17752)}, new int[][]{Cdef.CDFN(15820, 22738, 26488), Cdef.CDFN(13530, 20885, 25216), Cdef.CDFN(8395, 15530, 20452), Cdef.CDFN(6574, 12321, 16380), Cdef.CDFN(5353, 10419, 14568), Cdef.CDFN(4613, 8446, 12381), Cdef.CDFN(3440, 7158, 9903), Cdef.CDFN(24247, 29051, 31224), Cdef.CDFN(22118, 28058, 30369), Cdef.CDFN(16498, 24768, 28389), Cdef.CDFN(12920, 21175, 26137), Cdef.CDFN(10730, 18619, 25352), Cdef.CDFN(10187, 16279, 22791), Cdef.CDFN(9310, 14631, 22127), Cdef.CDFN(24970, 30558, 32057), Cdef.CDFN(24801, 29942, 31698), Cdef.CDFN(22432, 28453, 30855), Cdef.CDFN(19054, 25680, 29580), Cdef.CDFN(14392, 23036, 28109), Cdef.CDFN(12495, 20947, 26650), Cdef.CDFN(12442, 20326, 26214)}}, new int[][][]{new int[][]{Cdef.CDFN(12162, 18785, 22648), Cdef.CDFN(12749, 19697, 23806), Cdef.CDFN(8580, 15297, 20346), Cdef.CDFN(6169, 11749, 16543), Cdef.CDFN(4836, 9391, 13448), Cdef.CDFN(3821, 7711, 11613), Cdef.CDFN(2228, 4601, 7070), Cdef.CDFN(16319, 24725, 28280), Cdef.CDFN(15698, 23277, 27168), Cdef.CDFN(12726, 20368, 25047), Cdef.CDFN(9912, 17015, 21976), Cdef.CDFN(7888, 14220, 19179), Cdef.CDFN(6777, 12284, 17018), Cdef.CDFN(4492, 8590, 12252), Cdef.CDFN(23249, 28904, 30947), Cdef.CDFN(21050, 27908, 30512), Cdef.CDFN(17440, 25340, 28949), Cdef.CDFN(14059, 22018, 26541), Cdef.CDFN(11288, 18903, 23898), Cdef.CDFN(9411, 16342, 21428), Cdef.CDFN(6278, 11588, 15944)}, new int[][]{Cdef.CDFN(13981, 20067, 23226), Cdef.CDFN(16922, 23580, 26783), Cdef.CDFN(11005, 19039, 24487), Cdef.CDFN(7389, 14218, 19798), Cdef.CDFN(5598, 11505, 17206), Cdef.CDFN(6090, 11213, 15659), Cdef.CDFN(3820, 7371, 10119), Cdef.CDFN(21082, 26925, 29675), Cdef.CDFN(21262, 28627, 31128), Cdef.CDFN(18392, 26454, 30437), Cdef.CDFN(14870, 22910, 27096), Cdef.CDFN(12620, 19484, 24908), Cdef.CDFN(9290, 16553, 22802), Cdef.CDFN(6668, 14288, 20004), Cdef.CDFN(27704, 31055, 31949), Cdef.CDFN(24709, 29978, 31788), Cdef.CDFN(21668, 29264, 31657), Cdef.CDFN(18295, 26968, 30074), Cdef.CDFN(16399, 24422, 29313), Cdef.CDFN(14347, 23026, 28104), Cdef.CDFN(12370, 19806, 24477)}}};
    }
}

