/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.data;

import com.idrsolutions.image.avif.data.Frame;
import com.idrsolutions.image.avif.data.MV;
import com.idrsolutions.image.avif.data.TxfmInfo;

class BlockContext {
    int[] mode = new int[32];
    int[] lcoef = new int[32];
    int[][] ccoef = new int[2][32];
    int[] seg_pred = new int[32];
    int[] skip = new int[32];
    int[] skip_mode = new int[32];
    int[] intra = new int[32];
    int[] comp_type = new int[32];
    int[][] ref = new int[2][32];
    int[][] filter = new int[2][32];
    int[] tx_intra = new int[32];
    int[] tx = new int[32];
    int[] tx_lpf_y = new int[32];
    int[] tx_lpf_uv = new int[32];
    int[] partition = new int[32];
    int[] uvmode = new int[32];
    int[] pal_sz = new int[32];

    BlockContext() {
    }

    static int get_intra_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        if (have_left != 0) {
            if (have_top != 0) {
                int ctx;
                return ctx + ((ctx = l2.intra[yb4] + a10.intra[xb4]) == 2 ? 1 : 0);
            }
            return l2.intra[yb4] * 2;
        }
        return have_top != 0 ? a10.intra[xb4] * 2 : 0;
    }

    static int get_tx_ctx(BlockContext a10, BlockContext l2, TxfmInfo max_tx, int yb4, int xb4) {
        return (l2.tx_intra[yb4] >= max_tx.lh ? 1 : 0) + (a10.tx_intra[xb4] >= max_tx.lw ? 1 : 0);
    }

    static int get_partition_ctx(BlockContext a10, BlockContext l2, int bl2, int yb8, int xb8) {
        return (a10.partition[xb8] >> 4 - bl2 & 1) + ((l2.partition[yb8] >> 4 - bl2 & 1) << 1);
    }

    static int gather_left_partition_prob(int[] in, int bl2) {
        int out = in[0] - in[1];
        out += in[2] - in[6];
        if (bl2 != 0) {
            out += in[7] - in[8];
        }
        return out;
    }

    static int gather_top_partition_prob(int[] in, int bl2) {
        int out = in[1] - in[4];
        out += in[5];
        if (bl2 != 0) {
            out += in[8] - in[7];
        }
        return out;
    }

    static int get_uv_inter_txtp(TxfmInfo uvt_dim, int ytxtp) {
        if (uvt_dim.max == 3) {
            return ytxtp == 9 ? 9 : 0;
        }
        if (uvt_dim.min == 2 && (1 << ytxtp & 0xF000) != 0) {
            return 0;
        }
        return ytxtp;
    }

    static int get_filter_ctx(BlockContext a10, BlockContext l2, int comp, int dir, int ref, int yb4, int xb4) {
        int l_filter;
        int a_filter = a10.ref[0][xb4] == ref || a10.ref[1][xb4] == ref ? a10.filter[dir][xb4] : 3;
        int n2 = l_filter = l2.ref[0][yb4] == ref || l2.ref[1][yb4] == ref ? l2.filter[dir][yb4] : 3;
        if (a_filter == l_filter) {
            return comp * 4 + a_filter;
        }
        if (a_filter == 3) {
            return comp * 4 + l_filter;
        }
        if (l_filter == 3) {
            return comp * 4 + a_filter;
        }
        return comp * 4 + 3;
    }

    static int get_comp_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        if (have_top != 0) {
            if (have_left != 0) {
                if (a10.comp_type[xb4] != 0) {
                    if (l2.comp_type[yb4] != 0) {
                        return 4;
                    }
                    return 2 + (l2.ref[0][yb4] >= 4 ? 1 : 0);
                }
                if (l2.comp_type[yb4] != 0) {
                    return 2 + (a10.ref[0][xb4] >= 4 ? 1 : 0);
                }
                return (l2.ref[0][yb4] >= 4 ? 1 : 0) ^ (a10.ref[0][xb4] >= 4 ? 1 : 0);
            }
            return a10.comp_type[xb4] != 0 ? 3 : (a10.ref[0][xb4] >= 4 ? 1 : 0);
        }
        if (have_left != 0) {
            return l2.comp_type[yb4] != 0 ? 3 : (l2.ref[0][yb4] >= 4 ? 1 : 0);
        }
        return 1;
    }

    static int has_uni_comp(BlockContext edge, int off) {
        return edge.ref[0][off] < 4 == edge.ref[1][off] < 4 ? 1 : 0;
    }

    static int get_poc_diff(int order_hint_n_bits, int poc0, int poc1) {
        if (order_hint_n_bits == 0) {
            return 0;
        }
        int mask = 1 << order_hint_n_bits - 1;
        int diff = poc0 - poc1;
        return (diff & mask - 1) - (diff & mask);
    }

    static int get_jnt_comp_ctx(int order_hint_n_bits, int poc, int ref0poc, int ref1poc, BlockContext a10, BlockContext l2, int yb4, int xb4) {
        int d1;
        int d0 = Math.abs(BlockContext.get_poc_diff(order_hint_n_bits, ref0poc, poc));
        int offset = d0 == (d1 = Math.abs(BlockContext.get_poc_diff(order_hint_n_bits, poc, ref1poc))) ? 1 : 0;
        int a_ctx = a10.comp_type[xb4] >= 2 || a10.ref[0][xb4] == 6 ? 1 : 0;
        int l_ctx = l2.comp_type[yb4] >= 2 || l2.ref[0][yb4] == 6 ? 1 : 0;
        return 3 * offset + a_ctx + l_ctx;
    }

    static int get_mask_comp_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4) {
        int a_ctx;
        int n2 = a10.comp_type[xb4] >= 3 ? 1 : (a_ctx = a10.ref[0][xb4] == 6 ? 3 : 0);
        int l_ctx = l2.comp_type[yb4] >= 3 ? 1 : (l2.ref[0][yb4] == 6 ? 3 : 0);
        return Math.min(a_ctx + l_ctx, 5);
    }

    static int av1_get_ref_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            int n2 = a10.ref[0][xb4] >= 4 ? 1 : 0;
            cnt[n2] = cnt[n2] + 1;
            if (a10.comp_type[xb4] != 0) {
                int n3 = a10.ref[1][xb4] >= 4 ? 1 : 0;
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            int n4 = l2.ref[0][yb4] >= 4 ? 1 : 0;
            cnt[n4] = cnt[n4] + 1;
            if (l2.comp_type[yb4] != 0) {
                int n5 = l2.ref[1][yb4] >= 4 ? 1 : 0;
                cnt[n5] = cnt[n5] + 1;
            }
        }
        return cnt[0] == cnt[1] ? 1 : (cnt[0] < cnt[1] ? 0 : 2);
    }

    static int av1_get_fwd_ref_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0, 0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            if (a10.ref[0][xb4] < 4) {
                int n2 = a10.ref[0][xb4];
                cnt[n2] = cnt[n2] + 1;
            }
            if (a10.comp_type[xb4] != 0 && a10.ref[1][xb4] < 4) {
                int n3 = a10.ref[1][xb4];
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            if (l2.ref[0][yb4] < 4) {
                int n4 = l2.ref[0][yb4];
                cnt[n4] = cnt[n4] + 1;
            }
            if (l2.comp_type[yb4] != 0 && l2.ref[1][yb4] < 4) {
                int n5 = l2.ref[1][yb4];
                cnt[n5] = cnt[n5] + 1;
            }
        }
        cnt[0] = cnt[0] + cnt[1];
        cnt[2] = cnt[2] + cnt[3];
        return cnt[0] == cnt[2] ? 1 : (cnt[0] < cnt[2] ? 0 : 2);
    }

    static int av1_get_fwd_ref_1_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            if (a10.ref[0][xb4] < 2) {
                int n2 = a10.ref[0][xb4];
                cnt[n2] = cnt[n2] + 1;
            }
            if (a10.comp_type[xb4] != 0 && a10.ref[1][xb4] < 2) {
                int n3 = a10.ref[1][xb4];
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            if (l2.ref[0][yb4] < 2) {
                int n4 = l2.ref[0][yb4];
                cnt[n4] = cnt[n4] + 1;
            }
            if (l2.comp_type[yb4] != 0 && l2.ref[1][yb4] < 2) {
                int n5 = l2.ref[1][yb4];
                cnt[n5] = cnt[n5] + 1;
            }
        }
        return cnt[0] == cnt[1] ? 1 : (cnt[0] < cnt[1] ? 0 : 2);
    }

    static int av1_get_fwd_ref_2_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            if ((a10.ref[0][xb4] ^ 2) < 2) {
                int n2 = a10.ref[0][xb4] - 2;
                cnt[n2] = cnt[n2] + 1;
            }
            if (a10.comp_type[xb4] != 0 && (a10.ref[1][xb4] ^ 2) < 2) {
                int n3 = a10.ref[1][xb4] - 2;
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            if ((l2.ref[0][yb4] ^ 2) < 2) {
                int n4 = l2.ref[0][yb4] - 2;
                cnt[n4] = cnt[n4] + 1;
            }
            if (l2.comp_type[yb4] != 0 && (l2.ref[1][yb4] ^ 2) < 2) {
                int n5 = l2.ref[1][yb4] - 2;
                cnt[n5] = cnt[n5] + 1;
            }
        }
        return cnt[0] == cnt[1] ? 1 : (cnt[0] < cnt[1] ? 0 : 2);
    }

    static int av1_get_bwd_ref_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            if (a10.ref[0][xb4] >= 4) {
                int n2 = a10.ref[0][xb4] - 4;
                cnt[n2] = cnt[n2] + 1;
            }
            if (a10.comp_type[xb4] != 0 && a10.ref[1][xb4] >= 4) {
                int n3 = a10.ref[1][xb4] - 4;
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            if (l2.ref[0][yb4] >= 4) {
                int n4 = l2.ref[0][yb4] - 4;
                cnt[n4] = cnt[n4] + 1;
            }
            if (l2.comp_type[yb4] != 0 && l2.ref[1][yb4] >= 4) {
                int n5 = l2.ref[1][yb4] - 4;
                cnt[n5] = cnt[n5] + 1;
            }
        }
        cnt[1] = cnt[1] + cnt[0];
        return cnt[2] == cnt[1] ? 1 : (cnt[1] < cnt[2] ? 0 : 2);
    }

    static int av1_get_bwd_ref_1_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            if (a10.ref[0][xb4] >= 4) {
                int n2 = a10.ref[0][xb4] - 4;
                cnt[n2] = cnt[n2] + 1;
            }
            if (a10.comp_type[xb4] != 0 && a10.ref[1][xb4] >= 4) {
                int n3 = a10.ref[1][xb4] - 4;
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            if (l2.ref[0][yb4] >= 4) {
                int n4 = l2.ref[0][yb4] - 4;
                cnt[n4] = cnt[n4] + 1;
            }
            if (l2.comp_type[yb4] != 0 && l2.ref[1][yb4] >= 4) {
                int n5 = l2.ref[1][yb4] - 4;
                cnt[n5] = cnt[n5] + 1;
            }
        }
        return cnt[0] == cnt[1] ? 1 : (cnt[0] < cnt[1] ? 0 : 2);
    }

    static int av1_get_uni_p1_ctx(BlockContext a10, BlockContext l2, int yb4, int xb4, int have_top, int have_left) {
        int[] cnt = new int[]{0, 0, 0};
        if (have_top != 0 && a10.intra[xb4] == 0) {
            if (a10.ref[0][xb4] - 1 < 3) {
                int n2 = a10.ref[0][xb4] - 1;
                cnt[n2] = cnt[n2] + 1;
            }
            if (a10.comp_type[xb4] != 0 && a10.ref[1][xb4] - 1 < 3) {
                int n3 = a10.ref[1][xb4] - 1;
                cnt[n3] = cnt[n3] + 1;
            }
        }
        if (have_left != 0 && l2.intra[yb4] == 0) {
            if (l2.ref[0][yb4] - 1 < 3) {
                int n4 = l2.ref[0][yb4] - 1;
                cnt[n4] = cnt[n4] + 1;
            }
            if (l2.comp_type[yb4] != 0 && l2.ref[1][yb4] - 1 < 3) {
                int n5 = l2.ref[1][yb4] - 1;
                cnt[n5] = cnt[n5] + 1;
            }
        }
        cnt[1] = cnt[1] + cnt[2];
        return cnt[0] == cnt[1] ? 1 : (cnt[0] < cnt[1] ? 0 : 2);
    }

    static int get_cur_frame_segid(int by, int bx, int have_top, int have_left, int[] seg_ctx, int[] cur_seg_map, int cur_seg_mapPos, int stride) {
        cur_seg_mapPos += bx + by * stride;
        if (have_left != 0 && have_top != 0) {
            int l2 = cur_seg_map[cur_seg_mapPos - 1];
            int a10 = cur_seg_map[cur_seg_mapPos - stride];
            int al2 = cur_seg_map[cur_seg_mapPos - (stride + 1)];
            seg_ctx[0] = l2 == a10 && al2 == l2 ? 2 : (l2 == a10 || al2 == l2 || a10 == al2 ? 1 : 0);
            return a10 == al2 ? a10 : l2;
        }
        seg_ctx[0] = 0;
        return have_left != 0 ? cur_seg_map[cur_seg_mapPos - 1] : (have_top != 0 ? cur_seg_map[cur_seg_mapPos - stride] : 0);
    }

    static void fix_int_mv_precision(MV mv) {
        mv.x = mv.x - (mv.x >> 15) + 3 & 0xFFFFFFF8;
        mv.y = mv.y - (mv.y >> 15) + 3 & 0xFFFFFFF8;
    }

    static void fix_mv_precision(Frame.Header hdr, MV mv) {
        if (hdr.force_integer_mv != 0) {
            BlockContext.fix_int_mv_precision(mv);
        } else if (hdr.hp == 0) {
            mv.x = mv.x - (mv.x >> 15) & 0xFFFFFFFE;
            mv.y = mv.y - (mv.y >> 15) & 0xFFFFFFFE;
        }
    }
}

