/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.common;

import com.idrsolutions.image.avif.common.Mem;

class IntraPred {
    IntraPred() {
    }

    static void v_predictor(int[] dst, int stride, int bw, int bh2, int[] above, int abovePos) {
        int dstPos = 0;
        for (int r2 = 0; r2 < bh2; ++r2) {
            Mem.cpy(dst, dstPos, above, abovePos, bw);
            dstPos += stride;
        }
    }

    static void h_predictor(int[] dst, int stride, int bw, int bh2, int[] left) {
        int dstPos = 0;
        for (int r2 = 0; r2 < bh2; ++r2) {
            Mem.set(dst, dstPos, left[r2], bw);
            dstPos += stride;
        }
    }

    static int abs_diff(int a10, int b2) {
        return a10 > b2 ? a10 - b2 : b2 - a10;
    }

    static int paeth_predictor_single(int left, int top, int top_left) {
        int base = top + left - top_left;
        int p_left = IntraPred.abs_diff(base, left);
        int p_top = IntraPred.abs_diff(base, top);
        int p_top_left = IntraPred.abs_diff(base, top_left);
        return p_left <= p_top && p_left <= p_top_left ? left : (p_top <= p_top_left ? top : top_left);
    }

    static int divide_round(int value, int bits) {
        return value + (1 << bits - 1) >>> bits;
    }

    static void dc_128_predictor(int[] dst, int stride, int bw, int bh2) {
        int dstPos = 0;
        for (int r2 = 0; r2 < bh2; ++r2) {
            Mem.set(dst, dstPos, 128, bw);
            dstPos += stride;
        }
    }
}

