/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.avif.common;

public class BitReader {
    long state;
    int bits_left;
    int error;
    int ptr;
    int ptr_start;
    int ptr_end;
    byte[] data = null;

    BitReader(byte[] data) {
        this.data = data;
        this.ptr = 0;
        this.ptr_start = 0;
        this.ptr_end = data.length;
        this.state = 0L;
        this.bits_left = 0;
        this.error = 0;
    }

    void refill(int n2) {
        long ss = 0L;
        do {
            if (this.ptr >= this.ptr_end) {
                this.error = 1;
                if (ss != 0L) break;
                return;
            }
            ss = ss << 8 | (long)(this.data[this.ptr++] & 0xFF);
            this.bits_left += 8;
        } while (n2 > this.bits_left);
        this.state |= ss << 64 - this.bits_left;
    }

    int aom_rb_read_bit() {
        if (this.bits_left == 0) {
            if (this.ptr >= this.ptr_end) {
                this.error = 1;
            } else {
                long ss = this.data[this.ptr++] & 0xFF;
                this.bits_left = 7;
                this.state = ss << 57;
                return (int)(ss >>> 7);
            }
        }
        long ss = this.state;
        --this.bits_left;
        this.state = ss << 1;
        return (int)(ss >>> 63);
    }

    int aom_rb_read_literal(int n2) {
        if (n2 > this.bits_left) {
            this.refill(n2);
        }
        long ss = this.state;
        this.bits_left -= n2;
        this.state = ss << n2;
        return (int)(ss >>> (int)(64L - (long)n2));
    }

    int aom_rb_read_unsigned_literal(int n2) {
        return this.aom_rb_read_literal(n2);
    }

    int aom_rb_read_inv_signed_literal(int bits) {
        int nbits = 8 - bits - 1;
        int value = this.aom_rb_read_literal(bits + 1) << nbits;
        System.out.println("need testing bitreader");
        return value >> nbits;
    }

    int aom_rb_read_uvlc() {
        int num_zeros = 0;
        while (this.aom_rb_read_bit() == 0) {
            if (++num_zeros <= 31) continue;
            return 0;
        }
        if (num_zeros != 0) {
            return this.aom_rb_read_literal(num_zeros) + (1 << num_zeros) - 1;
        }
        return 0;
    }

    long get_uleb128() {
        int more;
        long val = 0L;
        int i2 = 0;
        do {
            int v2 = this.aom_rb_read_literal(8);
            more = v2 & 0x80;
            val |= (long)(v2 & 0x7F) << i2;
        } while (more != 0 && (i2 += 7) < 56);
        return val;
    }

    private static int FloorLog2(int x2) {
        int s2 = 0;
        while (x2 != 0) {
            x2 >>= 1;
            ++s2;
        }
        return s2 - 1;
    }

    private int aom_rb_read_primitive_quniform(int max) {
        int l2 = BitReader.FloorLog2(max) + 1;
        int m2 = (1 << l2) - max;
        int v2 = this.aom_rb_read_literal(l2 - 1);
        return v2 < m2 ? v2 : (v2 << 1) - m2 + this.aom_rb_read_bit();
    }

    private static int inv_recenter(int r2, int v2) {
        if (v2 > r2 << 1) {
            return v2;
        }
        if ((v2 & 1) == 0) {
            return (v2 >> 1) + r2;
        }
        return r2 - (v2 + 1 >> 1);
    }

    private int get_bits_subexp_u(int ref, int n2) {
        int v2 = 0;
        int i2 = 0;
        while (true) {
            int b2;
            int n3 = b2 = i2 != 0 ? 3 + i2 - 1 : 3;
            if (n2 < v2 + 3 * (1 << b2)) {
                v2 += this.aom_rb_read_primitive_quniform(n2 - v2 + 1);
                break;
            }
            if (this.aom_rb_read_bit() == 0) {
                v2 += this.aom_rb_read_literal(b2);
                break;
            }
            v2 += 1 << b2;
            ++i2;
        }
        return ref * 2 <= n2 ? BitReader.inv_recenter(ref, v2) : n2 - BitReader.inv_recenter(n2 - ref, v2);
    }

    int aom_rb_read_signed_primitive_refsubexpfin(int ref, int n2) {
        return this.get_bits_subexp_u(ref + (1 << n2), 2 << n2) - (1 << n2);
    }
}

