/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XPathUtils {
    private static Node getPreviousTypedNode(Node node, short s2) {
        for (node = node.getPreviousSibling(); node != null && node.getNodeType() != s2; node = node.getPreviousSibling()) {
        }
        return node;
    }

    private static Node getNextTypedNode(Node node, short s2) {
        for (node = node.getNextSibling(); node != null && node.getNodeType() != s2; node = node.getNextSibling()) {
        }
        return node;
    }

    private static String getValue(Node node, short s2) {
        switch (s2) {
            case 1: {
                return ((Element)node).getTagName();
            }
            case 3: {
                return ((Text)node).getData();
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
        }
        return "";
    }

    private static short getNodeType(Node node) {
        return node != null ? (short)node.getNodeType() : (short)-1;
    }

    private static String getXPathFromVector(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            boolean bl2;
            Node node = (Node)vector.elementAt(i2);
            short s2 = XPathUtils.getNodeType(node);
            String string2 = XPathUtils.getValue(node, s2);
            int n3 = 1;
            node = XPathUtils.getPreviousTypedNode(node, s2);
            while (node != null) {
                if (s2 == 1) {
                    if (XPathUtils.getValue(node, s2).equals(string2)) {
                        ++n3;
                    }
                } else {
                    ++n3;
                }
                node = XPathUtils.getPreviousTypedNode(node, s2);
            }
            boolean bl3 = bl2 = n3 > 1;
            if (!bl2) {
                node = (Node)vector.elementAt(i2);
                node = XPathUtils.getNextTypedNode(node, s2);
                while (!bl2 && node != null) {
                    if (s2 == 1) {
                        if (XPathUtils.getValue(node, s2).equals(string2)) {
                            bl2 = true;
                            continue;
                        }
                        node = XPathUtils.getNextTypedNode(node, s2);
                        continue;
                    }
                    bl2 = true;
                }
            }
            switch (s2) {
                case 3: {
                    string = "text()";
                    break;
                }
                case 7: {
                    string = "processing-instruction()";
                    break;
                }
                default: {
                    string = string2;
                }
            }
            if (string != null && string.length() > 0) {
                stringBuffer.append('/' + string);
            }
            if (!bl2) continue;
            stringBuffer.append("[" + n3 + "]");
        }
        return stringBuffer.toString();
    }

    private static Vector getVectorPathFromNode(Node node) {
        Vector<Node> vector = new Vector<Node>();
        while (node != null) {
            vector.insertElementAt(node, 0);
            node = node.getParentNode();
        }
        return vector;
    }

    public static String getXPathExprFromNode(Node node) throws IllegalArgumentException {
        short s2 = XPathUtils.getNodeType(node);
        switch (s2) {
            case 1: 
            case 3: 
            case 7: {
                return XPathUtils.getXPathFromVector(XPathUtils.getVectorPathFromNode(node));
            }
            case 9: {
                return "/";
            }
        }
        throw new IllegalArgumentException("Only works for element, text, document, and PI nodes.");
    }
}

