/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPBindingSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPBinding sOAPBinding = (SOAPBinding)extensibilityElement;
        if (sOAPBinding != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "binding", definition);
            printWriter.print("    <" + string);
            DOMUtils.printAttribute("style", sOAPBinding.getStyle(), printWriter);
            DOMUtils.printAttribute("transport", sOAPBinding.getTransportURI(), printWriter);
            Boolean bl2 = sOAPBinding.getRequired();
            if (bl2 != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl2.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPBinding sOAPBinding = (SOAPBinding)extensionRegistry.createExtension(clazz, qName);
        String string = DOMUtils.getAttribute(element, "transport");
        String string2 = DOMUtils.getAttribute(element, "style");
        String string3 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string != null) {
            sOAPBinding.setTransportURI(string);
        }
        if (string2 != null) {
            sOAPBinding.setStyle(string2);
        }
        if (string3 != null) {
            sOAPBinding.setRequired(new Boolean(string3));
        }
        return sOAPBinding;
    }
}

