/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public interface AnimatedIcon
extends Icon {
    @Override
    default public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        AnimationSupport.paintIcon(this, c2, g2, x2, y2);
    }

    public void paintIconAnimated(Component var1, Graphics var2, int var3, int var4, float var5);

    public float getValue(Component var1);

    default public boolean isAnimationEnabled() {
        return true;
    }

    default public int getAnimationDuration() {
        return 150;
    }

    default public int getAnimationResolution() {
        return 10;
    }

    default public Animator.Interpolator getAnimationInterpolator() {
        return CubicBezierEasing.STANDARD_EASING;
    }

    default public Object getClientPropertyKey() {
        return this.getClass();
    }

    public static class AnimationSupport {
        private float startValue;
        private float targetValue;
        private float animatedValue;
        private float fraction;
        private Animator animator;
        private int x;
        private int y;

        public static void paintIcon(AnimatedIcon icon, Component c2, Graphics g2, int x2, int y2) {
            if (!AnimationSupport.isAnimationEnabled(icon, c2)) {
                AnimationSupport.paintIconImpl(icon, c2, g2, x2, y2, null);
                return;
            }
            JComponent jc = (JComponent)c2;
            Object key = icon.getClientPropertyKey();
            AnimationSupport as2 = (AnimationSupport)jc.getClientProperty(key);
            if (as2 == null) {
                as2 = new AnimationSupport();
                as2.targetValue = as2.animatedValue = icon.getValue(c2);
                as2.startValue = as2.animatedValue;
                as2.x = x2;
                as2.y = y2;
                jc.putClientProperty(key, as2);
            } else {
                float value = icon.getValue(c2);
                if (value != as2.targetValue) {
                    if (as2.animator == null) {
                        AnimationSupport as22 = as2;
                        as2.animator = new Animator(icon.getAnimationDuration(), fraction -> {
                            if (!c2.isDisplayable()) {
                                as2.animator.stop();
                                return;
                            }
                            as2.animatedValue = as2.startValue + (as2.targetValue - as2.startValue) * fraction;
                            as2.fraction = fraction;
                            c2.repaint(as2.x, as2.y, icon.getIconWidth(), icon.getIconHeight());
                        }, () -> {
                            as2.startValue = as2.animatedValue = as2.targetValue;
                            as2.animator = null;
                        });
                    }
                    if (as2.animator.isRunning()) {
                        as2.animator.cancel();
                        int duration2 = (int)((float)icon.getAnimationDuration() * as2.fraction);
                        if (duration2 > 0) {
                            as2.animator.setDuration(duration2);
                        }
                        as2.startValue = as2.animatedValue;
                    } else {
                        as2.animator.setDuration(icon.getAnimationDuration());
                        as2.animator.setResolution(icon.getAnimationResolution());
                        as2.animator.setInterpolator(icon.getAnimationInterpolator());
                        as2.animatedValue = as2.startValue;
                    }
                    as2.targetValue = value;
                    as2.animator.start();
                }
                as2.x = x2;
                as2.y = y2;
            }
            AnimationSupport.paintIconImpl(icon, c2, g2, x2, y2, as2);
        }

        private static void paintIconImpl(AnimatedIcon icon, Component c2, Graphics g2, int x2, int y2, AnimationSupport as2) {
            float value = as2 != null ? as2.animatedValue : icon.getValue(c2);
            icon.paintIconAnimated(c2, g2, x2, y2, value);
        }

        private static boolean isAnimationEnabled(AnimatedIcon icon, Component c2) {
            return Animator.useAnimation() && icon.isAnimationEnabled() && c2 instanceof JComponent;
        }

        public static void saveIconLocation(AnimatedIcon icon, Component c2, int x2, int y2) {
            if (!AnimationSupport.isAnimationEnabled(icon, c2)) {
                return;
            }
            AnimationSupport as2 = (AnimationSupport)((JComponent)c2).getClientProperty(icon.getClientPropertyKey());
            if (as2 != null) {
                as2.x = x2;
                as2.y = y2;
            }
        }
    }
}

