/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatEditorPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTextFieldUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Caret;

public class FlatTextAreaUI
extends BasicTextAreaUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    private Color background;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color inactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    private Color oldDisabledBackground;
    private Color oldInactiveBackground;
    private Insets defaultMargin;
    private FocusListener focusListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatTextAreaUI();
    }

    @Override
    public void installUI(JComponent c2) {
        if (FlatUIUtils.needsLightAWTPeer(c2)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(c2));
        } else {
            this.installUIImpl(c2);
        }
    }

    private void installUIImpl(JComponent c2) {
        super.installUI(c2);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.background = UIManager.getColor("TextArea.background");
        this.disabledBackground = UIManager.getColor("TextArea.disabledBackground");
        this.inactiveBackground = UIManager.getColor("TextArea.inactiveBackground");
        this.focusedBackground = UIManager.getColor("TextArea.focusedBackground");
        this.defaultMargin = UIManager.getInsets("TextArea.margin");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.disabledBackground = null;
        this.inactiveBackground = null;
        this.focusedBackground = null;
        this.oldDisabledBackground = null;
        this.oldInactiveBackground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent(), c2 -> this.focusedBackground != null);
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    @Override
    protected Caret createCaret() {
        return new FlatCaret(null, false);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e2) {
        String propertyName = e2.getPropertyName();
        if ("editable".equals(propertyName) || "enabled".equals(propertyName)) {
            this.updateBackground();
        }
        super.propertyChange(e2);
        FlatEditorPaneUI.propertyChange(this.getComponent(), e2, this::installStyle);
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.getComponent(), "TextArea"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        this.oldDisabledBackground = this.disabledBackground;
        this.oldInactiveBackground = this.inactiveBackground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
        this.updateBackground();
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.getComponent(), key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c2) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c2, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    private void updateBackground() {
        FlatTextFieldUI.updateBackground(this.getComponent(), this.background, this.disabledBackground, this.inactiveBackground, this.oldDisabledBackground, this.oldInactiveBackground);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        return this.applyMinimumWidth(c2, super.getPreferredSize(c2));
    }

    @Override
    public Dimension getMinimumSize(JComponent c2) {
        return this.applyMinimumWidth(c2, super.getMinimumSize(c2));
    }

    private Dimension applyMinimumWidth(JComponent c2, Dimension size) {
        if (c2 instanceof JTextArea && ((JTextArea)c2).getColumns() > 0) {
            return size;
        }
        return FlatEditorPaneUI.applyMinimumWidth(c2, size, this.minimumWidth, this.defaultMargin);
    }

    @Override
    protected void paintSafely(Graphics g2) {
        super.paintSafely(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g2));
    }

    @Override
    protected void paintBackground(Graphics g2) {
        FlatEditorPaneUI.paintBackground(g2, this.getComponent(), this.focusedBackground);
    }
}

