/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TableUI;

public class FlatTableCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("Table.showCellFocusIndicator");
    private Component c;

    protected FlatTableCellBorder() {
        super(UIManager.getInsets("Table.cellMargins"), UIManager.getColor("Table.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets m2 = FlatTableCellBorder.getStyleFromTableUI(c2, ui -> ui.cellMargins);
        if (m2 != null) {
            return FlatTableCellBorder.scaleInsets(c2, insets, m2.top, m2.left, m2.bottom, m2.right);
        }
        return super.getBorderInsets(c2, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatTableCellBorder.getStyleFromTableUI(this.c, ui -> ui.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public int getArc() {
        Integer selectionArc;
        if (this.c != null && (selectionArc = FlatTableCellBorder.getStyleFromTableUI(this.c, ui -> ui.selectionArc)) != null) {
            return selectionArc;
        }
        return super.getArc();
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Insets selectionInsets;
        if (c2 != null && (selectionInsets = FlatTableCellBorder.getStyleFromTableUI(c2, ui -> ui.selectionInsets)) != null) {
            x2 += selectionInsets.left;
            y2 += selectionInsets.top;
            width -= selectionInsets.left + selectionInsets.right;
            height -= selectionInsets.top + selectionInsets.bottom;
        }
        this.c = c2;
        super.paintBorder(c2, g2, x2, y2, width, height);
        this.c = null;
    }

    static <T> T getStyleFromTableUI(Component c2, Function<FlatTableUI, T> f2) {
        TableUI ui;
        JTable table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c2);
        if (table != null && (ui = table.getUI()) instanceof FlatTableUI) {
            return f2.apply((FlatTableUI)ui);
        }
        return null;
    }

    public static class Selected
    extends FlatTableCellBorder {
        public int maxCheckCellsEditable = 50;

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            JTable table;
            boolean showCellFocusIndicator;
            Boolean b2 = Selected.getStyleFromTableUI(c2, ui -> ui.showCellFocusIndicator);
            boolean bl2 = showCellFocusIndicator = b2 != null ? b2 : this.showCellFocusIndicator;
            if (!showCellFocusIndicator && (table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c2)) != null && !this.shouldShowCellFocusIndicator(table)) {
                return;
            }
            super.paintBorder(c2, g2, x2, y2, width, height);
        }

        protected boolean shouldShowCellFocusIndicator(JTable table) {
            block8: {
                boolean columnSelectionAllowed;
                block7: {
                    boolean rowSelectionAllowed = table.getRowSelectionAllowed();
                    columnSelectionAllowed = table.getColumnSelectionAllowed();
                    if (rowSelectionAllowed && columnSelectionAllowed) {
                        return false;
                    }
                    if (!rowSelectionAllowed) break block7;
                    if (table.getSelectedRowCount() != 1) {
                        return false;
                    }
                    int columnCount = table.getColumnCount();
                    if (columnCount > this.maxCheckCellsEditable) {
                        return true;
                    }
                    int selectedRow = table.getSelectedRow();
                    for (int column = 0; column < columnCount; ++column) {
                        if (!table.isCellEditable(selectedRow, column)) continue;
                        return true;
                    }
                    break block8;
                }
                if (!columnSelectionAllowed) break block8;
                if (table.getSelectedColumnCount() != 1) {
                    return false;
                }
                int rowCount = table.getRowCount();
                if (rowCount > this.maxCheckCellsEditable) {
                    return true;
                }
                int selectedColumn = table.getSelectedColumn();
                for (int row = 0; row < rowCount; ++row) {
                    if (!table.isCellEditable(row, selectedColumn)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class Focused
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            Border border;
            JTable table;
            if (c2 != null && c2.getClass().getName().equals("javax.swing.JTable$BooleanRenderer") && (table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c2)) != null && c2.getForeground() == table.getSelectionForeground() && c2.getBackground() == table.getSelectionBackground() && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                border.paintBorder(c2, g2, x2, y2, width, height);
                return;
            }
            super.paintBorder(c2, g2, x2, y2, width, height);
        }
    }

    public static class Default
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        }
    }
}

