/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToggleButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class FlatButtonBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("Button.arc");
    protected Color endBorderColor = UIManager.getColor("Button.endBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("Button.hoverBorderColor");
    @FlatStylingSupport.Styleable
    protected Color pressedBorderColor = UIManager.getColor("Button.pressedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color selectedBorderColor = UIManager.getColor("Button.selectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBorderColor = UIManager.getColor("Button.disabledSelectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedSelectedBorderColor = UIManager.getColor("Button.focusedSelectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverSelectedBorderColor = UIManager.getColor("Button.hoverSelectedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color pressedSelectedBorderColor = UIManager.getColor("Button.pressedSelectedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float defaultBorderWidth = FlatUIUtils.getUIFloat("Button.default.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBorderColor = FlatUIUtils.getUIColor("Button.default.startBorderColor", "Button.default.borderColor");
    protected Color defaultEndBorderColor = UIManager.getColor("Button.default.endBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBorderColor = UIManager.getColor("Button.default.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusColor = UIManager.getColor("Button.default.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBorderColor = UIManager.getColor("Button.default.hoverBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedBorderColor = UIManager.getColor("Button.default.pressedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected float toolbarFocusWidth = FlatUIUtils.getUIFloat("Button.toolbar.focusWidth", 1.5f);
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarFocusColor = UIManager.getColor("Button.toolbar.focusColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarMargin = UIManager.getInsets("Button.toolbar.margin");
    @FlatStylingSupport.Styleable(dot=true)
    protected Insets toolbarSpacingInsets = UIManager.getInsets("Button.toolbar.spacingInsets");

    public FlatButtonBorder() {
        this.innerFocusWidth = FlatUIUtils.getUIFloat("Button.innerFocusWidth", this.innerFocusWidth);
        this.borderWidth = FlatUIUtils.getUIFloat("Button.borderWidth", this.borderWidth);
        this.borderColor = FlatUIUtils.getUIColor("Button.startBorderColor", "Button.borderColor");
        this.disabledBorderColor = UIManager.getColor("Button.disabledBorderColor");
        this.focusedBorderColor = UIManager.getColor("Button.focusedBorderColor");
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        if (!(!FlatButtonUI.isContentAreaFilled(c2) || FlatButtonUI.isToolBarButton(c2) || FlatButtonUI.isBorderlessButton(c2) && !FlatUIUtils.isPermanentFocusOwner(c2) || FlatButtonUI.isHelpButton(c2) || FlatToggleButtonUI.isTabButton(c2))) {
            super.paintBorder(c2, g2, x2, y2, width, height);
        } else if (FlatButtonUI.isToolBarButton(c2) && this.isFocused(c2)) {
            this.paintToolBarFocus(c2, g2, x2, y2, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintToolBarFocus(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Graphics2D g22 = (Graphics2D)g2.create();
        try {
            FlatUIUtils.setRenderingHints(g22);
            float focusWidth = UIScale.scale(this.toolbarFocusWidth);
            float arc = UIScale.scale((float)this.getArc(c2));
            Color outlineColor = this.getOutlineColor(c2);
            Insets spacing = UIScale.scale(this.toolbarSpacingInsets);
            Color color = outlineColor != null ? outlineColor : this.getFocusColor(c2);
            FlatUIUtils.paintOutlinedComponent(g22, x2 += spacing.left, y2 += spacing.top, width -= spacing.left + spacing.right, height -= spacing.top + spacing.bottom, 0.0f, 0.0f, 0.0f, focusWidth, arc, null, color, null);
        }
        finally {
            g22.dispose();
        }
    }

    @Override
    protected Color getFocusColor(Component c2) {
        return this.toolbarFocusColor != null && FlatButtonUI.isToolBarButton(c2) ? this.toolbarFocusColor : (FlatButtonUI.isDefaultButton(c2) ? this.defaultFocusColor : super.getFocusColor(c2));
    }

    @Override
    protected boolean isFocused(Component c2) {
        return FlatButtonUI.isFocusPainted(c2) && super.isFocused(c2);
    }

    @Override
    protected Paint getBorderColor(Component c2) {
        Color endBg;
        boolean selected;
        boolean def = FlatButtonUI.isDefaultButton(c2);
        boolean bl2 = selected = c2 instanceof AbstractButton && ((AbstractButton)c2).isSelected();
        Paint color = FlatButtonUI.buttonStateColor(c2, def ? this.defaultBorderColor : (selected && this.selectedBorderColor != null ? this.selectedBorderColor : this.borderColor), selected && this.disabledSelectedBorderColor != null ? this.disabledSelectedBorderColor : this.disabledBorderColor, def ? this.defaultFocusedBorderColor : (selected && this.focusedSelectedBorderColor != null ? this.focusedSelectedBorderColor : this.focusedBorderColor), def ? this.defaultHoverBorderColor : (selected && this.hoverSelectedBorderColor != null ? this.hoverSelectedBorderColor : this.hoverBorderColor), def ? this.defaultPressedBorderColor : (selected && this.pressedSelectedBorderColor != null ? this.pressedSelectedBorderColor : this.pressedBorderColor));
        Color startBg = def ? this.defaultBorderColor : this.borderColor;
        Color color2 = endBg = def ? this.defaultEndBorderColor : this.endBorderColor;
        if (color == startBg && endBg != null && !startBg.equals(endBg)) {
            color = new GradientPaint(0.0f, 0.0f, startBg, 0.0f, c2.getHeight(), endBg);
        }
        return color;
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        if (FlatButtonUI.isToolBarButton(c2)) {
            Insets margin = c2 instanceof AbstractButton ? ((AbstractButton)c2).getMargin() : null;
            FlatUIUtils.setInsets(insets, UIScale.scale(FlatUIUtils.addInsets(this.toolbarSpacingInsets, margin != null && !(margin instanceof UIResource) ? margin : this.toolbarMargin)));
        } else {
            insets = super.getBorderInsets(c2, insets);
            if (FlatButtonUI.isIconOnlyOrSingleCharacterButton(c2) && ((AbstractButton)c2).getMargin() instanceof UIResource) {
                insets.left = insets.right = Math.min(insets.top, insets.bottom);
            }
        }
        return insets;
    }

    @Override
    protected int getFocusWidth(Component c2) {
        return FlatToggleButtonUI.isTabButton(c2) ? 0 : super.getFocusWidth(c2);
    }

    @Override
    protected float getBorderWidth(Component c2) {
        return FlatButtonUI.isDefaultButton(c2) ? this.defaultBorderWidth : this.borderWidth;
    }

    @Override
    protected int getArc(Component c2) {
        if (this.isCellEditor(c2)) {
            return 0;
        }
        switch (FlatButtonUI.getButtonType(c2)) {
            case 0: {
                return 0;
            }
            case 1: {
                return Short.MAX_VALUE;
            }
        }
        return this.arc;
    }
}

