/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatTreeUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;

public class FlatTreeCollapsedIcon
extends FlatAbstractIcon {
    private final boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));
    private Path2D path;

    public FlatTreeCollapsedIcon() {
        this(UIManager.getColor("Tree.icon.collapsedColor"));
    }

    FlatTreeCollapsedIcon(Color color) {
        super(11, 11, color);
    }

    @Override
    protected void paintIcon(Component c2, Graphics2D g2) {
        boolean chevron;
        this.setStyleColorFromTreeUI(c2, g2);
        this.rotate(c2, g2);
        String arrowType = FlatTreeCollapsedIcon.getStyleFromTreeUI(c2, ui -> ui.iconArrowType);
        boolean bl2 = chevron = arrowType != null ? FlatUIUtils.isChevron(arrowType) : this.chevron;
        if (chevron) {
            g2.setStroke(new BasicStroke(1.0f, 1, 0));
            if (this.path == null) {
                this.path = FlatUIUtils.createPath(false, 3.5, 1.5, 7.5, 5.5, 3.5, 9.5);
            }
            g2.draw(this.path);
        } else {
            if (this.path == null) {
                this.path = FlatUIUtils.createPath(2.0, 1.0, 2.0, 10.0, 10.0, 5.5);
            }
            g2.fill(this.path);
        }
    }

    void setStyleColorFromTreeUI(Component c2, Graphics2D g2) {
        FlatTreeCollapsedIcon.setStyleColorFromTreeUI(c2, g2, ui -> ui.iconCollapsedColor);
    }

    void rotate(Component c2, Graphics2D g2) {
        if (!c2.getComponentOrientation().isLeftToRight()) {
            g2.rotate(Math.toRadians(180.0), (double)this.width / 2.0, (double)this.height / 2.0);
        }
    }

    static <T> T getStyleFromTreeUI(Component c2, Function<FlatTreeUI, T> f2) {
        TreeUI ui;
        JTree tree;
        JTree jTree = tree = c2 instanceof JTree ? (JTree)c2 : (JTree)SwingUtilities.getAncestorOfClass(JTree.class, c2);
        if (tree != null && (ui = tree.getUI()) instanceof FlatTreeUI) {
            return f2.apply((FlatTreeUI)ui);
        }
        return null;
    }

    static void setStyleColorFromTreeUI(Component c2, Graphics2D g2, Function<FlatTreeUI, Color> f2) {
        Color color = FlatTreeCollapsedIcon.getStyleFromTreeUI(c2, f2);
        if (color != null) {
            g2.setColor(color);
        }
    }
}

